/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import com.evermind.security.SecuritySensitive;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.dmt.op.re.base.Enum;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyManager;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reexception.BadDBConnectionException;
import oracle.dmt.op.re.reexception.ConnectionPoolIsFullException;
import oracle.dmt.op.re.reexception.ErrorExecutingRE;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.dmt.op.re.reexception.StringTooLargeException;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.jsp.webutil.personalization.SessionListener;

public class StartSessionTag
extends TagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    OPUtil.REInfo reinfo = new OPUtil.REInfo();
    boolean appSession = true;
    boolean isUserCustomer = false;
    String userID = null;
    boolean disableRec = false;
    String storeUserIDIn = null;

    public int doStartTag() throws JspTagException {
        Enum.UserType enumUser;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        REProxyRT proxy = null;
        IdentificationData idData = null;
        String oldUserID = null;
        HttpSession httpSess = request.getSession(false);
        if (httpSess != null) {
            proxy = (REProxyRT)httpSess.getAttribute("oracle.jsp.webutil.personalization.REProxy");
            idData = (IdentificationData)httpSess.getAttribute("oracle.jsp.webutil.personalization.IdData");
            oldUserID = (String)httpSess.getAttribute("oracle.jsp.webutil.personalization.UserID");
            if (proxy != null && idData != null) {
                if (!OPUtil.isEmpty(this.userID) && oldUserID != null && !oldUserID.equals(this.userID)) {
                    throw new JspTagException(msgs.getString("session_not_closed"));
                }
                if (!OPUtil.isEmpty(this.storeUserIDIn)) {
                    this.pageContext.setAttribute(this.storeUserIDIn, (Object)oldUserID);
                }
                this.release();
                return 0;
            }
        } else if (!this.appSession) {
            proxy = (REProxyRT)request.getAttribute("oracle.jsp.webutil.personalization.REProxy");
            idData = (IdentificationData)request.getAttribute("oracle.jsp.webutil.personalization.IdData");
            oldUserID = (String)request.getAttribute("oracle.jsp.webutil.personalization.UserID");
            if (proxy != null && idData != null) {
                if (!OPUtil.isEmpty(this.userID) && oldUserID != null && !oldUserID.equals(this.userID)) {
                    throw new JspTagException(msgs.getString("session_not_closed"));
                }
                if (!OPUtil.isEmpty(this.storeUserIDIn)) {
                    this.pageContext.setAttribute(this.storeUserIDIn, (Object)oldUserID);
                }
                this.release();
                return 0;
            }
            if (OPUtil.setupRequestForOP(this.pageContext)) {
                if (!OPUtil.isEmpty(this.storeUserIDIn)) {
                    this.pageContext.setAttribute(this.storeUserIDIn, (Object)((String)request.getAttribute("oracle.jsp.webutil.personalization.UserID")));
                }
                this.release();
                return 0;
            }
        }
        try {
            proxy = REProxyManager.getProxy((String)this.reinfo.name);
        }
        catch (REProxyInitException e) {
            // empty catch block
        }
        if (proxy == null) {
            proxy = OPUtil.createREProxy(this.reinfo, this.pageContext);
        }
        if (this.appSession) {
            httpSess = request.getSession(true);
            httpSess.setAttribute("oracle.jsp.webutil.personalization.REProxy", (Object)proxy);
        } else {
            response.addCookie(new Cookie("OPTL_REName", this.reinfo.name));
            request.setAttribute("oracle.jsp.webutil.personalization.REProxy", (Object)proxy);
        }
        if (OPUtil.isEmpty(this.userID)) {
            this.userID = this.genUserID(request);
        }
        if (!OPUtil.isEmpty(this.storeUserIDIn)) {
            this.pageContext.setAttribute(this.storeUserIDIn, (Object)this.userID);
        }
        if (this.appSession) {
            httpSess.setAttribute("oracle.jsp.webutil.personalization.UserID", (Object)this.userID);
        } else {
            request.setAttribute("oracle.jsp.webutil.personalization.UserID", (Object)this.userID);
            response.addCookie(new Cookie("OPTL_UserID", this.userID));
        }
        Enum.UserType userType = enumUser = this.isUserCustomer ? Enum.User.CUSTOMER : Enum.User.VISITOR;
        if (this.appSession) {
            String sessID = this.getCurrentSessID(request, this.reinfo.name);
            try {
                if (this.isUserCustomer) {
                    proxy.createCustomerSession(this.userID, sessID);
                } else {
                    proxy.createVisitorSession(this.userID, sessID);
                }
            }
            catch (ErrorExecutingRE e) {
            }
            catch (StringTooLargeException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "StringTooLargeException", e.getMessage()));
            }
            catch (InvalidIDException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "InvalidIDException", e.getMessage()));
            }
            catch (BadDBConnectionException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "BadDBConnectionException", e.getMessage()));
            }
            catch (REProxyInitException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "REProxyInitException", e.getMessage()));
            }
            catch (ConnectionPoolIsFullException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "ConnectionPoolIsFullException", e.getMessage()));
            }
            catch (NullParameterException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("create_session_fail"), "NullParameterException", e.getMessage()));
            }
            try {
                idData = IdentificationData.createSessionful((String)sessID, (Enum.UserType)enumUser);
            }
            catch (NullParameterException e) {
                throw new JspTagException(msgs.getString("user_missing"));
            }
            httpSess.setAttribute("oracle.jsp.webutil.personalization.IdData", (Object)idData);
        } else {
            try {
                idData = IdentificationData.createSessionless((String)this.userID, (Enum.UserType)enumUser);
            }
            catch (NullParameterException e) {
                throw new JspTagException(msgs.getString("user_missing"));
            }
            response.addCookie(new Cookie("OPTL_UserCustomer", this.isUserCustomer ? "true" : "false"));
            request.setAttribute("oracle.jsp.webutil.personalization.IdData", (Object)idData);
        }
        if (this.disableRec) {
            if (this.appSession) {
                httpSess.setAttribute("oracle.jsp.webutil.personalization.DisableRec", (Object)"true");
            } else {
                response.addCookie(new Cookie("OPTL_DisRec", "true"));
                request.setAttribute("oracle.jsp.webutil.personalization.DisableRec", (Object)"true");
            }
        }
        if (this.appSession) {
            httpSess.setAttribute("oracle.jsp.webutil.personalization.SessLsnr", (Object)new SessionListener(proxy, idData));
        }
        this.release();
        return 0;
    }

    public void setREName(String s) throws JspTagException {
        if (s.length() > 12) {
            throw new JspTagException(msgs.getString("ReName_too_long"));
        }
        this.reinfo.name = s;
    }

    public void setREURL(String s) {
        this.reinfo.URL = s;
    }

    public void setRESchema(String s) {
        this.reinfo.schema = s;
    }

    public void setREPassword(String s) {
        this.reinfo.passwd = SecuritySensitive.global().decode(s);
    }

    public void setRECacheSize(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.reinfo.cSize = 3234;
        } else {
            try {
                this.reinfo.cSize = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("attr_not_int"), "RECacheSize"));
            }
        }
    }

    public void setREFlushInterval(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.reinfo.flushInt = 60000;
        } else {
            try {
                this.reinfo.flushInt = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new JspTagException(MessageFormat.format(msgs.getString("attr_not_int"), "REFlushInterval"));
            }
        }
    }

    private boolean setBooleanAttr(String s, boolean dflt) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            return dflt;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no")) {
            return false;
        }
        throw new JspTagException();
    }

    public void setSession(String s) throws JspTagException {
        try {
            this.appSession = this.setBooleanAttr(s, true);
        }
        catch (JspTagException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_value"), "applicationSession"));
        }
    }

    public void setUserType(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            s = "visitor";
        }
        if (s.equalsIgnoreCase("visitor")) {
            this.isUserCustomer = false;
        } else if (s.equalsIgnoreCase("customer")) {
            this.isUserCustomer = true;
        } else {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_value"), "userType"));
        }
    }

    public void setUserID(String s) {
        this.userID = s;
    }

    public void setDisableRecording(String s) throws JspTagException {
        try {
            this.disableRec = this.setBooleanAttr(s, false);
        }
        catch (JspTagException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_value"), "disableRecording"));
        }
    }

    public void setStoreUserIDIn(String s) {
        this.storeUserIDIn = s;
    }

    public void release() {
        OPUtil.REInfo reinfo = new OPUtil.REInfo();
        this.appSession = true;
        this.isUserCustomer = false;
        this.userID = null;
        this.disableRec = false;
        this.storeUserIDIn = null;
    }

    private String genUserID(HttpServletRequest request) {
        return "UID" + Integer.toString(Math.abs(OPUtil.getRandom(request).nextInt())) + System.currentTimeMillis();
    }

    private String getCurrentSessID(HttpServletRequest request, String rename) {
        return rename.substring(0, 2) + Integer.toString(Math.abs(OPUtil.getRandom(request).nextInt())) + System.currentTimeMillis();
    }
}

