/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import oracle.dmt.op.re.base.FilteringSettings;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reapi.rt.RecommendationContent;
import oracle.dmt.op.re.reapi.rt.RecommendationList;
import oracle.dmt.op.re.reexception.ArrayTooLargeException;
import oracle.dmt.op.re.reexception.BadDBConnectionException;
import oracle.dmt.op.re.reexception.ConnectionPoolIsFullException;
import oracle.dmt.op.re.reexception.ErrorExecutingRE;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.jsp.webutil.personalization.ConfigFileException;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.jsp.webutil.personalization.tagext.RecommendationGetter;

public class SelectFromHotPicksTag
extends RecommendationGetter {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    long[] hotPicksGroups = null;

    public SelectFromHotPicksTag() {
        this.tagName = "SelectFromHotPicks";
        this.isXSell = false;
    }

    public int doStartTag() throws JspTagException {
        if (this.hotPicksGroups == null) {
            throw new JspTagException(msgs.getString("empty_hotPicks"));
        }
        try {
            this.checkMaxQuantity();
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_read_attr"), "SelectFromHotPicks", "maxQuantity", e.getMessage()));
        }
        REProxyRT proxy = OPUtil.getProxy(this.pageContext);
        IdentificationData idData = OPUtil.getIdData(this.pageContext);
        if (proxy == null) {
            throw new JspTagException(msgs.getString("no_proxy"));
        }
        if (idData == null) {
            throw new JspTagException(msgs.getString("no_id_data"));
        }
        try {
            TuningSettings tunings = this.createTuningSettings();
            RecommendationContent recContent = this.createRecommendationContent();
            FilteringSettings filters = this.createFilteringSettings();
            RecommendationList recList = null;
            recList = proxy.selectFromHotPicks(idData, this.maxQuantity, this.hotPicksGroups, tunings, filters, recContent);
            this.processRecommendationResults(recList);
            return 1;
        }
        catch (ArrayTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (BadDBConnectionException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (InvalidIDException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (ErrorExecutingRE e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (REProxyInitException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (ConnectionPoolIsFullException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_select"), e.getMessage()));
        }
    }

    public int doEndTag() throws JspTagException {
        this.release();
        return 6;
    }

    public void setHotPicksGroups(String s) throws JspTagException {
        this.hotPicksGroups = this.getLongArray(s, "hotPicksGroups");
    }

    public void release() {
        super.release();
        this.hotPicksGroups = null;
    }
}

