/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.dmt.op.re.base.Enum;
import oracle.dmt.op.re.base.FilteringSettings;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reapi.rt.RecommendationContent;
import oracle.dmt.op.re.reapi.rt.RecommendationList;
import oracle.dmt.op.re.reexception.ArrayTooLargeException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.jsp.webutil.personalization.ConfigFileException;
import oracle.jsp.webutil.personalization.InternalItem;
import oracle.jsp.webutil.personalization.Item;
import oracle.jsp.webutil.personalization.OPUtil;

public class RecommendationGetter
extends TagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    String storeResultsIn = null;
    String storeInterestDimensionIn = null;
    int maxQuantity = Integer.MIN_VALUE;
    String tuningName = null;
    String tuningDataSrc = null;
    String tuningIntDim = null;
    String tuningPersIdx = null;
    String tuningProfileDB = null;
    String tuningProfUsage = null;
    String filteringName = null;
    int filteringTaxonomyID = Integer.MIN_VALUE;
    String filteringMethod = null;
    long[] filteringCategoryList = null;
    String sortOrder = "NONE";
    InternalItem[] outItemList = null;
    int outItemList_position = 0;
    String tagName = "RecommendationGetter";
    boolean isXSell = false;

    protected void checkMaxQuantity() throws JspTagException, ConfigFileException {
        if (this.maxQuantity == Integer.MIN_VALUE) {
            this.maxQuantity = OPUtil.getMaxQuantity(this.pageContext);
            if (this.maxQuantity == Integer.MIN_VALUE) {
                throw new JspTagException(MessageFormat.format(msgs.getString("buggy_maxQuantity"), this.tagName));
            }
        }
    }

    protected void processRecommendationResults(RecommendationList recList) throws JspTagException {
        int nRecs;
        if (!OPUtil.isEmpty(this.storeInterestDimensionIn)) {
            this.pageContext.setAttribute(this.storeInterestDimensionIn, (Object)this.getInterestDimension(recList));
        }
        if ((nRecs = recList.getNumberOfRecommendations()) == 0) {
            if (!OPUtil.isEmpty(this.storeResultsIn)) {
                this.pageContext.setAttribute(this.storeResultsIn, (Object)new Item[0]);
            }
            return;
        }
        this.outItemList = new InternalItem[nRecs];
        for (int i = 0; i < nRecs; ++i) {
            this.outItemList[i] = new InternalItem(recList.getRecommendation(i));
        }
        if (!OPUtil.isEmpty(this.storeResultsIn)) {
            this.pageContext.setAttribute(this.storeResultsIn, (Object)this.outItemList);
        }
    }

    protected TuningSettings createTuningSettings() throws JspTagException, ConfigFileException {
        if (OPUtil.isEmpty(this.tuningDataSrc) || OPUtil.isEmpty(this.tuningIntDim) || OPUtil.isEmpty(this.tuningPersIdx) || OPUtil.isEmpty(this.tuningProfileDB) || OPUtil.isEmpty(this.tuningProfUsage)) {
            TuningSettings ts = OPUtil.getTuningSettings(this.pageContext, this.tuningName);
            if (ts != null) {
                return ts;
            }
            if (OPUtil.isEmpty(this.tuningName) && OPUtil.isEmpty(this.tuningDataSrc) && OPUtil.isEmpty(this.tuningIntDim) && OPUtil.isEmpty(this.tuningPersIdx) && OPUtil.isEmpty(this.tuningProfileDB) && OPUtil.isEmpty(this.tuningProfUsage)) {
                try {
                    return new TuningSettings(Enum.DataSourceType.getType((String)"ALL"), Enum.InterestDimensionType.getType((String)"NAVIGATION"), Enum.PersonalizationIndexType.getType((String)"MEDIUM"), Enum.ProfileDataBalanceType.getType((String)"BALANCED"), Enum.ProfileUsageType.getType((String)"INCLUDE"));
                }
                catch (NullParameterException nullParameterException) {
                }
            } else {
                throw new JspTagException(MessageFormat.format(msgs.getString("buggy_tuning"), this.tagName, this.tuningName));
            }
        }
        try {
            return new TuningSettings(Enum.DataSourceType.getType((String)this.tuningDataSrc), Enum.InterestDimensionType.getType((String)this.tuningIntDim), Enum.PersonalizationIndexType.getType((String)this.tuningPersIdx), Enum.ProfileDataBalanceType.getType((String)this.tuningProfileDB), Enum.ProfileUsageType.getType((String)this.tuningProfUsage));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("buggy_tuning_1"), this.tagName));
        }
    }

    protected RecommendationContent createRecommendationContent() throws JspTagException {
        try {
            return new RecommendationContent(Enum.SortingType.getType((String)this.sortOrder));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("buggy_sortOrder"), this.tagName));
        }
    }

    protected FilteringSettings createFilteringSettings() throws JspTagException, ConfigFileException {
        FilteringSettings fs = null;
        if (this.filteringTaxonomyID == Integer.MIN_VALUE || OPUtil.isEmpty(this.filteringMethod) || this.filteringCategoryList == null && !this.filteringMethod.equalsIgnoreCase("ALL_ITEMS") && !this.filteringMethod.equalsIgnoreCase("ALL_CATEGORIES")) {
            fs = OPUtil.getFilteringSettings(this.pageContext, this.filteringName);
            if (fs != null) {
                return fs;
            }
            throw new JspTagException(MessageFormat.format(msgs.getString("buggy_filtering"), this.tagName, this.filteringName));
        }
        fs = new FilteringSettings(this.filteringTaxonomyID);
        try {
            if (this.filteringMethod.equalsIgnoreCase("ALL_ITEMS")) {
                fs.setItemFiltering(this.filteringTaxonomyID);
            } else if (this.filteringMethod.equalsIgnoreCase("INCLUDE_ITEMS")) {
                fs.setItemFiltering(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("EXCLUDE_ITEMS")) {
                fs.setItemExclusion(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("SUBTREE_ITEMS")) {
                fs.setItemSubTreeFiltering(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("EXCLUDE_CATEGORIES")) {
                fs.setCategoryExclusion(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("SUBTREE_CATEGORIES")) {
                fs.setCategorySubTreeFiltering(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("CATEGORY_LEVEL")) {
                fs.setCategoryLevelFiltering(this.filteringTaxonomyID, this.filteringCategoryList);
            } else if (this.filteringMethod.equalsIgnoreCase("ALL_CATEGORIES")) {
                fs.setCategoryFiltering(this.filteringTaxonomyID);
            } else if (this.filteringMethod.equalsIgnoreCase("INCLUDE_CATEGORIES")) {
                fs.setCategoryFiltering(this.filteringTaxonomyID, this.filteringCategoryList);
            }
        }
        catch (ArrayTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("filtering_ex"), this.tagName, e.getMessage()));
        }
        return fs;
    }

    public void setStoreResultsIn(String s) {
        this.storeResultsIn = s;
    }

    public void setStoreInterestDimensionIn(String s) {
        this.storeInterestDimensionIn = s;
    }

    public void setMaxQuantity(String s) throws JspTagException {
        this.maxQuantity = this.getIntAttribute(s, "maxQuantity");
    }

    public void setTuningName(String s) {
        this.tuningName = s;
    }

    public void setTuningDataSource(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.tuningDataSrc = null;
            return;
        }
        if (!(s.equalsIgnoreCase("ALL") || s.equalsIgnoreCase("NAVIGATION") || s.equalsIgnoreCase("PURCHASE") || s.equalsIgnoreCase("RATING") || s.equalsIgnoreCase("DEMOGRAPHIC"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "tuningDataSource", s));
        }
        this.tuningDataSrc = s.toUpperCase();
    }

    public void setTuningInterestDimension(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.tuningIntDim = null;
            return;
        }
        if (!(s.equalsIgnoreCase("NAVIGATION") || s.equalsIgnoreCase("PURCHASING") || s.equalsIgnoreCase("RATING"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "tuningInterestDimension", s));
        }
        this.tuningIntDim = s.toUpperCase();
    }

    public void setTuningPersonalizationIndex(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.tuningPersIdx = null;
            return;
        }
        if (!(s.equalsIgnoreCase("LOW") || s.equalsIgnoreCase("MEDIUM") || s.equalsIgnoreCase("HIGH"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "tuningPersonalizationIndex", s));
        }
        this.tuningPersIdx = s.toUpperCase();
    }

    public void setTuningProfileDataBalance(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.tuningProfileDB = null;
            return;
        }
        if (!(s.equalsIgnoreCase("HISTORY") || s.equalsIgnoreCase("BALANCED") || s.equalsIgnoreCase("CURRENT"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "tuningProfileDataBalance", s));
        }
        this.tuningProfileDB = s.toUpperCase();
    }

    public void setTuningProfileUsage(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.tuningProfUsage = null;
            return;
        }
        if (!s.equalsIgnoreCase("INCLUDE") && !s.equalsIgnoreCase("EXCLUDE")) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "tuningProfileUsage", s));
        }
        this.tuningProfUsage = s.toUpperCase();
    }

    public void setFilteringName(String s) {
        this.filteringName = s;
    }

    public void setFilteringTaxonomyID(String s) throws JspTagException {
        this.filteringTaxonomyID = this.getIntAttribute(s, "filteringTaxonomyID");
    }

    public void setFilteringMethod(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.filteringMethod = null;
            return;
        }
        if (s.equalsIgnoreCase("INCLUDE_ITEMS") || s.equalsIgnoreCase("EXCLUDE_ITEMS") || s.equalsIgnoreCase("SUBTREE_ITEMS") || s.equalsIgnoreCase("ALL_ITEMS")) {
            this.filteringMethod = s.toUpperCase();
        } else if (!this.isXSell && (s.equalsIgnoreCase("EXCLUDE_CATEGORIES") || s.equalsIgnoreCase("INCLUDE_CATEGORIES") || s.equalsIgnoreCase("CATEGORY_LEVEL") || s.equalsIgnoreCase("SUBTREE_CATEGORIES") || s.equalsIgnoreCase("ALL_CATEGORIES"))) {
            this.filteringMethod = s.toUpperCase();
        } else {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, "filteringMethod", s));
        }
    }

    public void setFilteringCategories(String s) throws JspTagException {
        this.filteringCategoryList = this.getLongArray(s, "filteringCategories");
    }

    public void setSortOrder(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.sortOrder = "NONE";
            return;
        }
        if (s.equalsIgnoreCase("ASCEND") || s.equalsIgnoreCase("DESCEND")) {
            this.sortOrder = s.toUpperCase() + "ING";
        } else if (s.equalsIgnoreCase("NONE")) {
            this.sortOrder = "NONE";
        } else {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_attr"), this.tagName, s));
        }
    }

    public Item getNextItem() {
        if (this.outItemList.length > this.outItemList_position) {
            return this.outItemList[this.outItemList_position++];
        }
        return null;
    }

    public void release() {
        this.storeResultsIn = null;
        this.storeInterestDimensionIn = null;
        this.maxQuantity = Integer.MIN_VALUE;
        this.tuningName = null;
        this.tuningDataSrc = null;
        this.tuningIntDim = null;
        this.tuningPersIdx = null;
        this.tuningProfileDB = null;
        this.tuningProfUsage = null;
        this.filteringName = null;
        this.filteringTaxonomyID = Integer.MIN_VALUE;
        this.filteringMethod = null;
        this.filteringCategoryList = null;
        this.sortOrder = "NONE";
        this.outItemList = null;
        this.outItemList_position = 0;
    }

    protected String getInterestDimension(RecommendationList recList) {
        Enum.InterestDimensionType it = recList.getInterestDimension();
        if (it.isEqual((Enum.EnumType)Enum.InterestDimension.PURCHASING)) {
            return "PURCHASING";
        }
        if (it.isEqual((Enum.EnumType)Enum.InterestDimension.RATING)) {
            return "RATING";
        }
        if (it.isEqual((Enum.EnumType)Enum.InterestDimension.NAVIGATION)) {
            return "NAVIGATION";
        }
        return "NAVIGATION";
    }

    protected int getIntAttribute(String s, String attName) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("require_int"), attName));
        }
    }

    protected long[] getLongArray(String s, String attName) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, "+");
        int size = st.countTokens();
        if (size == 0) {
            return null;
        }
        long[] result = new long[size];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                result[i] = Long.parseLong(st.nextToken().trim());
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("require_int_list"), attName));
        }
    }
}

