/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.dmt.op.re.base.DataItem;
import oracle.dmt.op.re.base.Enum;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.StringTooLargeException;
import oracle.jsp.webutil.personalization.InternalItem;
import oracle.jsp.webutil.personalization.Item;
import oracle.jsp.webutil.personalization.OPUtil;

public class ItemTagSupport
extends TagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    String type = null;
    long ID = Long.MIN_VALUE;
    int index = -1;
    Item[] iList = null;
    String dataSrc = null;
    String value = null;
    String tagName = "ItemTagSupport";

    protected ItemTagSupport() {
    }

    protected InternalItem createOPItem() throws JspTagException {
        if (!OPUtil.isEmpty(this.type) && this.ID != Long.MIN_VALUE) {
            return new InternalItem(this.type, this.ID);
        }
        return this.getItemFromIndex();
    }

    private InternalItem getItemFromIndex() throws JspTagException {
        if (this.index < 0 || this.iList == null || this.iList.length == 0) {
            return null;
        }
        if (this.iList.length <= this.index) {
            return null;
        }
        return new InternalItem(this.iList[this.index].getType(), this.iList[this.index].getID());
    }

    protected DataItem getDataItem(InternalItem item, String datasrc, String value) throws JspTagException {
        String type = item.getType();
        long ID = item.getID();
        if (ID == Long.MIN_VALUE || OPUtil.isEmpty(type)) {
            throw new JspTagException(msgs.getString("item_not_init"));
        }
        try {
            return new DataItem(type, ID, Enum.DataSourceType.getType((String)datasrc), value);
        }
        catch (StringTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("string_too_long"), this.tagName, value));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("attr_missing"), this.tagName));
        }
        catch (InvalidIDException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_id"), this.tagName, new Long(ID)));
        }
    }

    protected Tag findCloserTag(Tag t1, Tag t2) {
        for (Tag parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == t1) {
                return t1;
            }
            if (parent != t2) continue;
            return t2;
        }
        return t1;
    }

    protected void checkRequiredAttributes() throws JspTagException {
        boolean typeID = false;
        boolean indexList = false;
        if (!OPUtil.isEmpty(this.type) && this.ID > Long.MIN_VALUE) {
            typeID = true;
        }
        if (this.index >= 0 && this.iList != null && this.iList.length > 0) {
            indexList = true;
        }
        if (!typeID && !indexList) {
            throw new JspTagException(MessageFormat.format(msgs.getString("scanty_attr"), this.tagName));
        }
        if (typeID && (this.iList != null && this.iList.length > 0 || this.index >= 0)) {
            throw new JspTagException(MessageFormat.format(msgs.getString("clashing_attr"), this.tagName));
        }
        if (indexList && (!OPUtil.isEmpty(this.type) || this.ID > Long.MIN_VALUE)) {
            throw new JspTagException(MessageFormat.format(msgs.getString("clashing_attr"), this.tagName));
        }
    }

    public void setID(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.ID = Long.MIN_VALUE;
        }
        try {
            this.ID = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new JspTagException(msgs.getString("id_not_integer"));
        }
    }

    public void setType(String s) throws JspTagException {
        this.type = s;
    }

    public void setIndex(String s) throws JspTagException {
        if (OPUtil.isEmpty(s)) {
            this.index = -1;
        }
        try {
            this.index = Integer.parseInt(s);
        }
        catch (NumberFormatException ne) {
            throw new JspTagException(MessageFormat.format(msgs.getString("index_not_integer"), this.tagName));
        }
    }

    public void setItemList(Item[] l) {
        this.iList = l;
    }

    public void release() {
        this.type = null;
        this.ID = Long.MIN_VALUE;
        this.index = -1;
        this.iList = null;
    }
}

