/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.personalization.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.jsp.JspTagException;
import oracle.dmt.op.re.base.TuningSettings;
import oracle.dmt.op.re.reapi.rt.IdentificationData;
import oracle.dmt.op.re.reapi.rt.REProxyRT;
import oracle.dmt.op.re.reapi.rt.RecommendationContent;
import oracle.dmt.op.re.reapi.rt.RecommendationList;
import oracle.dmt.op.re.reexception.ArrayTooLargeException;
import oracle.dmt.op.re.reexception.BadDBConnectionException;
import oracle.dmt.op.re.reexception.ConnectionPoolIsFullException;
import oracle.dmt.op.re.reexception.ErrorExecutingRE;
import oracle.dmt.op.re.reexception.InvalidIDException;
import oracle.dmt.op.re.reexception.NullParameterException;
import oracle.dmt.op.re.reexception.REProxyInitException;
import oracle.dmt.op.re.reexception.StringTooLargeException;
import oracle.jsp.webutil.personalization.ConfigFileException;
import oracle.jsp.webutil.personalization.InternalItem;
import oracle.jsp.webutil.personalization.Item;
import oracle.jsp.webutil.personalization.OPUtil;
import oracle.jsp.webutil.personalization.tagext.RecommendationGetter;
import oracle.jsp.webutil.personalization.tagext.XSellRecsTag;

public class EvaluateItemsTag
extends RecommendationGetter {
    private static final String MSG_FILE = "oracle.jsp.webutil.personalization.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.personalization.tagext.LocalStrings");
    Vector forItemList = null;
    int taxonomyID = Integer.MIN_VALUE;
    Item[] inputList = null;

    public EvaluateItemsTag() {
        this.tagName = "evaluateItems";
        this.isXSell = false;
    }

    public int doStartTag() throws JspTagException {
        if (OPUtil.isEmpty(this.storeResultsIn)) {
            throw new JspTagException(MessageFormat.format(msgs.getString("empty_attr"), "evaluateItems", "storeResultsIn"));
        }
        if (this.taxonomyID == Integer.MIN_VALUE) {
            throw new JspTagException(MessageFormat.format(msgs.getString("empty_attr"), "evaluateItems", "taxonomyID"));
        }
        this.forItemList = new Vector();
        return 1;
    }

    void addItem(InternalItem theItem) {
        this.forItemList.addElement(theItem);
    }

    public int doEndTag() throws JspTagException {
        REProxyRT proxy = OPUtil.getProxy(this.pageContext);
        IdentificationData idData = OPUtil.getIdData(this.pageContext);
        if (proxy == null) {
            throw new JspTagException(msgs.getString("no_proxy"));
        }
        if (idData == null) {
            throw new JspTagException(msgs.getString("no_id_data"));
        }
        try {
            if (this.forItemList.isEmpty() && (this.inputList == null || this.inputList.length == 0)) {
                this.pageContext.setAttribute(this.storeResultsIn, (Object)new Item[0]);
                this.release();
                return 6;
            }
            oracle.dmt.op.re.base.Item[] REitems = XSellRecsTag.combineInputLists(this.forItemList, this.inputList);
            TuningSettings tunings = this.createTuningSettings();
            RecommendationContent recContent = this.createRecommendationContent();
            RecommendationList recList = proxy.rateItems(idData, REitems, this.taxonomyID, tunings, recContent);
            this.processRecommendationResults(recList);
            this.release();
            return 6;
        }
        catch (ArrayTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (NullParameterException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (BadDBConnectionException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (InvalidIDException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (ErrorExecutingRE e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (REProxyInitException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (ConnectionPoolIsFullException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (StringTooLargeException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
        catch (ConfigFileException e) {
            throw new JspTagException(MessageFormat.format(msgs.getString("err_evaluateItems"), e.getMessage()));
        }
    }

    public void setTaxonomyID(String s) throws JspTagException {
        this.taxonomyID = this.getIntAttribute(s, "taxonomyID");
    }

    public void setInputItemList(Item[] l) {
        this.inputList = l;
    }

    public void release() {
        super.release();
        int taxonomyID = Integer.MIN_VALUE;
        this.inputList = null;
        this.forItemList = null;
    }
}

