/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi.tagext;

import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.calypso.invalidation.ActionInvalidator;
import oracle.calypso.invalidation.AdvancedSelectorInvalidator;
import oracle.calypso.invalidation.BasicSelectorInvalidator;
import oracle.calypso.invalidation.ObjectInvalidator;
import oracle.jsp.webutil.jesi.tagext.InvalidationTag;
import oracle.jsp.webutil.tagutil.TagUtil;

public class ObjectTag
extends BodyTagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.jesi.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.jesi.tagext.LocalStrings");
    private AdvancedSelectorInvalidator advSelInv;
    private String uri = null;
    private String prefix = "no";
    private String removalttl = "0";
    private ObjectInvalidator objInv;

    public void setUri(String s) {
        this.uri = s;
    }

    public String getUri() {
        return this.uri;
    }

    public void setPrefix(String s) {
        if (s != null) {
            this.prefix = s;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setMaxRemovalDelay(String s) {
        this.removalttl = s;
    }

    public String getMaxRemovalDelay() {
        return this.removalttl;
    }

    public void setAdvancedSelectorInvalidator(AdvancedSelectorInvalidator invalidator) {
        this.advSelInv = invalidator;
    }

    public AdvancedSelectorInvalidator getAdvancedSelectorInvalidator() {
        return this.advSelInv;
    }

    public AdvancedSelectorInvalidator createAdvancedSelectorInvalidator() {
        if (this.advSelInv != null) {
            return this.advSelInv;
        }
        if (this.prefix != null && !this.prefix.equals("") && this.prefix.equalsIgnoreCase("no")) {
            this.advSelInv = new AdvancedSelectorInvalidator("/");
            String uriExp = ObjectTag.URI2URIEXP(this.uri);
            this.advSelInv.setAttribute("URIEXP", uriExp);
            this.objInv.setChild(this.advSelInv);
        } else if (this.prefix != null && !this.prefix.equals("") && this.prefix.equalsIgnoreCase("yes")) {
            this.advSelInv = new AdvancedSelectorInvalidator(this.uri);
            this.objInv.setChild(this.advSelInv);
        }
        return this.advSelInv;
    }

    public int doEndTag() throws JspTagException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext application = this.pageContext.getServletContext();
        try {
            ActionInvalidator actInv;
            Tag parent = this.getParent();
            if (parent instanceof InvalidationTag) {
                actInv = new ActionInvalidator(this.removalttl);
                ((InvalidationTag)parent).getInvalidator2().setChild(this.objInv);
                if (this.uri.indexOf("://") < 0) {
                    this.uri = TagUtil.getAbsoluteUrlPath(this.uri, application, request);
                }
                if (this.prefix != null && !this.prefix.equals("") && this.prefix.equalsIgnoreCase("no") && this.advSelInv == null) {
                    BasicSelectorInvalidator bSelInv = new BasicSelectorInvalidator(this.uri);
                    this.objInv.setChild(bSelInv);
                } else if (this.prefix != null && !this.prefix.equals("") && this.prefix.equalsIgnoreCase("yes")) {
                    this.createAdvancedSelectorInvalidator();
                }
            } else {
                throw new JspTagException(msgs.getString("out_invalidate"));
            }
            this.objInv.setChild(actInv);
        }
        catch (Exception e) {
            this.release();
            throw new JspTagException(e.toString());
        }
        this.release();
        return 6;
    }

    public int doAfterBody() throws JspTagException {
        return 6;
    }

    public int doStartTag() throws JspTagException {
        if (this.prefix != null && !this.prefix.equalsIgnoreCase("yes") && !this.prefix.equalsIgnoreCase("no")) {
            this.release();
            throw new JspTagException(msgs.getString("invalid_prefix"));
        }
        if (this.uri == null || this.uri.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("uri_null_empty"));
        }
        if (this.removalttl == null || this.removalttl.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("removalttl_null_empty"));
        }
        try {
            if (new Integer(this.removalttl) < 0) {
                this.release();
                throw new JspTagException(msgs.getString("negative_value"));
            }
        }
        catch (Exception e) {
            this.release();
            throw new JspTagException(e.toString());
        }
        this.objInv = new ObjectInvalidator();
        return 2;
    }

    public void release() {
        this.uri = null;
        this.prefix = "no";
        this.removalttl = "0";
        this.objInv = null;
        this.advSelInv = null;
    }

    private static String URI2URIEXP(String URI2) {
        String URIEXP = '^' + URI2 + '$';
        int i = URI2.indexOf(46);
        if (i >= 0) {
            URIEXP = '^' + URI2.substring(0, i) + '\\' + URI2.substring(i);
        }
        return URIEXP;
    }
}

