/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi.tagext;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.jsp.webutil.jesi.URLEncoder;

public class JESIBodyTag
extends BodyTagSupport {
    protected static final String MSG_FILE = "oracle.jsp.webutil.jesi.tagext.LocalStrings";
    protected static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.jesi.tagext.LocalStrings");
    protected static final String FRAGMENT_PARAM = "__esi_fragment";
    protected static final int FRAGMENT_NONE = -1;
    protected static final String SURROGATE_CAPABILITY = "Surrogate-Capability";
    protected static final String SURROGATE_CTL_HEADER = "Surrogate-Control";
    protected static final String SURROGATE_10 = "Surrogate/1.0";
    protected static final String ESI_10 = "ESI/1.0";
    protected static final String CONTENT_ESI_10 = "content=\"ESI/1.0\"";
    protected static final String DEFAULT_EXPIRATION = "86400";
    protected static final String DEFAULT_DELAY = "0";
    protected static final String UNSET = "unset";
    protected static final String CONTROL_TAG = "oracle.jsp.webutil.jesi.tagext.controltag";
    protected static final String TEMPLATE_TAG = "oracle.jsp.webutil.jesi.tagext.templatetag";
    protected static final String TEMPLATE_INUSE = "oracle.jsp.webutil.jesi.tagext.template.inuse";
    static HashMap RESERVED_PARAM_NAMES = new HashMap();
    protected String control = null;
    protected String cache = null;
    protected String expiration = "unset";
    protected String maxRemovalDelay = "unset";

    public void setCache(String s) {
        this.cache = s;
    }

    public String getCache() {
        return this.cache;
    }

    public void setExpiration(String s) {
        this.expiration = s;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setMaxRemovalDelay(String s) {
        this.maxRemovalDelay = s;
    }

    public String getMaxRemovalDelay() {
        return this.maxRemovalDelay;
    }

    public void setControl(String s) {
        this.control = s;
    }

    public String getControl() {
        return this.control;
    }

    protected String makeSurrogateControl() throws JspTagException {
        if (this.expiration == null || this.expiration.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("expiration_null_empty"));
        }
        if (this.maxRemovalDelay == null || this.maxRemovalDelay.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("removalttl_null_empty"));
        }
        try {
            if (!this.expiration.equals(UNSET) && new Integer(this.expiration) < 0) {
                throw new JspTagException(msgs.getString("negative_value"));
            }
            if (!this.maxRemovalDelay.equals(UNSET) && new Integer(this.maxRemovalDelay) < 0) {
                throw new JspTagException(msgs.getString("negative_value"));
            }
        }
        catch (NumberFormatException e) {
            this.release();
            throw new JspTagException(e.toString());
        }
        String surrogata = CONTENT_ESI_10;
        if (!this.expiration.equals(UNSET)) {
            if (this.maxRemovalDelay.equals(UNSET)) {
                this.maxRemovalDelay = DEFAULT_DELAY;
            }
            surrogata = surrogata + ",max-age=" + this.expiration + "+" + this.maxRemovalDelay;
        } else if (!this.maxRemovalDelay.equals(UNSET)) {
            surrogata = surrogata + ",max-age=86400+" + this.maxRemovalDelay;
        }
        if (this.cache != null) {
            if (this.cache.equalsIgnoreCase("yes")) {
                if (surrogata.indexOf("max-age") == -1) {
                    surrogata = surrogata + ",max-age=86400+0";
                }
            } else if (this.cache.equalsIgnoreCase("no")) {
                surrogata = surrogata + ",no-store";
            } else if (this.cache.equalsIgnoreCase("no-remote")) {
                surrogata = surrogata + ",no-store-remote";
            } else {
                this.release();
                throw new JspTagException(msgs.getString("invalid_cache"));
            }
        }
        if (this.control != null) {
            surrogata = surrogata + "," + this.control;
        }
        return surrogata;
    }

    static String copyParams(HttpServletRequest request, HttpServletResponse response, String url, boolean copyparam, Vector params) {
        String name;
        int idx = url.indexOf("?");
        String requestURI = idx < 0 ? url : url.substring(0, idx);
        StringBuffer sb = new StringBuffer();
        String queryStr = null;
        if (idx >= 0 && url.length() > idx + 1) {
            queryStr = url.substring(idx + 1);
        }
        if (queryStr != null) {
            StringTokenizer st = new StringTokenizer(queryStr, " ", true);
            name = null;
            String val = null;
            while (st.hasMoreTokens()) {
                try {
                    name = null;
                    val = null;
                    name = st.nextToken("=");
                    st.nextToken();
                    val = st.nextToken("&");
                    st.nextToken();
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                if (name == null) continue;
                sb.append("&").append(URLEncoder.encode(name, request, response)).append("=").append(val != null ? URLEncoder.encode(val, request, response) : "");
            }
        }
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                String[] param = (String[])params.elementAt(i);
                sb.append("&").append(URLEncoder.encode(param[0], request, response));
                sb.append("=").append(URLEncoder.encode(param[1], request, response));
            }
        }
        if (copyparam) {
            Enumeration pars = request.getParameterNames();
            while (pars.hasMoreElements()) {
                name = (String)pars.nextElement();
                if (RESERVED_PARAM_NAMES.get(name) != null) continue;
                String[] vals = request.getParameterValues(name);
                for (int i = 0; i < vals.length; ++i) {
                    sb.append("&").append(URLEncoder.encode(name, request, response)).append("=").append(vals[i] != null ? URLEncoder.encode(vals[i], request, response) : "");
                }
            }
        }
        String reqParams = null;
        if (sb.length() > 0) {
            reqParams = sb.substring(1);
        }
        if (reqParams != null) {
            return requestURI + "?" + reqParams;
        }
        return url;
    }

    public void release() {
        this.cache = null;
        this.expiration = UNSET;
        this.maxRemovalDelay = UNSET;
        this.control = null;
    }

    static {
        RESERVED_PARAM_NAMES.put(FRAGMENT_PARAM, "");
    }
}

