/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi.tagext;

import com.evermind.security.SecuritySensitive;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.calypso.invalidation.Invalidator;
import oracle.calypso.invalidation.Invalidator2;
import oracle.calypso.invalidation.SystemInvalidator;
import oracle.jsp.webutil.jesi.JspConfig;
import oracle.jsp.webutil.jesi.JspConfigLoad;
import oracle.jsp.webutil.jesi.JspWebCache;
import oracle.jsp.webutil.jesi.tagext.JESITag;
import oracle.jsp.webutil.tagutil.TagUtil;

public class InvalidationTag
extends BodyTagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.jesi.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.jesi.tagext.LocalStrings");
    private String invalidationURL;
    private String user;
    private String password;
    private String output;
    private String config;
    private Invalidator2 invalidator2;
    private SystemInvalidator sysInv;

    public void setUrl(String s) {
        this.invalidationURL = s;
    }

    public String getUrl() {
        return this.invalidationURL;
    }

    public void setUsername(String s) {
        this.user = s;
    }

    public String getUsername() {
        return this.user;
    }

    public void setPassword(String s) {
        try {
            this.password = SecuritySensitive.global().decode(s);
        }
        catch (NoClassDefFoundError e) {
            this.password = s;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public String getOutput() {
        return this.output;
    }

    public void setConfig(String s) {
        this.config = s;
    }

    public String getConfig() {
        return this.config;
    }

    public void setInvalidator2(Invalidator2 inv2) {
        this.invalidator2 = inv2;
    }

    public Invalidator getInvalidator2() {
        return this.invalidator2;
    }

    public void setSystemInvalidator(SystemInvalidator inv) {
        this.sysInv = inv;
    }

    public SystemInvalidator getSystemInvalidator() {
        return this.sysInv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doStartTag() throws JspTagException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (!JESITag.requestFromESI_10(request)) {
            return 0;
        }
        if (this.invalidationURL != null && this.invalidationURL.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("url_empty"));
        }
        if (this.user != null && this.user.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("user_empty"));
        }
        if (this.password != null && this.password.equals("")) {
            this.release();
            throw new JspTagException(msgs.getString("password_empty"));
        }
        if (!(this.invalidationURL != null && this.user != null && this.password != null || this.invalidationURL == null && this.user == null && this.password == null)) {
            this.release();
            throw new JspTagException(msgs.getString("specify_conflict"));
        }
        ServletContext application = this.pageContext.getServletContext();
        try {
            block20: {
                if (this.invalidationURL != null) {
                    if (this.invalidationURL.indexOf("://") < 0) {
                        this.invalidationURL = TagUtil.getAbsoluteUrlPath(this.invalidationURL, application, request);
                    }
                    this.invalidator2 = new Invalidator2(this.invalidationURL, this.user, this.password);
                    return 2;
                }
                if (this.config != null && this.config.equals("")) {
                    this.release();
                    throw new JspTagException(msgs.getString("config_empty"));
                }
                JspConfig jspCfg = null;
                if (this.config != null) {
                    InputStream input = application.getResourceAsStream(this.config);
                    if (input == null) {
                        this.release();
                        throw new JspTagException(msgs.getString("config_invalid"));
                    }
                    jspCfg = new JspConfigLoad(input).getJspConfig();
                    JspWebCache cache = null;
                    if (jspCfg != null) {
                        cache = jspCfg.getWebCache();
                    }
                    if (jspCfg != null && cache != null) {
                        this.invalidationURL = cache.getProperty("url");
                        this.user = cache.getProperty("username");
                        this.password = cache.getProperty("password");
                        if (this.invalidationURL == null || this.user == null || this.password == null) {
                            this.release();
                            throw new JspTagException(msgs.getString("require_all") + this.config);
                        }
                        break block20;
                    } else {
                        this.release();
                        throw new JspTagException(msgs.getString("no_specify") + this.config);
                    }
                }
                jspCfg = JspConfigLoad.getDefaultConfig(application);
                JspWebCache cache = null;
                if (jspCfg == null) {
                    this.release();
                    throw new JspTagException(msgs.getString("config_null"));
                }
                cache = jspCfg.getWebCache();
                if (cache == null) {
                    this.release();
                    throw new JspTagException(msgs.getString("no_default"));
                }
                this.invalidationURL = cache.getProperty("url");
                this.user = cache.getProperty("username");
                this.password = cache.getProperty("password");
                if (this.invalidationURL == null || this.user == null || this.password == null) {
                    this.release();
                    throw new JspTagException(msgs.getString("required_all_config"));
                }
            }
            if (this.invalidationURL.indexOf("://") < 0) {
                this.invalidationURL = TagUtil.getAbsoluteUrlPath(this.invalidationURL, application, request);
            }
            this.invalidator2 = new Invalidator2(this.invalidationURL, this.user, this.password);
            return 2;
        }
        catch (Exception e) {
            this.release();
            throw new JspTagException(e.toString());
        }
    }

    public int doAfterBody() throws JspTagException {
        return 6;
    }

    public int doEndTag() throws JspTagException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (JESITag.requestFromESI_10(request)) {
            try {
                BodyContent body = this.getBodyContent();
                String bodyString = body.getString();
                JspWriter out = body.getEnclosingWriter();
                if (this.invalidator2.invalidate()) {
                    if ("browser".equalsIgnoreCase(this.output)) {
                        out.println(msgs.getString("succeed"));
                        out.println(msgs.getString("response") + InvalidationTag.escapeReservedChars(this.invalidator2.getInvalidationResponse()));
                    }
                } else if ("browser".equalsIgnoreCase(this.output)) {
                    out.println(msgs.getString("failed"));
                }
            }
            catch (Exception e) {
                this.release();
                throw new JspTagException(e.toString());
            }
        }
        this.release();
        return 6;
    }

    public void release() {
        this.invalidationURL = null;
        this.user = null;
        this.password = null;
        this.output = null;
        this.config = null;
    }

    public static String escapeReservedChars(String orig) {
        if (orig == null) {
            return "";
        }
        char[] toRemove = new char[]{'\"', '\'', ';', '/', '?', ':', '@', '=', '&', '<', '>'};
        String[] replacements = new String[]{"&#34;", "&#39;", "&#59;", "&#47;", "&#63;", "&#58;", "&#64;", "&#61;", "&#38;", "&#60;", "&#62;"};
        StringBuffer result = new StringBuffer(orig.length());
        if (toRemove.length != replacements.length) {
            return orig;
        }
        char[] origCharArr = orig.toCharArray();
        int arrLength = origCharArr.length;
        try {
            int i = 0;
            while (true) {
                String toAdd = null;
                for (int j = 0; j < toRemove.length; ++j) {
                    if (origCharArr[i] != toRemove[j]) continue;
                    toAdd = replacements[j];
                    break;
                }
                if (toAdd == null) {
                    result.append(origCharArr[i]);
                } else {
                    result.append(toAdd);
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException abe) {
            return result.toString();
        }
    }
}

