/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.jesi;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.webutil.tagutil.TagUtil;

public class URLEncoder {
    public static String getCharacterEncoding(HttpServletRequest req, HttpServletResponse resp) {
        String encoding = null;
        encoding = req.getCharacterEncoding();
        if (encoding != null) {
            return encoding;
        }
        encoding = resp.getCharacterEncoding();
        if (encoding != null) {
            return encoding;
        }
        encoding = "UTF-8";
        return encoding;
    }

    public static String encode(String s, HttpServletRequest req, HttpServletResponse resp) {
        StringBuffer sb = new StringBuffer();
        String givenEncoding = URLEncoder.getCharacterEncoding(req, resp);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                sb.append(c);
                continue;
            }
            String convStr = new Character(c).toString();
            if (givenEncoding != null) {
                String encoding = TagUtil.convIANAtoJavaEncoding(givenEncoding, false);
                if (encoding == null) {
                    encoding = givenEncoding;
                }
                try {
                    b = convStr.getBytes(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    b = convStr.getBytes();
                }
            } else {
                b = convStr.getBytes();
            }
            for (int j = 0; j < b.length; ++j) {
                String hexStr;
                int val = b[j];
                if (val < 0) {
                    val += 256;
                }
                if ((hexStr = Integer.toHexString(val)).length() == 1) {
                    hexStr = '0' + hexStr;
                }
                sb.append('%');
                sb.append(hexStr);
            }
        }
        return new String(sb);
    }
}

