/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess.tagext;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class HttpUploadFormTag
extends BodyTagSupport {
    private static final String MSG_FILE = "oracle.jsp.webutil.fileaccess.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.fileaccess.tagext.LocalStrings");
    private static int DEFAULTINPUTSIZE = 20;
    private static int DEFAULTINPUTMAXSIZE = 80;
    private static int DEFAULTMAXFILES = 1;
    private static String preamble1 = "<form action=\"";
    private static String preamble2 = "\" ENCTYPE=\"multipart/form-data\" method=POST>";
    private static String postscript1 = "<br><INPUT TYPE=\"SUBMIT\" NAME=\"Submit\" VALUE=\"";
    private static String postscript2 = "\"> </form>";
    private static String inputLine1 = "<INPUT TYPE=\"FILE\" NAME=\"File\" SIZE=\"";
    private static String inputLine2 = "\" MAXLENGTH=\"";
    private static String inputLine3 = "\" >";
    private static String DEFAULTBUTTONTEXT = "Send";
    private static boolean DEFAULTINCLUDENUM = false;
    private int maxFiles;
    private int inputSize;
    private int inputMaxSize;
    private String buttonText;
    private boolean includeNumbers;
    private String formsAction;
    private int counter;

    public HttpUploadFormTag() {
        this.resetAttr();
    }

    public void release() {
        this.resetAttr();
    }

    private void resetAttr() {
        this.maxFiles = DEFAULTMAXFILES;
        this.inputSize = DEFAULTINPUTSIZE;
        this.inputMaxSize = DEFAULTINPUTMAXSIZE;
        this.buttonText = DEFAULTBUTTONTEXT;
        this.includeNumbers = DEFAULTINCLUDENUM;
        this.formsAction = null;
        this.counter = 0;
    }

    public int doStartTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            this.counter = 0;
            this.maxFiles = this.getMaxFiles();
            out.write(preamble1 + this.getFormsAction() + preamble2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 2;
    }

    public void doInitBody() {
    }

    public int doAfterBody() throws JspTagException {
        try {
            BodyContent body = this.getBodyContent();
            if (this.counter < this.maxFiles) {
                ++this.counter;
                if (this.includeNumbers) {
                    body.print(this.counter);
                }
                body.println(inputLine1 + this.inputSize + inputLine2 + this.inputMaxSize + inputLine3);
            }
            if (this.counter < this.maxFiles) {
                return 2;
            }
            body.print(postscript1);
            body.print(this.buttonText);
            body.println(postscript2);
            body.writeOut((Writer)this.getPreviousOut());
            return 0;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString());
        }
    }

    public int doEndTag() throws JspTagException {
        this.resetAttr();
        return 6;
    }

    public void setFormsAction(String action) throws JspTagException {
        if (action == null || action.equals("")) {
            throw new JspTagException(msgs.getString("no_formsAction"));
        }
        this.formsAction = action;
    }

    public String getFormsAction() {
        return this.formsAction;
    }

    public void setMaxFiles(String num) throws JspTagException {
        try {
            this.maxFiles = new Integer(num);
            if (this.maxFiles == 0) {
                this.maxFiles = DEFAULTMAXFILES;
            }
            if (this.maxFiles < 1) {
                throw new JspTagException(MessageFormat.format(msgs.getString("invalid_max_files"), num));
            }
        }
        catch (NumberFormatException n) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_max_num"), num));
        }
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setFileNameSize(String num) throws JspTagException {
        try {
            this.inputSize = new Integer(num);
            if (this.inputSize < 1) {
                throw new JspTagException(MessageFormat.format(msgs.getString("size_too_small"), num));
            }
        }
        catch (NumberFormatException n) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_name_size"), num));
        }
    }

    public void setMaxFileNameSize(String num) throws JspTagException {
        try {
            this.inputMaxSize = new Integer(num);
            if (this.inputMaxSize < 1) {
                throw new JspTagException(MessageFormat.format(msgs.getString("size_too_small"), num));
            }
        }
        catch (NumberFormatException n) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_name_size"), num));
        }
    }

    public void setIncludeNumbers(String boolval) throws JspTagException {
        String temp = boolval.toLowerCase();
        if (temp.equals("true")) {
            this.includeNumbers = true;
        } else if (temp.equals("false")) {
            this.includeNumbers = false;
        } else if (temp == null || temp.equals("")) {
            this.includeNumbers = DEFAULTINCLUDENUM;
        } else {
            throw new JspTagException(MessageFormat.format(msgs.getString("not_boolean"), boolval));
        }
    }

    public void setSubmitButtonText(String s) {
        this.buttonText = s == null || s.equals("") ? DEFAULTBUTTONTEXT : s;
    }
}

