/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess.tagext;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.dbutil.tagext.dbOpenTag;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.HttpDownloadBean;

public class HttpDownloadTag
extends BodyTagSupport {
    private static String part1 = "<a href=\"";
    private static String part2 = "\" > ";
    private static String part3 = "</a>";
    private String sourceType = "filesystem";
    private String fileType = "binary";
    private String recurse = "true";
    private String table = "fileaccess";
    private String prefixCol = "fileprefix";
    private String fileNameCol = "filename";
    private String dataCol = "data";
    private String scope = "page";
    private String source;
    private String servletPath;
    private String connectionId;
    private String docCharacterset = "ISO-8859-1";
    private HttpDownloadBean downBean;
    private Enumeration fileNames;
    private ConnBean cb;
    private static final String MSG_FILE = "oracle.jsp.webutil.fileaccess.tagext.LocalStrings";
    private static final ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.fileaccess.tagext.LocalStrings");

    public HttpDownloadTag() {
        this.resetAttr();
    }

    public void release() {
        this.resetAttr();
    }

    private void resetAttr() {
        this.sourceType = "filesystem";
        this.fileType = "binary";
        this.recurse = "true";
        this.table = "fileaccess";
        this.prefixCol = "fileprefix";
        this.fileNameCol = "filename";
        this.dataCol = "data";
        this.source = null;
        this.servletPath = null;
        this.connectionId = null;
        this.downBean = null;
        this.fileNames = null;
        this.cb = null;
    }

    public int doStartTag() throws JspTagException {
        try {
            this.downBean = new HttpDownloadBean();
            if (this.sourceType == null || this.sourceType.equals("")) {
                throw new JspException(msgs.getString("NO_SOURCETYPE"));
            }
            this.downBean.setSourceType(this.sourceType);
            this.downBean.setFileType(this.fileType);
            this.downBean.setRecurse(this.recurse);
            if (this.sourceType.equalsIgnoreCase("filesystem")) {
                this.downBean.setBaseDir(this.pageContext.getServletContext(), (HttpServletRequest)this.pageContext.getRequest());
                this.downBean.setSource(this.source);
            }
            if (this.sourceType.equalsIgnoreCase("database")) {
                this.establishConnection();
                this.downBean.setTable(this.table);
                this.downBean.setPrefixColumn(this.prefixCol);
                this.downBean.setFileNameColumn(this.fileNameCol);
                this.downBean.setDataColumn(this.dataCol);
                this.downBean.setSource(this.source);
                this.downBean.setDocCharacterset(this.docCharacterset);
            }
            this.downBean.listFiles((HttpServletRequest)this.pageContext.getRequest());
            this.fileNames = this.downBean.getFileNames();
        }
        catch (FileAccessException a) {
            throw new JspTagException(a.toString());
        }
        catch (Exception e) {
            throw new JspTagException(e.toString());
        }
        return 2;
    }

    public void doInitBody() {
    }

    public int doAfterBody() throws JspTagException {
        try {
            BodyContent body = this.getBodyContent();
            if (this.fileNames.hasMoreElements()) {
                String name = ((String)this.fileNames.nextElement()).replace('\\', '/');
                body.print(part1);
                if (this.sourceType.equalsIgnoreCase("filesystem")) {
                    body.print(this.servletPath + name);
                } else {
                    body.print(this.servletPath + name + "?" + "srcType" + "=" + this.downBean.getSourceType() + "&" + "fileType" + "=" + this.downBean.getFileType() + "&" + "table" + "=" + this.downBean.getTable() + "&" + "prefixCol" + "=" + this.downBean.getPrefixColumn() + "&" + "fileNameCol" + "=" + this.downBean.getFileNameColumn() + "&" + "dataCol" + "=" + this.downBean.getDataColumn() + "&" + "docCharacterset" + "=" + this.downBean.getDocCharacterset());
                }
                body.print(part2);
                body.println(name);
                body.println(part3);
            }
            if (this.fileNames.hasMoreElements()) {
                return 2;
            }
            body.writeOut((Writer)this.getPreviousOut());
            return 0;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString());
        }
    }

    public int doEndTag() throws JspTagException {
        this.resetAttr();
        return 6;
    }

    private void establishConnection() throws JspTagException {
        String cid = this.getConnId();
        if (cid != null) {
            if (this.scope == null || this.scope.equals("page")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid);
            } else if (this.scope.equals("request")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 2);
            } else if (this.scope.equals("session")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 3);
            } else if (this.scope.equals("application")) {
                this.cb = (ConnBean)this.pageContext.getAttribute(cid, 4);
            }
            if (this.cb == null) {
                throw new JspTagException(MessageFormat.format(msgs.getString("CONNID_NOT_FOUND"), cid, this.scope));
            }
        } else {
            dbOpenTag tag = (dbOpenTag)HttpDownloadTag.findAncestorWithClass((Tag)this, (Class)dbOpenTag.class);
            if (tag == null) {
                throw new JspTagException(msgs.getString("NO_ENCLOSING_CONNECTION"));
            }
            this.cb = tag.getConnBean();
        }
        if (this.cb == null) {
            throw new JspTagException(msgs.getString("NO_CONNECTION"));
        }
        try {
            this.cb.connect();
            this.downBean.setConnection(this.cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSource(String s) {
        this.source = s;
    }

    public void setSourceType(String s) {
        this.sourceType = s;
    }

    public void setServletPath(String s) throws JspTagException {
        if (s == null || s.equals("")) {
            throw new JspTagException(msgs.getString("NO_SERVLETPATH"));
        }
        this.servletPath = s.endsWith("/") ? s : s + "/";
    }

    public void setConnId(String s) {
        this.connectionId = s;
    }

    public String getConnId() {
        return this.connectionId;
    }

    public void setScope(String s) throws JspTagException {
        if (s == null || s.equals("")) {
            throw new JspTagException(msgs.getString("NO_SCOPE"));
        }
        String temp = s.toLowerCase();
        if (!(temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("INVALID_SCOPE"), s));
        }
        this.scope = temp;
    }

    public void setRecurse(String s) {
        this.recurse = s;
    }

    public void setFileType(String s) {
        this.fileType = s;
    }

    public void setTable(String s) {
        this.table = s;
    }

    public void setPrefixColumn(String s) {
        this.prefixCol = s;
    }

    public void setFileNameColumn(String s) {
        this.fileNameCol = s;
    }

    public void setDataColumn(String s) {
        this.dataCol = s;
    }

    public void setDocCharacterset(String s) {
        this.docCharacterset = s;
    }
}

