/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.fileaccess.BinaryFile;
import oracle.jsp.webutil.fileaccess.DatabaseEntity;
import oracle.jsp.webutil.fileaccess.DbDetails;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.FileBLOB;
import oracle.jsp.webutil.fileaccess.FileCLOB;
import oracle.jsp.webutil.fileaccess.FileDetails;
import oracle.jsp.webutil.fileaccess.PersistentEntity;
import oracle.jsp.webutil.tagutil.TagUtil;

public abstract class HttpFileAccessBean
implements Serializable {
    protected static int ACCESSUPLOAD = 0;
    protected static int ACCESSDOWNLOAD = 1;
    protected Enumeration fileNames;
    protected DbDetails dd = new DbDetails();
    protected FileDetails fd = new FileDetails();

    protected void setFileType(String s) throws FileAccessException {
        if (s == null || s.equals("") || s.equalsIgnoreCase("binary")) {
            this.fd.setFileType(0);
        } else if (s.equalsIgnoreCase("character")) {
            this.fd.setFileType(1);
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_FILE_TYPE", s));
        }
    }

    protected void setFileType(int i) throws FileAccessException {
        if (i != 0 && i != 1) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_FILE_TYPE_INT", new Integer(i).toString()));
        }
        this.fd.setFileType(i);
    }

    protected void setTable(String s) throws FileAccessException {
        if (s == null || s.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("TABLE_NAME_NULL"));
        }
        this.dd.setTableName(s);
    }

    protected void setPrefixColumn(String s) throws FileAccessException {
        if (s == null || s.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("PREFIXCOL_NAME_NULL"));
        }
        this.dd.setDestColName(s);
    }

    protected void setFileNameColumn(String s) throws FileAccessException {
        if (s == null || s.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("FILENAMECOLL_NAME_NULL"));
        }
        this.dd.setFileColName(s);
    }

    protected void setDataColumn(String s) throws FileAccessException {
        if (s == null || s.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("DATANAMECOLL_NAME_NULL"));
        }
        this.dd.setDataColName(s);
    }

    protected void setConnBean(ConnBean cb) {
        this.dd.setConnBean(cb);
    }

    protected void setConnection(Connection conn) {
        this.dd.setConnBean(new ConnBean());
        this.dd.connBean.setConnection(conn);
        this.dd.isPlainConnection = true;
    }

    protected void setBaseDir(ServletContext sc, HttpServletRequest req) throws FileAccessException {
        this.fd.basedir = this.getBaseDir(sc, req);
    }

    protected PersistentEntity initPersistentEntity() throws FileAccessException {
        PersistentEntity pe = null;
        if (this.fd.locationType == 0) {
            pe = new BinaryFile();
        }
        if (this.fd.locationType == 1) {
            pe = this.fd.fileType == 0 ? new FileBLOB() : new FileCLOB();
            ((DatabaseEntity)pe).setDbDetails(this.dd);
            ((DatabaseEntity)pe).establishConnection();
        }
        pe.setFileDetails(this.fd);
        pe.checkLocation();
        return pe;
    }

    protected void setLocationType(String locType, int typ) throws FileAccessException {
        if (locType == null || locType.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION_TYPE" : "INVALID_SOURCE_TYPE", locType));
        }
        if (locType.equalsIgnoreCase("filesystem")) {
            this.fd.locationType = 0;
        } else if (locType.equalsIgnoreCase("database")) {
            this.fd.locationType = 1;
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION_TYPE" : "INVALID_SOURCE_TYPE", locType));
        }
    }

    protected void setLocationType(int srcType, int typ) throws FileAccessException {
        if (srcType != 0 && srcType != 1) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION_TYPE_BOOL" : "INVALID_SOURCE_TYPE_BOOL", new Integer(srcType)).toString());
        }
        this.fd.locationType = srcType;
    }

    protected void setLocation(String s, int typ) throws FileAccessException {
        if (s == null || s.equals("")) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION" : "INVALID_SOURCE", s));
        }
        if (s.equals("*") && typ == ACCESSDOWNLOAD) {
            this.fd.location = s;
        } else if (!s.equals("*")) {
            String s1 = System.getProperty("file.separator").equals("/") ? TagUtil.handleDotsInPath(s, '\\') : TagUtil.handleDotsInPath(s, '/');
            if (s1 == null) {
                throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION" : "INVALID_SOURCE", s));
            }
            s1 = TagUtil.handleDotsInPath(s, System.getProperty("file.separator").charAt(0));
            if (s1 == null) {
                throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION" : "INVALID_SOURCE", s));
            }
            this.fd.location = s1;
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage(typ == ACCESSUPLOAD ? "INVALID_DESTINATION" : "INVALID_SOURCE", s));
        }
    }

    protected void setDocCharacterset(String charset) {
        if (charset == null || charset.equals("")) {
            this.fd.setDocCharacterset("ISO-8859-1");
        } else {
            this.fd.setDocCharacterset(charset);
        }
    }

    protected String getLocationType() {
        return this.fd.locationType == 0 ? "filesystem" : "database";
    }

    protected String getLocation() {
        return this.fd.location;
    }

    protected String getFileType() {
        return this.fd.fileType == 0 ? "binary" : "character";
    }

    protected String getTable() {
        return this.dd.tableName;
    }

    protected String getPrefixColumn() {
        return this.dd.destColName;
    }

    protected String getFileNameColumn() {
        return this.dd.fileColName;
    }

    protected String getDataColumn() {
        return this.dd.dataColName;
    }

    protected ConnBean getConnBean() {
        return this.dd.connBean;
    }

    protected Connection getConnection() {
        return this.dd.conn;
    }

    protected Enumeration getFileNames() {
        return this.fileNames;
    }

    public String getDocCharacterset() {
        return this.fd.getDocCharacterset();
    }

    private String getBaseDir(ServletContext sc, HttpServletRequest req) throws FileAccessException {
        return new FileAccessUtil().getBaseDir(sc, req);
    }
}

