/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.fileaccess.DatabaseEntity;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.HttpFileAccessBean;
import oracle.jsp.webutil.fileaccess.PersistentEntity;

public class HttpDownloadBean
extends HttpFileAccessBean
implements Serializable {
    public void listFiles(HttpServletRequest req) throws FileAccessException {
        HttpSession session = null;
        try {
            PersistentEntity pe = this.initPersistentEntity();
            this.fileNames = pe.getFileNames();
            if (this.fd.locationType == 1) {
                if (((DatabaseEntity)pe).dd.connBean != null && !((DatabaseEntity)pe).dd.isPlainConnection) {
                    ((DatabaseEntity)pe).releaseConnection();
                    session = req.getSession(true);
                    session.putValue("9843UF8HF9YT9NVRJG", (Object)((DatabaseEntity)pe).dd.connBean);
                } else if (((DatabaseEntity)pe).dd.conn != null) {
                    session = req.getSession(true);
                    session.putValue("9843UF8HF9YT9NVRJG", (Object)((DatabaseEntity)pe).dd.conn);
                }
            }
        }
        catch (FileAccessException ae) {
            try {
                if (session != null && this.fd.locationType == 1) {
                    session.invalidate();
                }
            }
            catch (Exception e) {
                throw new FileAccessException(e.getMessage());
            }
            throw new FileAccessException(ae.getMessage());
        }
        catch (Exception e) {
            throw new FileAccessException(e.getMessage());
        }
    }

    public void setRecurse(String s) throws FileAccessException {
        if (s == null || s.equals("") || s.equalsIgnoreCase("true")) {
            this.fd.recurse = true;
        } else if (s.equalsIgnoreCase("false")) {
            this.fd.recurse = false;
        } else {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_RECURSE", s));
        }
    }

    public void setRecurse(boolean recurse) {
        this.fd.recurse = recurse;
    }

    public void setSourceType(String srcType) throws FileAccessException {
        this.setLocationType(srcType, ACCESSDOWNLOAD);
    }

    public void setSourceType(int srcType) throws FileAccessException {
        this.setLocationType(srcType, ACCESSDOWNLOAD);
    }

    public void setSource(String s) throws FileAccessException {
        this.setLocation(s, ACCESSDOWNLOAD);
    }

    public void setFileType(String s) throws FileAccessException {
        super.setFileType(s);
    }

    public void setFileType(int i) throws FileAccessException {
        super.setFileType(i);
    }

    public void setTable(String s) throws FileAccessException {
        super.setTable(s);
    }

    public void setPrefixColumn(String s) throws FileAccessException {
        super.setPrefixColumn(s);
    }

    public void setFileNameColumn(String s) throws FileAccessException {
        super.setFileNameColumn(s);
    }

    public void setDataColumn(String s) throws FileAccessException {
        super.setDataColumn(s);
    }

    public void setConnection(ConnBean cb) {
        super.setConnBean(cb);
    }

    public void setConnection(Connection conn) {
        super.setConnection(conn);
    }

    public void setBaseDir(ServletContext servletContext, HttpServletRequest request) throws FileAccessException {
        super.setBaseDir(servletContext, request);
    }

    public void setDocCharacterset(String charset) {
        super.setDocCharacterset(charset);
    }

    public String getRecurse() {
        return this.fd.recurse ? "true" : "false";
    }

    public String getSourceType() {
        return this.getLocationType();
    }

    public String getSource() {
        return this.getLocation();
    }

    public String getFileType() {
        return super.getFileType();
    }

    public String getTable() {
        return super.getTable();
    }

    public String getPrefixColumn() {
        return super.getPrefixColumn();
    }

    public String getFileNameColumn() {
        return super.getFileNameColumn();
    }

    public String getDataColumn() {
        return super.getDataColumn();
    }

    public Enumeration getFileNames() {
        return super.getFileNames();
    }

    public String getDocCharacterset() {
        return super.getDocCharacterset();
    }
}

