/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import oracle.jsp.webutil.fileaccess.BinaryFile;
import oracle.jsp.webutil.fileaccess.DatabaseEntity;
import oracle.jsp.webutil.fileaccess.DbDetails;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.FileBLOB;
import oracle.jsp.webutil.fileaccess.FileCLOB;
import oracle.jsp.webutil.fileaccess.FileDetails;
import oracle.jsp.webutil.fileaccess.FormBasedStream;
import oracle.jsp.webutil.fileaccess.PersistentEntity;
import oracle.jsp.webutil.fileaccess.UploadedFileDetails;

class FormBasedUpload {
    private static final int MAX_POST_SIZE = Integer.MAX_VALUE;
    private ServletRequest req;
    private int maxSize = Integer.MAX_VALUE;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();
    private Vector fileVector = new Vector();
    protected DbDetails dd;
    protected FileDetails fd;
    private PersistentEntity pe;

    FormBasedUpload() {
    }

    private PersistentEntity initPersistentEntity() throws FileAccessException {
        PersistentEntity pe = null;
        if (this.fd.locationType == 0) {
            pe = new BinaryFile();
        }
        if (this.fd.locationType == 1) {
            pe = this.fd.fileType == 0 ? new FileBLOB() : new FileCLOB();
            ((DatabaseEntity)pe).setDbDetails(this.dd);
            ((DatabaseEntity)pe).establishConnection();
        }
        pe.setFileDetails(this.fd);
        pe.checkLocation();
        return pe;
    }

    void upload(ServletRequest req) throws IOException, FileAccessException {
        if (req == null) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("NULL_REQUEST_ERROR"));
        }
        this.req = req;
        PersistentEntity pe = this.initPersistentEntity();
        this.readRequest(pe);
        pe.deleteEmpty();
        if (this.fd.locationType == 1) {
            ((DatabaseEntity)pe).releaseConnection();
        }
        this.fd.fileList = (Vector)this.fileVector.clone();
    }

    void setRequest(ServletRequest req) {
        this.req = req;
    }

    Hashtable getParameters() {
        return this.parameters;
    }

    Hashtable getFiles() {
        return this.files;
    }

    Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    Enumeration getFileNames() {
        if (this.fd.fileList == null) {
            return null;
        }
        return this.fd.fileList.elements();
    }

    String getParameter(String name) {
        String param = (String)this.parameters.get(name);
        if (param.equals("")) {
            return null;
        }
        return param;
    }

    void readRequest(PersistentEntity pe) throws IOException, FileAccessException {
        String type = this.req.getContentType();
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException(FileAccessUtil.formatErrorMessage("NOT_MULTIPART_FORM"));
        }
        int length = this.req.getContentLength();
        if (length > this.maxSize) {
            throw new IOException(FileAccessUtil.formatErrorMessage("LENGTH_TOO_BIG", new Object[]{new Integer(length), new Integer(this.maxSize)}));
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException(FileAccessUtil.formatErrorMessage("UNSPECIFIED_SEPARATION_BOUNDRY"));
        }
        FormBasedStream in = new FormBasedStream(this.req.getInputStream(), boundary, length);
        String line = in.readLine();
        if (line == null) {
            throw new IOException(FileAccessUtil.formatErrorMessage("FORM_UNEXPECTED_END"));
        }
        if (!line.startsWith(boundary)) {
            throw new IOException(FileAccessUtil.formatErrorMessage("FORM_NO_LEADING_BOUNDRY"));
        }
        boolean done = false;
        while (!done) {
            done = this.readNextpart(in, boundary, pe);
        }
    }

    boolean readNextpart(FormBasedStream in, String boundary, PersistentEntity pe) throws IOException, FileAccessException {
        String line = in.readLine();
        if (line == null) {
            return true;
        }
        String[] dispInfo = this.extractDispositionInfo(line);
        String disposition = dispInfo[0];
        String name = dispInfo[1];
        String filename = dispInfo[2];
        line = in.readLine();
        if (line == null) {
            return true;
        }
        String contentType = this.extractContentType(line);
        if (contentType != null) {
            line = in.readLine();
            if (line == null || line.length() > 0) {
                throw new IOException(FileAccessUtil.formatErrorMessage("BAD_LINE_AFTER_TYPE", line));
            }
        } else {
            contentType = "application/octet-stream";
        }
        if (filename == null) {
            String value = this.readParameter(in, boundary);
            this.parameters.put(name, value);
        } else {
            pe.fd.setFilename(filename);
            pe.readAndSave(in, boundary);
            if (filename.equals("__zero_len_file")) {
                this.files.put(name, new UploadedFileDetails(null, null, null));
            } else {
                this.files.put(name, new UploadedFileDetails(this.fd.basedir + this.fd.location, filename, contentType));
                this.fileVector.addElement(this.fd.location + (this.fd.location.endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator")) + filename);
            }
        }
        return false;
    }

    String readParameter(FormBasedStream in, String boundary) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = in.readLine()) != null && !line.startsWith(boundary)) {
            sbuf.append(line + "\r\n");
        }
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    String extractBoundary(String line) {
        int index = line.indexOf("boundary");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        boundary = "--" + boundary;
        return boundary;
    }

    String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[3];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException(FileAccessUtil.formatErrorMessage("CORRUPT_DISPOSITION", origline));
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException(FileAccessUtil.formatErrorMessage("INVALID_DISPOSITION", disposition));
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException(FileAccessUtil.formatErrorMessage("CORRUPT_DISPOSITION", origline));
        }
        String name = origline.substring(start + 6, end);
        if (!name.equalsIgnoreCase("File")) {
            retval[0] = disposition;
            retval[1] = name;
            retval[2] = null;
            return retval;
        }
        String filename = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
            if (filename.equals("")) {
                filename = null;
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = this.req.getCharacterEncoding() == null || this.req.getCharacterEncoding().equals("ISO-8859-1") ? filename : new String(filename.getBytes("ISO-8859-1"), this.req.getCharacterEncoding());
        return retval;
    }

    String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException(FileAccessUtil.formatErrorMessage("CORRUPT_TYPE", origline));
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException(FileAccessUtil.formatErrorMessage("BAD_LINE_AFTER_DISPOSITION", origline));
        }
        return contentType;
    }

    void setFileDetails(FileDetails fd) {
        this.fd = fd;
    }

    void setDbDetails(DbDetails dd) {
        this.dd = dd;
    }

    void setBaseDir(String basedir) {
        this.fd.basedir = basedir;
    }
}

