/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class DownloadServlet
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block24: {
            ServletOutputStream out = res.getOutputStream();
            boolean stype = false;
            int fileType = 0;
            String table = null;
            String dataCol = null;
            String prefixCol = null;
            String fileNameCol = null;
            ConnBean connBean = null;
            Connection conn = null;
            String docCharacterset = null;
            String fname = req.getPathInfo();
            if (fname == null) {
                return;
            }
            fname = fname.substring(1, fname.length());
            String contentType = this.getServletContext().getMimeType(fname);
            res.setContentType("application/octet-stream");
            Enumeration enumerator = req.getParameterNames();
            while (enumerator.hasMoreElements()) {
                String name = (String)enumerator.nextElement();
                String[] values = req.getParameterValues(name);
                if (values == null) continue;
                if (name.equalsIgnoreCase("srcType") && values[0].equalsIgnoreCase("database")) {
                    stype = true;
                }
                if (name.equalsIgnoreCase("table")) {
                    table = values[0];
                }
                if (name.equalsIgnoreCase("dataCol")) {
                    dataCol = values[0];
                }
                if (name.equalsIgnoreCase("prefixCol")) {
                    prefixCol = values[0];
                }
                if (name.equalsIgnoreCase("fileNameCol")) {
                    fileNameCol = values[0];
                }
                if (name.equalsIgnoreCase("fileType") && values[0].equalsIgnoreCase("character")) {
                    fileType = 1;
                }
                if (!name.equalsIgnoreCase("docCharacterset")) continue;
                if (values[0] == null || values[0].equals("")) {
                    docCharacterset = "ISO-8859-1";
                    continue;
                }
                docCharacterset = values[0];
            }
            if (!stype) {
                try {
                    String basedir = new FileAccessUtil().getBaseDir(this.getServletContext(), req);
                    if (basedir == null) {
                        throw new IOException(FileAccessUtil.formatErrorMessage("NO_BASE_DIR"));
                    }
                    this.readFile(basedir, fname, out);
                }
                catch (FileAccessException a) {
                    throw new IOException(a.toString());
                }
                catch (IOException i) {
                    throw new IOException(i.toString());
                }
            }
            if (stype) {
                try {
                    HttpSession session = req.getSession(false);
                    Object o = session.getValue("9843UF8HF9YT9NVRJG");
                    if (o != null) {
                        if (o instanceof ConnBean) {
                            connBean = (ConnBean)o;
                            if (connBean.isConnectionClosed()) {
                                connBean.connect();
                            }
                            conn = connBean.getConnection();
                        } else if (o instanceof Connection && (conn = (Connection)o).isClosed()) {
                            throw new ServletException(FileAccessUtil.formatErrorMessage("CONNECTION_CLOSED"));
                        }
                        this.readDBFile(conn, fname, out, fileType, table, dataCol, prefixCol, fileNameCol, docCharacterset);
                        if (connBean != null && !connBean.isConnectionClosed()) {
                            connBean.close();
                        }
                        break block24;
                    }
                    throw new SQLException(FileAccessUtil.formatErrorMessage("CANNOT_RECONNECT"));
                }
                catch (SQLException s) {
                    throw new ServletException(s.toString());
                }
                catch (Exception e) {
                    throw new ServletException(e.toString());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readDBFile(Connection conn, String f, ServletOutputStream out, int fileType, String table, String dataCol, String prefixCol, String fileNameCol, String docCharacterset) throws IOException, SQLException, FileAccessException {
        String prefix = null;
        String name = null;
        String sel_cmd = null;
        int i = f.lastIndexOf(System.getProperty("file.separator"));
        if (i == -1) {
            i = f.lastIndexOf(47);
            if (i == -1) throw new SQLException(FileAccessUtil.formatErrorMessage("no_prefix"));
            prefix = f.substring(0, i);
            name = f.substring(i + 1, f.length());
        } else {
            prefix = f.substring(0, i);
            name = f.substring(i + 1, f.length());
        }
        sel_cmd = "select " + dataCol + " from " + table + " where " + prefixCol + " = '" + prefix + "' and " + fileNameCol + " = '" + name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rset = stmt.executeQuery(sel_cmd);
        while (rset.next()) {
            if (fileType == 1) {
                CLOB clob = (CLOB)rset.getObject(1);
                this.streamClob(clob, 1L, out, docCharacterset, name);
                continue;
            }
            BLOB blob = (BLOB)rset.getObject(1);
            this.streamBlob(blob, 1L, out);
        }
    }

    public void streamBlob(BLOB blob, long offset, ServletOutputStream out) throws IOException, SQLException {
        InputStream is = blob.getBinaryStream(offset);
        this.readWriteData(is, (OutputStream)out);
        is.close();
    }

    public void streamClob(CLOB clob, long offset, ServletOutputStream out, String docCharacterset, String filename) throws IOException, SQLException, FileAccessException {
        Reader isr = clob.getCharacterStream(offset);
        try {
            this.readWriteData(isr, new OutputStreamWriter((OutputStream)out, docCharacterset));
        }
        catch (UnsupportedEncodingException uee) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("INVALID_ENCODING", new Object[]{docCharacterset, filename}));
        }
        isr.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(String basedir, String filename, ServletOutputStream out) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(basedir + filename);
            this.readWriteData(fis, (OutputStream)out);
        }
        catch (IOException i) {
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void readWriteData(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buf = new byte[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        out.flush();
    }

    public void readWriteData(Reader in, OutputStreamWriter out) throws IOException {
        int bytesRead;
        char[] buf = new char[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        out.flush();
    }
}

