/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.fileaccess;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import oracle.jsp.webutil.fileaccess.FileAccessException;
import oracle.jsp.webutil.fileaccess.FileAccessUtil;
import oracle.jsp.webutil.fileaccess.FileSystemEntity;
import oracle.jsp.webutil.fileaccess.FormBasedStream;

public class BinaryFile
extends FileSystemEntity {
    public void readAndSave(FormBasedStream in, String boundary) throws FileAccessException {
        String path = this.fd.getFSPath();
        try {
            String line;
            int result;
            File f = null;
            if (path == null || path.equals("")) {
                throw new FileAccessException(FileAccessUtil.formatErrorMessage("DIR_NOT_WRITABLE", this.fd.location));
            }
            f = new File(path + this.fd.filename);
            if (!this.fd.overwrite) {
                this.checkFileExists(f);
            }
            FileOutputStream fos = new FileOutputStream(f);
            BufferedOutputStream out = new BufferedOutputStream(fos, 8192);
            byte[] bbuf = new byte[8192];
            boolean rnflag = false;
            while (!((result = in.readLine(bbuf, 0, bbuf.length)) == -1 || result > 2 && bbuf[0] == 45 && bbuf[1] == 45 && (line = new String(bbuf, 0, result, "ISO-8859-1")).startsWith(boundary))) {
                if (rnflag) {
                    out.write(13);
                    out.write(10);
                    rnflag = false;
                }
                if (result >= 2 && bbuf[result - 2] == 13 && bbuf[result - 1] == 10) {
                    out.write(bbuf, 0, result - 2);
                    rnflag = true;
                    continue;
                }
                out.write(bbuf, 0, result);
            }
            out.flush();
            out.close();
            fos.close();
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("out_of_bound"));
        }
        catch (Exception io) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("ERROR_WRITING_FILE", this.fd.location + this.fd.filename + io.getMessage()));
        }
    }

    private void checkFileExists(File f) throws FileAccessException {
        if (f.exists()) {
            throw new FileAccessException(FileAccessUtil.formatErrorMessage("FILE_EXISTS", f.toString()));
        }
    }
}

