/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.email;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import oracle.jsp.webutil.email.SendMailUtil;
import oracle.jsp.webutil.fileaccess.FileAccessException;

public class SendMailBean {
    private String m_host = null;
    private String m_port = null;
    private String m_sessionStr = null;
    private Session m_session = null;
    private String m_sender = null;
    private String m_recipient = null;
    private String m_subject = null;
    private Vector m_attachment = new Vector();
    private Vector m_attachment_displayname = new Vector();
    private String m_attachment_permission = null;
    private String m_detect_attachment_type = null;
    private int m_attachment_index = 0;
    private String m_cc = null;
    private String m_bcc = null;
    private String m_content = null;
    private String m_contentType = null;
    private String m_contentTransferEncoding = null;
    private String m_contentTransferEncodingValue = null;
    private String m_defaultCharSet = null;
    private static final String MSG_FILE = "oracle.jsp.webutil.email.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.email.LocalStrings");

    public void setHost(String s) {
        this.m_host = s;
        this.m_session = null;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setSession(String s) {
        this.m_sessionStr = s;
        this.m_session = null;
    }

    public String getSession() {
        return this.m_sessionStr;
    }

    public void setMailSession(Session session) {
        this.m_session = session;
    }

    public Session getMailSession() {
        return this.m_session;
    }

    public void setSender(String s) throws Exception {
        if (s == null || s.equals("")) {
            throw new Exception(msgs.getString("invalid_sender"));
        }
        this.m_sender = s;
    }

    public String getSender() {
        return this.m_sender;
    }

    public void setRecipient(String s) throws Exception {
        if (s == null || s.equals("")) {
            throw new Exception(msgs.getString("invalid_recipient"));
        }
        this.m_recipient = s;
    }

    public String getRecipient() {
        return this.m_recipient;
    }

    public void setCc(String s) {
        this.m_cc = s;
    }

    public String getCc() {
        return this.m_cc;
    }

    public void setBcc(String s) {
        this.m_bcc = s;
    }

    public String getBcc() {
        return this.m_bcc;
    }

    public void setSubject(String s) {
        this.m_subject = s;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void addClientAttachment(String displayFileName) throws Exception {
        int i = 0;
        if (displayFileName == null) {
            return;
        }
        String s = displayFileName.trim();
        if (s.equals("") || s == null || s.length() == 0) {
            return;
        }
        i = s.indexOf(44);
        if (i >= 0) {
            this.addClientAttachment(s.substring(0, i));
            this.addClientAttachment(s.substring(i + 1));
        } else {
            i = s.indexOf(59);
            if (i >= 0) {
                this.addClientAttachment(s.substring(0, i));
                this.addClientAttachment(s.substring(i + 1));
            } else {
                this.m_attachment.addElement("");
                this.m_attachment_displayname.addElement(displayFileName);
            }
        }
    }

    public void setClientAttachment(String displayFileName) throws Exception {
        this.m_attachment.removeAllElements();
        this.m_attachment_displayname.removeAllElements();
        this.addClientAttachment(displayFileName);
    }

    public String getClientAttachment() {
        if (this.m_attachment_displayname.isEmpty()) {
            return "";
        }
        return this.m_attachment_displayname.toString();
    }

    public void addServerAttachment(String s1) throws Exception {
        int i = 0;
        if (s1 == null) {
            return;
        }
        String s = s1.trim();
        if (s.equals("") || s == null || s.length() == 0) {
            return;
        }
        i = s.indexOf(44);
        if (i >= 0) {
            this.addServerAttachment(s.substring(0, i));
            this.addServerAttachment(s.substring(i + 1));
        } else {
            i = s.indexOf(59);
            if (i >= 0) {
                this.addServerAttachment(s.substring(0, i));
                this.addServerAttachment(s.substring(i + 1));
            } else {
                try {
                    FileReader f = new FileReader(s);
                    this.m_attachment.addElement(s);
                }
                catch (FileNotFoundException e) {
                    throw new Exception(msgs.getString("invalid_attachment") + " " + s);
                }
            }
        }
    }

    public String getServerAttachment() {
        if (this.m_attachment.isEmpty()) {
            return "";
        }
        return this.m_attachment.toString();
    }

    public void setServerAttachment(String s) throws Exception {
        this.m_attachment.removeAllElements();
        this.addServerAttachment(s);
    }

    public void addAttachmentDisplayName(String s1) throws Exception {
        int i = 0;
        String s = s1.trim();
        if (s.equals("") || s == null || s.length() == 0) {
            return;
        }
        i = s.indexOf(44);
        if (i >= 0) {
            this.addAttachmentDisplayName(s.substring(0, i));
            this.addAttachmentDisplayName(s.substring(i + 1));
        } else {
            i = s.indexOf(59);
            if (i >= 0) {
                this.addAttachmentDisplayName(s.substring(0, i));
                this.addAttachmentDisplayName(s.substring(i + 1));
            } else {
                try {
                    FileReader f = new FileReader(s);
                    this.m_attachment_displayname.addElement(s);
                }
                catch (FileNotFoundException e) {
                    throw new Exception(msgs.getString("invalid_attachment") + " " + s);
                }
            }
        }
    }

    public void setAttachmentDisplayName(String s) throws Exception {
        this.m_attachment_displayname.removeAllElements();
        this.addAttachmentDisplayName(s);
    }

    public String getFirstServerAttachment() {
        this.m_attachment_index = 0;
        if (this.m_attachment.size() > 0) {
            return (String)this.m_attachment.firstElement();
        }
        return "";
    }

    public String getNextServerAttachment() {
        ++this.m_attachment_index;
        if (this.m_attachment_index < this.m_attachment.size()) {
            return (String)this.m_attachment.elementAt(this.m_attachment_index);
        }
        return "";
    }

    public String getAttachmentDisplayName() {
        if (this.m_attachment_index < this.m_attachment_displayname.size()) {
            return (String)this.m_attachment_displayname.elementAt(this.m_attachment_index);
        }
        return "";
    }

    public void setContentType(String s) {
        this.m_contentType = s;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setContentEncoding(String s) {
        this.m_contentTransferEncoding = s;
    }

    public String getContentEncoding() {
        return this.m_contentTransferEncoding;
    }

    public void setContent(String s) {
        this.m_content = s;
    }

    public String getContent() {
        return this.m_content;
    }

    public void sendMessage(PageContext pageContext) throws Exception {
        if (this.m_session == null) {
            if (this.m_sessionStr != null && !this.m_sessionStr.equals("") && this.m_sessionStr.length() != 0) {
                this.m_session = (Session)pageContext.getAttribute(this.m_sessionStr);
            } else if (this.m_host != null && this.m_host.length() != 0) {
                this.initSessionUsingHost();
            } else {
                throw new Exception(msgs.getString("no_host_or_session"));
            }
        }
        this.setDefaultCharSet(pageContext.getResponse());
        this.send();
    }

    public void sendMessage() throws Exception {
        if (this.m_session == null) {
            if (this.m_host != null && this.m_host.length() != 0) {
                this.initSessionUsingHost();
            } else {
                throw new Exception(msgs.getString("session_fail"));
            }
        }
        this.setDefaultCharSet();
        this.send();
    }

    private void initSessionUsingHost() throws Exception {
        if (this.m_host == null || this.m_host.equals("")) {
            throw new Exception(msgs.getString("no_host"));
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.m_host);
        this.m_session = Session.getDefaultInstance((Properties)props, null);
    }

    private void send() throws Exception {
        if (this.m_session == null) {
            throw new Exception(msgs.getString("session_fail"));
        }
        MimeMessage msg = new MimeMessage(this.m_session);
        this.assembleContentType();
        String charset = new ContentType(this.m_contentType).getParameter("charset");
        this.assembleContentTransferEncoding();
        msg.setFrom((Address)new InternetAddress(MimeUtility.encodeWord((String)this.m_sender, (String)charset, (String)this.m_contentTransferEncodingValue)));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)MimeUtility.encodeWord((String)this.m_recipient, (String)charset, (String)this.m_contentTransferEncodingValue), (boolean)false));
        if (this.m_cc != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)MimeUtility.encodeWord((String)this.m_cc, (String)charset, (String)this.m_contentTransferEncodingValue), (boolean)false));
        }
        if (this.m_bcc != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)MimeUtility.encodeWord((String)this.m_bcc, (String)charset, (String)this.m_contentTransferEncodingValue), (boolean)false));
        }
        if (this.m_subject != null) {
            msg.setSubject(MimeUtility.encodeText((String)this.m_subject, (String)charset, (String)this.m_contentTransferEncodingValue));
        }
        if (!this.getFirstServerAttachment().equals("")) {
            if (this.m_attachment_permission == null || !this.m_attachment_permission.equals("server")) {
                throw new Exception(msgs.getString("no_server_attachment_permission"));
            }
            MimeMultipart mp = new MimeMultipart();
            if (this.m_content != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(this.m_content, charset);
                mp.addBodyPart((BodyPart)mbp1);
            }
            String s = this.getFirstServerAttachment();
            do {
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(s);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(fds.getName());
                mp.addBodyPart((BodyPart)mbp2);
            } while (!(s = this.getNextServerAttachment()).equals(""));
            msg.setContent((Multipart)mp);
        } else {
            if (this.m_content == null) {
                this.m_content = "";
            }
            msg.setContent((Object)this.m_content, this.m_contentType);
        }
        msg.setSentDate(new Date());
        if (this.m_contentTransferEncoding != null) {
            msg.setHeader("Content-Transfer-Encoding", this.m_contentTransferEncoding);
        }
        Transport.send((Message)msg);
    }

    public void close() {
        this.m_session = null;
    }

    private void setDefaultCharSet(ServletResponse res) {
        String temp = res.getCharacterEncoding();
        this.m_defaultCharSet = temp.toUpperCase().equals("TIS620") ? "TIS-620" : MimeUtility.mimeCharset((String)temp);
    }

    private void setDefaultCharSet() {
        this.m_defaultCharSet = "ISO-8859-1";
    }

    private void assembleContentType() throws Exception {
        if (this.m_contentType == null || this.m_contentType.equals("")) {
            this.m_contentType = "text/plain; charset=" + this.m_defaultCharSet;
        } else {
            String temp = this.m_contentType.toLowerCase();
            int start = temp.indexOf("text");
            if (start != -1) {
                start = temp.indexOf("charset=");
                if (start == -1) {
                    this.m_contentType = this.m_contentType + "; charset=" + this.m_defaultCharSet;
                }
            } else {
                start = temp.indexOf("charset=");
                if (start != -1) {
                    throw new Exception(msgs.getString("not_text"));
                }
            }
        }
    }

    private void assembleContentTransferEncoding() throws Exception {
        Object defaultEncoding = null;
        if (this.m_contentTransferEncoding == null || this.m_contentTransferEncoding.equals("") || this.m_contentTransferEncoding.equalsIgnoreCase("7bit") || this.m_contentTransferEncoding.equalsIgnoreCase("8bit")) {
            this.m_contentTransferEncodingValue = defaultEncoding;
        } else if (this.m_contentTransferEncoding.toUpperCase().startsWith("B")) {
            this.m_contentTransferEncodingValue = "B";
            this.m_contentTransferEncoding = "base64";
        } else if (this.m_contentTransferEncoding.toUpperCase().startsWith("Q")) {
            this.m_contentTransferEncodingValue = "Q";
            this.m_contentTransferEncoding = "quoted-printable";
        } else {
            throw new Exception(msgs.getString("invalid_encoding"));
        }
    }

    public String setAttachmentPermission(ServletContext sc, HttpServletRequest req) throws FileAccessException {
        this.m_attachment_permission = SendMailUtil.getAttachmentPermission(sc, req);
        return this.m_attachment_permission;
    }

    public boolean detectClientAttachment() {
        if (this.m_detect_attachment_type == null) {
            this.m_detect_attachment_type = new String("client");
        }
        if (this.m_detect_attachment_type == null) {
            return false;
        }
        return this.m_detect_attachment_type.equals("client");
    }

    public boolean detectServerAttachment() {
        if (this.m_detect_attachment_type == null && !this.getServerAttachment().equals("") && !this.getServerAttachment().equals("[]")) {
            this.m_detect_attachment_type = new String("server");
        }
        if (this.m_detect_attachment_type == null) {
            return false;
        }
        return this.m_detect_attachment_type.equals("server");
    }
}

