/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.net.http;

import java.util.EmptyStackException;
import java.util.Stack;
import oracle.jsp.net.http.Attribute;

public class HttpXmlBuffer {
    private static final String CRLF = System.getProperty("line.separator", "\n");
    private StringBuffer m_buf;
    private Stack m_elements;
    private Stack m_attributes;
    private Stack m_flushed;
    private String m_element;

    public HttpXmlBuffer(int size) {
        this.m_buf = new StringBuffer(size);
        this.m_elements = new Stack();
        this.m_attributes = new Stack();
        this.m_flushed = new Stack();
    }

    public HttpXmlBuffer() {
        this(1000);
    }

    public String toString() {
        return this.m_buf.toString();
    }

    public int elementCount() {
        return this.m_elements.size();
    }

    public void decorate(String prefix) throws EmptyStackException {
        String decoratedName = prefix + (String)this.m_elements.pop();
        this.m_elements.push(decoratedName);
    }

    public void attribute(String name, String value) {
        this.m_attributes.push(this.newAttribute(name, value));
    }

    public void body(String value) {
        this.m_buf.append(value);
    }

    public void beginElement(String name) {
        if (!this.m_elements.empty()) {
            this.flush();
        }
        this.m_elements.push(name);
        this.m_flushed.push(new Boolean(false));
    }

    public void endElement() {
        this.flush();
        this.m_buf.append("</" + (String)this.m_elements.pop() + '>').append(CRLF);
    }

    protected void flush(boolean crlf) {
        Boolean alreadyFlushed = (Boolean)this.m_flushed.pop();
        this.m_flushed.push(new Boolean(true));
        if (alreadyFlushed.booleanValue()) {
            return;
        }
        this.m_buf.append('<' + (String)this.m_elements.peek());
        while (true) {
            Attribute attr;
            try {
                attr = (Attribute)this.m_attributes.pop();
            }
            catch (EmptyStackException e) {
                break;
            }
            this.m_buf.append(' ' + attr.name + "=\"" + attr.value + "\"");
        }
        this.m_buf.append('>');
        if (crlf) {
            this.m_buf.append(CRLF);
        }
    }

    private void flush() {
        this.flush(true);
    }

    private Attribute newAttribute(String name, String value) {
        Attribute attr = new Attribute();
        attr.name = name;
        attr.value = value;
        return attr;
    }
}

