/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.jsp.net.http.HttpRequest;

public class HttpResponse {
    private static final String MSG_FILE = "oracle.jsp.net.http.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.net.http.LocalStrings");
    private static final String CRLF = "\r\n";
    private HttpRequest m_req;
    private boolean m_recvd;
    private InputStream m_inputStream;
    private StringBuffer m_response;
    private StringBuffer m_content;
    private int m_contentLength;
    private int m_rc;
    private String[] m_headerKeys;
    private String[] m_headerValues;

    public HttpResponse(HttpRequest req) {
        this.m_req = req;
        this.m_recvd = false;
        this.m_response = new StringBuffer();
        this.m_content = null;
        this.m_contentLength = -1;
        this.m_rc = -1;
        this.m_headerValues = null;
        this.m_headerKeys = null;
    }

    public boolean recv() throws IOException {
        if (this.m_recvd) {
            throw new IOException(msgs.getString("invalid_op"));
        }
        this.m_recvd = true;
        this.m_rc = this.parseHeaders(this.m_req.getInputStream());
        if (this.m_rc == -1) {
            throw new IOException(MessageFormat.format(msgs.getString("unrecognized_header"), this.getHeader(0)));
        }
        String len = this.getHeader("Content-Length");
        this.m_contentLength = len != null && !len.equals("") ? Integer.parseInt(len) : 0;
        return this.responseOK();
    }

    public int getResponseCode() {
        return this.m_rc;
    }

    public boolean responseOK() {
        return this.getResponseCode() == 200;
    }

    public Hashtable getHeaders() {
        if (this.m_headerKeys == null || this.m_headerValues == null) {
            return null;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < this.m_headerKeys.length; ++i) {
            ht.put(this.m_headerKeys[i], this.m_headerValues[i]);
        }
        return ht;
    }

    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        if (this.m_headerKeys != null && this.m_headerValues != null) {
            for (int i = 0; i < this.m_headerKeys.length; ++i) {
                if (!this.m_headerKeys[i].equalsIgnoreCase(name)) continue;
                return this.m_headerValues[i];
            }
        }
        return null;
    }

    private String getHeader(int n) {
        try {
            return this.m_headerValues[n];
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getContentLength() {
        return this.m_contentLength;
    }

    public String getContent() throws IOException {
        if (this.m_contentLength < 0) {
            return null;
        }
        if (this.m_content == null) {
            this.m_content = this.readContent(this.m_req.getInputStream());
        }
        return this.m_content.toString();
    }

    private StringBuffer readContent(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer(1000);
        if (this.m_contentLength == 0) {
            int input;
            do {
                if ((input = is.read()) == -1) continue;
                sb.append((char)input);
            } while (input != -1);
        } else {
            while (sb.length() < this.m_contentLength) {
                int input = is.read();
                if (input == -1) {
                    throw new IOException(msgs.getString("res_truncated"));
                }
                sb.append((char)input);
            }
        }
        return sb;
    }

    private int parseHeaders(InputStream is) throws IOException {
        int rc;
        Vector<String> keys = new Vector<String>(10, 5);
        Vector<String> values = new Vector<String>(10, 5);
        this.m_headerKeys = null;
        this.m_headerValues = null;
        String line = this.readLine(is);
        if (line == null) {
            throw new IOException(msgs.getString("unexpected_EOF"));
        }
        if (!line.regionMatches(true, 0, "HTTP/", 0, 5)) {
            throw new ProtocolException(MessageFormat.format(msgs.getString("unexpected_response"), line));
        }
        this.m_response.append(line).append(CRLF);
        keys.addElement("null");
        values.addElement(line);
        int index = line.indexOf(32);
        while (line.charAt(index) == ' ') {
            ++index;
        }
        try {
            rc = Integer.parseInt(line.substring(index, index + 3));
        }
        catch (Exception e) {
            rc = -1;
        }
        while ((line = this.readLine(is)) != null) {
            this.m_response.append(line).append(CRLF);
            if (line.equals("")) break;
            index = line.indexOf(":");
            if (index < 0) {
                throw new ProtocolException(MessageFormat.format(msgs.getString("unexpected_header"), line));
            }
            keys.addElement(line.substring(0, index).trim().toLowerCase());
            if (index >= line.length() - 1) {
                values.addElement("");
                continue;
            }
            values.addElement(line.substring(index + 1).trim());
        }
        this.m_headerKeys = new String[keys.size()];
        this.m_headerValues = new String[values.size()];
        keys.copyInto(this.m_headerKeys);
        values.copyInto(this.m_headerValues);
        return rc;
    }

    private String readLine(InputStream is) throws IOException {
        StringBuffer sb;
        block6: {
            int previousInput = -1;
            boolean isNull = true;
            sb = new StringBuffer();
            try {
                int input;
                while ((input = is.read()) != -1) {
                    if (input == 10 && previousInput == 13) {
                        sb.setLength(sb.length() - 1);
                        break;
                    }
                    sb.append((char)input);
                    if (isNull) {
                        isNull = false;
                    }
                    previousInput = input;
                }
                if (isNull) {
                    return null;
                }
            }
            catch (IOException ioe) {
                if (!isNull) break block6;
                throw ioe;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return (this.m_response != null ? this.m_response.toString() : "") + (this.m_content != null ? this.m_content.toString() : "");
    }
}

