/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.text.ParseException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.StringSectionId;
import oracle.jsp.jwcache.tagext.CachePolicyActionTagBase;

public class UseCacheObjTag
extends CachePolicyActionTagBase
implements Tag {
    private static final String MSG_FILE = "oracle.jsp.jwcache.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.tagext.LocalStrings");
    private String id = null;
    private String type = null;
    private StringSectionId sectionId = null;
    private Object targetObj = null;
    private static final int usageScopeInt = 1;

    public int doStartTag() throws JspTagException {
        this.req = (HttpServletRequest)this.pc.getRequest();
        try {
            this.setupPolicy();
        }
        catch (ParseException pe) {
            throw new JspTagException(pe.toString());
        }
        catch (CachePolicyLoadingException cple) {
            throw new JspTagException(cple.toString());
        }
        this.targetObj = this.pc.getAttribute(this.id, 1);
        if (this.targetObj != null) {
            this.executeBody = false;
            return 0;
        }
        if (this.invalidateCache) {
            this.policyObj.invalidateCache(this.req, this.sectionId);
        }
        this.block = this.policyObj.getCache(this.req, this.sectionId);
        this.printInfo(true);
        if (!this.policyObj.isRecent(this.block)) {
            this.executeBody = true;
            return 1;
        }
        this.executeBody = false;
        this.targetObj = this.block.getData();
        this.pc.setAttribute(this.id, this.targetObj, 1);
        return 0;
    }

    public int doEndTag() throws JspTagException {
        if (this.executeBody) {
            this.targetObj = this.pc.getAttribute(this.id, 1);
            if (this.targetObj == null) {
                throw new JspTagException(msgs.getString("target_not_produced"));
            }
            if (this.block == null) {
                this.policyObj.putCache(this.targetObj, this.req, this.sectionId);
            }
        }
        this.printInfo(false);
        return 6;
    }

    public void release() {
        super.release();
        this.id = null;
        this.sectionId = null;
        this.type = null;
        this.targetObj = null;
    }

    public void setId(String id) {
        this.id = id;
        this.sectionId = new StringSectionId(id);
    }

    public void setCacheScope(String scope) {
        this.setScope(scope);
    }

    public void setType(String type) {
        this.type = type;
    }
}

