/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.text.ParseException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.tagext.CachePolicyTagBase;
import oracle.jsp.webutil.tagutil.TagUtil;

public class InvalidateCacheTag
extends CachePolicyTagBase
implements Tag {
    private static final String MSG_FILE = "oracle.jsp.jwcache.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.tagext.LocalStrings");
    private HttpServletRequest req = null;
    private String name = null;
    private boolean invalidateNameLike = false;
    private String page = null;
    private String autoInvalidateLevelStr = null;
    private int autoInvalidateLevel = -1;

    public int doStartTag() throws JspTagException {
        this.req = (HttpServletRequest)this.pc.getRequest();
        try {
            this.setupPolicy();
        }
        catch (ParseException pe) {
            throw new JspTagException(pe.toString());
        }
        catch (CachePolicyLoadingException cple) {
            throw new JspTagException(cple.toString());
        }
        if (this.policyObj.getAutoType() == 0) {
            if (this.name == null) {
                throw new JspTagException(msgs.getString("name_not_setup"));
            }
            if (this.invalidateNameLike) {
                this.policyObj.invalidateCacheLike(this.req, this.name);
            } else {
                this.policyObj.invalidateCache(this.req, this.name);
            }
        } else {
            if (this.page == null) {
                throw new JspTagException(msgs.getString("policy_not_setup"));
            }
            if (this.autoInvalidateLevel == -1) {
                this.policyObj.invalidateCacheOtherPathLike(this.req, this.page);
            } else {
                this.policyObj.invalidateCacheOtherPathLike(this.req, this.page, null, this.autoInvalidateLevel);
            }
        }
        return 0;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }

    public void release() {
        super.release();
        this.req = null;
        this.name = null;
        this.invalidateNameLike = false;
        this.page = null;
        this.autoInvalidateLevelStr = null;
        this.autoInvalidateLevel = -1;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInvalidateNameLike(boolean invalidateNameLike) {
        this.invalidateNameLike = invalidateNameLike;
    }

    public void setPage(String givenPage) {
        this.page = givenPage;
        if (!this.page.startsWith("/")) {
            this.req = (HttpServletRequest)this.pc.getRequest();
            String pagePath = null;
            pagePath = TagUtil.stripTarget(this.req.getServletPath());
            this.page = pagePath + '/' + this.page;
        }
    }

    public void setAutoInvalidateLevel(String autoInvalidateLevelStr) {
        this.autoInvalidateLevel = CachePolicy.autoInvalidateStrToLevelInt(autoInvalidateLevelStr);
    }
}

