/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.tagext.CachePolicyActionTagBase;
import oracle.jsp.webutil.tagutil.ImplicitXMLObjConsumer;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class CacheXMLObjTag
extends CachePolicyActionTagBase
implements Tag,
ImplicitXMLObjConsumer {
    private static final String MSG_FILE = "oracle.jsp.jwcache.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.tagext.LocalStrings");
    private Document fromDoc = null;
    private String fromXMLObjName = null;
    private String toXMLObjName = null;
    private boolean toWriter = false;

    public int doStartTag() throws JspTagException {
        this.req = (HttpServletRequest)this.pc.getRequest();
        try {
            this.setupPolicy();
        }
        catch (ParseException pe) {
            throw new JspTagException(pe.toString());
        }
        catch (CachePolicyLoadingException cple) {
            throw new JspTagException(cple.toString());
        }
        if (this.fromDoc != null) {
            this.executeBody = false;
            this.policyObj.putCache(this.fromDoc, this.req, this.specifiedName, this.getParentSectionCounter());
            this.outputDoc();
            return 0;
        }
        if (this.invalidateCache) {
            this.policyObj.invalidateCache(this.req, this.specifiedName, this.getParentSectionCounter());
        }
        this.block = this.policyObj.getCache(this.req, this.specifiedName, this.getParentSectionCounter());
        this.printInfo(true);
        this.policyObj.markupBegin(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), this.specifiedName, this.getParentSectionCounter());
        if (!this.policyObj.isRecent(this.block)) {
            this.executeBody = true;
            return 1;
        }
        this.executeBody = false;
        this.fromDoc = (Document)this.block.getData();
        this.outputDoc();
        return 0;
    }

    public int doEndTag() throws JspTagException {
        if (this.executeBody) {
            if (this.fromDoc == null && this.fromXMLObjName != null) {
                this.fromDoc = (Document)this.pc.getAttribute(this.fromXMLObjName);
                if (this.fromDoc == null) {
                    throw new JspTagException(msgs.getString("fromXMLObj_not_found"));
                }
            }
            if (this.fromDoc == null) {
                throw new JspTagException(msgs.getString("fromDoc_not_set"));
            }
            if (this.block == null) {
                this.policyObj.putCache(this.fromDoc, this.req, this.specifiedName, this.getParentSectionCounter());
            }
            this.outputDoc();
        }
        this.policyObj.markupEnd(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), this.specifiedName, this.getParentSectionCounter());
        this.printInfo(false);
        this.getParentSectionCounter().inc();
        return 6;
    }

    public void release() {
        super.release();
        this.fromDoc = null;
        this.fromXMLObjName = null;
        this.toXMLObjName = null;
        this.toWriter = false;
    }

    private void outputDoc() throws JspTagException {
        Tag parentTag = this.getParent();
        if (parentTag instanceof ImplicitXMLObjConsumer) {
            ((ImplicitXMLObjConsumer)parentTag).setImplicitFromXMLObj(this.fromDoc);
        }
        if (this.toXMLObjName != null) {
            this.pc.setAttribute(this.toXMLObjName, (Object)this.fromDoc);
        }
        if (this.toWriter) {
            if (this.fromDoc instanceof XMLDocument) {
                XMLDocument oxdoc = (XMLDocument)this.fromDoc;
                try {
                    oxdoc.print(new PrintWriter((Writer)this.pc.getOut()));
                }
                catch (IOException ioe) {
                    throw new JspTagException(ioe.toString());
                }
            } else {
                throw new JspTagException(msgs.getString("wrong_xml_instance"));
            }
        }
    }

    public void setImplicitFromXMLObj(Document doc) throws JspTagException {
        if (this.fromDoc != null) {
            throw new JspTagException(msgs.getString("xml_already_set"));
        }
        this.fromDoc = doc;
    }

    public void setFromXMLObjName(String s) throws JspTagException {
        this.fromXMLObjName = s;
        this.fromDoc = (Document)this.pc.getAttribute(this.fromXMLObjName);
    }

    public void setToXMLObjName(String s) {
        this.toXMLObjName = s;
    }

    public void setToWriter(boolean b) {
        this.toWriter = b;
    }
}

