/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.NumberSectionId;
import oracle.jsp.jwcache.impl.CacheCommonUtil;

public class CachePolicyTagBase
implements Tag {
    protected CachePolicy policyObj;
    protected String policyFile;
    protected Boolean ignoreCache;
    protected Boolean reportException;
    protected String scopeStr;
    protected String autoTypeStr;
    protected String selectedParamStr;
    protected String selectedCookiesStr;
    protected String reusableTimeStampStr;
    protected String reusableDeltaTimeStr;
    protected String cacheRepositoryName;
    protected String expirationTypeStr;
    protected Long TTL;
    protected String timeInaDayStr;
    protected String dayInaWeekStr;
    protected Integer dayInaMonth;
    protected Boolean writeThrough;
    protected NumberSectionId sectionCounterForChildren = null;
    protected NumberSectionId parentSectionCounter = null;
    protected Tag parentTag;
    protected PageContext pc;

    public void setPolicy(String policyFile) {
        this.policyFile = policyFile;
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCache = new Boolean(ignoreCache);
    }

    public void setReportException(boolean reportException) {
        this.reportException = new Boolean(reportException);
    }

    public void setScope(String scopeStr) {
        this.scopeStr = scopeStr;
    }

    public void setAutoType(String autoTypeStr) {
        this.autoTypeStr = autoTypeStr;
    }

    public void setSelectedParam(String selectedParamStr) {
        this.selectedParamStr = selectedParamStr;
    }

    public void setSelectedCookies(String selectedCookiesStr) {
        this.selectedCookiesStr = selectedCookiesStr;
    }

    public void setReusableTimeStamp(String reusableTimeStampStr) {
        this.reusableTimeStampStr = reusableTimeStampStr;
    }

    public void setReusableDeltaTime(String reusableDeltaTimeStr) {
        this.reusableDeltaTimeStr = reusableDeltaTimeStr;
    }

    public void setCacheRepositoryName(String cacheRepositoryName) {
        this.cacheRepositoryName = cacheRepositoryName;
    }

    public void setExpirationType(String expirationTypeStr) {
        this.expirationTypeStr = expirationTypeStr;
    }

    public void setTTL(long TTL) {
        this.TTL = new Long(TTL);
    }

    public void setTimeInaDay(String timeInaDayStr) {
        this.timeInaDayStr = timeInaDayStr;
    }

    public void setDayInaWeek(String dayInaWeekStr) {
        this.dayInaWeekStr = dayInaWeekStr;
    }

    public void setDayInaMonth(int dayInaMonth) {
        this.dayInaMonth = new Integer(dayInaMonth);
    }

    public void setWriteThrough(boolean writeThrough) {
        this.writeThrough = new Boolean(writeThrough);
    }

    protected void setupPolicy() throws ParseException, CachePolicyLoadingException {
        this.policyObj = this.policyFile != null ? CacheCommonUtil.lookupPolicy(this.pc.getServletConfig(), (HttpServletRequest)this.pc.getRequest(), this.policyFile) : new CachePolicy(this.pc.getServletConfig());
        if (this.ignoreCache != null) {
            this.policyObj.setIgnoreCache(this.ignoreCache);
        }
        if (this.reportException != null) {
            this.policyObj.setReportException(this.reportException);
        }
        if (this.scopeStr != null) {
            this.policyObj.setScope(this.scopeStr);
        }
        if (this.autoTypeStr != null) {
            this.policyObj.setAutoType(this.autoTypeStr);
        }
        if (this.selectedParamStr != null) {
            this.policyObj.setSelectedParam(this.selectedParamStr);
        }
        if (this.selectedCookiesStr != null) {
            this.policyObj.setSelectedCookies(this.selectedCookiesStr);
        }
        if (this.reusableTimeStampStr != null) {
            this.policyObj.setReusableTimeStamp(this.reusableTimeStampStr);
        }
        if (this.reusableDeltaTimeStr != null) {
            this.policyObj.setReusableDeltaTime(this.reusableDeltaTimeStr);
        }
        if (this.cacheRepositoryName != null) {
            this.policyObj.setCacheRepositoryName(this.cacheRepositoryName);
        }
        ExpirationPolicy expPolicy = this.policyObj.getExpirationPolicy();
        if (this.expirationTypeStr != null) {
            expPolicy.setExpirationType(this.expirationTypeStr);
        }
        if (this.TTL != null) {
            expPolicy.setTTL(this.TTL);
        }
        if (this.timeInaDayStr != null) {
            expPolicy.setTimeInaDay(this.timeInaDayStr);
        }
        if (this.dayInaWeekStr != null) {
            expPolicy.setDayInaWeek(this.dayInaWeekStr);
        }
        if (this.dayInaMonth != null) {
            expPolicy.setDayInaMonth(this.dayInaMonth);
        }
        if (this.writeThrough != null) {
            expPolicy.setWriteThrough(this.writeThrough);
        }
    }

    public CachePolicy getPolicy() {
        return this.policyObj;
    }

    public Tag getParent() {
        return this.parentTag;
    }

    public void setParent(Tag t) {
        this.parentTag = t;
    }

    public void setPageContext(PageContext pc) {
        this.pc = pc;
    }

    protected NumberSectionId getParentSectionCounter() {
        if (this.parentSectionCounter != null) {
            return this.parentSectionCounter;
        }
        CachePolicyTagBase cTag = (CachePolicyTagBase)TagSupport.findAncestorWithClass((Tag)this, (Class)CachePolicyTagBase.class);
        if (cTag != null) {
            this.parentSectionCounter = cTag.sectionCounterForChildren;
        } else {
            this.parentSectionCounter = (NumberSectionId)this.pc.getAttribute("oracle.jsp.jwcache.autosectionid");
            if (this.parentSectionCounter == null) {
                this.parentSectionCounter = new NumberSectionId();
            }
            this.pc.setAttribute("oracle.jsp.jwcache.autosectionid", (Object)this.parentSectionCounter);
        }
        this.sectionCounterForChildren = new NumberSectionId(this.parentSectionCounter);
        this.sectionCounterForChildren.pushLevel();
        return this.parentSectionCounter;
    }

    public int doStartTag() throws JspTagException {
        return 0;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }

    public void release() {
        this.policyObj = null;
        this.policyFile = null;
        this.ignoreCache = null;
        this.reportException = null;
        this.scopeStr = null;
        this.autoTypeStr = null;
        this.selectedParamStr = null;
        this.selectedCookiesStr = null;
        this.reusableTimeStampStr = null;
        this.reusableDeltaTimeStr = null;
        this.cacheRepositoryName = null;
        this.expirationTypeStr = null;
        this.TTL = null;
        this.timeInaDayStr = null;
        this.dayInaWeekStr = null;
        this.dayInaMonth = null;
        this.writeThrough = null;
        this.sectionCounterForChildren = null;
        this.parentSectionCounter = null;
        this.parentTag = null;
        this.pc = null;
    }
}

