/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.tagext;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.tagext.CachePolicyTagBase;

public class CacheIncludeTag
extends CachePolicyTagBase
implements Tag {
    private static final String MSG_FILE = "oracle.jsp.jwcache.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.tagext.LocalStrings");
    private HttpServletRequest req = null;
    private CacheBlock block = null;
    private boolean printCacheBlockInfo = false;
    private String page = null;
    private boolean flush = false;
    private static final String specifiedName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspTagException {
        this.req = (HttpServletRequest)this.pc.getRequest();
        try {
            this.setupPolicy();
        }
        catch (ParseException pe) {
            throw new JspTagException(pe.toString());
        }
        catch (CachePolicyLoadingException cple) {
            throw new JspTagException(cple.toString());
        }
        if (this.policyObj.getAutoType() == 0) {
            throw new JspTagException(msgs.getString("custom_cache_policy"));
        }
        this.block = this.policyObj.getCache(this.req, specifiedName, this.getParentSectionCounter());
        if (!this.policyObj.isRecent(this.block)) {
            try {
                String bodyStr = null;
                try {
                    this.pc.pushBody();
                    this.pc.include(this.page);
                    bodyStr = ((BodyContent)this.pc.getOut()).getString();
                }
                finally {
                    this.pc.popBody();
                }
                if (this.block == null) {
                    this.policyObj.putCache(bodyStr, this.req, specifiedName, this.getParentSectionCounter());
                }
                this.printInfo(true);
                this.policyObj.markupBegin(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), specifiedName, this.getParentSectionCounter());
                try {
                    this.pc.getOut().print(bodyStr);
                }
                catch (IOException ioe) {
                    throw new JspTagException(MessageFormat.format(msgs.getString("cannot_write"), ioe));
                }
                this.policyObj.markupEnd(this.pc.getServletContext(), this.req, (Writer)this.pc.getOut(), specifiedName, this.getParentSectionCounter());
                this.printInfo(false);
            }
            catch (ServletException se) {
                throw new JspTagException(se.toString());
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.toString());
            }
        }
        try {
            this.pc.getOut().print(this.block.getData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getParentSectionCounter().inc();
        return 0;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }

    public void release() {
        super.release();
        this.req = null;
        this.block = null;
        this.printCacheBlockInfo = false;
        this.page = null;
        this.flush = false;
    }

    private void printInfo(boolean start) {
        if (!this.printCacheBlockInfo) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!-- oracle_jwcache");
        sb.append(' ');
        if (start) {
            sb.append("cache_start:");
            sb.append('\n');
        } else {
            sb.append("cache_end:");
            sb.append('\n');
        }
        sb.append(this.policyObj.getDebugCacheName(this.req, specifiedName, this.getParentSectionCounter()));
        if (start && this.printCacheBlockInfo && this.block != null) {
            Date creationDate = new Date(this.block.getCreationTime());
            Date expirationDate = new Date(this.block.getExpirationTime());
            sb.append("<cache_block_info>\n");
            sb.append("  <creation_time>");
            sb.append(creationDate);
            sb.append("</creation_time>\n");
            sb.append("  <expiration_time>");
            sb.append(expirationDate);
            sb.append("</expiration_time>\n");
            sb.append("</cache_block_info>\n");
        }
        sb.append("oracle_jwcache -->");
        try {
            this.pc.getOut().print((Object)sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setPrintCacheBlockInfo(boolean printCacheBlockInfo) {
        this.printCacheBlockInfo = printCacheBlockInfo;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }
}

