/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.repository.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CacheConfig;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.jsp.jwcache.repository.impl.RepoImplUtil;

public class SimpleHTRepoImpl
implements CacheRepository {
    private Hashtable table = new Hashtable(10, 10.0f);

    public void init(CacheConfig cacheConfig) throws CacheRepositoryException {
    }

    public void destroy() {
    }

    public void putCache(String[] name, Serializable cacheTarget, ExpirationPolicy expirationPolicy) throws CacheRepositoryException {
        String cacheName = RepoImplUtil.concatName(name);
        long creationTime = this.getCurrentTime().getTime();
        long expirationTime = expirationPolicy.getExpirationTime(creationTime);
        cacheTarget = (Serializable)RepoImplUtil.cloneObjIfNeeded(cacheTarget);
        CacheBlock cBlock = new CacheBlock(creationTime, expirationTime, cacheTarget);
        this.table.put(cacheName, cBlock);
    }

    public CacheBlock getCache(String[] name) throws CacheRepositoryException {
        String cacheName = RepoImplUtil.concatName(name);
        CacheBlock cBlock = (CacheBlock)this.table.get(cacheName);
        if ((cBlock = RepoImplUtil.cloneCacheBlockIfNeeded(cBlock)) != null && cBlock.getExpirationTime() < this.getCurrentTime().getTime()) {
            this.table.remove(cacheName);
            return null;
        }
        return cBlock;
    }

    public void invalidateCache(String[] name) throws CacheRepositoryException {
        String cacheName = RepoImplUtil.concatName(name);
        this.table.remove(cacheName);
    }

    public void invalidateCacheLike(String[] name) throws CacheRepositoryException {
        String[] matchedNamePart = RepoImplUtil.handleWildcard(name);
        String matchedNameStr = RepoImplUtil.concatName(matchedNamePart);
        Enumeration enumerator = this.table.keys();
        Vector<String> v = new Vector<String>(10, 10);
        while (enumerator.hasMoreElements()) {
            String elementName = (String)enumerator.nextElement();
            if (!elementName.startsWith(matchedNameStr)) continue;
            v.addElement(elementName);
        }
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            this.table.remove((String)v.elementAt(i));
        }
    }

    public void cleanExpiredCache() throws CacheRepositoryException {
    }

    public Date getCurrentTime() {
        return new Date();
    }
}

