/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.repository.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Random;
import java.util.ResourceBundle;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CacheConfig;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.jsp.jwcache.repository.impl.RepoImplUtil;

public class SimpleFSRepositoryImpl
implements CacheRepository {
    private static final String MSG_FILE = "oracle.jsp.jwcache.repository.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.repository.impl.LocalStrings");
    public static final String PREFIX_CACHEHEADER = "CH";
    public static final String PREFIX_CACHEDATA = "CD";
    public static final String PREFIX_CACHENAMESEGMENT = "CNS";
    public static final int PREFIX_CACHEHEADER_LEN = "CH".length();
    public static final String PARAM_REPOROOT = "reporoot";
    private static final int MAX_TRIAL = 100;
    private static final int MAX_LEVEL = 100;
    private Random rGen = new Random();
    private String repoRoot = null;

    public void init(CacheConfig cacheConfig) throws CacheRepositoryException {
        String root = cacheConfig.getInitParameter(PARAM_REPOROOT);
        if (root == null) {
            throw new CacheRepositoryException(MessageFormat.format(msgs.getString("reporoot_needed"), PARAM_REPOROOT));
        }
        File f = new File(root);
        if (!f.exists() || !f.isDirectory()) {
            throw new CacheRepositoryException(MessageFormat.format(msgs.getString("no_root_dir"), PARAM_REPOROOT, root));
        }
        this.setRepoRoot(root);
    }

    public void destroy() {
    }

    public void setRepoRoot(String s) {
        if (!s.endsWith(File.separator)) {
            s = s + File.separator;
        }
        this.repoRoot = s;
    }

    public String getRepoRoot() {
        return this.repoRoot;
    }

    private boolean matchName(String[] name1, String[] name2) {
        if (name1.length == name2.length) {
            for (int j = 0; j < name1.length; ++j) {
                if (name1[j].equals(name2[j])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchPartialName(String[] name1, String[] name2) {
        for (int j = 0; j < name2.length; ++j) {
            if (name1[j].equals(name2[j])) continue;
            return false;
        }
        return true;
    }

    private CacheHeader findFile(String[] name, String fp) {
        File f = new File(fp);
        String[] list = f.list();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].startsWith(PREFIX_CACHEHEADER)) continue;
            try {
                CacheHeader header = (CacheHeader)this.readObject(fp + list[i]);
                if (!this.matchName(header.name, name)) continue;
                return header;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private int getNewFileId(String fp) throws CacheRepositoryException {
        int count = 0;
        do {
            int num = Math.abs(this.rGen.nextInt());
            File f = new File(fp + PREFIX_CACHEHEADER + num);
            if (f.exists()) continue;
            return num;
        } while (count < 100);
        throw new CacheRepositoryException(msgs.getString("new_file_ID"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(String f, Serializable o) throws IOException {
        FileOutputStream fs;
        block5: {
            fs = null;
            ObjectOutputStream os = null;
            try {
                fs = new FileOutputStream(f);
                os = new ObjectOutputStream(fs);
                os.writeObject(o);
                Object var6_5 = null;
                if (os == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (os != null) {
                    os.close();
                }
                if (fs != null) {
                    fs.close();
                }
                throw throwable;
            }
            os.close();
        }
        if (fs != null) {
            fs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(String f) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream fs;
        block4: {
            fs = null;
            ObjectInputStream os = null;
            try {
                fs = new FileInputStream(f);
                os = new ObjectInputStream(fs);
                object = os.readObject();
                Object var6_5 = null;
                if (os == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_6 = null;
                    if (os != null) {
                        os.close();
                    }
                    if (fs == null) break block5;
                    fs.close();
                }
                throw throwable;
            }
            os.close();
        }
        if (fs != null) {
            fs.close();
        }
        return object;
    }

    public void putCache(String[] name, Serializable cacheTarget, ExpirationPolicy expirationPolicy) throws CacheRepositoryException {
        String fp = this.getFilePath(name);
        this.createFilePath(fp);
        CacheHeader existingHeader = this.findFile(name, fp);
        CacheHeader newHeader = new CacheHeader();
        newHeader.name = name;
        newHeader.creationTime = this.getCurrentTime().getTime();
        newHeader.expirationTime = expirationPolicy.getExpirationTime(newHeader.creationTime);
        CacheData data = new CacheData();
        data.header = newHeader;
        data.cacheTarget = cacheTarget;
        try {
            newHeader.fileID = existingHeader == null ? this.getNewFileId(fp) : existingHeader.fileID;
            this.writeObject(fp + PREFIX_CACHEHEADER + newHeader.fileID, newHeader);
            this.writeObject(fp + PREFIX_CACHEDATA + newHeader.fileID, data);
        }
        catch (IOException ioe) {
            CacheRepositoryException cre = new CacheRepositoryException(ioe);
            throw cre;
        }
    }

    public CacheBlock getCache(String[] name) throws CacheRepositoryException {
        String fp = this.getFilePath(name);
        CacheHeader existingHeader = this.findFile(name, fp);
        if (existingHeader == null) {
            return null;
        }
        try {
            if (this.matchName(existingHeader.name, name)) {
                if (existingHeader.expirationTime >= this.getCurrentTime().getTime()) {
                    CacheData data = (CacheData)this.readObject(fp + PREFIX_CACHEDATA + existingHeader.fileID);
                    return new CacheBlock(existingHeader.creationTime, existingHeader.expirationTime, data.cacheTarget);
                }
                this.invalidateCachewithFileID(fp, existingHeader.fileID);
                return null;
            }
            throw new CacheRepositoryException(msgs.getString("name_mismatched"));
        }
        catch (Exception e) {
            throw new CacheRepositoryException(e);
        }
    }

    private void invalidateCachewithFileID(String filePath, int fileID) {
        File headerFile = new File(filePath + PREFIX_CACHEHEADER + fileID);
        headerFile.delete();
        File dataFile = new File(filePath + PREFIX_CACHEDATA + fileID);
        dataFile.delete();
    }

    public void invalidateCache(String[] name) throws CacheRepositoryException {
        String fp = this.getFilePath(name);
        CacheHeader existingHeader = this.findFile(name, fp);
        if (existingHeader == null) {
            return;
        }
        this.invalidateCachewithFileID(fp, existingHeader.fileID);
    }

    public void invalidateCacheLike(String[] name) throws CacheRepositoryException {
        String[] matchedNamePart = RepoImplUtil.handleWildcard(name);
        String fp = this.getFilePath(matchedNamePart);
        this.recursiveDel(fp, matchedNamePart, 0);
    }

    private void recursiveDel(String fp, String[] name, int level) {
        if (level > 100) {
            return;
        }
        ++level;
        File f = new File(fp);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith(PREFIX_CACHEHEADER)) {
                try {
                    CacheHeader header = (CacheHeader)this.readObject(fp + list[i]);
                    if (!this.matchPartialName(header.name, name)) continue;
                    this.invalidateCachewithFileID(fp, header.fileID);
                }
                catch (Exception e) {}
                continue;
            }
            if (!list[i].startsWith(PREFIX_CACHENAMESEGMENT)) continue;
            this.recursiveDel(fp + list[i] + File.separatorChar, name, level);
        }
    }

    public void cleanExpiredCache() throws CacheRepositoryException {
        this.recursiveClean(this.repoRoot, 0);
    }

    private void recursiveClean(String fp, int level) {
        if (level > 100) {
            return;
        }
        ++level;
        File f = new File(fp);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith(PREFIX_CACHEHEADER)) {
                try {
                    CacheHeader header = (CacheHeader)this.readObject(fp + list[i]);
                    if (header.expirationTime >= this.getCurrentTime().getTime()) continue;
                    this.invalidateCachewithFileID(fp, header.fileID);
                }
                catch (Exception e) {}
                continue;
            }
            if (!list[i].startsWith(PREFIX_CACHENAMESEGMENT)) continue;
            this.recursiveClean(fp + list[i] + File.separatorChar, level);
        }
    }

    private String getFilePath(String[] name) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.repoRoot);
        if (name != null) {
            int len = name.length;
            for (int i = 0; i < len; ++i) {
                sb.append(PREFIX_CACHENAMESEGMENT);
                sb.append(name[i].hashCode());
                sb.append(File.separatorChar);
            }
        }
        return new String(sb);
    }

    private void createFilePath(String path) {
        File f = new File(path);
        f.mkdirs();
    }

    public Date getCurrentTime() {
        return new Date();
    }

    private static class CacheData
    implements Serializable {
        CacheHeader header;
        Serializable cacheTarget;

        private CacheData() {
        }
    }

    private static class CacheHeader
    implements Serializable {
        String[] name;
        long creationTime;
        long expirationTime;
        int fileID;

        private CacheHeader() {
        }
    }
}

