/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.repository.impl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CloneableCacheObj;
import oracle.jsp.jwcache.repository.CacheRepositoryException;

public class RepoImplUtil {
    private static final String MSG_FILE = "oracle.jsp.jwcache.repository.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.repository.impl.LocalStrings");

    public static String[] handleWildcard(String[] name) throws CacheRepositoryException {
        String[] matchedNamePart;
        int found = -1;
        int lastWildCard = -1;
        for (int i = 0; i < name.length; ++i) {
            if (name[i].equals("*")) {
                if (found == -1) {
                    found = i;
                } else if (lastWildCard + 1 != i) {
                    throw new CacheRepositoryException(msgs.getString("intermittent_wildcards"));
                }
                lastWildCard = i;
                continue;
            }
            if (name[i].indexOf("*") == -1) continue;
            throw new CacheRepositoryException(MessageFormat.format(msgs.getString("unsupported_pattern"), name[i]));
        }
        if (found == -1) {
            matchedNamePart = name;
        } else {
            matchedNamePart = new String[found];
            for (int i = 0; i < found; ++i) {
                matchedNamePart[i] = name[i];
            }
        }
        return matchedNamePart;
    }

    public static String concatName(String[] name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length; ++i) {
            if (name[i].indexOf(32) != -1) {
                throw new IllegalArgumentException(MessageFormat.format(msgs.getString("contains_delimiter"), name[i]));
            }
            sb.append(name[i]);
            if (i == name.length - 1) continue;
            sb.append(' ');
        }
        return new String(sb);
    }

    public static Object cloneObjIfNeeded(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CloneableCacheObj) {
            return ((CloneableCacheObj)obj).cloneCacheObj();
        }
        return obj;
    }

    public static CacheBlock cloneCacheBlockIfNeeded(CacheBlock cb) {
        Object obj2;
        if (cb == null) {
            return null;
        }
        Object obj = cb.getData();
        if (obj != (obj2 = RepoImplUtil.cloneObjIfNeeded(obj))) {
            return new CacheBlock(cb.getCreationTime(), cb.getExpirationTime(), obj2);
        }
        return cb;
    }
}

