/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import oracle.jsp.jwcache.impl.CacheCommonUtil;

public class InvalidateRequest
implements HttpServletRequest {
    private static final String MSG_FILE = "oracle.jsp.jwcache.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.impl.LocalStrings");
    protected HttpServletRequest request;
    protected Hashtable parameters;
    protected Map parametersMap;
    protected boolean translateParams;
    protected Cookie[] cookies;
    protected String requestURI;
    protected String inPath;
    protected String appPath;

    public InvalidateRequest(HttpServletRequest request, String inPath) {
        this(request, inPath, null);
    }

    public InvalidateRequest(HttpServletRequest request, String inPath, Cookie[] newCookies) {
        this.request = request;
        this.parameters = null;
        this.translateParams = false;
        this.cookies = newCookies != null ? newCookies : request.getCookies();
        if (!inPath.startsWith("/")) {
            throw new IllegalArgumentException(msgs.getString("no_leading_slash"));
        }
        this.inPath = inPath;
        this.appPath = CacheCommonUtil.getContextPath(request);
        this.requestURI = this.appPath + inPath;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public final String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public final int getContentLength() {
        return this.request.getContentLength();
    }

    public final String getContentType() {
        return this.request.getContentType();
    }

    public final ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public final String getProtocol() {
        return this.request.getProtocol();
    }

    public final String getScheme() {
        return this.request.getScheme();
    }

    public final String getServerName() {
        return this.request.getServerName();
    }

    public final int getServerPort() {
        return this.request.getServerPort();
    }

    public final BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public final String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public final String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String key, Object o) {
        this.request.setAttribute(key, o);
    }

    public final String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public final String getAuthType() {
        return this.request.getAuthType();
    }

    public final Cookie[] getCookies() {
        return this.cookies;
    }

    public final long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public final String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public final Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public final int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public final String getMethod() {
        return this.request.getMethod();
    }

    public final String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public final String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public final HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public final HttpSession getSession() {
        return this.request.getSession();
    }

    public final boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public final boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public final boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public final boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public final String getParameter(String name) {
        Object param;
        if (this.parameters == null) {
            this.parameters = this.parseQueryString();
        }
        if ((param = this.parameters.get(name)) == null) {
            return null;
        }
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        return (String)param;
    }

    public final Enumeration getParameterNames() {
        if (this.parameters == null) {
            this.parameters = this.parseQueryString();
        }
        return this.parameters.keys();
    }

    public final String[] getParameterValues(String name) {
        Object params;
        if (this.parameters == null) {
            this.parameters = this.parseQueryString();
        }
        if ((params = this.parameters.get(name)) == null) {
            return null;
        }
        if (params instanceof String) {
            String[] p = new String[]{(String)params};
            return p;
        }
        return (String[])params;
    }

    private Hashtable parseQueryString() {
        Hashtable includeParams = this.parseQueryString(this.getQueryString());
        return includeParams;
    }

    protected Hashtable parseQueryString(String queryString) {
        try {
            return HttpUtils.parseQueryString((String)queryString);
        }
        catch (IllegalArgumentException e) {
            return new Hashtable();
        }
    }

    public final Locale getLocale() {
        return this.request.getLocale();
    }

    public final Enumeration getLocales() {
        return this.request.getLocales();
    }

    public final boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public final Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public final Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public final String getContextPath() {
        return this.appPath;
    }

    public final void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public final boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public final String getQueryString() {
        int index = this.inPath.indexOf(63);
        if (index == -1 || index == this.inPath.length() - 1) {
            return null;
        }
        return this.inPath.substring(index + 1);
    }

    public final String getRequestURI() {
        int index = this.requestURI.indexOf(63);
        if (index != -1) {
            return this.requestURI.substring(0, index);
        }
        return this.requestURI;
    }

    private String get20PathInfo() {
        int index = this.inPath.indexOf(63);
        if (index != -1) {
            return this.inPath.substring(0, index);
        }
        return this.inPath;
    }

    public String getPathInfo() {
        switch (CacheCommonUtil.getServletImplFlag(this.request)) {
            case 1: {
                return null;
            }
            case 2: {
                return this.get20PathInfo();
            }
        }
        throw new IllegalStateException(msgs.getString("undefined_flag"));
    }

    public String getPathTranslated() {
        return this.getRealPath(this.getPathInfo());
    }

    public String getServletPath() {
        switch (CacheCommonUtil.getServletImplFlag(this.request)) {
            case 1: {
                return this.get20PathInfo();
            }
            case 2: {
                return null;
            }
        }
        throw new IllegalStateException(msgs.getString("undefined_flag"));
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }

    public static Map convHashtableToMap(Hashtable t) {
        Enumeration keyEnum = t.keys();
        HashMap hm = new HashMap();
        while (keyEnum.hasMoreElements()) {
            Object key = keyEnum.nextElement();
            Object paramValue = t.get(key);
            hm.put(key, paramValue);
        }
        return hm;
    }

    public Map getParameterMap() {
        if (this.parametersMap != null) {
            return this.parametersMap;
        }
        if (this.parameters == null) {
            this.parameters = this.parseQueryString();
        }
        this.parametersMap = InvalidateRequest.convHashtableToMap(this.parameters);
        return this.parametersMap;
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }
}

