/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.impl.CacheCommonUtil;
import oracle.jsp.jwcache.impl.CacheConfigParamImpl;
import oracle.jsp.jwcache.impl.CacheRepoSetting;
import oracle.jsp.jwcache.impl.FileBasedCachePolicy;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CacheConfigFileUtil {
    private static final String MSG_FILE = "oracle.jsp.jwcache.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.impl.LocalStrings");
    private static Hashtable dtdTable = new Hashtable();

    private static InputStream getInternalResourceStream(String s) {
        return CacheConfigFileUtil.class.getResourceAsStream(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DTD getDTD(String name, String root) throws IOException, XMLParseException, SAXException {
        DTD dtd = (DTD)dtdTable.get(name);
        if (dtd != null) {
            return dtd;
        }
        DOMParser parser = new DOMParser();
        InputStream dtdStream = null;
        try {
            dtdStream = CacheConfigFileUtil.getInternalResourceStream(name);
            parser.parseDTD(dtdStream, root);
            dtd = parser.getDoctype();
            dtdTable.put(name, dtd);
            DTD dTD = dtd;
            return dTD;
        }
        finally {
            if (dtdStream != null) {
                dtdStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getWebCacheConfigDoc(ServletContext sc) throws FileNotFoundException, IOException, SAXException, XMLParseException {
        DOMParser parser = new DOMParser();
        DTD dtd = CacheConfigFileUtil.getDTD("wcache.dtd", "wcache-config");
        parser.setDoctype(dtd);
        parser.setErrorStream((OutputStream)System.err);
        parser.setValidationMode(true);
        parser.showWarnings(true);
        InputStream docStream = null;
        try {
            XMLDocument doc;
            docStream = CacheCommonUtil.getResourceAsStream(sc, "/WEB-INF/wcache.xml");
            if (docStream == null) {
                throw new IOException(MessageFormat.format(msgs.getString("resource_not_found"), "WEB-INF/wcache.xml"));
            }
            parser.parse(docStream);
            XMLDocument xMLDocument = doc = parser.getDocument();
            return xMLDocument;
        }
        finally {
            if (docStream != null) {
                docStream.close();
            }
        }
    }

    private static String getSimpleElemValue(Element e) {
        if (e.hasChildNodes()) {
            return e.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static CacheConfigParamImpl elemToInitParam(CacheConfigParamImpl config, Element initParamElem) {
        NodeList nl = initParamElem.getChildNodes();
        int len = nl.getLength();
        String paramName = null;
        String paramValue = null;
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = CacheConfigFileUtil.getSimpleElemValue(e);
            if (!CacheConfigFileUtil.containsValue(nodeValue)) continue;
            if (nodeName.equals("param-name")) {
                paramName = nodeValue.trim();
            }
            if (nodeName.equals("param-value")) {
                paramValue = nodeValue.trim();
            }
            if (paramName == null || paramValue == null) continue;
            config.setInitParameter(paramName, paramValue);
            paramName = null;
            paramValue = null;
        }
        return config;
    }

    private static CacheRepoSetting elemToCacheRepoSetting(Element cacheRepoSettingElem) {
        NodeList nl = cacheRepoSettingElem.getChildNodes();
        int len = nl.getLength();
        CacheRepoSetting cacheRepoSettingObj = new CacheRepoSetting();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = CacheConfigFileUtil.getSimpleElemValue(e);
            if (nodeName.equals("init-param")) {
                CacheConfigFileUtil.elemToInitParam(cacheRepoSettingObj.configParams, e);
                continue;
            }
            if (!CacheConfigFileUtil.containsValue(nodeValue)) continue;
            if (nodeName.equals("cache-repository-name")) {
                cacheRepoSettingObj.repoName = nodeValue.trim();
            }
            if (!nodeName.equals("cache-repository-class")) continue;
            cacheRepoSettingObj.className = nodeValue.trim();
        }
        return cacheRepoSettingObj;
    }

    private static CacheRepoSetting getCacheRepoSetting(ServletConfig config, String name) throws XMLParseException, IOException, SAXException, FileNotFoundException, CacheRepositoryException {
        ServletContext sc = config.getServletContext();
        Hashtable<String, CacheRepoSetting> settings = new Hashtable<String, CacheRepoSetting>();
        Document doc = CacheConfigFileUtil.getWebCacheConfigDoc(sc);
        Element wcacheConfigElem = doc.getDocumentElement();
        NodeList nl = wcacheConfigElem.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element e;
            String nodeName;
            Node n = nl.item(i);
            if (!(n instanceof Element) || !(nodeName = (e = (Element)n).getNodeName()).equals("cache-repository")) continue;
            CacheRepoSetting setting = CacheConfigFileUtil.elemToCacheRepoSetting(e);
            setting.configParams.setServletConfig(config);
            if (settings.get(setting.repoName) != null) {
                throw new CacheRepositoryException(MessageFormat.format(msgs.getString("duplicated_repos_names"), setting.repoName));
            }
            settings.put(setting.repoName, setting);
        }
        return (CacheRepoSetting)settings.get(name);
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static CacheRepository createRepo(ServletConfig config, String name) throws CacheRepositoryException {
        CacheRepoSetting repoSetting = null;
        try {
            repoSetting = CacheConfigFileUtil.getCacheRepoSetting(config, name);
            if (repoSetting == null) {
                throw new CacheRepositoryException(MessageFormat.format(msgs.getString("setting_not_found"), name));
            }
            Class repoClass = CacheConfigFileUtil.loadClass(repoSetting.className);
            CacheRepository cr = (CacheRepository)repoClass.newInstance();
            cr.init(repoSetting.configParams);
            return cr;
        }
        catch (Exception e) {
            throw new CacheRepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getCachePolicyDoc(ServletContext sc, String name) throws FileNotFoundException, IOException, SAXException, XMLParseException {
        DOMParser parser = new DOMParser();
        DTD dtd = CacheConfigFileUtil.getDTD("cachepolicy.dtd", "cachePolicy");
        parser.setDoctype(dtd);
        parser.setErrorStream((OutputStream)System.err);
        parser.setValidationMode(true);
        parser.showWarnings(true);
        InputStream docStream = null;
        try {
            XMLDocument doc;
            docStream = CacheCommonUtil.getResourceAsStream(sc, name);
            if (docStream == null) {
                throw new IOException(MessageFormat.format(msgs.getString("resource_not_found"), name));
            }
            parser.parse(docStream);
            XMLDocument xMLDocument = doc = parser.getDocument();
            return xMLDocument;
        }
        finally {
            if (docStream != null) {
                docStream.close();
            }
        }
    }

    private static ExpirationPolicy elemToExpirationPolicy(Element e) throws NumberFormatException, ParseException {
        ExpirationPolicy ePolicy = new ExpirationPolicy();
        String attrValue = e.getAttribute("expirationType");
        if (CacheConfigFileUtil.containsValue(attrValue)) {
            ePolicy.setExpirationType(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = e.getAttribute("TTL"))) {
            ePolicy.setTTL(Long.parseLong(attrValue));
        }
        if (CacheConfigFileUtil.containsValue(attrValue = e.getAttribute("timeInaDay"))) {
            ePolicy.setTimeInaDay(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = e.getAttribute("dayInaWeek"))) {
            ePolicy.setDayInaWeek(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = e.getAttribute("dayInaMonth"))) {
            ePolicy.setDayInaMonth(Integer.parseInt(attrValue));
        }
        if (CacheConfigFileUtil.containsValue(attrValue = e.getAttribute("writeThrough"))) {
            ePolicy.setWriteThrough(attrValue);
        }
        return ePolicy;
    }

    public static CachePolicy loadCachePolicy(ServletConfig config, String name) throws XMLParseException, IOException, SAXException, FileNotFoundException, ParseException, NumberFormatException {
        ServletContext sc = config.getServletContext();
        Document doc = CacheConfigFileUtil.getCachePolicyDoc(sc, name);
        FileBasedCachePolicy cPolicy = new FileBasedCachePolicy(config);
        Element cachePolicyElem = doc.getDocumentElement();
        String attrValue = cachePolicyElem.getAttribute("ignoreCache");
        if (CacheConfigFileUtil.containsValue(attrValue)) {
            cPolicy.setIgnoreCache(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = cachePolicyElem.getAttribute("reportException"))) {
            cPolicy.setReportException(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = cachePolicyElem.getAttribute("scope"))) {
            cPolicy.setScope(attrValue);
        }
        if (CacheConfigFileUtil.containsValue(attrValue = cachePolicyElem.getAttribute("autoType"))) {
            cPolicy.setAutoType(attrValue);
        }
        NodeList nl = cachePolicyElem.getChildNodes();
        int len = nl.getLength();
        Vector<String> selectedParameters = new Vector<String>(20, 20);
        Vector<String> selectedCookies = new Vector<String>(20, 20);
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String nodeName = e.getNodeName();
            String nodeValue = CacheConfigFileUtil.getSimpleElemValue(e);
            if (CacheConfigFileUtil.containsValue(nodeValue)) {
                nodeValue = nodeValue.trim();
            }
            if (nodeName.equals("expirationPolicy")) {
                ExpirationPolicy ePolicy = CacheConfigFileUtil.elemToExpirationPolicy(e);
                cPolicy.setExpirationPolicy(ePolicy);
                continue;
            }
            if (!CacheConfigFileUtil.containsValue(nodeValue)) continue;
            if (nodeName.equals("selectedParam")) {
                selectedParameters.addElement(nodeValue);
            }
            if (nodeName.equals("selectedCookie")) {
                selectedCookies.addElement(nodeValue);
            }
            if (nodeName.equals("reusableTimeStamp")) {
                cPolicy.setReusableTimeStamp(nodeValue);
            }
            if (nodeName.equals("reusableDeltaTime")) {
                cPolicy.setReusableDeltaTime(Long.parseLong(nodeValue));
            }
            if (!nodeName.equals("cacheRepositoryName")) continue;
            cPolicy.setCacheRepositoryName(nodeValue);
        }
        cPolicy.setSelectedParam(CacheConfigFileUtil.vectorToStrArray(selectedParameters));
        cPolicy.setSelectedCookies(CacheConfigFileUtil.vectorToStrArray(selectedCookies));
        cPolicy.setPolicyFile(name);
        return cPolicy;
    }

    private static boolean containsValue(String s) {
        return s != null && s.length() > 0;
    }

    private static String[] vectorToStrArray(Vector v) {
        if (v == null) {
            return null;
        }
        int size = v.size();
        if (size == 0) {
            return null;
        }
        String[] s = new String[size];
        for (int i = 0; i < size; ++i) {
            s[i] = (String)v.elementAt(i);
        }
        return s;
    }
}

