/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache.impl;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.jsp.jwcache.CachePolicy;
import oracle.jsp.jwcache.CachePolicyLoadingException;
import oracle.jsp.jwcache.impl.CacheConfigFileUtil;
import oracle.jsp.jwcache.impl.CacheOCSUtil;
import oracle.jsp.jwcache.impl.InvalidateRequest;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.jsp.webutil.tagutil.TagUtil;
import oracle.jsp.webutil.tagutil.event.JspScopeEvent;
import oracle.jsp.webutil.tagutil.event.JspScopeListener;

public class CacheCommonUtil {
    private static final String MSG_FILE = "oracle.jsp.jwcache.impl.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.impl.LocalStrings");
    public static final int SERVLET_UNDEFINED = 0;
    public static final int SERVLET_22_OR_ABOVE = 1;
    public static final int SERVLET_APACHEJSERV = 2;
    private static int servletImplFlag = 0;

    public static boolean strToBoolean(String v) {
        if (v.equalsIgnoreCase("true")) {
            return true;
        }
        if (v.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(msgs.getString("true_or_false"));
    }

    public static Object getAppAttribute(ServletContext app, String name) {
        return app.getAttribute(name);
    }

    public static void setAppAttribute(ServletContext app, String name, Object obj) {
        app.setAttribute(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheRepository lookupRepo(ServletConfig config, String name) throws CacheRepositoryException {
        ServletContext app = config.getServletContext();
        RepoTable repoTable = null;
        Object object = app;
        synchronized (object) {
            repoTable = (RepoTable)CacheCommonUtil.getAppAttribute(app, "oracle.jsp.jwcache.cacherepositories");
            if (repoTable == null) {
                repoTable = new RepoTable();
                CacheCommonUtil.setAppAttribute(app, "oracle.jsp.jwcache.cacherepositories", repoTable);
            }
        }
        object = repoTable;
        synchronized (object) {
            CacheRepository repo = (CacheRepository)repoTable.get(name);
            if (repo == null) {
                repo = CacheConfigFileUtil.createRepo(config, name);
                repoTable.put(name, repo);
                return repo;
            }
            return repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyRepo(ServletContext app, String name) throws IllegalStateException {
        RepoTable repoTable = null;
        Object object = app;
        synchronized (object) {
            repoTable = (RepoTable)CacheCommonUtil.getAppAttribute(app, "oracle.jsp.jwcache.cacherepositories");
            if (repoTable == null) {
                throw new IllegalStateException(MessageFormat.format(msgs.getString("repos_not_found"), name));
            }
        }
        object = repoTable;
        synchronized (object) {
            CacheRepository repo = (CacheRepository)repoTable.get(name);
            if (repo == null) {
                throw new IllegalStateException(MessageFormat.format(msgs.getString("repos_not_found"), name));
            }
            repoTable.remove(name);
            repo.destroy();
        }
    }

    private static String handleRelPath(HttpServletRequest req, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        throw new IllegalArgumentException(msgs.getString("no_slash"));
    }

    public static CachePolicy lookupPolicy(ServletConfig config, HttpServletRequest req, String name) throws CachePolicyLoadingException {
        name = CacheCommonUtil.handleRelPath(req, name);
        if (CacheOCSUtil.isPolicyInOCS(config)) {
            return CacheOCSUtil.lookupPolicyOCS(config, req, name);
        }
        return CacheCommonUtil.lookupPolicyHT(config, name);
    }

    public static CachePolicy refreshPolicy(ServletConfig config, HttpServletRequest req, String name) throws CachePolicyLoadingException {
        name = CacheCommonUtil.handleRelPath(req, name);
        if (CacheOCSUtil.isPolicyInOCS(config)) {
            return CacheOCSUtil.refreshPolicyOCS(config, req, name);
        }
        return CacheCommonUtil.refreshPolicyHT(config, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachePolicy lookupPolicyHT(ServletConfig config, String name) throws CachePolicyLoadingException {
        ServletContext app = config.getServletContext();
        Hashtable<String, CachePolicy> policyTable = null;
        Object object = app;
        synchronized (object) {
            policyTable = (Hashtable<String, CachePolicy>)CacheCommonUtil.getAppAttribute(app, "oracle.jsp.jwcache.cachepolicies");
            if (policyTable == null) {
                policyTable = new Hashtable<String, CachePolicy>();
                CacheCommonUtil.setAppAttribute(app, "oracle.jsp.jwcache.cachepolicies", policyTable);
            }
        }
        object = policyTable;
        synchronized (object) {
            CachePolicy policy = (CachePolicy)policyTable.get(name);
            if (policy == null) {
                try {
                    policy = CacheConfigFileUtil.loadCachePolicy(config, name);
                }
                catch (Exception e) {
                    throw new CachePolicyLoadingException(MessageFormat.format(msgs.getString("cannot_load_policy"), name), e);
                }
                policyTable.put(name, policy);
                return new CachePolicy(policy);
            }
            return new CachePolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachePolicy refreshPolicyHT(ServletConfig config, String name) throws CachePolicyLoadingException {
        ServletContext app = config.getServletContext();
        Hashtable<String, CachePolicy> policyTable = null;
        Object object = app;
        synchronized (object) {
            policyTable = (Hashtable<String, CachePolicy>)CacheCommonUtil.getAppAttribute(app, "oracle.jsp.jwcache.cachepolicies");
            if (policyTable == null) {
                policyTable = new Hashtable<String, CachePolicy>();
                CacheCommonUtil.setAppAttribute(app, "oracle.jsp.jwcache.cachepolicies", policyTable);
            }
        }
        object = policyTable;
        synchronized (object) {
            CachePolicy policy = null;
            try {
                policy = CacheConfigFileUtil.loadCachePolicy(config, name);
            }
            catch (Exception e) {
                throw new CachePolicyLoadingException(MessageFormat.format(msgs.getString("cannot_load_policy"), name), e);
            }
            policyTable.put(name, policy);
            return policy;
        }
    }

    public static int getServletImplFlag(HttpServletRequest req) {
        if (servletImplFlag == 0 && req != null) {
            try {
                req.getContextPath();
                servletImplFlag = 1;
            }
            catch (NoSuchMethodError e) {
                servletImplFlag = 2;
            }
        }
        return servletImplFlag;
    }

    public static String getContextPath(HttpServletRequest req) {
        if (req instanceof InvalidateRequest) {
            String cp = ((InvalidateRequest)req).getContextPath();
            return cp;
        }
        String cp = req.getContextPath();
        return cp;
    }

    public static InputStream getResourceAsStream(ServletContext sc, String path) {
        return sc.getResourceAsStream(path);
    }

    public static String getRequestURI(HttpServletRequest req) {
        String path = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (path == null) {
            return req.getRequestURI();
        }
        return path;
    }

    public static String getQueryString(HttpServletRequest req) {
        String qs = TagUtil.getQueryString(req);
        if (qs == null) {
            return "";
        }
        return qs;
    }

    public static String getAppConfigInitParameter(ServletConfig config, String name) {
        String value = null;
        value = config.getInitParameter(name);
        if (value != null) {
            return value;
        }
        try {
            value = config.getServletContext().getInitParameter(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    private static class RepoTable
    extends Hashtable
    implements JspScopeListener {
        private RepoTable() {
        }

        public void outOfScope(JspScopeEvent ae) {
            Enumeration enumerator = this.elements();
            while (enumerator.hasMoreElements()) {
                CacheRepository repo = (CacheRepository)enumerator.nextElement();
                repo.destroy();
            }
        }
    }
}

