/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jwcache;

import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.BodyContent;
import oracle.jsp.jwcache.CacheBlock;
import oracle.jsp.jwcache.CacheRuntimeException;
import oracle.jsp.jwcache.ExpirationPolicy;
import oracle.jsp.jwcache.SectionId;
import oracle.jsp.jwcache.StringSectionId;
import oracle.jsp.jwcache.impl.CacheCommonUtil;
import oracle.jsp.jwcache.impl.InvalidateRequest;
import oracle.jsp.jwcache.repository.CacheRepository;
import oracle.jsp.jwcache.repository.CacheRepositoryException;
import oracle.jsp.jwcache.repository.impl.DOMCacheWrapper;
import oracle.jsp.jwcache.repository.impl.SimpleHTRepoImpl;
import org.w3c.dom.Document;

public class CachePolicy
implements Serializable {
    private transient ServletConfig config;
    private transient ServletContext application;
    private boolean attrChanged;
    private boolean ignoreCache;
    private int scope;
    private int autoType;
    private String[] selectedParameters;
    private String[] selectedCookies;
    private Date reusableTimeStamp;
    private long reusableDeltaTime;
    private ExpirationPolicy expirationPolicyObj;
    private String repoName;
    private boolean reportException;
    private static final String MSG_FILE = "oracle.jsp.jwcache.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jwcache.LocalStrings");
    public static final int SCOPE_SESSION = 1;
    public static final int SCOPE_APP = 2;
    public static final String SCOPE_SESSION_STR = "session";
    public static final String SCOPE_APP_STR = "application";
    public static final int TYPE_USERSPECIFIED = 0;
    public static final int TYPE_URI_ONLY = 1;
    public static final int TYPE_URI_QUERYSTR = 2;
    public static final int TYPE_URI_ALLPARAM = 3;
    public static final int TYPE_URI_SELECTEDPARAM = 4;
    public static final int TYPE_URI_EXCLUDEDPARAM = 5;
    public static final String[] TYPE_STRS = new String[]{"user", "URI", "URI_query", "URI_allParam", "URI_selectedParam", "URI_excludedParam"};
    public static final String DEFAULT_REPO_NAME = "DefaultCacheRepository";
    public static final String CACHE_REPOS = "oracle.jsp.jwcache.cacherepositories";
    public static final String CACHE_POLICIES = "oracle.jsp.jwcache.cachepolicies";
    public static final String SECTION_ID = "oracle.jsp.jwcache.autosectionid";
    public static final String SESSION_CACHE_REPO = "oracle.jsp.jwcache.sessioncacherepo";
    public static final int REUSABLE_ALWAYS = -1;
    private SimpleDateFormat[] date_formats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z"), new SimpleDateFormat("yyyy.MM.dd hh:mm:ss"), new SimpleDateFormat("yyyy.MM.dd")};
    public static final String REUSABLE_IGNORED = "ignored";
    public static final String CACHENAME_USER = "user";
    public static final String CACHENAME_AUTO = "auto";
    public static final int AUTO_INVALIDATE_UNDEFINED = -1;
    public static final int AUTO_INVALIDATE_APP_LEVEL = 3;
    public static final int AUTO_INVALIDATE_PAGE_LEVEL = 4;
    public static final int AUTO_INVALIDATE_PARAM_LEVEL = 5;
    public static final int AUTO_INVALIDATE_COOKIE_LEVEL = 6;
    public static final String AUTO_INVALIDATE_APP_LEVEL_STR = "application";
    public static final String AUTO_INVALIDATE_PAGE_LEVEL_STR = "page";
    public static final String AUTO_INVALIDATE_PARAM_LEVEL_STR = "param";
    public static final String AUTO_INVALIDATE_COOKIE_LEVEL_STR = "cookie";

    public CachePolicy(ServletConfig config) {
        this(config, false, false, 2, 3, null, null, -1L, -1L, new ExpirationPolicy(), DEFAULT_REPO_NAME, true);
    }

    public CachePolicy(CachePolicy cPolicy) {
        this.config = cPolicy.config;
        this.application = cPolicy.application;
        this.ignoreCache = cPolicy.ignoreCache;
        this.scope = cPolicy.scope;
        this.autoType = cPolicy.autoType;
        this.selectedParameters = CachePolicy.clone(cPolicy.selectedParameters);
        this.selectedCookies = CachePolicy.clone(cPolicy.selectedCookies);
        this.reusableTimeStamp = cPolicy.reusableTimeStamp;
        this.reusableDeltaTime = cPolicy.reusableDeltaTime;
        this.setExpirationPolicy(new ExpirationPolicy(cPolicy.expirationPolicyObj));
        this.repoName = cPolicy.repoName;
        this.reportException = cPolicy.reportException;
        this.attrChanged = cPolicy.attrChanged;
    }

    public CachePolicy(ServletConfig config, CachePolicy cPolicy) {
        this.config = config;
        this.application = config.getServletContext();
        this.ignoreCache = cPolicy.ignoreCache;
        this.scope = cPolicy.scope;
        this.autoType = cPolicy.autoType;
        this.selectedParameters = CachePolicy.clone(cPolicy.selectedParameters);
        this.selectedCookies = CachePolicy.clone(cPolicy.selectedCookies);
        this.reusableTimeStamp = cPolicy.reusableTimeStamp;
        this.reusableDeltaTime = cPolicy.reusableDeltaTime;
        this.setExpirationPolicy(new ExpirationPolicy(cPolicy.expirationPolicyObj));
        this.repoName = cPolicy.repoName;
        this.reportException = cPolicy.reportException;
        this.attrChanged = cPolicy.attrChanged;
    }

    protected CachePolicy(ServletConfig config, boolean attrChanged, boolean ignoreCache, int scope, int autoType, String[] selectedParameters, String[] selectedCookies, long reusableTimeStamp, long reusableDeltaTime, ExpirationPolicy expirationPolicyObj, String repoName, boolean reportException) {
        this.config = config;
        this.application = config.getServletContext();
        this.setIgnoreCache(ignoreCache);
        this.setScope(scope);
        this.setAutoType(autoType);
        this.setSelectedParam(selectedParameters);
        this.setSelectedCookies(selectedCookies);
        this.setReusableTimeStamp(reusableTimeStamp);
        this.setReusableDeltaTime(reusableDeltaTime);
        this.setExpirationPolicy(expirationPolicyObj);
        this.setCacheRepositoryName(repoName);
        this.setReportException(reportException);
        this.attrChanged = attrChanged;
    }

    private static String[] clone(String[] s) {
        if (s == null) {
            return null;
        }
        String[] t = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            t[i] = s[i];
        }
        return t;
    }

    private CacheRepository getRepo() throws CacheRepositoryException {
        return CacheCommonUtil.lookupRepo(this.config, this.repoName);
    }

    protected void setAttrChanged() {
        this.attrChanged = true;
    }

    protected void resetAttrChanged() {
        this.attrChanged = false;
    }

    public boolean getAttrChanged() {
        return this.attrChanged;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
        this.attrChanged = true;
    }

    public void setIgnoreCache(String v) {
        this.setIgnoreCache(CacheCommonUtil.strToBoolean(v));
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        if (scope < 1 || scope > 2) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("undefined_scope_value"), new Integer(scope)));
        }
        this.scope = scope;
        this.attrChanged = true;
    }

    public void setScope(String s) {
        if (s.equalsIgnoreCase(SCOPE_SESSION_STR)) {
            this.setScope(1);
            return;
        }
        if (s.equalsIgnoreCase("application")) {
            this.setScope(2);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(msgs.getString("illegal_scope"), s));
    }

    public int getAutoType() {
        return this.autoType;
    }

    public void setAutoType(int autoType) {
        if (autoType < 0 || autoType > 5) {
            throw new IllegalArgumentException(MessageFormat.format(msgs.getString("undefined_autoType"), new Integer(autoType)));
        }
        this.autoType = autoType;
        this.attrChanged = true;
    }

    public void setAutoType(String s) {
        for (int i = 0; i < TYPE_STRS.length; ++i) {
            if (!s.equalsIgnoreCase(TYPE_STRS[i])) continue;
            this.setAutoType(i);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(msgs.getString("illegal_autoType"), s));
    }

    public static String[] parseSpaceDelimitedString(String s) {
        Vector<String> v = new Vector<String>(10);
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken().trim());
        }
        int size = v.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public String[] getSelectedParam() {
        return this.selectedParameters;
    }

    public void setSelectedParam(String[] selectedParameters) {
        this.selectedParameters = CachePolicy.clone(selectedParameters);
        this.attrChanged = true;
    }

    public void setSelectedParam(String selectedParamStr) {
        this.setSelectedParam(CachePolicy.parseSpaceDelimitedString(selectedParamStr));
    }

    public String[] getSelectedCookies() {
        return this.selectedCookies;
    }

    public void setSelectedCookies(String[] selectedCookies) {
        this.selectedCookies = CachePolicy.clone(selectedCookies);
        this.attrChanged = true;
    }

    public void setSelectedCookies(String selectedCookiesStr) {
        this.setSelectedCookies(CachePolicy.parseSpaceDelimitedString(selectedCookiesStr));
    }

    public Date getReusableTimeStamp() {
        return this.reusableTimeStamp;
    }

    public void setReusableTimeStamp(Date reusableTimeStamp) {
        this.reusableTimeStamp = reusableTimeStamp;
        this.attrChanged = true;
    }

    public void setReusableTimeStamp(long reusableTimeStamp) {
        this.setReusableTimeStamp(new Date(reusableTimeStamp));
    }

    public void setReusableTimeStamp(String s) throws ParseException {
        if (s.equals(REUSABLE_IGNORED)) {
            this.setReusableTimeStamp(-1L);
            return;
        }
        Date d = null;
        ParseException pe = null;
        for (int i = 0; i < this.date_formats.length; ++i) {
            try {
                d = this.date_formats[i].parse(s);
                break;
            }
            catch (ParseException e) {
                pe = e;
                continue;
            }
        }
        if (d == null) {
            throw pe;
        }
        this.setReusableTimeStamp(d);
    }

    public long getReusableDeltaTime() {
        return this.reusableDeltaTime;
    }

    public void setReusableDeltaTime(long reusableDeltaTime) {
        if (reusableDeltaTime < 0L && reusableDeltaTime != -1L) {
            throw new IllegalArgumentException(msgs.getString("negative_reusableDeltaTime"));
        }
        this.reusableDeltaTime = reusableDeltaTime;
        this.attrChanged = true;
    }

    public void setReusableDeltaTime(String s) throws NumberFormatException {
        if (s.equals(REUSABLE_IGNORED)) {
            this.setReusableDeltaTime(-1L);
        } else {
            this.setReusableDeltaTime(Long.parseLong(s));
        }
    }

    public ExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicyObj;
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicyObj) {
        this.expirationPolicyObj = new ExpirationPolicy(expirationPolicyObj);
        this.expirationPolicyObj.cachePolicyObj = this;
        this.attrChanged = true;
    }

    public void setCacheRepositoryName(String repoName) {
        this.repoName = repoName;
        this.attrChanged = true;
    }

    public String getCacheRepositoryName() {
        return this.repoName;
    }

    public void setReportException(boolean reportException) {
        this.reportException = reportException;
        this.attrChanged = true;
    }

    public void setReportException(String reportExceptionStr) {
        this.setReportException(CacheCommonUtil.strToBoolean(reportExceptionStr));
    }

    public boolean getReportException() {
        return this.reportException;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("<cachePolicy \n");
        sb.append("  ignoreCache=\"");
        sb.append(this.ignoreCache);
        sb.append("\"\n");
        sb.append("  scope=\"");
        if (this.scope == 1) {
            sb.append(SCOPE_SESSION_STR);
        } else {
            sb.append("application");
        }
        sb.append("\"\n");
        sb.append("  autoType=\"");
        sb.append(TYPE_STRS[this.autoType]);
        sb.append("\"\n");
        sb.append("  reportException=\"");
        sb.append(this.reportException);
        sb.append("\"\n");
        sb.append("  >\n");
        if (this.selectedParameters != null) {
            for (i = 0; i < this.selectedParameters.length; ++i) {
                sb.append("  <selectedParam>");
                sb.append(this.selectedParameters[i]);
                sb.append("</selectedParam>\n");
            }
        }
        if (this.selectedCookies != null) {
            for (i = 0; i < this.selectedCookies.length; ++i) {
                sb.append("  <selectedCookie>");
                sb.append(this.selectedCookies[i]);
                sb.append("</selectedCookie>\n");
            }
        }
        if (this.reusableTimeStamp.getTime() != -1L) {
            sb.append("  <reusableTimeStamp>");
            sb.append(this.reusableTimeStamp);
            sb.append("</reusableTimeStamp>\n");
        }
        if (this.reusableDeltaTime != -1L) {
            sb.append("  <reusableDeltaTime>");
            sb.append(this.reusableDeltaTime);
            sb.append("</reusableDeltaTime>\n");
        }
        sb.append("  <cacheRepositoryName>");
        sb.append(this.repoName);
        sb.append("</cacheRepositoryName>\n");
        sb.append(this.expirationPolicyObj.toString());
        sb.append("\n");
        sb.append("</cachePolicy>");
        return new String(sb);
    }

    public String getDebugCacheName(HttpServletRequest req, String specifiedName, SectionId sectionId) {
        String[] name = this.genCacheNameFromReq(req, specifiedName, sectionId);
        StringBuffer sb = new StringBuffer();
        sb.append("<cache_internal_name>");
        for (int i = 0; i < name.length; ++i) {
            sb.append("<nseq>");
            sb.append(name[i]);
            sb.append("</nseq>");
        }
        sb.append("</cache_internal_name>");
        sb.append('\n');
        return new String(sb);
    }

    private String[] genCacheNameFromReq(HttpServletRequest req, String specifiedName, SectionId sectionId) {
        return this.genCacheNameFromReq(req, specifiedName, sectionId, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] genCacheNameFromReq(HttpServletRequest req, String specifiedName, SectionId sectionId, boolean genWildCard) {
        if (this.autoType == 0) {
            String[] name = new String[4];
            name[0] = req.getServerName() + ":" + req.getServerPort();
            name[1] = CacheCommonUtil.getContextPath(req);
            name[2] = CACHENAME_USER;
            if (specifiedName == null) {
                if (!genWildCard) throw new IllegalArgumentException(msgs.getString("null_cache_name"));
                name[3] = "*";
                return name;
            } else {
                name[3] = specifiedName;
            }
            return name;
        }
        String[] name = new String[7];
        name[0] = req.getServerName() + ":" + req.getServerPort();
        name[1] = CacheCommonUtil.getContextPath(req);
        name[2] = CACHENAME_AUTO;
        name[3] = CacheCommonUtil.getRequestURI(req);
        switch (this.autoType) {
            case 1: {
                name[4] = "";
                name[5] = "";
                break;
            }
            case 2: {
                name[4] = CacheCommonUtil.getQueryString(req);
                name[5] = this.genSelectedCookiesString(req);
                break;
            }
            case 3: {
                name[4] = this.genAllParamString(req);
                name[5] = this.genSelectedCookiesString(req);
                break;
            }
            case 4: {
                name[4] = this.genSelectedParamString(req);
                name[5] = this.genSelectedCookiesString(req);
                break;
            }
            case 5: {
                name[4] = this.genExcludedParamString(req);
                name[5] = this.genSelectedCookiesString(req);
            }
        }
        if (sectionId == null) {
            if (!genWildCard) throw new IllegalArgumentException(msgs.getString("null_sectionId"));
            name[6] = "*";
            return name;
        } else {
            name[6] = ((Object)sectionId).toString();
        }
        return name;
    }

    private String genAllParamString(HttpServletRequest req) {
        return CachePolicy.genAllButExcludedParamString(req, null);
    }

    private String genExcludedParamString(HttpServletRequest req) {
        return CachePolicy.genAllButExcludedParamString(req, this.selectedParameters);
    }

    private static String genAllButExcludedParamString(HttpServletRequest req, String[] params) {
        Enumeration enumerator = CachePolicy.sortEnum(req.getParameterNames());
        StringBuffer sb = new StringBuffer();
        while (enumerator.hasMoreElements()) {
            String name = (String)enumerator.nextElement();
            if (CachePolicy.strInStrs(name, params)) continue;
            CachePolicy.addNameValue(sb, name, req.getParameter(name));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new String(sb);
    }

    private static boolean strInStrs(String str, String[] strs) {
        if (strs == null) {
            return false;
        }
        if (str == null) {
            return false;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!str.equals(strs[i])) continue;
            return true;
        }
        return false;
    }

    private String genSelectedParamString(HttpServletRequest req) {
        if (this.selectedParameters == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectedParameters.length; ++i) {
            CachePolicy.addNameValue(sb, this.selectedParameters[i], req.getParameter(this.selectedParameters[i]));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new String(sb);
    }

    private String genSelectedCookiesString(HttpServletRequest req) {
        if (this.selectedCookies == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.selectedCookies.length; ++i) {
            CachePolicy.addNameValue(sb, this.selectedCookies[i], this.getCookieValue(req, this.selectedCookies[i]));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new String(sb);
    }

    private String getCookieValue(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!name.equals(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static Enumeration sortEnum(Enumeration enumerator) {
        if (enumerator == null) {
            return null;
        }
        Vector<String> v = new Vector<String>(40, 40);
        while (enumerator.hasMoreElements()) {
            int i;
            String s = (String)enumerator.nextElement();
            int vLen = v.size();
            for (i = 0; i < vLen && s.compareTo((String)v.elementAt(i)) > 0; ++i) {
            }
            if (i == vLen) {
                v.addElement(s);
                continue;
            }
            v.insertElementAt(s, i);
        }
        return v.elements();
    }

    private static void addNameValue(StringBuffer sb, String name, String value) {
        if (name != null && value != null) {
            sb.append(CachePolicy.encodeSpecialChar(name));
            sb.append('=');
            sb.append(CachePolicy.encodeSpecialChar(value));
            sb.append('&');
        }
    }

    private static String encodeSpecialChar(String s) {
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (c[i] == ' ' || c[i] == '%' || c[i] == '?' || c[i] == '&' || c[i] == '=' || c[i] == '\r' || c[i] == '\n') {
                sb.append('%');
                String hexStr = Integer.toHexString(c[i]);
                continue;
            }
            sb.append(c[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheRepository getSessionCacheRepo(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        CacheRepository sessionCacheRepo = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            sessionCacheRepo = (CacheRepository)session.getValue(SESSION_CACHE_REPO);
            if (sessionCacheRepo == null) {
                sessionCacheRepo = new SimpleHTRepoImpl();
                session.putValue(SESSION_CACHE_REPO, (Object)sessionCacheRepo);
            }
            return sessionCacheRepo;
        }
    }

    private void handleException(Exception e) {
        this.application.log(e.toString());
        if (this.reportException) {
            throw new CacheRuntimeException(e);
        }
    }

    public CacheBlock getCache(HttpServletRequest req, String specifiedName, SectionId sectionId) {
        if (this.ignoreCache) {
            return null;
        }
        String[] name = this.genCacheNameFromReq(req, specifiedName, sectionId);
        try {
            Object data;
            CacheBlock cb = null;
            cb = this.scope == 2 ? this.getRepo().getCache(name) : this.getSessionCacheRepo(req).getCache(name);
            if (cb != null && (data = cb.getData()) instanceof DOMCacheWrapper) {
                Document doc = ((DOMCacheWrapper)data).getDocument();
                cb = new CacheBlock(cb.getCreationTime(), cb.getExpirationTime(), doc);
            }
            return cb;
        }
        catch (CacheRepositoryException cre) {
            this.handleException(cre);
            return null;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public CacheBlock getCache(HttpServletRequest req, SectionId sectionId) {
        return this.getCache(req, null, sectionId);
    }

    public CacheBlock getCache(HttpServletRequest req, String specifiedName) {
        return this.getCache(req, specifiedName, null);
    }

    public Date getCurrentTime() {
        try {
            return this.getRepo().getCurrentTime();
        }
        catch (CacheRepositoryException cre) {
            return new Date();
        }
    }

    public boolean isRecent(CacheBlock block) {
        if (block == null) {
            return false;
        }
        if (this.reusableTimeStamp.getTime() != -1L) {
            return block.getCreationTime() > this.reusableTimeStamp.getTime();
        }
        if (this.reusableDeltaTime != -1L) {
            return this.getCurrentTime().getTime() - block.getCreationTime() < this.reusableDeltaTime * 1000L;
        }
        return true;
    }

    public void putCache(Object obj, HttpServletRequest req, String specifiedName, SectionId sectionId) {
        if (this.ignoreCache) {
            return;
        }
        String[] name = this.genCacheNameFromReq(req, specifiedName, sectionId);
        try {
            if (obj instanceof BodyContent) {
                obj = ((BodyContent)obj).getString();
            }
            if (obj instanceof Document) {
                obj = new DOMCacheWrapper((Document)obj);
            }
            if (this.scope == 2) {
                this.getRepo().putCache(name, (Serializable)obj, this.expirationPolicyObj);
            } else {
                this.getSessionCacheRepo(req).putCache(name, (Serializable)obj, this.expirationPolicyObj);
            }
        }
        catch (CacheRepositoryException cre) {
            this.handleException(cre);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void putCache(Object obj, HttpServletRequest req, SectionId sectionId) {
        this.putCache(obj, req, null, sectionId);
    }

    public void putCache(Object obj, HttpServletRequest req, String specifiedName) {
        this.putCache(obj, req, specifiedName, null);
    }

    public void invalidateCache(HttpServletRequest req, String specifiedName, SectionId sectionId) {
        if (this.ignoreCache) {
            return;
        }
        String[] name = this.genCacheNameFromReq(req, specifiedName, sectionId);
        try {
            if (this.scope == 2) {
                this.getRepo().invalidateCache(name);
            } else {
                this.getSessionCacheRepo(req).invalidateCache(name);
            }
        }
        catch (CacheRepositoryException cre) {
            this.handleException(cre);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void invalidateCache(HttpServletRequest req, String specifiedName) {
        this.invalidateCache(req, specifiedName, null);
    }

    public void invalidateCache(HttpServletRequest req, SectionId sectionId) {
        this.invalidateCache(req, null, sectionId);
    }

    public static int autoInvalidateStrToLevelInt(String s) {
        if ((s = s.toLowerCase()).equals("application")) {
            return 3;
        }
        if (s.equals(AUTO_INVALIDATE_PAGE_LEVEL_STR)) {
            return 4;
        }
        if (s.equals(AUTO_INVALIDATE_PARAM_LEVEL_STR)) {
            return 5;
        }
        if (s.equals(AUTO_INVALIDATE_COOKIE_LEVEL_STR)) {
            return 6;
        }
        throw new IllegalArgumentException(MessageFormat.format(msgs.getString("not_autoinvalidate_level"), s));
    }

    public void invalidateCacheLike(HttpServletRequest req, String specifiedName, int autoInvalidateLevel) {
        if (this.ignoreCache) {
            return;
        }
        String[] name = this.genCacheNameFromReq(req, specifiedName, null, true);
        if (this.autoType != 0 && autoInvalidateLevel >= 3 && autoInvalidateLevel <= 6) {
            for (int i = autoInvalidateLevel; i < name.length; ++i) {
                name[i] = "*";
            }
        }
        try {
            if (this.scope == 2) {
                this.getRepo().invalidateCacheLike(name);
            } else {
                this.getSessionCacheRepo(req).invalidateCacheLike(name);
            }
        }
        catch (CacheRepositoryException cre) {
            this.handleException(cre);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void invalidateCacheLike(HttpServletRequest req, String specifiedName) {
        this.invalidateCacheLike(req, specifiedName, -1);
    }

    public void invalidateCacheLike(HttpServletRequest req, int autoInvalidateLevel) {
        this.invalidateCacheLike(req, null, autoInvalidateLevel);
    }

    public void invalidateCacheOtherPathLike(HttpServletRequest req, String otherPath, Cookie[] newCookies, int autoInvalidateLevel) {
        InvalidateRequest newReq = new InvalidateRequest(req, otherPath, newCookies);
        this.invalidateCacheLike((HttpServletRequest)newReq, autoInvalidateLevel);
    }

    public void invalidateCacheOtherPathLike(HttpServletRequest req, String otherPath) {
        if (otherPath.indexOf(63) >= 0) {
            this.invalidateCacheOtherPathLike(req, otherPath, null, 5);
        } else {
            this.invalidateCacheOtherPathLike(req, otherPath, null, 4);
        }
    }

    public void putAutoCacheForOtherPath(Object obj, HttpServletRequest req, String otherPath, StringSectionId sectionId) {
        this.putAutoCacheForOtherPath(obj, req, otherPath, null, sectionId);
    }

    public void putAutoCacheForOtherPath(Object obj, HttpServletRequest req, String otherPath, Cookie[] newCookies, StringSectionId sectionId) {
        InvalidateRequest newReq = new InvalidateRequest(req, otherPath, newCookies);
        this.putCache(obj, (HttpServletRequest)newReq, sectionId);
    }

    public CacheBlock getAutoCacheForOtherPath(HttpServletRequest req, String otherPath, StringSectionId sectionId) {
        return this.getAutoCacheForOtherPath(req, otherPath, null, sectionId);
    }

    public CacheBlock getAutoCacheForOtherPath(HttpServletRequest req, String otherPath, Cookie[] newCookies, StringSectionId sectionId) {
        InvalidateRequest newReq = new InvalidateRequest(req, otherPath, newCookies);
        return this.getCache((HttpServletRequest)newReq, sectionId);
    }

    public void markupBegin(ServletContext sc, HttpServletRequest req, Writer out, String specifiedName, SectionId sectionId) {
    }

    public void markupEnd(ServletContext sc, HttpServletRequest req, Writer out, String specifiedName, SectionId sectionId) {
    }
}

