/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.jml.tagext;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.webutil.tagutil.TagUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;

public class JmlParseXML
extends BodyTagSupport {
    private static final String MSG_FILE = "oracle.jsp.jml.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.jml.tagext.LocalStrings");
    private String resource;
    private String toXMLObjName;
    private String validateResource;
    private String root;

    public JmlParseXML() {
        this.resetAttr();
    }

    private void resetAttr() {
        this.resource = null;
        this.validateResource = null;
        this.toXMLObjName = null;
        this.root = null;
    }

    public void setResource(String s) {
        this.resource = s;
    }

    public String getResource() {
        return this.resource;
    }

    public void setRoot(String s) {
        this.root = s;
    }

    public String getRoot() {
        return this.root;
    }

    public void setToXMLObjName(String s) {
        this.toXMLObjName = s;
    }

    public String getToXMLObjName() {
        return this.toXMLObjName;
    }

    public void setValidateResource(String s) {
        this.validateResource = s;
    }

    public String getValidateResource() {
        return this.validateResource;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doAfterBody() throws JspException {
        try {
            BodyContent body = this.getBodyContent();
            URL validateUrl = null;
            if (this.validateResource != null) {
                validateUrl = TagUtil.getURLFromResource(this.pageContext, this.validateResource, ".dtd");
            }
            XMLDocument xmlDOM = null;
            Reader source = null;
            DOMParser parser = new DOMParser();
            DTD dtd = null;
            if (this.resource != null) {
                URL resourceUrl = TagUtil.getURLFromResource(this.pageContext, this.resource, ".xml");
                source = new InputStreamReader(resourceUrl.openStream());
            } else {
                source = body.getReader();
            }
            if (validateUrl != null) {
                parser.parseDTD(validateUrl, this.root);
                dtd = parser.getDoctype();
                parser.reset();
                parser.setErrorStream((OutputStream)System.err);
                parser.setValidationMode(true);
                parser.showWarnings(true);
                parser.setDoctype(dtd);
            }
            parser.parse(source);
            xmlDOM = parser.getDocument();
            if (this.toXMLObjName != null) {
                this.pageContext.setAttribute(this.toXMLObjName, (Object)xmlDOM);
            }
            TagUtil.setToXMLObj((Tag)this, xmlDOM);
            body.clearBody();
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return 0;
    }

    public int doEndTag() {
        this.resetAttr();
        return 6;
    }

    public void release() {
        this.resetAttr();
        super.release();
    }
}

