/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil.tagext;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.jsp.dbutil.ConnBean;
import oracle.jsp.webutil.tagutil.TagUtil;

public class dbCloseTag
extends TagSupport {
    private String cid;
    private String scope;
    private static final String MSG_FILE = "oracle.jsp.dbutil.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.tagext.LocalStrings");

    public dbCloseTag() {
        this.resetAttrs();
    }

    public int doStartTag() throws JspTagException {
        if (this.cid != null) {
            ConnBean cb = null;
            if (this.scope == null || this.scope.equals("page")) {
                cb = (ConnBean)this.pageContext.getAttribute(this.cid);
            } else if (this.scope.equals("request")) {
                cb = (ConnBean)this.pageContext.getAttribute(this.cid, 2);
            } else if (this.scope.equals("session")) {
                cb = (ConnBean)this.pageContext.getAttribute(this.cid, 3);
            } else if (this.scope.equals("application")) {
                cb = (ConnBean)this.pageContext.getAttribute(this.cid, 4);
            }
            if (cb == null) {
                throw new JspTagException(MessageFormat.format(msgs.getString("connid_not_found"), this.cid, this.scope));
            }
            try {
                cb.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public void release() {
        super.release();
        this.resetAttrs();
    }

    public void setConnId(String s) throws JspException {
        TagUtil.validateString(s, "connId");
        this.cid = s;
    }

    public void setScope(String s) throws JspTagException {
        TagUtil.validateString(s, "scope");
        String temp = s.toLowerCase();
        if (!(temp.equals("page") || temp.equals("request") || temp.equals("session") || temp.equals("application"))) {
            throw new JspTagException(MessageFormat.format(msgs.getString("invalid_scope"), s));
        }
        this.scope = s.toLowerCase();
    }

    private void resetAttrs() {
        this.cid = null;
        this.scope = "page";
    }
}

