/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.xml.sql.query.OracleXMLQuery;
import org.w3c.dom.Document;

public class BeanUtil {
    static Hashtable m_xmlObjCache = null;

    private BeanUtil() {
    }

    public static String translateToHTMLTable(ResultSet rs) throws SQLException {
        return BeanUtil.translateToHTMLTable(rs, -1);
    }

    public static String translateToHTMLTable(ResultSet rs, int maxRows) throws SQLException {
        StringBuffer sb = new StringBuffer();
        if (rs == null || !rs.next() || maxRows == 0) {
            sb.append("<P> No matching rows. <P> \n");
        } else {
            sb.append("<TABLE BORDER> \n");
            ResultSetMetaData md = rs.getMetaData();
            int numCols = md.getColumnCount();
            for (int i = 1; i <= numCols; ++i) {
                sb.append("<TH><I>" + md.getColumnName(i) + "</I></TH>");
            }
            Object obj = null;
            int count = 0;
            do {
                ++count;
                sb.append("<TR>\n");
                for (int i = 1; i <= numCols; ++i) {
                    sb.append("<TD>");
                    obj = rs.getObject(i);
                    if (obj != null) {
                        sb.append(obj.toString());
                    }
                    sb.append("</TD>");
                }
                sb.append("</TR>\n");
            } while (rs.next() && maxRows - count != 0);
            sb.append("</TABLE>");
        }
        return sb.toString();
    }

    public static String translateToXML(Connection conn, String sql, ResultSet rs) {
        return BeanUtil.translateToXML(conn, sql, rs, -1);
    }

    public static String translateToXML(Connection conn, String sql, ResultSet rs, int maxRows) {
        OracleXMLQuery xq = new OracleXMLQuery(conn, rs);
        if (maxRows > 0) {
            xq.setMaxRows(maxRows);
        }
        return xq.getXMLString();
    }

    public static Document translateToXMLDocument(Connection conn, String sql, ResultSet rs, int maxRows) {
        OracleXMLQuery xq = new OracleXMLQuery(conn, rs);
        if (maxRows > 0) {
            xq.setMaxRows(maxRows);
        }
        return xq.getXMLDOM();
    }
}

