/*
 * Decompiled with CFR 0.152.
 */
package oracle.calypso.invalidation;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.calypso.invalidation.Attribute;

public class Element {
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    protected String m_name;
    protected Element m_parent;
    protected String m_value;
    private Vector m_attributes;
    private Vector m_children;

    public Element(String name) {
        this.m_name = name;
        this.m_parent = null;
        this.m_value = null;
        this.m_attributes = new Vector();
        this.m_children = new Vector();
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setChild(Element el) {
        if (this.m_value == null) {
            this.m_children.addElement(el);
            el.m_parent = this;
        }
    }

    public void setNameValuePair(String name, String value) {
        this.setAttribute("NAME", name);
        this.setAttribute("VALUE", value);
    }

    public void setAttribute(String name, String value) {
        if (value != null) {
            this.m_attributes.addElement(this.newAttribute(name, value));
        }
    }

    public void setAttributes(Properties attrs) {
        Enumeration<?> enumerator = attrs.propertyNames();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            this.setAttribute(key, attrs.getProperty(key));
        }
    }

    private Attribute newAttribute(String name, String value) {
        Attribute a = new Attribute();
        a.name = name;
        a.value = value;
        return a;
    }

    private boolean emptyBody() {
        return this.m_value == null && this.m_children.size() == 0;
    }

    private void attributesToString(StringBuffer sb) {
        Enumeration enumerator = this.m_attributes.elements();
        while (enumerator.hasMoreElements()) {
            Attribute a = (Attribute)enumerator.nextElement();
            sb.append(" ").append(a.name).append("=\"").append(a.value).append("\"");
        }
    }

    private void childrenToString(StringBuffer sb) {
        Enumeration enumerator = this.m_children.elements();
        while (enumerator.hasMoreElements()) {
            Element el = (Element)enumerator.nextElement();
            sb.append(el.toString());
        }
    }

    private void bodyToString(StringBuffer sb) {
        if (this.m_value != null) {
            sb.append(this.m_value);
        } else {
            sb.append(NEWLINE);
            this.childrenToString(sb);
        }
    }

    private String toXml() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append('<').append(this.m_name);
        this.attributesToString(sb);
        if (this.emptyBody()) {
            sb.append("/>").append(NEWLINE);
        } else {
            sb.append('>');
            this.bodyToString(sb);
            sb.append("</").append(this.m_name).append('>').append(NEWLINE);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toXml();
    }
}

