/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.taglib.util;

import com.evermind.taglib.util.LocaleUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class DisplayNumberTag
extends TagSupport {
    private double number;
    private String format;
    private Locale locale;

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String locale) {
        this.locale = LocaleUtil.createLocale(locale);
    }

    public void setNumber(double number) {
        this.number = number;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int doStartTag() throws JspTagException {
        if (this.locale == null) {
            this.locale = this.pageContext.getRequest().getLocale();
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
        }
        NumberFormat format = this.format == null ? NumberFormat.getInstance(this.locale) : new DecimalFormat(this.format);
        try {
            this.pageContext.getOut().print(format.format(this.number));
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 0;
    }
}

