/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import java.util.Hashtable;
import java.util.List;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorState;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.util.QDR;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class QDRDiscriminator
implements DiscriminatorXML,
DiscriminatorState {
    protected QDR m_QDR;
    protected int m_setOperator = 3;
    public static final int SUBSET = 0;
    public static final int PROPER_SUBSET = 1;
    public static final int PROPER_SUPERSET = 2;
    public static final int EQUALS = 3;
    public static final int SUPERSET = 4;
    protected static final String QDR_NAME = "QDRName";
    protected static final String S_NAME_QDR_DISC = "QD";
    protected static final String s_setOperator = "s";
    protected static final String s_qdrString = "q";
    protected static QDRDiscriminator m_defaultDiscriminator;
    protected Hashtable m_context;
    public static final String NAME_QDR_DISC = "QDRDisc";
    protected static final int setOperator = 0;
    protected static final String a_setOperator = "setOp";
    protected static final String subset = "SUBSET";
    protected static final String proper_subset = "PROPER_SUBSET";
    protected static final String proper_superset = "PROPER_SUPERSET";
    protected static final String equals = "EQUALS";
    protected static final String superset = "SUPERSET";

    public QDRDiscriminator() {
    }

    public QDRDiscriminator(QDR qDR, int n) {
        this.m_QDR = (QDR)(qDR != null ? qDR.clone() : qDR);
        this.m_setOperator = n;
    }

    public Object clone() {
        return new QDRDiscriminator(this.m_QDR, this.m_setOperator);
    }

    public void setQDR(QDR qDR) {
        this.m_QDR = (QDR)(qDR != null ? qDR.clone() : qDR);
    }

    public QDR getQDR() {
        return this.m_QDR;
    }

    public void setSetOperator(int n) {
        if (n < 0 || n > 4) {
            return;
        }
        this.m_setOperator = n;
    }

    public int getSetOperator() {
        return this.m_setOperator;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QDRDiscriminator)) {
            return false;
        }
        return ((QDRDiscriminator)object).getSetOperator() == this.getSetOperator() && this.getQDR() != null && ((QDRDiscriminator)object).getQDR().equals(this.getQDR());
    }

    public boolean applies(RuleContext ruleContext) {
        boolean bl;
        if (this.m_QDR == null) {
            return false;
        }
        QDR qDR = (QDR)ruleContext.get("QDR");
        QDR qDR2 = (QDR)ruleContext.get("DIMENSIONQDR");
        switch (this.m_setOperator) {
            case 0: {
                bl = this.m_QDR.isSubsetOf(qDR);
                break;
            }
            case 1: {
                bl = this.m_QDR.isProperSubsetOf(qDR);
                break;
            }
            case 2: {
                bl = this.m_QDR.isProperSupersetOf(qDR);
                break;
            }
            case 3: {
                bl = this.m_QDR.equals(qDR) || this.m_QDR.equals(qDR2);
                break;
            }
            case 4: {
                bl = this.m_QDR.isSupersetOf(qDR);
                break;
            }
            default: {
                bl = this.m_QDR.equals(qDR);
            }
        }
        return bl;
    }

    public void setContext(Hashtable hashtable) {
        this.m_context = hashtable;
    }

    public boolean setXML(ObjectNode objectNode, ComponentTypeConverter componentTypeConverter, String string, int n) {
        String string2;
        PropertyNode propertyNode;
        XMLContext xMLContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
        if (xMLContext.getScope() == null) {
            xMLContext.setScope(new ObjectScope());
        }
        if ((propertyNode = objectNode.getProperty(a_setOperator)) != null) {
            string2 = propertyNode.getValueAsString();
            if (string2.equals(subset)) {
                this.setSetOperator(0);
            } else if (string2.equals(proper_subset)) {
                this.setSetOperator(1);
            } else if (string2.equals(proper_superset)) {
                this.setSetOperator(2);
            } else if (string2.equals(equals)) {
                this.setSetOperator(3);
            } else if (string2.equals(superset)) {
                this.setSetOperator(4);
            }
        }
        string2 = null;
        try {
            string2 = objectNode.getPropertyValueAsString(QDR_NAME);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        ContainerNode containerNode = null;
        String string3 = null;
        if (string2 == null) {
            containerNode = objectNode.getContainer("QDR");
        } else {
            containerNode = objectNode.getContainer(string2);
            if (!string2.equals("QDR")) {
                string3 = "oracle.dss.selection.OlapQDR";
            }
        }
        if (containerNode != null) {
            if (this.getQDR() != null) {
                this.getQDR().setXML(xMLContext, containerNode);
            } else {
                QDR qDR = null;
                Class<?> clazz = null;
                if (string3 != null) {
                    try {
                        clazz = Class.forName(string3);
                        qDR = (QDR)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (qDR == null) {
                    qDR = new QDR();
                }
                qDR.setXML(xMLContext, containerNode);
                this.setQDR(qDR);
            }
        }
        return true;
    }

    public ObjectNode getXML(boolean bl, ComponentTypeConverter componentTypeConverter, boolean bl2) {
        ObjectNode objectNode = new ObjectNode(NAME_QDR_DISC);
        boolean bl3 = false;
        if (this.getQDR() != null) {
            XMLContext xMLContext = this.m_context != null && this.m_context.containsKey("xml_context") ? (XMLContext)this.m_context.get("xml_context") : new XMLContext(new ObjectScope(), false);
            if (xMLContext.getScope() == null) {
                xMLContext.setScope(new ObjectScope());
            }
            xMLContext.getScope().addObject("allProperties", new Boolean(bl));
            ContainerNode containerNode = (ContainerNode)this.getQDR().getXML(xMLContext);
            if (containerNode != null) {
                objectNode.addProperty(QDR_NAME, containerNode.getName());
                objectNode.addContainer(containerNode);
                bl3 = true;
            }
        }
        if (this.getSetOperator() == 0) {
            objectNode.addProperty(a_setOperator, subset);
        } else if (this.getSetOperator() == 1) {
            objectNode.addProperty(a_setOperator, proper_subset);
        } else if (this.getSetOperator() == 2) {
            objectNode.addProperty(a_setOperator, proper_superset);
        } else if (this.getSetOperator() == 3) {
            objectNode.addProperty(a_setOperator, equals);
        } else if (this.getSetOperator() == 4) {
            objectNode.addProperty(a_setOperator, superset);
        }
        return objectNode;
    }

    public void setStateAsObjectNode(List list, ObjectNode objectNode, DiscriminatorState discriminatorState) {
        QDRDiscriminator qDRDiscriminator;
        PropertyNode propertyNode = objectNode.getProperty(s_setOperator);
        QDRDiscriminator qDRDiscriminator2 = qDRDiscriminator = discriminatorState instanceof QDRDiscriminator ? (QDRDiscriminator)discriminatorState : null;
        if (propertyNode != null) {
            this.setSetOperator(propertyNode.getValueAsInteger());
        } else if (qDRDiscriminator != null) {
            this.setSetOperator(qDRDiscriminator.getSetOperator());
        } else {
            this.setSetOperator(4);
        }
        propertyNode = objectNode.getProperty(s_qdrString);
        if (propertyNode != null) {
            this.setQDR(QDR.setStateString(list, propertyNode.getValueAsString()));
        } else if (qDRDiscriminator != null) {
            this.setQDR((QDR)qDRDiscriminator.getQDR().clone());
        } else {
            this.setQDR(new QDR());
        }
    }

    public ObjectNode getStateAsObjectNode(List list, DiscriminatorState discriminatorState) {
        ObjectNode objectNode = new ObjectNode(S_NAME_QDR_DISC);
        QDRDiscriminator qDRDiscriminator = discriminatorState instanceof QDRDiscriminator ? (QDRDiscriminator)discriminatorState : QDRDiscriminator.createDefaultDiscriminator();
        boolean bl = false;
        if (qDRDiscriminator.getSetOperator() != this.getSetOperator()) {
            objectNode.addProperty(s_setOperator, this.getSetOperator());
            bl = true;
        }
        if (!Utility.compareObj(qDRDiscriminator.getQDR(), this.getQDR())) {
            objectNode.addProperty(s_qdrString, this.getQDR().getStateString(list));
            bl = true;
        }
        return bl ? objectNode : null;
    }

    protected static QDRDiscriminator createDefaultDiscriminator() {
        if (m_defaultDiscriminator == null) {
            m_defaultDiscriminator = new QDRDiscriminator();
            m_defaultDiscriminator.setSetOperator(4);
        }
        return m_defaultDiscriminator;
    }
}

