/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.AxisHistObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class JChart_2D_Hist
extends JChart_2D_Standard {
    private int[] m_buckets;

    public void calc() {
        super.calc();
        this.drawRisers();
    }

    private void calcBuckets() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        DataFormat dataFormat = this.m_Access.getDataFormat();
        double d = 0.0;
        int n = this.m_X1Axis.getNumIntervals();
        this.m_buckets = new int[n];
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            groupsEnumerator.reset();
            block1: while (groupsEnumerator.hasMoreElements()) {
                int n3 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
                boolean bl = true;
                DatumObj datumObj = this.getDataValue(n2, n3);
                d = datumObj.m_fValue;
                bl = datumObj.m_bOK;
                if (!bl) continue;
                int n4 = 0;
                while (n4 < this.m_X1Axis.getNumIntervals()) {
                    if (d >= this.m_X1Axis.getIntervalStart(n4) && d <= this.m_X1Axis.getIntervalStop(n4)) {
                        int n5 = n4;
                        this.m_buckets[n5] = this.m_buckets[n5] + 1;
                        continue block1;
                    }
                    ++n4;
                }
            }
        }
    }

    protected Point getCoords(int n, int n2) {
        Point point = this.m_bHorz ? new Point(this.m_numYCoords[n][n2], this.m_numXCoords[n][n2]) : new Point(this.m_numXCoords[n][n2], this.m_numYCoords[n][n2]);
        return point;
    }

    protected void createX1Axis(boolean bl, boolean bl2) {
        MinMaxObj minMaxObj = this.findLimits(7, this.m_scaling, false, null);
        this.m_X1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, minMaxObj, bl, bl2, 0, 100);
    }

    protected void createY1Axis(boolean bl, boolean bl2, int n, int n2) {
        this.calcBuckets();
        MinMaxObj minMaxObj = this.findHistLimits();
        this.m_Y1Axis = new AxisHistObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl, bl2, n, n2);
    }

    private void drawRisers() {
        int n = this.m_X1Axis.getNumIntervals();
        IdentObj identObj = new IdentObj(311);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        boolean bl = this.m_X1Axis.isDescending();
        boolean bl2 = this.m_Y1Axis.isDescending();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = ((AxisHistObj)this.m_X1Axis).getLowIntervalCoord(n2);
            int n8 = ((AxisHistObj)this.m_X1Axis).getHighIntervalCoord(n2);
            if (this.m_gt.isOrientHorz()) {
                n6 = (int)this.m_Y1Axis.getValueCoord(bl2 ? this.m_buckets[n2] : 0);
                n5 = (int)this.m_Y1Axis.getValueCoord(bl2 ? 0 : this.m_buckets[n2]);
                n4 = bl ? n8 : n7;
                n3 = bl ? n7 : n8;
            } else {
                n4 = (int)this.m_Y1Axis.getValueCoord(bl2 ? this.m_buckets[n2] : 0);
                n3 = (int)this.m_Y1Axis.getValueCoord(bl2 ? 0 : this.m_buckets[n2]);
                n6 = bl ? n8 : n7;
                n5 = bl ? n7 : n8;
            }
            Rectangle rectangle = new Rectangle(n6, n4, Math.abs(n5 - n6), Math.abs(n3 - n4));
            new DetRect(this.m_Detectiv, new IdentObj(311, -3, -3, -3, n2), rectangle, (BlackBoxIF)blackBoxObj, this.m_rClip);
            ++n2;
        }
    }

    private MinMaxObj findHistLimits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_X1Axis.getNumIntervals()) {
            if (this.m_buckets[n2] > n) {
                n = this.m_buckets[n2];
            }
            ++n2;
        }
        return new MinMaxObj(0.0, n);
    }

    public boolean wantLegend() {
        return false;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        return string2;
    }
}

