/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;

public class DataRange
implements Serializable {
    private int m_rowStart;
    private int m_rowStop;
    private int m_colStart;
    private int m_colStop;

    public DataRange() {
        this.m_rowStart = 0;
        this.m_rowStop = -1;
        this.m_colStart = 0;
        this.m_colStop = -1;
    }

    public DataRange(DataRange dataRange) {
        this.copy(dataRange);
    }

    public DataRange(int n, int n2) {
        this.m_rowStart = 0;
        this.m_rowStop = n;
        this.m_colStart = 0;
        this.m_colStop = n2;
    }

    public DataRange(int n, int n2, int n3, int n4) {
        this.m_rowStart = n;
        this.m_rowStop = n3;
        this.m_colStart = n2;
        this.m_colStop = n4;
    }

    public void copy(DataRange dataRange) {
        this.m_rowStart = dataRange.getRowStart();
        this.m_colStart = dataRange.getColStart();
        this.m_rowStop = dataRange.getRowStop();
        this.m_colStop = dataRange.getColStop();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataRange)) {
            return false;
        }
        DataRange dataRange = (DataRange)object;
        return this.m_rowStart == dataRange.m_rowStart && this.m_colStart == dataRange.m_colStart && this.m_rowStop == dataRange.m_rowStop && this.m_colStop == dataRange.m_colStop;
    }

    public void extendTo(int n, int n2) {
        if (n > this.m_rowStop) {
            this.m_rowStop = n;
        }
        if (n2 > this.m_colStop) {
            this.m_colStop = n2;
        }
        if (n < this.m_rowStart) {
            this.m_rowStart = n;
        }
        if (n2 < this.m_colStart) {
            this.m_colStart = n2;
        }
    }

    public void shrinkTo(int n, int n2, int n3, int n4) {
        if (n3 < this.m_rowStop) {
            this.m_rowStop = n3;
        }
        if (n4 < this.m_colStop) {
            this.m_colStop = n4;
        }
        if (n > this.m_rowStart) {
            this.m_rowStart = n;
        }
        if (n2 > this.m_colStart) {
            this.m_colStart = n2;
        }
    }

    public int getColStart() {
        return this.m_colStart;
    }

    public int getColStop() {
        return this.m_colStop;
    }

    public int getNumCols() {
        return this.m_colStop - this.m_colStart + 1;
    }

    public int getNumRows() {
        return this.m_rowStop - this.m_rowStart + 1;
    }

    public int getRowStart() {
        return this.m_rowStart;
    }

    public int getRowStop() {
        return this.m_rowStop;
    }

    public boolean isCellValid(int n, int n2) {
        boolean bl = n >= this.m_rowStart && n <= this.m_rowStop && n2 >= this.m_colStart && n2 <= this.m_colStop;
        return bl;
    }

    public int hashCode() {
        return this.m_rowStart + this.m_colStart + this.m_rowStop + this.m_colStop;
    }

    public String toString() {
        return String.valueOf(String.valueOf("(rStart=")) + this.m_rowStart + ", cStart=" + this.m_colStart + ", rStop=" + this.m_rowStop + ", cStop=" + this.m_colStop + ")";
    }
}

