/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.util.BitSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.UIDataviewAdapter;
import oracle.dss.dataView.UIParetoLine;
import oracle.dss.dataView.UISeriesColor;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.DataFilter;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.LabelPosition;
import oracle.dss.graph.MajorTick;
import oracle.dss.graph.UIAssignedValue;
import oracle.dss.graph.UIBase3DPanel;
import oracle.dss.graph.UIBaseFrame;
import oracle.dss.graph.UIDataAxis;
import oracle.dss.graph.UIDataTickLabel;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.UIGraphFontAttribute;
import oracle.dss.graph.UILegendArea;
import oracle.dss.graph.UILegendText;
import oracle.dss.graph.UIMarkerText;
import oracle.dss.graph.UIO1Axis;
import oracle.dss.graph.UIReferenceLine;
import oracle.dss.graph.UISeries;
import oracle.dss.graph.UISliceLabel;
import oracle.dss.graph.UITickLabel;
import oracle.dss.graph.UITitle;
import oracle.dss.graph.gui.DataFilterAdapter;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.LabelPositionAdapter;
import oracle.dss.graph.gui.MajorTickAdapter;
import oracle.dss.graph.gui.UIAssignedValueAdapter;
import oracle.dss.graph.gui.UIBase3DPanelAdapter;
import oracle.dss.graph.gui.UIBaseFrameAdapter;
import oracle.dss.graph.gui.UIDataAxisAdapter;
import oracle.dss.graph.gui.UIDataTickLabelAdapter;
import oracle.dss.graph.gui.UIGraphFontAdapter;
import oracle.dss.graph.gui.UILegendAreaAdapter;
import oracle.dss.graph.gui.UILegendTextAdapter;
import oracle.dss.graph.gui.UIMarkerTextAdapter;
import oracle.dss.graph.gui.UIO1AxisAdapter;
import oracle.dss.graph.gui.UIParetoLineAdapter;
import oracle.dss.graph.gui.UIReferenceLineAdapter;
import oracle.dss.graph.gui.UISeriesAdapter;
import oracle.dss.graph.gui.UISliceLabelAdapter;
import oracle.dss.graph.gui.UITickLabelAdapter;
import oracle.dss.graph.gui.UITitleAdapter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitDataAvailableEvent;

public class UIGraphAdapter
extends UIDataviewAdapter
implements UIGraph {
    public static final int UNKNOWN = 0;
    public static final int TIME_AXIS = 1;
    public static final int NO_TIME_AXIS = 2;
    protected boolean m_dataRowShownAsASeries;
    protected int m_columnCount;
    protected int m_rowCount;
    protected int m_graphType;
    protected int m_seriesTooltipLabelType;
    protected int m_groupTooltipLabelType;
    protected int m_markerTooltipType;
    protected boolean m_dataLineDisplayed;
    protected boolean m_isHorizontal;
    protected boolean m_isPagingControlVisible;
    protected boolean m_dataUnavailable;
    protected int m_seriesEffect = 0;
    protected int m_seriesObjectCount;
    protected DataFilterAdapter m_dataFilter;
    protected int m_autoLayout;
    protected int m_timeAxisData = 0;
    protected boolean m_3DEffectChanged;
    protected boolean m_3DEffect;
    protected UITitle m_title;
    protected UITitle m_subtitle;
    protected UITitle m_footnote;
    protected UITitle m_O1Title;
    protected UITitle m_X1Title;
    protected UITitle m_Y1Title;
    protected UITitle m_Y2Title;
    protected MajorTick m_Y1Tick;
    protected MajorTick m_X1Tick;
    protected MajorTick m_Y2Tick;
    protected MajorTick m_O1Tick;
    protected UIO1Axis m_O1Axis;
    protected UITickLabel m_O1TickLabel;
    protected UIDataAxis m_X1Axis;
    protected UIDataAxis m_Y1Axis;
    protected UIDataAxis m_Y2Axis;
    protected UIDataTickLabel m_X1DataTickLabel;
    protected UIDataTickLabel m_Y1DataTickLabel;
    protected UIDataTickLabel m_Y2DataTickLabel;
    protected UILegendArea m_legendArea;
    protected UILegendText m_legendText;
    protected UIBaseFrame m_plotArea;
    protected UIBase3DPanel m_3DFloor;
    protected UIBaseFrame m_pieFrame;
    protected UIMarkerText m_markerText;
    protected UISliceLabel m_sliceLabel;
    protected UISeries m_series;
    protected GraphTypeConverter m_converter;
    protected LabelPosition m_slice;
    protected UISeriesColor m_seriesColor;
    protected ViewStyle m_viewStyle;
    protected DataSource m_dataSource;
    protected DataAccess m_dataAccess;
    protected ResourceBundle rBundle;
    protected int m_dataDirectorType;
    protected UIParetoLine m_paretoLine;
    protected UIReferenceLine m_X1ReferenceLine;
    protected UIReferenceLine m_Y1ReferenceLine;
    protected UIReferenceLine m_Y2ReferenceLine;
    protected UIAssignedValue m_Y1AssignedValue;
    protected UIAssignedValue m_Y2AssignedValue;
    protected boolean m_markerDisplayed;
    protected boolean m_markerDisplayedChanged;
    protected transient DataDirector m_dataDirector;
    protected DataDirectorListener m_dataDirectorListener;
    protected String[] m_timeAxis = new String[4];
    protected BitSet m_propertyChangedFlags;
    protected boolean m_bUseCallback = true;
    private static final int DataDirectorTypePropertyBit = 0;
    private static final int DataRowShownAsASeriesPropertyBit = 1;
    private static final int DataSourcePropertyBit = 2;
    private static final int GraphTypePropertyBit = 3;
    private static final int GroupTooltipLabelTypePropertyBit = 4;
    private static final int LineDataLineDisplayedPropertyBit = 5;
    private static final int MarkerTooltipTypePropertyBit = 6;
    private static final int PagingControlVisiblePropertyBit = 7;
    private static final int SeriesObjectCountPropertyBit = 8;
    private static final int SeriesTooltipLabelTypePropertyBit = 9;
    private static final int TokenSubstitutionPropertyBit = 10;
    private static final int MarkerDisplayPropertyBit = 11;
    private static final int ThreeDEffectPropertyBit = 12;
    private static final int NumberOfPropertyBits = 13;
    private boolean[] m_timeAxisChanged = new boolean[4];

    public UIGraphAdapter() {
        this._init();
        this.initDefaultValues();
        this.m_series = new UISeriesAdapter(this);
        GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
        this.setGraphTypeConverter(graphTypeConverterAdapter);
        graphTypeConverterAdapter.setLocale(this.getLocale());
        this.m_propertyChangedFlags = new BitSet(13);
        this.setDataSource(new LocalDataSource());
        this.setDataSourceChanged(false);
    }

    public UIGraphAdapter(Graph graph) {
        this._init();
        this.m_series = new UISeriesAdapter(this);
        if (graph.getGraphTypeConverter() != null) {
            this.setGraphTypeConverter(graph.getGraphTypeConverter());
        } else {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.setGraphTypeConverter(graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(graph.getLocale());
        }
        this.m_propertyChangedFlags = new BitSet(13);
        this.initFromGraph(graph);
    }

    private void _init() {
        this.m_title = new UITitleAdapter();
        this.m_subtitle = new UITitleAdapter();
        this.m_footnote = new UITitleAdapter();
        this.m_O1Title = new UITitleAdapter();
        this.m_X1Title = new UITitleAdapter();
        this.m_Y1Title = new UITitleAdapter();
        this.m_Y2Title = new UITitleAdapter();
        this.m_legendArea = new UILegendAreaAdapter();
        this.m_legendText = new UILegendTextAdapter();
        this.m_markerText = new UIMarkerTextAdapter();
        this.m_pieFrame = new UIBaseFrameAdapter();
        this.m_slice = new LabelPositionAdapter();
        this.m_plotArea = new UIBaseFrameAdapter();
        this.m_3DFloor = new UIBase3DPanelAdapter();
        ((UIBaseFrameAdapter)this.m_pieFrame).setUIBaseFrameAdapter(this.m_plotArea, this.m_3DFloor);
        ((UIBaseFrameAdapter)this.m_plotArea).setUIBaseFrameAdapter(this.m_pieFrame, this.m_3DFloor);
        ((UIBaseFrameAdapter)((Object)this.m_3DFloor)).setUIBaseFrameAdapter(this.m_plotArea, this.m_pieFrame);
        this.m_X1Tick = new MajorTickAdapter();
        this.m_Y1Tick = new MajorTickAdapter();
        this.m_Y2Tick = new MajorTickAdapter();
        this.m_O1Tick = new MajorTickAdapter();
        this.m_X1Axis = new UIDataAxisAdapter(this, 41);
        this.m_Y1Axis = new UIDataAxisAdapter(this, 46);
        this.m_Y2Axis = new UIDataAxisAdapter(this, 51);
        this.m_O1Axis = new UIO1AxisAdapter();
        this.m_X1DataTickLabel = new UIDataTickLabelAdapter();
        this.m_Y1DataTickLabel = new UIDataTickLabelAdapter();
        this.m_Y2DataTickLabel = new UIDataTickLabelAdapter();
        this.m_O1TickLabel = new UITickLabelAdapter();
        this.m_sliceLabel = new UISliceLabelAdapter();
        this.m_dataFilter = new DataFilterAdapter(this);
        this.m_dataDirectorListener = new MyDataDirectorListener();
        this.m_paretoLine = new UIParetoLineAdapter();
        this.m_X1ReferenceLine = new UIReferenceLineAdapter();
        this.m_Y1ReferenceLine = new UIReferenceLineAdapter();
        this.m_Y2ReferenceLine = new UIReferenceLineAdapter();
        this.m_Y1AssignedValue = new UIAssignedValueAdapter();
        this.m_Y2AssignedValue = new UIAssignedValueAdapter();
    }

    private void initDefaultValues() {
        this.m_autoLayout = GraphDefaultValues.getAutoLayout();
        this.m_graphType = GraphDefaultValues.getGraphType();
        this.m_seriesTooltipLabelType = GraphDefaultValues.getSeriesTooltipLabelType();
        this.m_groupTooltipLabelType = GraphDefaultValues.getGroupTooltipLabelType();
        this.m_markerTooltipType = GraphDefaultValues.getMarkerTooltipType();
        this.m_dataRowShownAsASeries = GraphDefaultValues.isDataRowShownAsASeries();
        this.m_dataLineDisplayed = GraphDefaultValues.isLineDataLinedDisplayed();
        this.m_markerDisplayed = GraphDefaultValues.isMarkerdisplayed();
        this.m_seriesObjectCount = GraphDefaultValues.getSeriesObjectCount();
        this.m_dataDirectorType = GraphDefaultValues.getDataDirectorType();
        this.m_title.setVisible(GraphDefaultValues.isTitleVisible());
        this.m_title.setText(GraphDefaultValues.getTitleText());
        this.m_title.setHorizontalAlignment(GraphDefaultValues.getTitleHorizontalAlignment());
        this.m_title.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getTitleFontTypeface());
        this.m_title.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getTitleFontColor());
        this.m_title.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getTitleFontStyle());
        this.m_title.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getTitleFontSize());
        this.m_subtitle.setVisible(GraphDefaultValues.isSubtitleVisible());
        this.m_subtitle.setText(GraphDefaultValues.getSubtitleText());
        this.m_subtitle.setHorizontalAlignment(GraphDefaultValues.getSubtitleHorizontalAlignment());
        this.m_subtitle.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getSubtitleFontTypeface());
        this.m_subtitle.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getSubtitleFontColor());
        this.m_subtitle.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getSubtitleFontStyle());
        this.m_subtitle.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getSubtitleFontSize());
        this.m_footnote.setVisible(GraphDefaultValues.isFootnoteVisible());
        this.m_footnote.setText(GraphDefaultValues.getFootnoteText());
        this.m_footnote.setHorizontalAlignment(GraphDefaultValues.getFootnoteHorizontalAlignment());
        this.m_footnote.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getFootnoteFontTypeface());
        this.m_footnote.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getFootnoteFontColor());
        this.m_footnote.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getFootnoteFontStyle());
        this.m_footnote.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getFootnoteFontSize());
        this.m_O1Title.setVisible(GraphDefaultValues.isO1TitleVisible());
        this.m_O1Title.setText(GraphDefaultValues.getO1TitleText());
        this.m_O1Title.setHorizontalAlignment(GraphDefaultValues.getO1TitleHorizontalAlignment());
        this.m_O1Title.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getO1TitleFontTypeface());
        this.m_O1Title.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getO1TitleFontColor());
        this.m_O1Title.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getO1TitleFontStyle());
        this.m_O1Title.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getO1TitleFontSize());
        this.m_O1Title.setTextRotation(GraphDefaultValues.getO1TitleTextRotation());
        this.m_X1Title.setVisible(GraphDefaultValues.isX1TitleVisible());
        this.m_X1Title.setText(GraphDefaultValues.getX1TitleText());
        this.m_X1Title.setHorizontalAlignment(GraphDefaultValues.getX1TitleHorizontalAlignment());
        this.m_X1Title.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getX1TitleFontTypeface());
        this.m_X1Title.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getX1TitleFontColor());
        this.m_X1Title.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getX1TitleFontStyle());
        this.m_X1Title.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getX1TitleFontSize());
        this.m_X1Title.setTextRotation(GraphDefaultValues.getX1TitleTextRotation());
        this.m_Y1Title.setVisible(GraphDefaultValues.isY1TitleVisible());
        this.m_Y1Title.setText(GraphDefaultValues.getY1TitleText());
        this.m_Y1Title.setHorizontalAlignment(GraphDefaultValues.getY1TitleHorizontalAlignment());
        this.m_Y1Title.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getY1TitleFontTypeface());
        this.m_Y1Title.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getY1TitleFontColor());
        this.m_Y1Title.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getY1TitleFontStyle());
        this.m_Y1Title.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getY1TitleFontSize());
        this.m_Y1Title.setTextRotation(GraphDefaultValues.getY1TitleTextRotation());
        this.m_Y2Title.setVisible(GraphDefaultValues.isY2TitleVisible());
        this.m_Y2Title.setText(GraphDefaultValues.getY2TitleText());
        this.m_Y2Title.setHorizontalAlignment(GraphDefaultValues.getY2TitleHorizontalAlignment());
        this.m_Y2Title.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getY2TitleFontTypeface());
        this.m_Y2Title.getUIGraphFont().setGraphFontColor(GraphDefaultValues.getY2TitleFontColor());
        this.m_Y2Title.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getY2TitleFontStyle());
        this.m_Y2Title.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getY2TitleFontSize());
        this.m_Y2Title.setTextRotation(GraphDefaultValues.getY2TitleTextRotation());
        this.m_X1Axis.setAxisMinAutoScaled(GraphDefaultValues.isX1AxisMinAutoScaled());
        this.m_X1Axis.setAxisMaxAutoScaled(GraphDefaultValues.isX1AxisMaxAutoScaled());
        this.m_X1Axis.setMajorTickStepAutomatic(GraphDefaultValues.isX1MajorTickStepAutomatic());
        this.m_X1Axis.setLogarithmicBase(GraphDefaultValues.getX1AxisLogBase());
        this.m_X1Axis.setScaledLogarithmic(GraphDefaultValues.isX1AxisScaledLogarithmic());
        this.m_X1Axis.setLineWidth(GraphDefaultValues.getX1AxisLineWidth());
        this.m_X1Axis.setLineColor(GraphDefaultValues.getX1AxisLineColor());
        this.m_X1Axis.setVisible(GraphDefaultValues.isX1AxisVisible());
        this.m_X1Axis.setAxisMaxValue(45.0);
        this.m_X1Axis.setAxisMinValue(0.0);
        this.m_X1Axis.setMajorTickStep(5.0);
        this.m_Y1Axis.setAxisMinAutoScaled(GraphDefaultValues.isY1AxisMinAutoScaled());
        this.m_Y1Axis.setAxisMaxAutoScaled(GraphDefaultValues.isY1AxisMaxAutoScaled());
        this.m_Y1Axis.setMajorTickStepAutomatic(GraphDefaultValues.isY1MajorTickStepAutomatic());
        this.m_Y1Axis.setLogarithmicBase(GraphDefaultValues.getY1AxisLogBase());
        this.m_Y1Axis.setScaledLogarithmic(GraphDefaultValues.isY1AxisScaledLogarithmic());
        this.m_Y1Axis.setLineWidth(GraphDefaultValues.getY1AxisLineWidth());
        this.m_Y1Axis.setLineColor(GraphDefaultValues.getY1AxisLineColor());
        this.m_Y1Axis.setVisible(GraphDefaultValues.isY1AxisVisible());
        this.m_Y1Axis.setMajorTickStep(GraphDefaultValues.getY1TickStep());
        this.m_Y1Axis.setAxisMaxValue(60.0);
        this.m_Y1Axis.setAxisMinValue(0.0);
        this.m_Y2Axis.setAxisMinAutoScaled(GraphDefaultValues.isY2AxisMinAutoScaled());
        this.m_Y2Axis.setAxisMaxAutoScaled(GraphDefaultValues.isY2AxisMaxAutoScaled());
        this.m_Y2Axis.setMajorTickStepAutomatic(GraphDefaultValues.isY2MajorTickStepAutomatic());
        this.m_Y2Axis.setLogarithmicBase(GraphDefaultValues.getY2AxisLogBase());
        this.m_Y2Axis.setScaledLogarithmic(GraphDefaultValues.isY2AxisScaledLogarithmic());
        this.m_Y2Axis.setLineWidth(GraphDefaultValues.getY2AxisLineWidth());
        this.m_Y2Axis.setLineColor(GraphDefaultValues.getY2AxisLineColor());
        this.m_Y2Axis.setVisible(GraphDefaultValues.isY2AxisVisible());
        this.m_Y2Axis.setMajorTickStep(GraphDefaultValues.getY2TickStep());
        this.m_Y2Axis.setAxisMaxValue(80.0);
        this.m_Y2Axis.setAxisMinValue(10.0);
        this.m_X1DataTickLabel.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getX1TickFontTypeface());
        this.m_X1DataTickLabel.getUIGraphFont().setGraphFontColor(new Color(GraphDefaultValues.getX1TickFontColor()));
        this.m_X1DataTickLabel.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getX1TickFontStyle());
        this.m_X1DataTickLabel.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getX1TickFontSize());
        this.m_X1DataTickLabel.setTextRotation(GraphDefaultValues.getX1TickTextRotation());
        this.m_Y1DataTickLabel.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getY1TickFontTypeface());
        this.m_Y1DataTickLabel.getUIGraphFont().setGraphFontColor(new Color(GraphDefaultValues.getY1TickFontColor()));
        this.m_Y1DataTickLabel.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getY1TickFontStyle());
        this.m_Y1DataTickLabel.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getY1TickFontSize());
        this.m_Y1DataTickLabel.setTextRotation(GraphDefaultValues.getY1TickTextRotation());
        this.m_Y2DataTickLabel.getUIGraphFont().setGraphFontTypeface(GraphDefaultValues.getY2TickFontTypeface());
        this.m_Y2DataTickLabel.getUIGraphFont().setGraphFontColor(new Color(GraphDefaultValues.getY2TickFontColor()));
        this.m_Y2DataTickLabel.getUIGraphFont().setGraphFontStyle(GraphDefaultValues.getY2TickFontStyle());
        this.m_Y2DataTickLabel.getUIGraphFont().setGraphFontSize(GraphDefaultValues.getY2TickFontSize());
        this.m_Y2DataTickLabel.setTextRotation(GraphDefaultValues.getY2TickTextRotation());
        this.m_O1Tick.setVisible(GraphDefaultValues.isO1MajorTickVisible());
        this.m_O1Tick.setLineColor(new Color(GraphDefaultValues.getO1MajorTickLineColor()));
        this.m_O1Tick.setLineWidth(GraphDefaultValues.getO1MajorTickLineWidth());
        this.m_O1Tick.setTickStyle(GraphDefaultValues.getO1MajorTickStyle());
        this.m_X1Tick.setVisible(GraphDefaultValues.isX1MajorTickVisible());
        this.m_X1Tick.setLineColor(new Color(GraphDefaultValues.getX1MajorTickLineColor()));
        this.m_X1Tick.setLineWidth(GraphDefaultValues.getX1MajorTickLineWidth());
        this.m_X1Tick.setTickStyle(GraphDefaultValues.getX1MajorTickStyle());
        this.m_Y1Tick.setVisible(GraphDefaultValues.isY1MajorTickVisible());
        this.m_Y1Tick.setLineColor(new Color(GraphDefaultValues.getY1MajorTickLineColor()));
        this.m_Y1Tick.setLineWidth(GraphDefaultValues.getY1MajorTickLineWidth());
        this.m_Y1Tick.setTickStyle(GraphDefaultValues.getY1MajorTickStyle());
        this.m_Y2Tick.setVisible(GraphDefaultValues.isY2MajorTickVisible());
        this.m_Y2Tick.setLineColor(new Color(GraphDefaultValues.getY2MajorTickLineColor()));
        this.m_Y2Tick.setLineWidth(GraphDefaultValues.getY2MajorTickLineWidth());
        this.m_Y2Tick.setTickStyle(GraphDefaultValues.getY2MajorTickStyle());
        this.m_pieFrame.setFillColor(GraphDefaultValues.getPieFillColor());
        this.m_pieFrame.setFillTransparent(GraphDefaultValues.isPieFillTransparent());
        this.m_pieFrame.setBorderColor(new Color(GraphDefaultValues.getPieBorderColor()));
        this.m_pieFrame.setBorderTransparent(GraphDefaultValues.isPieBorderTransparent());
        this.m_plotArea.setFillColor(GraphDefaultValues.getPlotAreaFillColor());
        this.m_plotArea.setFillTransparent(GraphDefaultValues.isPlotAreaFillTransparent());
        this.m_plotArea.setBorderColor(new Color(GraphDefaultValues.getPlotAreaBorderColor()));
        this.m_plotArea.setBorderTransparent(GraphDefaultValues.isPlotAreaBorderTransparent());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.getGraphTypeConverter() != null) {
            this.getGraphTypeConverter().setLocale(locale);
        }
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.setDataSourceChanged(true);
        if (this.m_dataDirector != null) {
            this.m_dataDirector.removeDataDirectorListener(this.m_dataDirectorListener);
        }
        this.m_dataSource = dataSource == null ? new LocalDataSource() : dataSource;
        switch (this.getDataDirectorType()) {
            case 1: {
                this.setDataDirector(this.m_dataSource.createRelationalDataDirector());
                break;
            }
            case 0: {
                this.setDataDirector(this.m_dataSource.createCubeDataDirector());
                break;
            }
            default: {
                this.getErrorHandler().log("Invalid DataDirectorType", this.getClass().getName(), "setDataSource");
            }
        }
    }

    public int getDataDirectorType() {
        return this.m_dataDirectorType;
    }

    public void setDataDirectorType(int n) {
        if (n < 0 || n > 1) {
            this.getErrorHandler().log("invalid data directory type", this.getClass().getName(), "setDataDirectorType(int type)");
        } else {
            this.m_dataDirectorType = n;
            this.setDataDirectorTypeChanged(true);
        }
    }

    public void applyToGraph(Graph graph) {
        super.applyToDataview(graph);
        if (this.isGraphTypeChanged()) {
            if (graph.getGraphTypeConverter() == null) {
                graph.setGraphTypeConverter(this.getGraphTypeConverter());
            }
            graph.getGraphTypeConverter().setTypeAndSubtype(graph, this.getGraphTypeConverter().getTypeAndSubtype(this));
        }
        if (this.is3DEffectChanged()) {
            graph.set3DEffect(this.is3DEffect());
        }
        if (this.isLineDataLineDisplayedChanged()) {
            graph.setLineDataLineDisplayed(this.isLineDataLineDisplayed());
        }
        if (this.isPagingControlVisibleChanged()) {
            graph.setPagingControlVisible(this.isPagingControlVisible());
        }
        if (this.isDataRowShownAsASeriesChanged()) {
            graph.setDataRowShownAsASeries(this.isDataRowShownAsASeries());
        }
        if (this.isMarkerTooltipTypeChanged()) {
            graph.setMarkerTooltipType(this.getMarkerTooltipType());
        }
        if (this.isSeriesTooltipLabelTypeChanged()) {
            graph.setSeriesTooltipLabelType(this.getSeriesTooltipLabelType());
        }
        if (this.isGroupTooltipLabelTypeChanged()) {
            graph.setGroupTooltipLabelType(this.getGroupTooltipLabelType());
        }
        if (this.isMarkerDisplayedChanged()) {
            graph.setMarkerDisplayed(this.isMarkerDisplayed());
        }
        if (((UITitleAdapter)this.getUITitle()).isTextChanged()) {
            graph.getUITitle().setText(this.getUITitle().getUnParseText());
        }
        if (((UITitleAdapter)this.getUITitle()).isVisibleChanged()) {
            graph.getUITitle().setVisible(this.getUITitle().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUITitle().getUIGraphFont().setFontBold(this.getUITitle().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUITitle().getUIGraphFont().setGraphFontTypeface(this.getUITitle().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUITitle().getUIGraphFont().setGraphFontSize(this.getUITitle().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUITitle().getUIGraphFont().setFontBold(this.getUITitle().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUITitle().getUIGraphFont().setFontItalic(this.getUITitle().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUITitle().getUIGraphFont().setUnderline(this.getUITitle().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUITitle().getUIGraphFont().setGraphFontColor(this.getUITitle().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUITitle()).isHorizontalAlignmentChanged()) {
            graph.getUITitle().setHorizontalAlignment(this.getUITitle().getHorizontalAlignment());
        }
        if (((UITitleAdapter)this.getUITitle()).isTextRotationChanged()) {
            graph.getUITitle().setTextRotation(this.getUITitle().getTextRotation());
        }
        if (((UITitleAdapter)this.getUISubtitle()).isTextChanged()) {
            graph.getUISubtitle().setText(this.getUISubtitle().getUnParseText());
        }
        if (((UITitleAdapter)this.getUISubtitle()).isVisibleChanged()) {
            graph.getUISubtitle().setVisible(this.getUISubtitle().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUISubtitle().getUIGraphFont().setGraphFontTypeface(this.getUISubtitle().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUISubtitle().getUIGraphFont().setGraphFontSize(this.getUISubtitle().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUISubtitle().getUIGraphFont().setFontBold(this.getUISubtitle().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUISubtitle().getUIGraphFont().setFontItalic(this.getUISubtitle().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUISubtitle().getUIGraphFont().setUnderline(this.getUISubtitle().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUISubtitle().getUIGraphFont().setGraphFontColor(this.getUISubtitle().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUISubtitle()).isHorizontalAlignmentChanged()) {
            graph.getUISubtitle().setHorizontalAlignment(this.getUISubtitle().getHorizontalAlignment());
        }
        if (((UITitleAdapter)this.getUISubtitle()).isTextRotationChanged()) {
            graph.getUISubtitle().setTextRotation(this.getUISubtitle().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIFootnote()).isTextChanged()) {
            graph.getUIFootnote().setText(this.getUIFootnote().getUnParseText());
        }
        if (((UITitleAdapter)this.getUIFootnote()).isVisibleChanged()) {
            graph.getUIFootnote().setVisible(this.getUIFootnote().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIFootnote().getUIGraphFont().setGraphFontTypeface(this.getUIFootnote().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIFootnote().getUIGraphFont().setGraphFontSize(this.getUIFootnote().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIFootnote().getUIGraphFont().setFontBold(this.getUIFootnote().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIFootnote().getUIGraphFont().setFontItalic(this.getUIFootnote().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIFootnote().getUIGraphFont().setUnderline(this.getUIFootnote().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIFootnote().getUIGraphFont().setGraphFontColor(this.getUIFootnote().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUIFootnote()).isHorizontalAlignmentChanged()) {
            graph.getUIFootnote().setHorizontalAlignment(this.getUIFootnote().getHorizontalAlignment());
        }
        if (((UITitleAdapter)this.getUIFootnote()).isTextRotationChanged()) {
            graph.getUIFootnote().setTextRotation(this.getUIFootnote().getTextRotation());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isPositionChanged()) {
            graph.getUILegendArea().setPosition(this.getUILegendArea().getPosition());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isBorderColorChanged()) {
            graph.getUILegendArea().setBorderColor(this.getUILegendArea().getBorderColor());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isBorderTransparentChanged()) {
            graph.getUILegendArea().setBorderTransparent(this.getUILegendArea().isBorderTransparent());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isVisibleChanged()) {
            graph.getUILegendArea().setVisible(this.getUILegendArea().isVisible());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isFillColorChanged()) {
            graph.getUILegendArea().setFillColor(this.getUILegendArea().getFillColor());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isFillTransparentChanged()) {
            graph.getUILegendArea().setFillTransparent(this.getUILegendArea().isFillTransparent());
        }
        if (((UILegendAreaAdapter)this.getUILegendArea()).isAutomaticPlacementChanged()) {
            graph.getUILegendArea().setAutomaticPlacement(this.getUILegendArea().getAutomaticPlacement());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUILegendText().getUIGraphFont().setGraphFontTypeface(this.getUILegendText().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUILegendText().getUIGraphFont().setGraphFontSize(this.getUILegendText().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUILegendText().getUIGraphFont().setFontBold(this.getUILegendText().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUILegendText().getUIGraphFont().setFontItalic(this.getUILegendText().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUILegendText().getUIGraphFont().setUnderline(this.getUILegendText().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUILegendText().getUIGraphFont().setGraphFontColor(this.getUILegendText().getUIGraphFont().getGraphFontColor());
        }
        if (((UILegendTextAdapter)this.getUILegendText()).isHorizontalAlignmentChanged()) {
            graph.getUILegendText().setHorizontalAlignment(this.getUILegendText().getHorizontalAlignment());
        }
        if (((UIBase3DPanelAdapter)this.getUI3DFloor()).isFillColorChanged()) {
            graph.getUI3DFloor().setSharePanelProperties(true);
            graph.getUI3DFloor().setFillColor(this.getUI3DFloor().getFillColor());
        }
        if (((UIBase3DPanelAdapter)this.getUI3DFloor()).isBorderColorChanged()) {
            graph.getUI3DFloor().setSharePanelProperties(true);
            graph.getUI3DFloor().setBorderColor(this.getUI3DFloor().getBorderColor());
        }
        if (((UIBase3DPanelAdapter)this.getUI3DFloor()).isBorderTransparentChanged()) {
            graph.getUI3DFloor().setSharePanelProperties(true);
            graph.getUI3DFloor().setBorderTransparent(this.getUI3DFloor().isBorderTransparent());
        }
        if (((UIBase3DPanelAdapter)this.getUI3DFloor()).isSharePanelPropertiesChanged()) {
            graph.getUI3DFloor().setSharePanelProperties(this.getUI3DFloor().isSharePanelProperties());
        }
        if (((UIBaseFrameAdapter)this.getUIPieFrame()).isFillColorChanged()) {
            graph.getUIPieFrame().setFillColor(this.getUIPieFrame().getFillColor());
        }
        if (((UIBaseFrameAdapter)this.getUIPieFrame()).isBorderColorChanged()) {
            graph.getUIPieFrame().setBorderColor(this.getUIPieFrame().getBorderColor());
        }
        if (((UIBaseFrameAdapter)this.getUIPieFrame()).isBorderTransparentChanged()) {
            graph.getUIPieFrame().setBorderTransparent(this.getUIPieFrame().isBorderTransparent());
        }
        if (((LabelPositionAdapter)this.getUISlice()).isLabelPositionChanged()) {
            graph.getUISlice().setLabelPosition(this.getUISlice().getLabelPosition());
        }
        if (((UIBaseFrameAdapter)this.getUIPlotArea()).isFillColorChanged()) {
            graph.getUIPlotArea().setFillColor(this.getUIPlotArea().getFillColor());
        }
        if (((UIBaseFrameAdapter)this.getUIPlotArea()).isBorderColorChanged()) {
            graph.getUIPlotArea().setBorderColor(this.getUIPlotArea().getBorderColor());
        }
        if (((UIBaseFrameAdapter)this.getUIPlotArea()).isBorderTransparentChanged()) {
            graph.getUIPlotArea().setBorderTransparent(this.getUIPlotArea().isBorderTransparent());
        }
        if (((MajorTickAdapter)this.getUIY1MajorTick()).isVisibleChanged()) {
            graph.getUIY1MajorTick().setVisible(this.getUIY1MajorTick().isVisible());
        }
        if (((MajorTickAdapter)this.getUIY1MajorTick()).isLineWidthChanged()) {
            graph.getUIY1MajorTick().setLineWidth(this.getUIY1MajorTick().getLineWidth());
        }
        if (((MajorTickAdapter)this.getUIY1MajorTick()).isLineColorChanged()) {
            graph.getUIY1MajorTick().setLineColor(this.getUIY1MajorTick().getLineColor());
        }
        if (((MajorTickAdapter)this.getUIY2MajorTick()).isVisibleChanged()) {
            graph.getUIY2MajorTick().setVisible(this.getUIY2MajorTick().isVisible());
        }
        if (((MajorTickAdapter)this.getUIY2MajorTick()).isLineWidthChanged()) {
            graph.getUIY2MajorTick().setLineWidth(this.getUIY2MajorTick().getLineWidth());
        }
        if (((MajorTickAdapter)this.getUIY2MajorTick()).isLineColorChanged()) {
            graph.getUIY2MajorTick().setLineColor(this.getUIY2MajorTick().getLineColor());
        }
        if (((MajorTickAdapter)this.getUIX1MajorTick()).isVisibleChanged()) {
            graph.getUIX1MajorTick().setVisible(this.getUIX1MajorTick().isVisible());
        }
        if (((MajorTickAdapter)this.getUIX1MajorTick()).isLineWidthChanged()) {
            graph.getUIX1MajorTick().setLineWidth(this.getUIX1MajorTick().getLineWidth());
        }
        if (((MajorTickAdapter)this.getUIX1MajorTick()).isLineColorChanged()) {
            graph.getUIX1MajorTick().setLineColor(this.getUIX1MajorTick().getLineColor());
        }
        if (((MajorTickAdapter)this.getUIO1MajorTick()).isVisibleChanged()) {
            graph.getUIO1MajorTick().setVisible(this.getUIO1MajorTick().isVisible());
        }
        if (((MajorTickAdapter)this.getUIO1MajorTick()).isLineWidthChanged()) {
            graph.getUIO1MajorTick().setLineWidth(this.getUIO1MajorTick().getLineWidth());
        }
        if (((MajorTickAdapter)this.getUIO1MajorTick()).isLineColorChanged()) {
            graph.getUIO1MajorTick().setLineColor(this.getUIO1MajorTick().getLineColor());
        }
        if (((UIMarkerTextAdapter)this.getUIMarkerText()).isVisibleChanged()) {
            graph.getUIMarkerText().setVisible(this.getUIMarkerText().isVisible());
        }
        if (((UIMarkerTextAdapter)this.getUIMarkerText()).isMarkerTextPlaceChanged()) {
            graph.getUIMarkerText().setMarkerTextPlace(this.getUIMarkerText().getMarkerTextPlace());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setGraphFontTypeface(this.getUIMarkerText().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setGraphFontSize(this.getUIMarkerText().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setFontBold(this.getUIMarkerText().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setFontItalic(this.getUIMarkerText().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setUnderline(this.getUIMarkerText().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIMarkerText().getUIGraphFont().setGraphFontColor(this.getUIMarkerText().getUIGraphFont().getGraphFontColor());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setGraphFontTypeface(this.getUISliceLabel().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setGraphFontSize(this.getUISliceLabel().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setFontBold(this.getUISliceLabel().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setFontItalic(this.getUISliceLabel().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setUnderline(this.getUISliceLabel().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUISliceLabel().getUIGraphFont().setGraphFontColor(this.getUISliceLabel().getUIGraphFont().getGraphFontColor());
        }
        if (((UISliceLabelAdapter)this.getUISliceLabel()).isTextTypeChanged()) {
            graph.getUISliceLabel().setTextType(this.getUISliceLabel().getTextType());
        }
        if (this.isSeriesObjectCountChanged()) {
            // empty if block
        }
        graph.setSeriesObjectCount(this.getSeriesObjectCount());
        try {
            if (((UISeriesAdapter)this.getUISeries()).isDefaultColorChanged()) {
                graph.getUISeries().setDefaultColor(this.getUISeries().getDefaultColor());
            }
            if (((UISeriesAdapter)this.getUISeries()).isDefaultLineWidthChanged()) {
                graph.getUISeries().setDefaultLineWidth(this.getUISeries().getDefaultLineWidth());
            }
            if (((UISeriesAdapter)this.getUISeries()).isDefaultMarkerShapeChanged()) {
                graph.getUISeries().setDefaultMarkerShape(this.getUISeries().getDefaultMarkerShape());
            }
            if (((UISeriesAdapter)this.getUISeries()).isDefaultAssignedToY2Changed()) {
                graph.getUISeries().setDefaultAssignedToY2(this.getUISeries().getDefaultAssignedToY2());
            }
            if (((UISeriesAdapter)this.getUISeries()).isDefaultMarkerTypeChanged()) {
                graph.getUISeries().setDefaultMarkerType(this.getUISeries().getDefaultMarkerType());
            }
            if (((UISeriesAdapter)this.getUISeries()).isDefaultFitlineTypeChanged()) {
                graph.getUISeries().setDefaultFitlineType(this.getUISeries().getDefaultFitlineType());
            }
            int n = 0;
            while (n < this.m_seriesObjectCount) {
                if (((UISeriesAdapter)this.getUISeries()).isColorChanged(n)) {
                    graph.getUISeries().setColor(this.getUISeries().getColor(n), n);
                }
                if (((UISeriesAdapter)this.getUISeries()).isLineWidthChanged(n)) {
                    graph.getUISeries().setLineWidth(this.getUISeries().getLineWidth(n), n);
                }
                if (((UISeriesAdapter)this.getUISeries()).isMarkerShapeChanged(n)) {
                    graph.getUISeries().setMarkerShape(this.getUISeries().getMarkerShape(n), n);
                }
                if (((UISeriesAdapter)this.getUISeries()).isAssignedToY2Changed(n)) {
                    graph.getUISeries().setAssignedToY2(this.getUISeries().isAssignedToY2(n), n);
                }
                if (((UISeriesAdapter)this.getUISeries()).isMarkerTypeChanged(n)) {
                    graph.getUISeries().setMarkerType(this.getUISeries().getMarkerType(n), n);
                }
                if (((UISeriesAdapter)this.getUISeries()).isFitlineTypeChanged(n)) {
                    graph.getUISeries().setFitlineType(this.getUISeries().getFitlineType(n), n);
                }
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        graph.beginAxisChanges();
        if (((UITitleAdapter)this.getUIO1Title()).isTextChanged()) {
            graph.getUIO1Title().setText(this.getUIO1Title().getUnParseText());
        }
        if (((UITitleAdapter)this.getUIO1Title()).isVisibleChanged()) {
            graph.getUIO1Title().setVisible(this.getUIO1Title().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIO1Title().getUIGraphFont().setGraphFontTypeface(this.getUIO1Title().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIO1Title().getUIGraphFont().setGraphFontSize(this.getUIO1Title().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIO1Title().getUIGraphFont().setFontBold(this.getUIO1Title().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIO1Title().getUIGraphFont().setFontItalic(this.getUIO1Title().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIO1Title().getUIGraphFont().setUnderline(this.getUIO1Title().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIO1Title().getUIGraphFont().setGraphFontColor(this.getUIO1Title().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUIO1Title()).isHorizontalAlignmentChanged()) {
            graph.getUIO1Title().setHorizontalAlignment(this.getUIO1Title().getHorizontalAlignment());
        }
        if (((UITitleAdapter)this.getUIO1Title()).isTextRotationChanged()) {
            graph.getUIO1Title().setTextRotation(this.getUIO1Title().getTextRotation());
        }
        if (((UIO1AxisAdapter)this.getUIO1Axis()).isLineWidthChanged()) {
            graph.getUIO1Axis().setLineWidth(this.getUIO1Axis().getLineWidth());
        }
        if (((UIO1AxisAdapter)this.getUIO1Axis()).isLineColorChanged()) {
            graph.getUIO1Axis().setLineColor(this.getUIO1Axis().getLineColor());
        }
        if (((UIO1AxisAdapter)this.getUIO1Axis()).isVisibleChanged()) {
            graph.getUIO1Axis().setVisible(this.getUIO1Axis().isVisible());
        }
        if (((UITickLabelAdapter)this.getUIO1TickLabel()).isTickLabelSkipCountChanged()) {
            graph.getUIO1TickLabel().setTickLabelSkipCount(this.getUIO1TickLabel().getTickLabelSkipCount());
        }
        if (((UITickLabelAdapter)this.getUIO1TickLabel()).isTickLabelSkipFirstChanged()) {
            graph.getUIO1TickLabel().setTickLabelSkipFirst(this.getUIO1TickLabel().getTickLabelSkipFirst());
        }
        if (((UITickLabelAdapter)this.getUIO1TickLabel()).isTickLabelSkipModeChanged()) {
            graph.getUIO1TickLabel().setTickLabelSkipMode(this.getUIO1TickLabel().getTickLabelSkipMode());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setGraphFontTypeface(this.getUIO1TickLabel().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setGraphFontSize(this.getUIO1TickLabel().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setFontBold(this.getUIO1TickLabel().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setFontItalic(this.getUIO1TickLabel().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setUnderline(this.getUIO1TickLabel().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIO1TickLabel().getUIGraphFont().setGraphFontColor(this.getUIO1TickLabel().getUIGraphFont().getGraphFontColor());
        }
        if (((UITickLabelAdapter)this.getUIO1TickLabel()).isAutomaticRotationChanged()) {
            graph.getUIO1TickLabel().setAutomaticRotation(this.getUIO1TickLabel().getAutomaticRotation());
        }
        if (((UITickLabelAdapter)this.getUIO1TickLabel()).isTextRotationChanged()) {
            graph.getUIO1TickLabel().setTextRotation(this.getUIO1TickLabel().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIX1Title()).isTextChanged()) {
            graph.getUIX1Title().setText(this.getUIX1Title().getUnParseText());
        }
        if (((UITitleAdapter)this.getUIX1Title()).isVisibleChanged()) {
            graph.getUIX1Title().setVisible(this.getUIX1Title().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIX1Title().getUIGraphFont().setGraphFontTypeface(this.getUIX1Title().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIX1Title().getUIGraphFont().setGraphFontSize(this.getUIX1Title().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIX1Title().getUIGraphFont().setFontBold(this.getUIX1Title().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIX1Title().getUIGraphFont().setFontItalic(this.getUIX1Title().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIX1Title().getUIGraphFont().setUnderline(this.getUIX1Title().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIX1Title().getUIGraphFont().setGraphFontColor(this.getUIX1Title().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUIX1Title()).isTextRotationChanged()) {
            graph.getUIX1Title().setTextRotation(this.getUIX1Title().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIX1Title()).isHorizontalAlignmentChanged()) {
            graph.getUIX1Title().setHorizontalAlignment(this.getUIX1Title().getHorizontalAlignment());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isLineWidthChanged()) {
            graph.getUIX1Axis().setLineWidth(this.getUIX1Axis().getLineWidth());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isLineColorChanged()) {
            graph.getUIX1Axis().setLineColor(this.getUIX1Axis().getLineColor());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isMajorTickStepAutomaticChanged()) {
            graph.getUIX1Axis().setMajorTickStepAutomatic(this.getUIX1Axis().isMajorTickStepAutomatic());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isAxisMaxAutoScaledChanged()) {
            graph.getUIX1Axis().setAxisMaxAutoScaled(this.getUIX1Axis().isAxisMaxAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isAxisMinAutoScaledChanged()) {
            graph.getUIX1Axis().setAxisMinAutoScaled(this.getUIX1Axis().isAxisMinAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isAxisMinValueChanged()) {
            graph.getUIX1Axis().setAxisMinValue(this.getUIX1Axis().getAxisMinValue());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isAxisMaxValueChanged()) {
            graph.getUIX1Axis().setAxisMaxValue(this.getUIX1Axis().getAxisMaxValue());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isMajorTickStepChanged()) {
            graph.getUIX1Axis().setMajorTickStep(this.getUIX1Axis().getMajorTickStep());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isMajorTickStepAutomaticChanged()) {
            graph.getUIX1Axis().setMajorTickStepAutomatic(this.getUIX1Axis().isMajorTickStepAutomatic());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isScaledLogarithmicChanged()) {
            graph.getUIX1Axis().setScaledLogarithmic(this.getUIX1Axis().isScaledLogarithmic());
        }
        if (((UIDataAxisAdapter)this.getUIX1Axis()).isLogarithmicBaseChanged()) {
            graph.getUIX1Axis().setLogarithmicBase(this.getUIX1Axis().getLogarithmicBase());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontTypeface(this.getUIDataX1TickLabel().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontSize(this.getUIDataX1TickLabel().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setFontBold(this.getUIDataX1TickLabel().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setFontItalic(this.getUIDataX1TickLabel().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setUnderline(this.getUIDataX1TickLabel().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIDataX1TickLabel().getUIGraphFont().setGraphFontColor(this.getUIDataX1TickLabel().getUIGraphFont().getGraphFontColor());
        }
        if (((UIDataTickLabelAdapter)this.getUIDataX1TickLabel()).isTextRotationChanged()) {
            graph.getUIDataX1TickLabel().setTextRotation(this.getUIDataX1TickLabel().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIY1Title()).isTextChanged()) {
            graph.getUIY1Title().setText(this.getUIY1Title().getUnParseText());
        }
        if (((UITitleAdapter)this.getUIY1Title()).isVisibleChanged()) {
            graph.getUIY1Title().setVisible(this.getUIY1Title().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIY1Title().getUIGraphFont().setGraphFontTypeface(this.getUIY1Title().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIY1Title().getUIGraphFont().setGraphFontSize(this.getUIY1Title().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIY1Title().getUIGraphFont().setFontBold(this.getUIY1Title().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIY1Title().getUIGraphFont().setFontItalic(this.getUIY1Title().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIY1Title().getUIGraphFont().setUnderline(this.getUIY1Title().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIY1Title().getUIGraphFont().setGraphFontColor(this.getUIY1Title().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUIY1Title()).isTextRotationChanged()) {
            graph.getUIY1Title().setTextRotation(this.getUIY1Title().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIY1Title()).isHorizontalAlignmentChanged()) {
            graph.getUIY1Title().setHorizontalAlignment(this.getUIY1Title().getHorizontalAlignment());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isLineWidthChanged()) {
            graph.getUIY1Axis().setLineWidth(this.getUIY1Axis().getLineWidth());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isLineColorChanged()) {
            graph.getUIY1Axis().setLineColor(this.getUIY1Axis().getLineColor());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isAxisMaxAutoScaledChanged()) {
            graph.getUIY1Axis().setAxisMaxAutoScaled(this.getUIY1Axis().isAxisMaxAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isAxisMinAutoScaledChanged()) {
            graph.getUIY1Axis().setAxisMinAutoScaled(this.getUIY1Axis().isAxisMinAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isAxisMinValueChanged()) {
            graph.getUIY1Axis().setAxisMinValue(this.getUIY1Axis().getAxisMinValue());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isAxisMaxValueChanged()) {
            graph.getUIY1Axis().setAxisMaxValue(this.getUIY1Axis().getAxisMaxValue());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isMajorTickStepChanged()) {
            graph.getUIY1Axis().setMajorTickStep(this.getUIY1Axis().getMajorTickStep());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isMajorTickStepAutomaticChanged()) {
            graph.getUIY1Axis().setMajorTickStepAutomatic(this.getUIY1Axis().isMajorTickStepAutomatic());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isScaledLogarithmicChanged()) {
            graph.getUIY1Axis().setScaledLogarithmic(this.getUIY1Axis().isScaledLogarithmic());
        }
        if (((UIDataAxisAdapter)this.getUIY1Axis()).isLogarithmicBaseChanged()) {
            graph.getUIY1Axis().setLogarithmicBase(this.getUIY1Axis().getLogarithmicBase());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontTypeface(this.getUIDataY1TickLabel().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontSize(this.getUIDataY1TickLabel().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setFontBold(this.getUIDataY1TickLabel().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setFontItalic(this.getUIDataY1TickLabel().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setUnderline(this.getUIDataY1TickLabel().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIDataY1TickLabel().getUIGraphFont().setGraphFontColor(this.getUIDataY1TickLabel().getUIGraphFont().getGraphFontColor());
        }
        if (((UIDataTickLabelAdapter)this.getUIDataY1TickLabel()).isTextRotationChanged()) {
            graph.getUIDataY1TickLabel().setTextRotation(this.getUIDataY1TickLabel().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIY2Title()).isTextChanged()) {
            graph.getUIY2Title().setText(this.getUIY2Title().getUnParseText());
        }
        if (((UITitleAdapter)this.getUIY2Title()).isVisibleChanged()) {
            graph.getUIY2Title().setVisible(this.getUIY2Title().isVisible());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIY2Title().getUIGraphFont().setGraphFontTypeface(this.getUIY2Title().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIY2Title().getUIGraphFont().setGraphFontSize(this.getUIY2Title().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIY2Title().getUIGraphFont().setFontBold(this.getUIY2Title().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIY2Title().getUIGraphFont().setFontItalic(this.getUIY2Title().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIY2Title().getUIGraphFont().setUnderline(this.getUIY2Title().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIY2Title().getUIGraphFont().setGraphFontColor(this.getUIY2Title().getUIGraphFont().getGraphFontColor());
        }
        if (((UITitleAdapter)this.getUIY2Title()).isTextRotationChanged()) {
            graph.getUIY2Title().setTextRotation(this.getUIY2Title().getTextRotation());
        }
        if (((UITitleAdapter)this.getUIY2Title()).isHorizontalAlignmentChanged()) {
            graph.getUIY2Title().setHorizontalAlignment(this.getUIY2Title().getHorizontalAlignment());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isLineWidthChanged()) {
            graph.getUIY2Axis().setLineWidth(this.getUIY2Axis().getLineWidth());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isLineColorChanged()) {
            graph.getUIY2Axis().setLineColor(this.getUIY2Axis().getLineColor());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isAxisMaxAutoScaledChanged()) {
            graph.getUIY2Axis().setAxisMaxAutoScaled(this.getUIY2Axis().isAxisMaxAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isAxisMinAutoScaledChanged()) {
            graph.getUIY2Axis().setAxisMinAutoScaled(this.getUIY2Axis().isAxisMinAutoScaled());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isAxisMinValueChanged()) {
            graph.getUIY2Axis().setAxisMinValue(this.getUIY2Axis().getAxisMinValue());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isAxisMaxValueChanged()) {
            graph.getUIY2Axis().setAxisMaxValue(this.getUIY2Axis().getAxisMaxValue());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isMajorTickStepChanged()) {
            graph.getUIY2Axis().setMajorTickStep(this.getUIY2Axis().getMajorTickStep());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isMajorTickStepAutomaticChanged()) {
            graph.getUIY2Axis().setMajorTickStepAutomatic(this.getUIY2Axis().isMajorTickStepAutomatic());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isScaledLogarithmicChanged()) {
            graph.getUIY2Axis().setScaledLogarithmic(this.getUIY2Axis().isScaledLogarithmic());
        }
        if (((UIDataAxisAdapter)this.getUIY2Axis()).isLogarithmicBaseChanged()) {
            graph.getUIY2Axis().setLogarithmicBase(this.getUIY2Axis().getLogarithmicBase());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isGraphFontTypefaceChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontTypeface(this.getUIDataY2TickLabel().getUIGraphFont().getGraphFontTypeface());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isGraphFontSizeChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontSize(this.getUIDataY2TickLabel().getUIGraphFont().getGraphFontSize());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isFontBoldChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setFontBold(this.getUIDataY2TickLabel().getUIGraphFont().isFontBold());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isFontItalicChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setFontItalic(this.getUIDataY2TickLabel().getUIGraphFont().isFontItalic());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isUnderlineChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setUnderline(this.getUIDataY2TickLabel().getUIGraphFont().isUnderline());
        }
        if (((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).isGraphFontColorChanged()) {
            graph.getUIDataY2TickLabel().getUIGraphFont().setGraphFontColor(this.getUIDataY2TickLabel().getUIGraphFont().getGraphFontColor());
        }
        if (((UIDataTickLabelAdapter)this.getUIDataY2TickLabel()).isTextRotationChanged()) {
            graph.getUIDataY2TickLabel().setTextRotation(this.getUIDataY2TickLabel().getTextRotation());
        }
        if (((UIAssignedValueAdapter)this.getUIY1Baseline()).isValueChanged()) {
            graph.getUIY1Baseline().setValue(this.getUIY1Baseline().getValue());
        }
        if (((UIAssignedValueAdapter)this.getUIY2Baseline()).isValueChanged()) {
            graph.getUIY2Baseline().setValue(this.getUIY2Baseline().getValue());
        }
        int n = 0;
        while (n < 3) {
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isDisplayedInLegendChanged(n)) {
                graph.getUIX1ReferenceLine().setDisplayedInLegend(this.getUIX1ReferenceLine().isDisplayedInLegend(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isLineColorChanged(n)) {
                graph.getUIX1ReferenceLine().setLineColor(this.getUIX1ReferenceLine().getLineColor(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isLineWidthChanged(n)) {
                graph.getUIX1ReferenceLine().setLineWidth(this.getUIX1ReferenceLine().getLineWidth(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isTextChanged(n)) {
                graph.getUIX1ReferenceLine().setText(this.getUIX1ReferenceLine().getText(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isValueChanged(n)) {
                graph.getUIX1ReferenceLine().setValue(this.getUIX1ReferenceLine().getValue(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).isVisibleChanged(n)) {
                graph.getUIX1ReferenceLine().setVisible(this.getUIX1ReferenceLine().isVisible(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isDisplayedInLegendChanged(n)) {
                graph.getUIY1ReferenceLine().setDisplayedInLegend(this.getUIY1ReferenceLine().isDisplayedInLegend(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isLineColorChanged(n)) {
                graph.getUIY1ReferenceLine().setLineColor(this.getUIY1ReferenceLine().getLineColor(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isLineWidthChanged(n)) {
                graph.getUIY1ReferenceLine().setLineWidth(this.getUIY1ReferenceLine().getLineWidth(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isTextChanged(n)) {
                graph.getUIY1ReferenceLine().setText(this.getUIY1ReferenceLine().getText(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isValueChanged(n)) {
                graph.getUIY1ReferenceLine().setValue(this.getUIY1ReferenceLine().getValue(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).isVisibleChanged(n)) {
                graph.getUIY1ReferenceLine().setVisible(this.getUIY1ReferenceLine().isVisible(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isDisplayedInLegendChanged(n)) {
                graph.getUIY2ReferenceLine().setDisplayedInLegend(this.getUIY2ReferenceLine().isDisplayedInLegend(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isLineColorChanged(n)) {
                graph.getUIY2ReferenceLine().setLineColor(this.getUIY2ReferenceLine().getLineColor(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isLineWidthChanged(n)) {
                graph.getUIY2ReferenceLine().setLineWidth(this.getUIY2ReferenceLine().getLineWidth(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isTextChanged(n)) {
                graph.getUIY2ReferenceLine().setText(this.getUIY2ReferenceLine().getText(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isValueChanged(n)) {
                graph.getUIY2ReferenceLine().setValue(this.getUIY2ReferenceLine().getValue(n), n);
            }
            if (((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).isVisibleChanged(n)) {
                graph.getUIY2ReferenceLine().setVisible(this.getUIY2ReferenceLine().isVisible(n), n);
            }
            ++n;
        }
        graph.endAxisChanges();
        if (((UIParetoLineAdapter)this.getParetoLine()).isColorChanged()) {
            graph.getParetoLine().setColor(this.getParetoLine().getColor());
        }
        if (((UIParetoLineAdapter)this.getParetoLine()).isWidthChanged()) {
            graph.getParetoLine().setWidth(this.getParetoLine().getWidth());
        }
        if (((UIParetoLineAdapter)this.getParetoLine()).isMarkerShapeChanged()) {
            graph.getParetoLine().setMarkerShape(this.getParetoLine().getMarkerShape());
        }
        ((DataFilterImpl)graph.getDataFilter()).setTotalMeasures(this.m_dataFilter.getTotalMeasures());
        this.m_dataFilter.applyMeasuresToGraph(graph);
        ((DataFilterImpl)graph.getDataFilter()).setGraphType(this.getGraphType());
        ((DataFilterImpl)graph.getDataFilter()).setDataRowShownAsASeries(this.isDataRowShownAsASeries());
        if (this.isTimeAxisDateFormatChanged(0)) {
            graph.setTimeAxisDateFormat(0, this.getTimeAxisDateFormat(0));
        }
        if (this.isTimeAxisDateFormatChanged(1)) {
            graph.setTimeAxisDateFormat(1, this.getTimeAxisDateFormat(1));
        }
        if (this.isTimeAxisDateFormatChanged(2)) {
            graph.setTimeAxisDateFormat(2, this.getTimeAxisDateFormat(2));
        }
        if (this.isTimeAxisDateFormatChanged(3)) {
            graph.setTimeAxisDateFormat(3, this.getTimeAxisDateFormat(3));
        }
    }

    public void initFromGraph(Graph graph) {
        super.initFromDataview(graph);
        this.setAutoLayout(graph.getAutoLayout());
        this.setGraphType(graph.getGraphType());
        this.setGraphTypeChanged(false);
        if (graph.getGraphTypeConverter() != null) {
            this.setGraphTypeConverter(graph.getGraphTypeConverter());
        } else {
            GraphTypeConverterAdapter graphTypeConverterAdapter = new GraphTypeConverterAdapter();
            this.setGraphTypeConverter(graphTypeConverterAdapter);
            graphTypeConverterAdapter.setLocale(graph.getLocale());
        }
        this.setDataDirectorType(graph.getDataDirectorType());
        this.setDataDirectorTypeChanged(false);
        this.setDataSource(graph.getDataSource());
        this.setDataSourceChanged(false);
        this.set3DEffect(graph.is3DEffect());
        this.set3DEffectChanged(false);
        this.setLineDataLineDisplayed(graph.isLineDataLineDisplayed());
        this.setLineDataLineDisplayedChanged(false);
        this.setPagingControlVisible(graph.isPagingControlVisible());
        this.setPagingControlVisibleChanged(false);
        this.setDataRowShownAsASeries(graph.isDataRowShownAsASeries());
        this.setDataRowShownAsASeriesChanged(false);
        this.setTokenSubstitution(graph.getTokenSubstitution());
        this.setTokenSubstitutionChanged(false);
        this.setSeriesObjectCount(graph.getSeriesObjectCount());
        this.setSeriesObjectCountChanged(false);
        this.setMarkerDisplayed(graph.isMarkerDisplayed());
        this.setMarkerDisplayedChanged(false);
        ((UITitleAdapter)this.getUITitle()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUITitle().setText(graph.getUITitle().getUnParseText());
        ((UITitleAdapter)this.getUITitle()).setTextChanged(false);
        this.getUITitle().setVisible(graph.getUITitle().isVisible());
        ((UITitleAdapter)this.getUITitle()).setVisibleChanged(false);
        this.getUITitle().getUIGraphFont().setGraphFontTypeface(graph.getUITitle().getUIGraphFont().getGraphFontTypeface());
        this.getUITitle().getUIGraphFont().setGraphFontSize(graph.getUITitle().getUIGraphFont().getGraphFontSize());
        this.getUITitle().getUIGraphFont().setFontBold(graph.getUITitle().getUIGraphFont().isFontBold());
        this.getUITitle().getUIGraphFont().setFontItalic(graph.getUITitle().getUIGraphFont().isFontItalic());
        this.getUITitle().getUIGraphFont().setUnderline(graph.getUITitle().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUITitle().getUIGraphFont().setGraphFontColor(graph.getUITitle().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUITitle().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUITitle().setHorizontalAlignment(graph.getUITitle().getHorizontalAlignment());
        ((UITitleAdapter)this.getUITitle()).setHorizontalAlignmentChanged(false);
        this.getUITitle().setTextRotation(graph.getUITitle().getTextRotation());
        ((UITitleAdapter)this.getUITitle()).setTextRotationChanged(false);
        ((UITitleAdapter)this.getUISubtitle()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUISubtitle().setText(graph.getUISubtitle().getUnParseText());
        ((UITitleAdapter)this.getUISubtitle()).setTextChanged(false);
        this.getUISubtitle().setVisible(graph.getUISubtitle().isVisible());
        ((UITitleAdapter)this.getUISubtitle()).setVisibleChanged(false);
        this.getUISubtitle().getUIGraphFont().setGraphFontTypeface(graph.getUISubtitle().getUIGraphFont().getGraphFontTypeface());
        this.getUISubtitle().getUIGraphFont().setGraphFontSize(graph.getUISubtitle().getUIGraphFont().getGraphFontSize());
        this.getUISubtitle().getUIGraphFont().setFontBold(graph.getUISubtitle().getUIGraphFont().isFontBold());
        this.getUISubtitle().getUIGraphFont().setFontItalic(graph.getUISubtitle().getUIGraphFont().isFontItalic());
        this.getUISubtitle().getUIGraphFont().setUnderline(graph.getUISubtitle().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUISubtitle().getUIGraphFont().setGraphFontColor(graph.getUISubtitle().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUISubtitle().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUISubtitle().setHorizontalAlignment(graph.getUISubtitle().getHorizontalAlignment());
        ((UITitleAdapter)this.getUISubtitle()).setHorizontalAlignmentChanged(false);
        this.getUISubtitle().setTextRotation(graph.getUISubtitle().getTextRotation());
        ((UITitleAdapter)this.getUISubtitle()).setTextRotationChanged(false);
        ((UITitleAdapter)this.getUIFootnote()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUIFootnote().setText(graph.getUIFootnote().getUnParseText());
        ((UITitleAdapter)this.getUIFootnote()).setTextChanged(false);
        this.getUIFootnote().setVisible(graph.getFootnote().isVisible());
        ((UITitleAdapter)this.getUIFootnote()).setVisibleChanged(false);
        this.getUIFootnote().getUIGraphFont().setGraphFontTypeface(graph.getUIFootnote().getUIGraphFont().getGraphFontTypeface());
        this.getUIFootnote().getUIGraphFont().setGraphFontSize(graph.getUIFootnote().getUIGraphFont().getGraphFontSize());
        this.getUIFootnote().getUIGraphFont().setFontBold(graph.getUIFootnote().getUIGraphFont().isFontBold());
        this.getUIFootnote().getUIGraphFont().setFontItalic(graph.getUIFootnote().getUIGraphFont().isFontItalic());
        this.getUIFootnote().getUIGraphFont().setUnderline(graph.getUIFootnote().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIFootnote().getUIGraphFont().setGraphFontColor(graph.getUIFootnote().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIFootnote().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIFootnote().setHorizontalAlignment(graph.getUIFootnote().getHorizontalAlignment());
        ((UITitleAdapter)this.getUIFootnote()).setHorizontalAlignmentChanged(false);
        this.getUIFootnote().setTextRotation(graph.getUIFootnote().getTextRotation());
        ((UITitleAdapter)this.getUIFootnote()).setTextRotationChanged(false);
        this.getUILegendArea().setAutomaticPlacement(graph.getUILegendArea().getAutomaticPlacement());
        ((UILegendAreaAdapter)this.getUILegendArea()).setAutomaticPlacementChanged(false);
        this.getUILegendArea().setPosition(graph.getUILegendArea().getPosition());
        ((UILegendAreaAdapter)this.getUILegendArea()).setPositionChanged(false);
        this.getUILegendArea().setBorderColor(graph.getUILegendArea().getBorderColor());
        ((UILegendAreaAdapter)this.getUILegendArea()).setBorderColorChanged(false);
        this.getUILegendArea().setBorderTransparent(graph.getUILegendArea().isBorderTransparent());
        ((UILegendAreaAdapter)this.getUILegendArea()).setBorderTransparentChanged(false);
        this.getUILegendArea().setVisible(graph.getUILegendArea().isVisible());
        ((UILegendAreaAdapter)this.getUILegendArea()).setVisibleChanged(false);
        this.getUILegendArea().setFillColor(graph.getUILegendArea().getFillColor());
        ((UILegendAreaAdapter)this.getUILegendArea()).setFillColorChanged(false);
        this.getUILegendArea().setFillTransparent(graph.getUILegendArea().isFillTransparent());
        ((UILegendAreaAdapter)this.getUILegendArea()).setFillTransparentChanged(false);
        this.getUILegendText().getUIGraphFont().setGraphFontTypeface(graph.getUILegendText().getUIGraphFont().getGraphFontTypeface());
        this.getUILegendText().getUIGraphFont().setGraphFontSize(graph.getUILegendText().getUIGraphFont().getGraphFontSize());
        this.getUILegendText().getUIGraphFont().setFontBold(graph.getUILegendText().getUIGraphFont().isFontBold());
        this.getUILegendText().getUIGraphFont().setFontItalic(graph.getUILegendText().getUIGraphFont().isFontItalic());
        this.getUILegendText().getUIGraphFont().setUnderline(graph.getUILegendText().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUILegendText().getUIGraphFont().setGraphFontColor(graph.getUILegendText().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUILegendText().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUILegendText().setHorizontalAlignment(graph.getUILegendText().getHorizontalAlignment());
        ((UILegendTextAdapter)this.getUILegendText()).setHorizontalAlignmentChanged(false);
        this.getUI3DFloor().setSharePanelProperties(true);
        this.getUI3DFloor().setFillColor(graph.getUI3DFloor().getFillColor());
        ((UIBase3DPanelAdapter)this.getUI3DFloor()).setFillColorChanged(false);
        this.getUI3DFloor().setBorderColor(graph.getUI3DFloor().getBorderColor());
        ((UIBase3DPanelAdapter)this.getUI3DFloor()).setBorderColorChanged(false);
        this.getUI3DFloor().setBorderTransparent(graph.getUI3DFloor().isBorderTransparent());
        ((UIBase3DPanelAdapter)this.getUI3DFloor()).setBorderTransparentChanged(false);
        this.getUI3DFloor().setSharePanelProperties(graph.getUI3DFloor().isSharePanelProperties());
        ((UIBase3DPanelAdapter)this.getUI3DFloor()).setSharePanelPropertiesChanged(false);
        this.getUIPieFrame().setFillColor(graph.getUIPieFrame().getFillColor());
        ((UIBaseFrameAdapter)this.getUIPieFrame()).setFillColorChanged(false);
        this.getUIPieFrame().setFillTransparent(graph.getUIPieFrame().isFillTransparent());
        ((UIBaseFrameAdapter)this.getUIPieFrame()).setFillTransparentChanged(false);
        this.getUIPieFrame().setBorderColor(graph.getUIPieFrame().getBorderColor());
        ((UIBaseFrameAdapter)this.getUIPieFrame()).setBorderColorChanged(false);
        this.getUIPieFrame().setBorderTransparent(graph.getUIPieFrame().isBorderTransparent());
        ((UIBaseFrameAdapter)this.getUIPieFrame()).setBorderTransparentChanged(false);
        this.getUISlice().setLabelPosition(graph.getUISlice().getLabelPosition());
        ((LabelPositionAdapter)this.getUISlice()).setLabelPositionChanged(false);
        this.getUIPlotArea().setFillColor(graph.getUIPlotArea().getFillColor());
        ((UIBaseFrameAdapter)this.getUIPlotArea()).setFillColorChanged(false);
        this.getUIPlotArea().setFillTransparent(graph.getUIPlotArea().isFillTransparent());
        ((UIBaseFrameAdapter)this.getUIPlotArea()).setFillTransparentChanged(false);
        this.getUIPlotArea().setBorderColor(graph.getUIPlotArea().getBorderColor());
        ((UIBaseFrameAdapter)this.getUIPlotArea()).setBorderColorChanged(false);
        this.getUIPlotArea().setBorderTransparent(graph.getUIPlotArea().isBorderTransparent());
        ((UIBaseFrameAdapter)this.getUIPlotArea()).setBorderTransparentChanged(false);
        this.getUIY1MajorTick().setVisible(graph.getUIY1MajorTick().isVisible());
        ((MajorTickAdapter)this.getUIY1MajorTick()).setVisibleChanged(false);
        this.getUIY1MajorTick().setLineWidth(graph.getUIY1MajorTick().getLineWidth());
        ((MajorTickAdapter)this.getUIY1MajorTick()).setLineWidthChanged(false);
        this.getUIY1MajorTick().setLineColor(graph.getUIY1MajorTick().getLineColor());
        ((MajorTickAdapter)this.getUIY1MajorTick()).setLineColorChanged(false);
        this.getUIY1MajorTick().setTickStyle(graph.getUIY1MajorTick().getTickStyle());
        ((MajorTickAdapter)this.getUIY1MajorTick()).setTickStyleChanged(false);
        this.getUIY2MajorTick().setVisible(graph.getUIY2MajorTick().isVisible());
        ((MajorTickAdapter)this.getUIY2MajorTick()).setVisibleChanged(false);
        this.getUIY2MajorTick().setLineWidth(graph.getUIY2MajorTick().getLineWidth());
        ((MajorTickAdapter)this.getUIY2MajorTick()).setLineWidthChanged(false);
        this.getUIY2MajorTick().setLineColor(graph.getUIY2MajorTick().getLineColor());
        ((MajorTickAdapter)this.getUIY2MajorTick()).setLineColorChanged(false);
        this.getUIY2MajorTick().setTickStyle(graph.getUIY2MajorTick().getTickStyle());
        ((MajorTickAdapter)this.getUIY2MajorTick()).setTickStyleChanged(false);
        this.getUIX1MajorTick().setVisible(graph.getUIX1MajorTick().isVisible());
        ((MajorTickAdapter)this.getUIX1MajorTick()).setVisibleChanged(false);
        this.getUIX1MajorTick().setLineWidth(graph.getUIX1MajorTick().getLineWidth());
        ((MajorTickAdapter)this.getUIX1MajorTick()).setLineWidthChanged(false);
        this.getUIX1MajorTick().setLineColor(graph.getUIX1MajorTick().getLineColor());
        ((MajorTickAdapter)this.getUIX1MajorTick()).setLineColorChanged(false);
        this.getUIX1MajorTick().setTickStyle(graph.getUIX1MajorTick().getTickStyle());
        ((MajorTickAdapter)this.getUIX1MajorTick()).setTickStyleChanged(false);
        this.getUIO1MajorTick().setVisible(graph.getUIO1MajorTick().isVisible());
        ((MajorTickAdapter)this.getUIO1MajorTick()).setVisibleChanged(false);
        this.getUIO1MajorTick().setLineWidth(graph.getUIO1MajorTick().getLineWidth());
        ((MajorTickAdapter)this.getUIO1MajorTick()).setLineWidthChanged(false);
        this.getUIO1MajorTick().setLineColor(graph.getUIO1MajorTick().getLineColor());
        ((MajorTickAdapter)this.getUIO1MajorTick()).setLineColorChanged(false);
        this.getUIO1MajorTick().setTickStyle(graph.getUIO1MajorTick().getTickStyle());
        ((MajorTickAdapter)this.getUIO1MajorTick()).setTickStyleChanged(false);
        this.getUIMarkerText().setVisible(graph.getUIMarkerText().isVisible());
        ((UIMarkerTextAdapter)this.getUIMarkerText()).setVisibleChanged(false);
        this.getUIMarkerText().setMarkerTextPlace(graph.getUIMarkerText().getMarkerTextPlace());
        ((UIMarkerTextAdapter)this.getUIMarkerText()).setMarkerTextPlaceChanged(false);
        this.getUIMarkerText().getUIGraphFont().setGraphFontTypeface(graph.getUIMarkerText().getUIGraphFont().getGraphFontTypeface());
        this.getUIMarkerText().getUIGraphFont().setGraphFontSize(graph.getUIMarkerText().getUIGraphFont().getGraphFontSize());
        this.getUIMarkerText().getUIGraphFont().setFontBold(graph.getUIMarkerText().getUIGraphFont().isFontBold());
        this.getUIMarkerText().getUIGraphFont().setFontItalic(graph.getUIMarkerText().getUIGraphFont().isFontItalic());
        this.getUIMarkerText().getUIGraphFont().setUnderline(graph.getUIMarkerText().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIMarkerText().getUIGraphFont().setGraphFontColor(graph.getUIMarkerText().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIMarkerText().getUIGraphFont()).setGraphFontColorChanged(false);
        this.setMarkerTooltipType(graph.getMarkerTooltipType());
        this.setMarkerTooltipTypeChanged(false);
        this.getUISliceLabel().getUIGraphFont().setGraphFontTypeface(graph.getUISliceLabel().getUIGraphFont().getGraphFontTypeface());
        this.getUISliceLabel().getUIGraphFont().setGraphFontSize(graph.getUISliceLabel().getUIGraphFont().getGraphFontSize());
        this.getUISliceLabel().getUIGraphFont().setFontBold(graph.getUISliceLabel().getUIGraphFont().isFontBold());
        this.getUISliceLabel().getUIGraphFont().setFontItalic(graph.getUISliceLabel().getUIGraphFont().isFontItalic());
        this.getUISliceLabel().getUIGraphFont().setUnderline(graph.getUISliceLabel().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUISliceLabel().getUIGraphFont().setGraphFontColor(graph.getUISliceLabel().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUISliceLabel().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUISliceLabel().setTextType(graph.getUISliceLabel().getTextType());
        ((UISliceLabelAdapter)this.getUISliceLabel()).setTextTypeChanged(false);
        this.setSeriesTooltipLabelType(graph.getSeriesTooltipLabelType());
        this.setSeriesTooltipLabelTypeChanged(false);
        this.setGroupTooltipLabelType(graph.getGroupTooltipLabelType());
        this.setGroupTooltipLabelTypeChanged(false);
        try {
            this.getUISeries().setDefaultColor(graph.getUISeries().getDefaultColor());
            ((UISeriesAdapter)this.getUISeries()).setDefaultColorChanged(false);
            this.getUISeries().setDefaultLineWidth(graph.getUISeries().getDefaultLineWidth());
            ((UISeriesAdapter)this.getUISeries()).setDefaultLineWidthChanged(false);
            this.getUISeries().setDefaultMarkerShape(graph.getUISeries().getDefaultMarkerShape());
            ((UISeriesAdapter)this.getUISeries()).setDefaultMarkerShapeChanged(false);
            this.getUISeries().setDefaultAssignedToY2(graph.getUISeries().getDefaultAssignedToY2());
            ((UISeriesAdapter)this.getUISeries()).setDefaultAssignedToY2Changed(false);
            this.getUISeries().setDefaultMarkerType(graph.getUISeries().getDefaultMarkerType());
            ((UISeriesAdapter)this.getUISeries()).setDefaultMarkerTypeChanged(false);
            this.getUISeries().setDefaultFitlineType(graph.getUISeries().getDefaultFitlineType());
            ((UISeriesAdapter)this.getUISeries()).setDefaultFitlineTypeChanged(false);
            int n = 0;
            while (n < this.m_seriesObjectCount) {
                this.getUISeries().setColor(graph.getUISeries().getColor(n), n);
                ((UISeriesAdapter)this.getUISeries()).setColorChanged(false, n);
                this.getUISeries().setLineWidth(graph.getUISeries().getLineWidth(n), n);
                ((UISeriesAdapter)this.getUISeries()).setLineWidthChanged(false, n);
                this.getUISeries().setMarkerShape(graph.getUISeries().getMarkerShape(n), n);
                ((UISeriesAdapter)this.getUISeries()).setMarkerShapeChanged(false, n);
                this.getUISeries().setAssignedToY2(graph.getUISeries().isAssignedToY2(n), n);
                ((UISeriesAdapter)this.getUISeries()).setAssignedToY2Changed(false, n);
                this.getUISeries().setMarkerType(graph.getUISeries().getMarkerType(n), n);
                ((UISeriesAdapter)this.getUISeries()).setMarkerTypeChanged(false, n);
                this.getUISeries().setFitlineType(graph.getUISeries().getFitlineType(n), n);
                ((UISeriesAdapter)this.getUISeries()).setFitlineTypeChanged(false, n);
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        ((UITitleAdapter)this.getUIO1Title()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUIO1Title().setText(graph.getUIO1Title().getUnParseText());
        ((UITitleAdapter)this.getUIO1Title()).setTextChanged(false);
        this.getUIO1Title().setVisible(graph.getUIO1Title().isVisible());
        ((UITitleAdapter)this.getUIO1Title()).setVisibleChanged(false);
        this.getUIO1Title().getUIGraphFont().setGraphFontTypeface(graph.getUIO1Title().getUIGraphFont().getGraphFontTypeface());
        this.getUIO1Title().getUIGraphFont().setGraphFontSize(graph.getUIO1Title().getUIGraphFont().getGraphFontSize());
        this.getUIO1Title().getUIGraphFont().setFontBold(graph.getUIO1Title().getUIGraphFont().isFontBold());
        this.getUIO1Title().getUIGraphFont().setFontItalic(graph.getUIO1Title().getUIGraphFont().isFontItalic());
        this.getUIO1Title().getUIGraphFont().setUnderline(graph.getUIO1Title().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIO1Title().getUIGraphFont().setGraphFontColor(graph.getUIO1Title().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIO1Title().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIO1Title().setHorizontalAlignment(graph.getUIO1Title().getHorizontalAlignment());
        ((UITitleAdapter)this.getUIO1Title()).setHorizontalAlignmentChanged(false);
        this.getUIO1Title().setTextRotation(graph.getUIO1Title().getTextRotation());
        ((UITitleAdapter)this.getUIO1Title()).setTextRotationChanged(false);
        this.getUIO1Axis().setLineWidth(graph.getUIO1Axis().getLineWidth());
        ((UIO1AxisAdapter)this.getUIO1Axis()).setLineWidthChanged(false);
        this.getUIO1Axis().setLineColor(graph.getUIO1Axis().getLineColor());
        ((UIO1AxisAdapter)this.getUIO1Axis()).setLineColorChanged(false);
        this.getUIO1Axis().setVisible(graph.getUIO1Axis().isVisible());
        ((UIO1AxisAdapter)this.getUIO1Axis()).setVisibleChanged(false);
        this.getUIO1TickLabel().setTickLabelSkipCount(graph.getUIO1TickLabel().getTickLabelSkipCount());
        ((UITickLabelAdapter)this.getUIO1TickLabel()).setTickLabelSkipCountChanged(false);
        this.getUIO1TickLabel().setTickLabelSkipFirst(graph.getUIO1TickLabel().getTickLabelSkipFirst());
        ((UITickLabelAdapter)this.getUIO1TickLabel()).setTickLabelSkipFirstChanged(false);
        this.getUIO1TickLabel().setTickLabelSkipMode(graph.getUIO1TickLabel().getTickLabelSkipMode());
        ((UITickLabelAdapter)this.getUIO1TickLabel()).setTickLabelSkipModeChanged(false);
        this.getUIO1TickLabel().getUIGraphFont().setGraphFontTypeface(graph.getUIO1TickLabel().getUIGraphFont().getGraphFontTypeface());
        this.getUIO1TickLabel().getUIGraphFont().setGraphFontSize(graph.getUIO1TickLabel().getUIGraphFont().getGraphFontSize());
        this.getUIO1TickLabel().getUIGraphFont().setFontBold(graph.getUIO1TickLabel().getUIGraphFont().isFontBold());
        this.getUIO1TickLabel().getUIGraphFont().setFontItalic(graph.getUIO1TickLabel().getUIGraphFont().isFontItalic());
        this.getUIO1TickLabel().getUIGraphFont().setUnderline(graph.getUIO1TickLabel().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIO1TickLabel().getUIGraphFont().setGraphFontColor(graph.getUIO1TickLabel().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIO1TickLabel().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIO1TickLabel().setAutomaticRotation(graph.getUIO1TickLabel().getAutomaticRotation());
        ((UITickLabelAdapter)this.getUIO1TickLabel()).setAutomaticRotationChanged(false);
        this.getUIO1TickLabel().setTextRotation(graph.getUIO1TickLabel().getTextRotation());
        ((UITickLabelAdapter)this.getUIO1TickLabel()).setTextRotationChanged(false);
        ((UITitleAdapter)this.getUIX1Title()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUIX1Title().setText(graph.getUIX1Title().getUnParseText());
        ((UITitleAdapter)this.getUIX1Title()).setTextChanged(false);
        this.getUIX1Title().setVisible(graph.getUIX1Title().isVisible());
        ((UITitleAdapter)this.getUIX1Title()).setVisibleChanged(false);
        this.getUIX1Title().getUIGraphFont().setGraphFontTypeface(graph.getUIX1Title().getUIGraphFont().getGraphFontTypeface());
        this.getUIX1Title().getUIGraphFont().setGraphFontSize(graph.getUIX1Title().getUIGraphFont().getGraphFontSize());
        this.getUIX1Title().getUIGraphFont().setFontBold(graph.getUIX1Title().getUIGraphFont().isFontBold());
        this.getUIX1Title().getUIGraphFont().setFontItalic(graph.getUIX1Title().getUIGraphFont().isFontItalic());
        this.getUIX1Title().getUIGraphFont().setUnderline(graph.getUIX1Title().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontSizeChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontStyleChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontSizeChanged(false);
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        this.getUIX1Title().getUIGraphFont().setGraphFontColor(graph.getUIX1Title().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIX1Title().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIX1Title().setTextRotation(graph.getUIX1Title().getTextRotation());
        ((UITitleAdapter)this.getUIX1Title()).setTextRotationChanged(false);
        this.getUIX1Title().setHorizontalAlignment(graph.getUIX1Title().getHorizontalAlignment());
        ((UITitleAdapter)this.getUIX1Title()).setHorizontalAlignmentChanged(false);
        this.getUIX1Axis().setLineWidth(graph.getUIX1Axis().getLineWidth());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setLineWidthChanged(false);
        this.getUIX1Axis().setVisible(graph.getUIX1Axis().isVisible());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setVisibleChanged(false);
        this.getUIX1Axis().setLineColor(graph.getUIX1Axis().getLineColor());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setLineColorChanged(false);
        this.getUIX1Axis().setMajorTickStepAutomatic(graph.getUIX1Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIX1Axis().setAxisMaxAutoScaled(graph.getUIX1Axis().isAxisMaxAutoScaled());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMaxAutoScaledChanged(false);
        this.getUIX1Axis().setAxisMinAutoScaled(graph.getUIX1Axis().isAxisMinAutoScaled());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMinAutoScaledChanged(false);
        this.getUIX1Axis().setAxisMinValue(graph.getUIX1Axis().getAxisMinValue());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMinValueChanged(false);
        this.getUIX1Axis().setAxisMaxValue(graph.getUIX1Axis().getAxisMaxValue());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMaxValueChanged(false);
        this.getUIX1Axis().setMajorTickStep(graph.getUIX1Axis().getMajorTickStep());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setMajorTickStepChanged(false);
        this.getUIX1Axis().setMajorTickStepAutomatic(graph.getUIX1Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIX1Axis().setScaledLogarithmic(graph.getUIX1Axis().isScaledLogarithmic());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setScaledLogarithmicChanged(false);
        this.getUIX1Axis().setLogarithmicBase(graph.getUIX1Axis().getLogarithmicBase());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setLogarithmicBaseChanged(false);
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMaxAutoValue(graph.getUIX1Axis().getAxisMaxAutoValue());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAxisMinAutoValue(graph.getUIX1Axis().getAxisMinAutoValue());
        ((UIDataAxisAdapter)this.getUIX1Axis()).setAutoMajorTickStep(graph.getUIX1Axis().getAutoMajorTickStep());
        this.getUIDataX1TickLabel().getUIGraphFont().setGraphFontTypeface(graph.getUIDataX1TickLabel().getUIGraphFont().getGraphFontTypeface());
        this.getUIDataX1TickLabel().getUIGraphFont().setGraphFontSize(graph.getUIDataX1TickLabel().getUIGraphFont().getGraphFontSize());
        this.getUIDataX1TickLabel().getUIGraphFont().setFontBold(graph.getUIDataX1TickLabel().getUIGraphFont().isFontBold());
        this.getUIDataX1TickLabel().getUIGraphFont().setFontItalic(graph.getUIDataX1TickLabel().getUIGraphFont().isFontItalic());
        this.getUIDataX1TickLabel().getUIGraphFont().setUnderline(graph.getUIDataX1TickLabel().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIDataX1TickLabel().getUIGraphFont().setGraphFontColor(graph.getUIDataX1TickLabel().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIDataX1TickLabel().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIDataX1TickLabel().setTextRotation(graph.getUIDataX1TickLabel().getTextRotation());
        ((UIDataTickLabelAdapter)this.getUIDataX1TickLabel()).setTextRotationChanged(false);
        ((UITitleAdapter)this.getUIY1Title()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUIY1Title().setText(graph.getUIY1Title().getUnParseText());
        ((UITitleAdapter)this.getUIY1Title()).setTextChanged(false);
        this.getUIY1Title().setVisible(graph.getUIY1Title().isVisible());
        ((UITitleAdapter)this.getUIY1Title()).setVisibleChanged(false);
        this.getUIY1Title().getUIGraphFont().setGraphFontTypeface(graph.getUIY1Title().getUIGraphFont().getGraphFontTypeface());
        this.getUIY1Title().getUIGraphFont().setGraphFontSize(graph.getUIY1Title().getUIGraphFont().getGraphFontSize());
        this.getUIY1Title().getUIGraphFont().setFontBold(graph.getUIY1Title().getUIGraphFont().isFontBold());
        this.getUIY1Title().getUIGraphFont().setFontItalic(graph.getUIY1Title().getUIGraphFont().isFontItalic());
        this.getUIY1Title().getUIGraphFont().setUnderline(graph.getUIY1Title().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIY1Title().getUIGraphFont().setGraphFontColor(graph.getUIY1Title().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIY1Title().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIY1Title().setTextRotation(graph.getUIY1Title().getTextRotation());
        ((UITitleAdapter)this.getUIY1Title()).setTextRotationChanged(false);
        this.getUIY1Title().setHorizontalAlignment(graph.getUIY1Title().getHorizontalAlignment());
        ((UITitleAdapter)this.getUIY1Title()).setHorizontalAlignmentChanged(false);
        this.getUIY1Axis().setLineWidth(graph.getUIY1Axis().getLineWidth());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setLineWidthChanged(false);
        this.getUIY1Axis().setVisible(graph.getUIY1Axis().isVisible());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setVisibleChanged(false);
        this.getUIY1Axis().setLineColor(graph.getUIY1Axis().getLineColor());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setLineColorChanged(false);
        this.getUIY1Axis().setMajorTickStepAutomatic(graph.getUIY1Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIY1Axis().setAxisMaxAutoScaled(graph.getUIY1Axis().isAxisMaxAutoScaled());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMaxAutoScaledChanged(false);
        this.getUIY1Axis().setAxisMinAutoScaled(graph.getUIY1Axis().isAxisMinAutoScaled());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMinAutoScaledChanged(false);
        this.getUIY1Axis().setAxisMinValue(graph.getUIY1Axis().getAxisMinValue());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMinValueChanged(false);
        this.getUIY1Axis().setAxisMaxValue(graph.getUIY1Axis().getAxisMaxValue());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMaxValueChanged(false);
        this.getUIY1Axis().setMajorTickStep(graph.getUIY1Axis().getMajorTickStep());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setMajorTickStepChanged(false);
        this.getUIY1Axis().setMajorTickStepAutomatic(graph.getUIY1Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIY1Axis().setScaledLogarithmic(graph.getUIY1Axis().isScaledLogarithmic());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setScaledLogarithmicChanged(false);
        this.getUIY1Axis().setLogarithmicBase(graph.getUIY1Axis().getLogarithmicBase());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setLogarithmicBaseChanged(false);
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMaxAutoValue(graph.getUIY1Axis().getAxisMaxAutoValue());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAxisMinAutoValue(graph.getUIY1Axis().getAxisMinAutoValue());
        ((UIDataAxisAdapter)this.getUIY1Axis()).setAutoMajorTickStep(graph.getUIY1Axis().getAutoMajorTickStep());
        this.getUIDataY1TickLabel().getUIGraphFont().setGraphFontTypeface(graph.getUIDataY1TickLabel().getUIGraphFont().getGraphFontTypeface());
        this.getUIDataY1TickLabel().getUIGraphFont().setGraphFontSize(graph.getUIDataY1TickLabel().getUIGraphFont().getGraphFontSize());
        this.getUIDataY1TickLabel().getUIGraphFont().setFontBold(graph.getUIDataY1TickLabel().getUIGraphFont().isFontBold());
        this.getUIDataY1TickLabel().getUIGraphFont().setFontItalic(graph.getUIDataY1TickLabel().getUIGraphFont().isFontItalic());
        this.getUIDataY1TickLabel().getUIGraphFont().setUnderline(graph.getUIDataY1TickLabel().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIDataY1TickLabel().getUIGraphFont().setGraphFontColor(graph.getUIDataY1TickLabel().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIDataY1TickLabel().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIDataY1TickLabel().setTextRotation(graph.getUIDataY1TickLabel().getTextRotation());
        ((UIDataTickLabelAdapter)this.getUIDataY1TickLabel()).setTextRotationChanged(false);
        ((UITitleAdapter)this.getUIY2Title()).setTokenSubstitution(this.getTokenSubstitution());
        this.getUIY2Title().setText(graph.getUIY2Title().getUnParseText());
        ((UITitleAdapter)this.getUIY2Title()).setTextChanged(false);
        this.getUIY2Title().setVisible(graph.getUIY2Title().isVisible());
        ((UITitleAdapter)this.getUIY2Title()).setVisibleChanged(false);
        this.getUIY2Title().getUIGraphFont().setGraphFontTypeface(graph.getUIY2Title().getUIGraphFont().getGraphFontTypeface());
        this.getUIY2Title().getUIGraphFont().setGraphFontSize(graph.getUIY2Title().getUIGraphFont().getGraphFontSize());
        this.getUIY2Title().getUIGraphFont().setFontBold(graph.getUIY2Title().getUIGraphFont().isFontBold());
        this.getUIY2Title().getUIGraphFont().setFontItalic(graph.getUIY2Title().getUIGraphFont().isFontItalic());
        this.getUIY2Title().getUIGraphFont().setUnderline(graph.getUIY2Title().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIY2Title().getUIGraphFont().setGraphFontColor(graph.getUIY2Title().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIY2Title().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIY2Title().setTextRotation(graph.getUIY2Title().getTextRotation());
        ((UITitleAdapter)this.getUIY2Title()).setTextRotationChanged(false);
        this.getUIY2Title().setHorizontalAlignment(graph.getUIY2Title().getHorizontalAlignment());
        ((UITitleAdapter)this.getUIY2Title()).setHorizontalAlignmentChanged(false);
        this.getUIY2Axis().setLineWidth(graph.getUIY2Axis().getLineWidth());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setLineWidthChanged(false);
        this.getUIY2Axis().setVisible(graph.getUIY2Axis().isVisible());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setVisibleChanged(false);
        this.getUIY2Axis().setLineColor(graph.getUIY2Axis().getLineColor());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setLineColorChanged(false);
        this.getUIY2Axis().setMajorTickStepAutomatic(graph.getUIY2Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIY2Axis().setAxisMaxAutoScaled(graph.getUIY2Axis().isAxisMaxAutoScaled());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMaxAutoScaledChanged(false);
        this.getUIY2Axis().setAxisMinAutoScaled(graph.getUIY2Axis().isAxisMinAutoScaled());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMinAutoScaledChanged(false);
        this.getUIY2Axis().setAxisMinValue(graph.getUIY2Axis().getAxisMinValue());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMinValueChanged(false);
        this.getUIY2Axis().setAxisMaxValue(graph.getUIY2Axis().getAxisMaxValue());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMaxValueChanged(false);
        this.getUIY2Axis().setMajorTickStep(graph.getUIY2Axis().getMajorTickStep());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setMajorTickStepChanged(false);
        this.getUIY2Axis().setMajorTickStepAutomatic(graph.getUIY2Axis().isMajorTickStepAutomatic());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setMajorTickStepAutomaticChanged(false);
        this.getUIY2Axis().setScaledLogarithmic(graph.getUIY2Axis().isScaledLogarithmic());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setScaledLogarithmicChanged(false);
        this.getUIY2Axis().setLogarithmicBase(graph.getUIY2Axis().getLogarithmicBase());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setLogarithmicBaseChanged(false);
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMaxAutoValue(graph.getUIY2Axis().getAxisMaxAutoValue());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAxisMinAutoValue(graph.getUIY2Axis().getAxisMinAutoValue());
        ((UIDataAxisAdapter)this.getUIY2Axis()).setAutoMajorTickStep(graph.getUIY2Axis().getAutoMajorTickStep());
        this.getUIDataY2TickLabel().getUIGraphFont().setGraphFontTypeface(graph.getUIDataY2TickLabel().getUIGraphFont().getGraphFontTypeface());
        this.getUIDataY2TickLabel().getUIGraphFont().setGraphFontSize(graph.getUIDataY2TickLabel().getUIGraphFont().getGraphFontSize());
        this.getUIDataY2TickLabel().getUIGraphFont().setFontBold(graph.getUIDataY2TickLabel().getUIGraphFont().isFontBold());
        this.getUIDataY2TickLabel().getUIGraphFont().setFontItalic(graph.getUIDataY2TickLabel().getUIGraphFont().isFontItalic());
        this.getUIDataY2TickLabel().getUIGraphFont().setUnderline(graph.getUIDataY2TickLabel().getUIGraphFont().isUnderline());
        ((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).setFontBoldChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).setFontItalicChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).setUnderlineChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).setGraphFontTypefaceChanged(false);
        ((UIGraphFontAdapter)this.getUIDataY2TickLabel().getUIGraphFont()).setGraphFontSizeChanged(false);
        this.getUIDataY2TickLabel().getUIGraphFont().setGraphFontColor(graph.getUIDataY2TickLabel().getUIGraphFont().getGraphFontColor());
        ((UIGraphFontAdapter)this.getUIY2TickLabel().getUIGraphFont()).setGraphFontColorChanged(false);
        this.getUIDataY2TickLabel().setTextRotation(graph.getUIDataY2TickLabel().getTextRotation());
        ((UIDataTickLabelAdapter)this.getUIDataY2TickLabel()).setTextRotationChanged(false);
        this.getParetoLine().setColor(graph.getParetoLine().getColor());
        ((UIParetoLineAdapter)this.getParetoLine()).setColorChanged(false);
        this.getParetoLine().setWidth(graph.getParetoLine().getWidth());
        ((UIParetoLineAdapter)this.getParetoLine()).setWidthChanged(false);
        this.getParetoLine().setMarkerShape(graph.getParetoLine().getMarkerShape());
        ((UIParetoLineAdapter)this.getParetoLine()).setMarkerShapeChanged(false);
        this.getUIY1Baseline().setValue(graph.getUIY1Baseline().getValue());
        ((UIAssignedValueAdapter)this.getUIY1Baseline()).setValueChanged(false);
        this.getUIY2Baseline().setValue(graph.getUIY2Baseline().getValue());
        ((UIAssignedValueAdapter)this.getUIY2Baseline()).setValueChanged(false);
        int n = 0;
        while (n < 3) {
            this.getUIX1ReferenceLine().setDisplayedInLegend(graph.getUIX1ReferenceLine().isDisplayedInLegend(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setDisplayedInLegendChanged(false, n);
            this.getUIX1ReferenceLine().setLineColor(graph.getUIX1ReferenceLine().getLineColor(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setLineColorChanged(false, n);
            this.getUIX1ReferenceLine().setLineWidth(graph.getUIX1ReferenceLine().getLineWidth(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setLineWidthChanged(false, n);
            this.getUIX1ReferenceLine().setText(graph.getUIX1ReferenceLine().getText(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setTextChanged(false, n);
            this.getUIX1ReferenceLine().setValue(graph.getUIX1ReferenceLine().getValue(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setValueChanged(false, n);
            this.getUIX1ReferenceLine().setVisible(graph.getUIX1ReferenceLine().isVisible(n), n);
            ((UIReferenceLineAdapter)this.getUIX1ReferenceLine()).setVisibleChanged(false, n);
            this.getUIY1ReferenceLine().setDisplayedInLegend(graph.getUIY1ReferenceLine().isDisplayedInLegend(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setDisplayedInLegendChanged(false, n);
            this.getUIY1ReferenceLine().setLineColor(graph.getUIY1ReferenceLine().getLineColor(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setLineColorChanged(false, n);
            this.getUIY1ReferenceLine().setLineWidth(graph.getUIY1ReferenceLine().getLineWidth(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setLineWidthChanged(false, n);
            this.getUIY1ReferenceLine().setText(graph.getUIY1ReferenceLine().getText(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setTextChanged(false, n);
            this.getUIY1ReferenceLine().setValue(graph.getUIY1ReferenceLine().getValue(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setValueChanged(false, n);
            this.getUIY1ReferenceLine().setVisible(graph.getUIY1ReferenceLine().isVisible(n), n);
            ((UIReferenceLineAdapter)this.getUIY1ReferenceLine()).setVisibleChanged(false, n);
            this.getUIY2ReferenceLine().setDisplayedInLegend(graph.getUIY2ReferenceLine().isDisplayedInLegend(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setDisplayedInLegendChanged(false, n);
            this.getUIY2ReferenceLine().setLineColor(graph.getUIY2ReferenceLine().getLineColor(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setLineColorChanged(false, n);
            this.getUIY2ReferenceLine().setLineWidth(graph.getUIY2ReferenceLine().getLineWidth(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setLineWidthChanged(false, n);
            this.getUIY2ReferenceLine().setText(graph.getUIY2ReferenceLine().getText(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setTextChanged(false, n);
            this.getUIY2ReferenceLine().setValue(graph.getUIY2ReferenceLine().getValue(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setValueChanged(false, n);
            this.getUIY2ReferenceLine().setVisible(graph.getUIY2ReferenceLine().isVisible(n), n);
            ((UIReferenceLineAdapter)this.getUIY2ReferenceLine()).setVisibleChanged(false, n);
            ++n;
        }
        this.setTimeAxisDateFormat(0, graph.getTimeAxisDateFormat(0));
        this.setTimeAxisDateFormatChanged(false, 0);
        this.setTimeAxisDateFormat(1, graph.getTimeAxisDateFormat(1));
        this.setTimeAxisDateFormatChanged(false, 1);
        this.setTimeAxisDateFormat(2, graph.getTimeAxisDateFormat(2));
        this.setTimeAxisDateFormatChanged(false, 2);
        this.setTimeAxisDateFormat(3, graph.getTimeAxisDateFormat(3));
        this.setTimeAxisDateFormatChanged(false, 3);
        this.m_dataFilter.setTotalMeasures(((DataFilterImpl)graph.getDataFilter()).getTotalMeasures());
        this.m_dataFilter.initMeasuresFromGraph(graph);
        this.m_dataFilter.setGraphType(graph.getGraphType());
        this.m_dataFilter.setDataRowShownAsASeries(graph.isDataRowShownAsASeries());
        this.m_timeAxisData = 0;
        this.m_propertyChangedFlags = new BitSet(13);
    }

    public void setDataRowShownAsASeries(boolean bl) {
        this.setDataRowShownAsASeriesChanged(true);
        this.m_dataRowShownAsASeries = bl;
    }

    public boolean isDataRowShownAsASeries() {
        return this.m_dataRowShownAsASeries;
    }

    public int getColumnCount() throws EdgeOutOfRangeException {
        return this.m_dataFilter.getColumns();
    }

    public int getRowCount() throws EdgeOutOfRangeException {
        return this.m_dataFilter.getRows();
    }

    public Object getDataAccessSliceLabel(int n, int n2, String string) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        if (this.m_dataAccess == null) {
            return null;
        }
        return this.m_dataAccess.getSliceLabel(n, n2, string);
    }

    public void setGraphType(int n) {
        this.setGraphTypeChanged(true);
        this.m_dataFilter.setGraphType(n);
        this.m_graphType = n;
    }

    public int getGraphType() {
        return this.m_graphType;
    }

    public void setSeriesTooltipLabelType(int n) {
        this.setSeriesTooltipLabelTypeChanged(true);
        this.m_seriesTooltipLabelType = n;
    }

    public int getSeriesTooltipLabelType() {
        return this.m_seriesTooltipLabelType;
    }

    public void setGroupTooltipLabelType(int n) {
        this.setGroupTooltipLabelTypeChanged(true);
        this.m_groupTooltipLabelType = n;
    }

    public int getGroupTooltipLabelType() {
        return this.m_groupTooltipLabelType;
    }

    public void setMarkerTooltipType(int n) {
        this.setMarkerTooltipTypeChanged(true);
        this.m_markerTooltipType = n;
    }

    public int getMarkerTooltipType() {
        return this.m_markerTooltipType;
    }

    public int getAutoLayout() {
        return this.m_autoLayout;
    }

    private void setAutoLayout(int n) {
        this.m_autoLayout = n;
    }

    public void setLineDataLineDisplayed(boolean bl) {
        this.setLineDataLineDisplayedChanged(true);
        this.m_dataLineDisplayed = bl;
    }

    public boolean isLineDataLineDisplayed() {
        return this.m_dataLineDisplayed;
    }

    public void setTokenSubstitution(TokenSubstitution tokenSubstitution) {
        super.setTokenSubstitution(tokenSubstitution);
        this.setTokenSubstitutionChanged(true);
    }

    public UITitle getUITitle() {
        return this.m_title;
    }

    public UITitle getUISubtitle() {
        return this.m_subtitle;
    }

    public UITitle getUIFootnote() {
        return this.m_footnote;
    }

    public MajorTick getUIY1MajorTick() {
        return this.m_Y1Tick;
    }

    public MajorTick getUIX1MajorTick() {
        return this.m_X1Tick;
    }

    public MajorTick getUIY2MajorTick() {
        return this.m_Y2Tick;
    }

    public MajorTick getUIO1MajorTick() {
        return this.m_O1Tick;
    }

    public UITitle getUIO1Title() {
        return this.m_O1Title;
    }

    public UIO1Axis getUIO1Axis() {
        return this.m_O1Axis;
    }

    public UITickLabel getUIO1TickLabel() {
        return this.m_O1TickLabel;
    }

    public UITitle getUIX1Title() {
        return this.m_X1Title;
    }

    public UIDataAxis getUIX1Axis() {
        return this.m_X1Axis;
    }

    public UITitle getUIY2Title() {
        return this.m_Y2Title;
    }

    public UIDataAxis getUIY2Axis() {
        return this.m_Y2Axis;
    }

    public UITitle getUIY1Title() {
        return this.m_Y1Title;
    }

    public UIDataAxis getUIY1Axis() {
        return this.m_Y1Axis;
    }

    public UIGraphFontAttribute getUIX1TickLabel() {
        return this.m_X1DataTickLabel;
    }

    public UIDataTickLabel getUIDataX1TickLabel() {
        return this.m_X1DataTickLabel;
    }

    public UIGraphFontAttribute getUIY1TickLabel() {
        return this.m_Y1DataTickLabel;
    }

    public UIDataTickLabel getUIDataY1TickLabel() {
        return this.m_Y1DataTickLabel;
    }

    public UIGraphFontAttribute getUIY2TickLabel() {
        return this.m_Y2DataTickLabel;
    }

    public UIDataTickLabel getUIDataY2TickLabel() {
        return this.m_Y2DataTickLabel;
    }

    public UILegendArea getUILegendArea() {
        return this.m_legendArea;
    }

    public UILegendText getUILegendText() {
        return this.m_legendText;
    }

    public UIBaseFrame getUIPlotArea() {
        return this.m_plotArea;
    }

    public UIBase3DPanel getUI3DFloor() {
        return this.m_3DFloor;
    }

    public UIBaseFrame getUIPieFrame() {
        return this.m_pieFrame;
    }

    public LabelPosition getUISlice() {
        return this.m_slice;
    }

    public UIMarkerText getUIMarkerText() {
        return this.m_markerText;
    }

    public UISliceLabel getUISliceLabel() {
        return this.m_sliceLabel;
    }

    public UISeries getUISeries() {
        return this.m_series;
    }

    public GraphTypeConverter getGraphTypeConverter() {
        return this.m_converter;
    }

    public void setGraphTypeConverter(GraphTypeConverter graphTypeConverter) {
        this.m_converter = graphTypeConverter;
    }

    public boolean isHorizontal() {
        switch (this.getGraphType()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    public boolean isO1AxisSupported() {
        return !(this.m_graphType >= 55 && this.m_graphType <= 66 || this.m_graphType >= 85 && this.m_graphType <= 87) && (this.m_graphType < 89 || this.m_graphType > 94);
    }

    public boolean isPagingControlVisible() {
        return this.m_isPagingControlVisible;
    }

    public void setPagingControlVisible(boolean bl) {
        this.setPagingControlVisibleChanged(true);
        this.m_isPagingControlVisible = bl;
    }

    public void beginAxisChanges() {
    }

    public void endAxisChanges() {
    }

    public void setSeriesObjectCount(int n) {
        if (n < 1 || n > 128) {
            this.getErrorHandler().log("invalid series object count", this.getClass().getName(), "setSeriesObjectCount(int count)");
        } else {
            this.setSeriesObjectCountChanged(true);
            int n2 = this.m_seriesObjectCount;
            this.m_seriesObjectCount = n;
            ((UISeriesAdapter)this.m_series).setSeriesObjectCount(n);
            try {
                if (n > 30 && n2 < n) {
                    int n3 = n2;
                    while (n3 < n) {
                        this.m_series.setColor(new Color(GraphDefaultValues.getDefaultSeriesColor()[n3 % 30]), n3);
                        ++n3;
                    }
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                this.getErrorHandler().log("Series out of range", this.getClass().toString(), "setSeriesObjectCount(int count)");
            }
        }
    }

    public int getSeriesEffect() {
        return this.m_seriesEffect;
    }

    public void setSeriesEffect(int n) {
        this.m_seriesEffect = n;
    }

    public int getSeriesObjectCount() {
        return this.m_seriesObjectCount;
    }

    public boolean isGroupSeriesTooltipSupported(int n) {
        if (this.m_dataAccess == null || n < 0) {
            return false;
        }
        try {
            if (this.m_dataAccess.getLayerCount(n) > 1) {
                boolean bl = false;
                return bl;
            }
            if (this.m_dataAccess.getLayerCount(n) == 0) {
                boolean bl = true;
                return bl;
            }
            QDR qDR = this.m_dataAccess.getSliceQDR(n, 0, 0);
            if (qDR != null && qDR.getDimMember(qDR.getMeasureDim()) != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public DataFilter getDataFilter() {
        return this.m_dataFilter;
    }

    public UISeriesColor getUISeriesColor() {
        return this.m_series;
    }

    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        return this.m_viewStyle;
    }

    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
    }

    public int getViewType() {
        return 1;
    }

    public UIParetoLine getParetoLine() {
        return this.m_paretoLine;
    }

    public UIReferenceLine getUIX1ReferenceLine() {
        return this.m_X1ReferenceLine;
    }

    public UIReferenceLine getUIY1ReferenceLine() {
        return this.m_Y1ReferenceLine;
    }

    public UIReferenceLine getUIY2ReferenceLine() {
        return this.m_Y2ReferenceLine;
    }

    public UIAssignedValue getUIY1Baseline() {
        return this.m_Y1AssignedValue;
    }

    public UIAssignedValue getUIY2Baseline() {
        return this.m_Y2AssignedValue;
    }

    public boolean isMarkerDisplayed() {
        return this.m_markerDisplayed;
    }

    public void setMarkerDisplayed(boolean bl) {
        this.setMarkerDisplayedChanged(true);
        this.m_markerDisplayed = bl;
    }

    public void setTimeAxisData(int n) {
        this.m_timeAxisData = n;
    }

    public int getTimeAxisData() {
        return this.m_timeAxisData;
    }

    public void set3DEffect(boolean bl) {
        this.m_3DEffect = bl;
        this.set3DEffectChanged(true);
    }

    public boolean is3DEffect() {
        return this.m_3DEffect;
    }

    public void setTimeAxisDateFormat(int n, String string) {
        switch (n) {
            case 0: {
                this.m_timeAxis[0] = string;
                this.m_timeAxisChanged[0] = true;
                break;
            }
            case 1: {
                this.m_timeAxis[1] = string;
                this.m_timeAxisChanged[1] = true;
                break;
            }
            case 2: {
                this.m_timeAxis[2] = string;
                this.m_timeAxisChanged[2] = true;
                break;
            }
            case 3: {
                this.m_timeAxis[3] = string;
                this.m_timeAxisChanged[3] = true;
            }
        }
    }

    public String getTimeAxisDateFormat(int n) {
        switch (n) {
            case 0: {
                return this.m_timeAxis[0];
            }
            case 1: {
                return this.m_timeAxis[1];
            }
            case 2: {
                return this.m_timeAxis[2];
            }
            case 3: {
                return this.m_timeAxis[3];
            }
        }
        return null;
    }

    protected void set3DEffectChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(12);
        } else {
            this.m_propertyChangedFlags.clear(12);
        }
    }

    protected boolean is3DEffectChanged() {
        return this.m_propertyChangedFlags.get(12);
    }

    protected void setTimeAxisDateFormatChanged(boolean bl, int n) {
        this.m_timeAxisChanged[n] = bl;
    }

    protected boolean isTimeAxisDateFormatChanged(int n) {
        return this.m_timeAxisChanged[n];
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_dataAccess = null;
        if (this.m_dataDirector != null) {
            this.m_dataDirector.removeDataDirectorListener(this.m_dataDirectorListener);
        }
        this.m_dataDirectorListener = null;
        this.m_dataSource = null;
        if (this.m_title != null) {
            ((UITitleAdapter)this.m_title).cleanUp();
        }
        if (this.m_subtitle != null) {
            ((UITitleAdapter)this.m_subtitle).cleanUp();
        }
        if (this.m_footnote != null) {
            ((UITitleAdapter)this.m_footnote).cleanUp();
        }
        this.m_title = null;
        this.m_subtitle = null;
        this.m_footnote = null;
        if (this.m_O1Title != null) {
            ((UITitleAdapter)this.m_O1Title).cleanUp();
        }
        if (this.m_X1Title != null) {
            ((UITitleAdapter)this.m_X1Title).cleanUp();
        }
        if (this.m_Y1Title != null) {
            ((UITitleAdapter)this.m_Y1Title).cleanUp();
        }
        if (this.m_Y2Title != null) {
            ((UITitleAdapter)this.m_Y2Title).cleanUp();
        }
        this.m_O1Title = null;
        this.m_X1Title = null;
        this.m_Y1Title = null;
        this.m_Y2Title = null;
        if (this.m_legendArea != null) {
            ((UILegendAreaAdapter)this.m_legendArea).cleanUp();
        }
        this.m_legendArea = null;
        if (this.m_legendText != null) {
            ((UILegendTextAdapter)this.m_legendText).cleanUp();
        }
        this.m_legendText = null;
        if (this.m_markerText != null) {
            ((UIMarkerTextAdapter)this.m_markerText).cleanUp();
        }
        this.m_markerText = null;
        this.m_slice = null;
        if (this.m_pieFrame != null) {
            ((UIBaseFrameAdapter)this.m_pieFrame).cleanUp();
        }
        if (this.m_plotArea != null) {
            ((UIBaseFrameAdapter)this.m_plotArea).cleanUp();
        }
        this.m_pieFrame = null;
        this.m_plotArea = null;
        if (this.m_3DFloor != null) {
            ((UIBase3DPanelAdapter)this.m_3DFloor).cleanUp();
        }
        this.m_3DFloor = null;
        if (this.m_X1Tick != null) {
            ((MajorTickAdapter)this.m_X1Tick).cleanUp();
        }
        this.m_X1Tick = null;
        if (this.m_Y1Tick != null) {
            ((MajorTickAdapter)this.m_Y1Tick).cleanUp();
        }
        this.m_Y1Tick = null;
        if (this.m_Y2Tick != null) {
            ((MajorTickAdapter)this.m_Y2Tick).cleanUp();
        }
        this.m_Y2Tick = null;
        if (this.m_O1Tick != null) {
            ((MajorTickAdapter)this.m_O1Tick).cleanUp();
        }
        this.m_O1Tick = null;
        if (this.m_X1Axis != null) {
            ((UIDataAxisAdapter)this.m_X1Axis).cleanUp();
        }
        if (this.m_Y1Axis != null) {
            ((UIDataAxisAdapter)this.m_Y1Axis).cleanUp();
        }
        if (this.m_Y2Axis != null) {
            ((UIDataAxisAdapter)this.m_Y2Axis).cleanUp();
        }
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        if (this.m_O1Axis != null) {
            ((UIO1AxisAdapter)this.m_O1Axis).cleanUp();
        }
        this.m_O1Axis = null;
        if (this.m_X1DataTickLabel != null) {
            ((UIDataTickLabelAdapter)this.m_X1DataTickLabel).cleanUp();
        }
        this.m_X1DataTickLabel = null;
        if (this.m_Y1DataTickLabel != null) {
            ((UIDataTickLabelAdapter)this.m_Y1DataTickLabel).cleanUp();
        }
        this.m_Y1DataTickLabel = null;
        if (this.m_Y2DataTickLabel != null) {
            ((UIDataTickLabelAdapter)this.m_Y2DataTickLabel).cleanUp();
        }
        this.m_Y2DataTickLabel = null;
        if (this.m_O1TickLabel != null) {
            ((UITickLabelAdapter)this.m_O1TickLabel).cleanUp();
        }
        this.m_O1TickLabel = null;
        if (this.m_sliceLabel != null) {
            ((UISliceLabelAdapter)this.m_sliceLabel).cleanUp();
        }
        this.m_sliceLabel = null;
        if (this.m_dataFilter != null) {
            this.m_dataFilter.cleanUp();
        }
        this.m_dataFilter = null;
        if (this.m_paretoLine != null) {
            ((UIParetoLineAdapter)this.m_paretoLine).cleanUp();
        }
        this.m_paretoLine = null;
        this.m_Y1AssignedValue = null;
        this.m_Y2AssignedValue = null;
        if (this.m_series != null) {
            ((UISeriesAdapter)this.m_series).cleanUp();
        }
        this.m_series = null;
        if (this.m_converter != null) {
            ((GraphTypeConverterAdapter)this.m_converter).cleanUp();
        }
        this.m_converter = null;
        this.m_propertyChangedFlags = null;
        this.rBundle = null;
    }

    protected boolean isDataDirectorTypeChanged() {
        return this.m_propertyChangedFlags.get(0);
    }

    protected void setDataDirectorTypeChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(0);
        } else {
            this.m_propertyChangedFlags.clear(0);
        }
    }

    protected boolean isDataRowShownAsASeriesChanged() {
        return this.m_propertyChangedFlags.get(1);
    }

    protected void setDataRowShownAsASeriesChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(1);
        } else {
            this.m_propertyChangedFlags.clear(1);
        }
    }

    protected boolean isDataSourceChanged() {
        return this.m_propertyChangedFlags.get(2);
    }

    protected void setDataSourceChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(2);
        } else {
            this.m_propertyChangedFlags.clear(2);
        }
    }

    protected boolean isGraphTypeChanged() {
        return this.m_propertyChangedFlags.get(3);
    }

    protected void setGraphTypeChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(3);
        } else {
            this.m_propertyChangedFlags.clear(3);
        }
    }

    protected boolean isLineDataLineDisplayedChanged() {
        return this.m_propertyChangedFlags.get(5);
    }

    protected void setLineDataLineDisplayedChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(5);
        } else {
            this.m_propertyChangedFlags.clear(5);
        }
    }

    protected boolean isPagingControlVisibleChanged() {
        return this.m_propertyChangedFlags.get(7);
    }

    protected void setPagingControlVisibleChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(7);
        } else {
            this.m_propertyChangedFlags.clear(7);
        }
    }

    protected boolean isMarkerTooltipTypeChanged() {
        return this.m_propertyChangedFlags.get(6);
    }

    protected void setMarkerTooltipTypeChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(6);
        } else {
            this.m_propertyChangedFlags.clear(6);
        }
    }

    protected boolean isSeriesTooltipLabelTypeChanged() {
        return this.m_propertyChangedFlags.get(9);
    }

    protected void setSeriesTooltipLabelTypeChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(9);
        } else {
            this.m_propertyChangedFlags.clear(9);
        }
    }

    protected boolean isGroupTooltipLabelTypeChanged() {
        return this.m_propertyChangedFlags.get(4);
    }

    protected void setGroupTooltipLabelTypeChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(4);
        } else {
            this.m_propertyChangedFlags.clear(4);
        }
    }

    protected boolean isSeriesObjectCountChanged() {
        return this.m_propertyChangedFlags.get(8);
    }

    protected void setSeriesObjectCountChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(8);
        } else {
            this.m_propertyChangedFlags.clear(8);
        }
    }

    protected boolean isTokenSubstitutionChanged() {
        return this.m_propertyChangedFlags.get(10);
    }

    protected void setTokenSubstitutionChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(10);
        } else {
            this.m_propertyChangedFlags.clear(10);
        }
    }

    protected boolean isMarkerDisplayedChanged() {
        return this.m_propertyChangedFlags.get(11);
    }

    protected void setMarkerDisplayedChanged(boolean bl) {
        if (bl) {
            this.m_propertyChangedFlags.set(11);
        } else {
            this.m_propertyChangedFlags.clear(11);
        }
    }

    protected void setDataDirector(DataDirector dataDirector) {
        this.m_dataDirector = dataDirector;
        this.m_dataDirector.addDataDirectorListener(this.m_dataDirectorListener);
    }

    protected DataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    protected DataDirector getDataDirector() {
        return this.m_dataDirector;
    }

    protected boolean isDataUnavailable() {
        return this.m_dataUnavailable;
    }

    class MyDataDirectorListener
    implements DataDirectorListener {
        MyDataDirectorListener() {
        }

        public void viewDataChanged(DataChangedEvent dataChangedEvent) {
            UIGraphAdapter.this.m_dataAccess = dataChangedEvent.getDataAccess();
        }

        public void viewDataAvailable(DataAvailableEvent dataAvailableEvent) {
            if (dataAvailableEvent.getType() == 1) {
                UIGraphAdapter.this.m_dataUnavailable = true;
                return;
            }
            UIGraphAdapter.this.m_dataUnavailable = false;
            UIGraphAdapter.this.m_dataAccess = dataAvailableEvent.getDataAccess();
        }

        public void waitDataAvailable(WaitDataAvailableEvent waitDataAvailableEvent) {
        }
    }
}

