/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.graph.gui.GraphStandardStyles;
import oracle.dss.graph.gui.StyleListEntry;

public class StyleList
extends ArrayList {
    private ResourceBundle _bundle;
    private int defaultIndex = -1;
    private int customIndex = -1;

    public StyleList(int n) {
        super(n);
    }

    public StyleList(StyleList styleList) {
        super(styleList);
    }

    public void setLocale(Locale locale) {
        int n = 0;
        while (n < this.size()) {
            StyleListEntry styleListEntry = this.getStyleListEntry(n);
            if (styleListEntry != null) {
                styleListEntry.setLocale(locale);
            }
            ++n;
        }
    }

    public StyleListEntry getStyleListEntry(int n) {
        return (StyleListEntry)this.get(n);
    }

    public int getStyleIndex(String string) {
        if (string == null) {
            return this.getDefaultStyleIndex();
        }
        StyleListEntry styleListEntry = new StyleListEntry(string, "", null);
        return this.indexOf(styleListEntry);
    }

    public int getDefaultStyleIndex() {
        if (this.defaultIndex == -1) {
            this.addRequiredStyles();
        }
        return this.defaultIndex;
    }

    public int getCustomStyleIndex() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
        }
        return this.customIndex;
    }

    public int addCustomStyle() {
        if (this.customIndex == -1) {
            this.setRequiredStyleIndices();
            if (this.customIndex == -1) {
                StyleListEntry styleListEntry = GraphStandardStyles.CUSTOM_STYLE;
                this.customIndex = this.size();
                this.add(this.customIndex, styleListEntry);
            }
        }
        return this.customIndex;
    }

    public void addRequiredStyles() {
        this.setRequiredStyleIndices();
        if (this.defaultIndex == -1) {
            StyleListEntry styleListEntry = GraphStandardStyles.DEFAULT_STYLE;
            this.add(0, styleListEntry);
        }
    }

    private void setRequiredStyleIndices() {
        StyleListEntry styleListEntry = GraphStandardStyles.DEFAULT_STYLE;
        StyleListEntry styleListEntry2 = GraphStandardStyles.CUSTOM_STYLE;
        int n = 0;
        while (n < this.size()) {
            StyleListEntry styleListEntry3 = this.getStyleListEntry(n);
            if (styleListEntry3 != null) {
                if (styleListEntry3 == styleListEntry) {
                    this.defaultIndex = n;
                } else if (styleListEntry3 == styleListEntry2) {
                    this.customIndex = n;
                }
            }
            ++n;
        }
    }
}

