/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.BeanInfo;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.IdentObj;

public class PFJ
extends Perspective
implements ViewComponent {
    protected Image m_offscreenImage;
    protected boolean m_printOrPreviewMode;
    protected String m_lazyDataFetchMessage;
    protected int m_maxBarWidth = GraphDefaultValues.getMaxBarWidth();

    public PFJ() {
        super(null, null, false);
    }

    protected void cleanUp() {
        this.askForRelease();
    }

    public int getID() {
        return 9;
    }

    public String getComponentName() {
        return "Graph";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public void paint(Graphics graphics) {
        if (!this.m_printOrPreviewMode) {
            if (this.m_lazyDataFetchMessage != null) {
                this.paintLazyDataFetchMessage(graphics);
            } else {
                super.paint(graphics);
            }
        } else if (this.m_offscreenImage != null) {
            graphics.drawImage(this.m_offscreenImage, 0, 0, null);
        }
    }

    protected void setPrintOrPreviewMode(boolean bl) {
        Graphics graphics = null;
        if (bl) {
            Dimension dimension = this.getSize();
            if (this.m_offscreenImage == null) {
                this.m_offscreenImage = this.createImage(dimension.width, dimension.height);
            }
            if (this.m_offscreenImage != null) {
                graphics = this.m_offscreenImage.getGraphics();
                graphics.setClip(0, 0, dimension.width, dimension.height);
                this.paint(graphics);
            }
            this.m_printOrPreviewMode = bl;
        } else {
            this.m_printOrPreviewMode = bl;
            if (graphics != null) {
                graphics.dispose();
            }
            this.m_offscreenImage = null;
        }
    }

    protected void paintLazyDataFetchMessage(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Font font2 = null;
        font2 = font != null ? new Font(font.getName(), font.getStyle(), 10) : new Font("Dialog", 0, 10);
        graphics.setColor(Color.black);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        int n = fontMetrics.getHeight();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = fontMetrics.stringWidth(this.m_lazyDataFetchMessage);
        n2 = dimension.width / 2 - n4 / 2;
        if (n2 < fontMetrics.getMaxAdvance()) {
            n2 = fontMetrics.getMaxAdvance();
        }
        if ((n3 = dimension.height / 2 - n / 2 + fontMetrics.getAscent() + fontMetrics.getLeading()) < fontMetrics.getAscent() + fontMetrics.getLeading()) {
            n3 = fontMetrics.getAscent() + fontMetrics.getLeading();
        }
        graphics.drawString(this.m_lazyDataFetchMessage, n2, n3);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    protected void setLazyDataFetchMessage(String string) {
        this.m_lazyDataFetchMessage = string;
    }

    protected void setMaxBarWidth(int n) {
        this.m_maxBarWidth = n;
    }

    protected int calcRiserWidth() {
        int n = 75;
        if (this.m_maxBarWidth == -1) {
            return n;
        }
        int n2 = this.getNumGroups();
        if (n2 < 1) {
            return n;
        }
        int n3 = this._getBarCountPerGroup();
        if (n3 < 1) {
            return n;
        }
        int n4 = this.getRect((IdentObj)this.getFrame()).width;
        int n5 = n4 / n2;
        int n6 = n5 / n3;
        if (n6 < 1) {
            return n;
        }
        double d = (double)this.m_maxBarWidth / (double)n6;
        int n7 = (int)Math.floor(100.0 * d);
        if (n7 > 100) {
            n7 = 100;
        } else if (n7 < 1) {
            n7 = 1;
        }
        if (n7 < n) {
            return n7;
        }
        return n;
    }

    protected boolean isCalculated() {
        return this.getChartState() > 0;
    }

    private int _getBarCountPerGroup() {
        int n = 0;
        switch (this.getGraphType()) {
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: {
                n = this._getClusteredBarCountPerGroup(true);
                break;
            }
            case 18: 
            case 23: 
            case 25: 
            case 30: {
                n = this._getStackedBarCountPerGroup(true, false, false);
                break;
            }
            case 20: 
            case 27: {
                n = this._getStackedBarCountPerGroup(true, true, false);
                break;
            }
            case 22: 
            case 29: {
                n = this._getStackedBarCountPerGroup(true, true, true);
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: {
                n = this._getClusteredBarCountPerGroup(false);
                break;
            }
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 54: {
                n = this._getStackedBarCountPerGroup(false, false, false);
                break;
            }
            case 44: 
            case 51: {
                n = this._getStackedBarCountPerGroup(false, true, false);
                break;
            }
            case 34: 
            case 39: 
            case 46: 
            case 53: {
                n = this._getStackedBarCountPerGroup(false, true, true);
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                n = 1;
                break;
            }
            case 74: 
            case 77: 
            case 80: {
                n = 1;
                break;
            }
            case 75: 
            case 78: 
            case 81: {
                n = 1;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n = 0;
                break;
            }
            case 93: 
            case 94: {
                n = 0;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int _getClusteredBarCountPerGroup(boolean bl) {
        int n;
        int n2;
        if (this._isEverySeriesShown()) {
            n2 = 0;
            n = this.getNumSeries() - 1;
        } else {
            n2 = this.getScrollOffsetSeries();
            n = n2 + this.getNumSeries() - 1;
        }
        int n3 = 0;
        int n4 = n2;
        while (n4 <= n) {
            int n5 = this.getSeriesType(n4);
            if (bl && n5 == 0 || n5 == 1) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    private int _getStackedBarCountPerGroup(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        if (this._isEverySeriesShown()) {
            n2 = 0;
            n = this.getNumSeries() - 1;
        } else {
            n2 = this.getScrollOffsetSeries();
            n = n2 + this.getNumSeries() - 1;
        }
        if (!bl2 || bl3) {
            int n3 = n2;
            while (n3 <= n) {
                int n4 = this.getSeriesType(n3);
                if (bl && n4 == 0 || n4 == 1) {
                    return 1;
                }
                ++n3;
            }
            return 0;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = n2;
        while (n5 <= n) {
            int n6 = this.getSeriesType(n5);
            if (bl && n6 == 0 || n6 == 1) {
                if (this.getAxisAssignment(n5) == 1) {
                    bl5 = true;
                } else {
                    bl4 = true;
                }
            }
            ++n5;
        }
        if (bl4 && bl5) {
            return 2;
        }
        if (bl4 || bl5) {
            return 1;
        }
        return 0;
    }

    private boolean _isEverySeriesShown() {
        return this.getViewableSeries() == 0 || this.getViewableSeries() >= this.getNumTotalSeries();
    }
}

