/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.managers;

import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.Utility;
import oracle.dss.util.format.BaseViewFormat;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ViewFormat
extends BaseViewFormat {
    protected DataviewCommon m_view;
    protected static final String s_numberType = "n";
    protected static final String s_thousandSeparator = "t";
    protected static final String s_decimalSeparator = "d";
    protected static final String s_currencySymbol = "c";
    protected static final String s_leadingZero = "l";
    protected static final String s_decimalDigit = "a";
    protected static final String s_posNumFmt = "e";
    protected static final String s_negNumFmt = "f";
    protected static final String s_posCurFmt = "g";
    protected static final String s_negCurFmt = "h";
    protected static final String s_scaleFactor = "s";
    protected static final String s_scaleDownThousands = "k";
    protected static final String s_scaleDownMillions = "m";
    protected static final String s_scaleDownBillions = "b";
    protected static final String s_scaleDownTrillions = "i";
    protected static final String s_scaleDownQuadrillions = "q";
    protected static final String s_javaDateFormat = "j";
    protected static final String s_oracleDateFormat = "o";
    protected static final String s_CustomFormatString = "cf";
    protected static final String s_numberTypeUsed = "nu";
    protected static final String s_thousandSeparatorUsed = "tu";
    protected static final String s_decimalSeparatorUsed = "du";
    protected static final String s_currencySymbolUsed = "cu";
    protected static final String s_leadingZeroUsed = "lu";
    protected static final String s_decimalDigitUsed = "au";
    protected static final String s_posNumFmtUsed = "eu";
    protected static final String s_negNumFmtUsed = "fu";
    protected static final String s_posCurFmtUsed = "gu";
    protected static final String s_negCurFmtUsed = "hu";
    protected static final String s_scaleFactorUsed = "su";
    protected static final String s_scaleDownThousandsUsed = "ku";
    protected static final String s_scaleDownMillionsUsed = "mu";
    protected static final String s_scaleDownBillionsUsed = "bu";
    protected static final String s_scaleDownTrillionsUsed = "iu";
    protected static final String s_scaleDownQuadrillionsUsed = "qu";
    protected static final String s_javaDateFormatUsed = "ju";
    protected static final String s_oracleDateFormatUsed = "ou";

    public ViewFormat() {
    }

    public ViewFormat(int n, char c, char c2, String string, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(n, c, c2, string, bl, n2, n3, n4, n5, n6, n7, string2, string3, string4, string5, string6, string7);
    }

    public ViewFormat(String string, int n) {
        super(string, n);
    }

    public ViewFormat(BaseViewFormat baseViewFormat) {
        this(baseViewFormat.getNumberType(), baseViewFormat.getThousandSeparator(), baseViewFormat.getDecimalSeparator(), baseViewFormat.getCurrencySymbol(), baseViewFormat.isLeadingZero(), baseViewFormat.getDecimalDigit(), baseViewFormat.getPosNumFmt(), baseViewFormat.getNegNumFmt(), baseViewFormat.getPosCurFmt(), baseViewFormat.getNegCurFmt(), baseViewFormat.getScaleFactor(), baseViewFormat.getScaleDownThousands(), baseViewFormat.getScaleDownMillions(), baseViewFormat.getScaleDownBillions(), baseViewFormat.getScaleDownTrillions(), baseViewFormat.getScaleDownQuadrillions(), baseViewFormat.getOracleDateFormat());
        this.setView(null);
        this.setLocale(baseViewFormat.getLocale());
        this.setJavaDateFormat(baseViewFormat.getJavaDateFormat());
        this.setJavaDateFormatUsed(baseViewFormat.isJavaDateFormatUsed());
    }

    public Object clone() {
        ViewFormat viewFormat = new ViewFormat(this.getNumberType(), this.getThousandSeparator(), this.getDecimalSeparator(), this.getCurrencySymbol(), this.isLeadingZero(), this.getDecimalDigit(), this.getPosNumFmt(), this.getNegNumFmt(), this.getPosCurFmt(), this.getNegCurFmt(), this.getScaleFactor(), this.getScaleDownThousands(), this.getScaleDownMillions(), this.getScaleDownBillions(), this.getScaleDownTrillions(), this.getScaleDownQuadrillions(), this.getOracleDateFormat());
        viewFormat.setLocale(this.getLocale());
        viewFormat.merge(this);
        viewFormat.setView(this.m_view);
        viewFormat.setErrorHandler(this._getErrorHandler());
        viewFormat.setJavaDateFormat(this.getJavaDateFormat());
        viewFormat.setJavaDateFormatUsed(this.isJavaDateFormatUsed());
        return viewFormat;
    }

    public void setViewFormatCallback(ViewFormatCallback viewFormatCallback) {
        this.m_vfCallback = viewFormatCallback;
    }

    public void setView(DataviewCommon dataviewCommon) {
        this.m_view = dataviewCommon;
        if (this.m_view != null) {
            this.setErrorHandler(null);
        }
    }

    public DataviewCommon getView() {
        return this.m_view;
    }

    public String getDateFormat() {
        return this.getJavaDateFormat();
    }

    public boolean isDateFormatUsed() {
        return this.m_formatUsedFlags.get(16);
    }

    public void setDateFormat(String string) {
        this.setJavaDateFormat(string);
    }

    public void setDateFormatUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(16);
        } else {
            this.m_formatUsedFlags.clear(16);
        }
    }

    protected ErrorHandler _getErrorHandler() {
        ErrorHandler errorHandler = super._getErrorHandler();
        if (errorHandler != null) {
            return errorHandler;
        }
        if (this.getView() != null && this.getView().getErrorHandler() != null) {
            return this.getView().getErrorHandler();
        }
        return null;
    }

    public void setStateAsObjectNode(ObjectNode objectNode, ViewFormat viewFormat) {
        PropertyNode propertyNode;
        if (objectNode == null) {
            return;
        }
        if (viewFormat == null) {
            viewFormat = new ViewFormat();
        }
        if ((propertyNode = objectNode.getProperty(s_numberType)) != null) {
            this.setNumberType(propertyNode.getValueAsInteger());
        } else {
            this.setNumberType(viewFormat.getNumberType());
            propertyNode = objectNode.getProperty(s_numberTypeUsed);
            if (propertyNode != null) {
                this.setNumberTypeUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setNumberTypeUsed(viewFormat.isNumberTypeUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_thousandSeparator);
        if (propertyNode != null) {
            this.setThousandSeparator(propertyNode.getValueAsCharacter());
        } else {
            this.setThousandSeparator(viewFormat.getThousandSeparator());
            propertyNode = objectNode.getProperty(s_thousandSeparatorUsed);
            if (propertyNode != null) {
                this.setThousandSeparatorUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setThousandSeparatorUsed(viewFormat.isThousandSeparatorUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_decimalSeparator);
        if (propertyNode != null) {
            this.setDecimalSeparator(propertyNode.getValueAsCharacter());
        } else {
            this.setDecimalSeparator(viewFormat.getDecimalSeparator());
            propertyNode = objectNode.getProperty(s_decimalSeparatorUsed);
            if (propertyNode != null) {
                this.setDecimalSeparatorUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setDecimalSeparatorUsed(viewFormat.isDecimalSeparatorUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_currencySymbol);
        if (propertyNode != null) {
            this.setCurrencySymbol(propertyNode.getValueAsString());
        } else {
            this.setCurrencySymbol(viewFormat.getCurrencySymbol());
            propertyNode = objectNode.getProperty(s_currencySymbolUsed);
            if (propertyNode != null) {
                this.setCurrencySymbolUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setCurrencySymbolUsed(viewFormat.isCurrencySymbolUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_leadingZero);
        if (propertyNode != null) {
            this.setLeadingZero(Utility.getValueAsBoolean(propertyNode));
        } else {
            this.setLeadingZero(viewFormat.isLeadingZero());
            propertyNode = objectNode.getProperty(s_leadingZeroUsed);
            if (propertyNode != null) {
                this.setLeadingZeroUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setLeadingZeroUsed(viewFormat.isLeadingZeroUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_decimalDigit);
        if (propertyNode != null) {
            this.setDecimalDigit(propertyNode.getValueAsInteger());
        } else {
            this.setDecimalDigit(viewFormat.getDecimalDigit());
            propertyNode = objectNode.getProperty(s_decimalDigitUsed);
            if (propertyNode != null) {
                this.setDecimalDigitUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setDecimalDigitUsed(viewFormat.isDecimalDigitUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_posNumFmt);
        if (propertyNode != null) {
            this.setPosNumFmt(propertyNode.getValueAsInteger());
        } else {
            this.setPosNumFmt(viewFormat.getPosNumFmt());
            propertyNode = objectNode.getProperty(s_posNumFmtUsed);
            if (propertyNode != null) {
                this.setPosNumFmtUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setPosNumFmtUsed(viewFormat.isPosNumFmtUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_negNumFmt);
        if (propertyNode != null) {
            this.setNegNumFmt(propertyNode.getValueAsInteger());
        } else {
            this.setNegNumFmt(viewFormat.getNegNumFmt());
            propertyNode = objectNode.getProperty(s_negNumFmtUsed);
            if (propertyNode != null) {
                this.setNegNumFmtUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setNegNumFmtUsed(viewFormat.isNegNumFmtUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_posCurFmt);
        if (propertyNode != null) {
            this.setPosCurFmt(propertyNode.getValueAsInteger());
        } else {
            this.setPosCurFmt(viewFormat.getPosCurFmt());
            propertyNode = objectNode.getProperty(s_posCurFmtUsed);
            if (propertyNode != null) {
                this.setPosCurFmtUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setPosCurFmtUsed(viewFormat.isPosCurFmtUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_negCurFmt);
        if (propertyNode != null) {
            this.setNegCurFmt(propertyNode.getValueAsInteger());
        } else {
            this.setNegCurFmt(viewFormat.getNegCurFmt());
            propertyNode = objectNode.getProperty(s_negCurFmtUsed);
            if (propertyNode != null) {
                this.setNegCurFmtUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setNegCurFmtUsed(viewFormat.isNegCurFmtUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleFactor);
        if (propertyNode != null) {
            this.setScaleFactor(propertyNode.getValueAsInteger());
        } else {
            this.setScaleFactor(viewFormat.getScaleFactor());
            propertyNode = objectNode.getProperty(s_scaleFactorUsed);
            if (propertyNode != null) {
                this.setScaleFactorUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleFactorUsed(viewFormat.isScaleFactorUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleDownThousands);
        if (propertyNode != null) {
            this.setScaleDownThousands(propertyNode.getValueAsString());
        } else {
            this.setScaleDownThousands(viewFormat.getScaleDownThousands());
            propertyNode = objectNode.getProperty(s_scaleDownThousandsUsed);
            if (propertyNode != null) {
                this.setScaleDownThousandsUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleDownThousandsUsed(viewFormat.isScaleDownThousandsUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleDownMillions);
        if (propertyNode != null) {
            this.setScaleDownMillions(propertyNode.getValueAsString());
        } else {
            this.setScaleDownMillions(viewFormat.getScaleDownMillions());
            propertyNode = objectNode.getProperty(s_scaleDownMillionsUsed);
            if (propertyNode != null) {
                this.setScaleDownMillionsUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleDownMillionsUsed(viewFormat.isScaleDownMillionsUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleDownBillions);
        if (propertyNode != null) {
            this.setScaleDownBillions(propertyNode.getValueAsString());
        } else {
            this.setScaleDownBillions(viewFormat.getScaleDownBillions());
            propertyNode = objectNode.getProperty(s_scaleDownBillionsUsed);
            if (propertyNode != null) {
                this.setScaleDownBillionsUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleDownBillionsUsed(viewFormat.isScaleDownBillionsUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleDownTrillions);
        if (propertyNode != null) {
            this.setScaleDownTrillions(propertyNode.getValueAsString());
        } else {
            this.setScaleDownTrillions(viewFormat.getScaleDownTrillions());
            propertyNode = objectNode.getProperty(s_scaleDownTrillionsUsed);
            if (propertyNode != null) {
                this.setScaleDownTrillionsUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleDownTrillionsUsed(viewFormat.isScaleDownTrillionsUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_scaleDownQuadrillions);
        if (propertyNode != null) {
            this.setScaleDownQuadrillions(propertyNode.getValueAsString());
        } else {
            this.setScaleDownQuadrillions(viewFormat.getScaleDownQuadrillions());
            propertyNode = objectNode.getProperty(s_scaleDownQuadrillionsUsed);
            if (propertyNode != null) {
                this.setScaleDownQuadrillionsUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setScaleDownQuadrillionsUsed(viewFormat.isScaleDownQuadrillionsUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_javaDateFormat);
        if (propertyNode != null) {
            this.setJavaDateFormat(propertyNode.getValueAsString());
        } else {
            this.setJavaDateFormat(viewFormat.getJavaDateFormat());
            propertyNode = objectNode.getProperty(s_javaDateFormatUsed);
            if (propertyNode != null) {
                this.setJavaDateFormatUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setJavaDateFormatUsed(viewFormat.isJavaDateFormatUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_oracleDateFormat);
        if (propertyNode != null) {
            this.setOracleDateFormat(propertyNode.getValueAsString());
        } else {
            this.setOracleDateFormat(viewFormat.getOracleDateFormat());
            propertyNode = objectNode.getProperty(s_oracleDateFormatUsed);
            if (propertyNode != null) {
                this.setOracleDateFormatUsed(Utility.getValueAsBoolean(propertyNode));
            } else {
                this.setOracleDateFormatUsed(viewFormat.isOracleDateFormatUsed());
            }
        }
        propertyNode = objectNode.getProperty(s_CustomFormatString);
        if (propertyNode != null) {
            this.setNumberFormatString(propertyNode.getValueAsString());
        } else {
            this.setNumberFormatString(viewFormat.getNumberFormatString());
        }
    }

    public ObjectNode getStateAsObjectNode(String string, ViewFormat viewFormat) {
        if (viewFormat == null) {
            viewFormat = new ViewFormat();
        }
        ObjectNode objectNode = new ObjectNode(string);
        boolean bl = false;
        if (this.isNumberTypeUsed() && viewFormat.getNumberType() != this.getNumberType()) {
            objectNode.addProperty(s_numberType, this.getNumberType());
            bl = true;
        } else if (viewFormat.isNumberTypeUsed() != this.isNumberTypeUsed()) {
            objectNode.addProperty(s_numberTypeUsed, Utility.getBooleanAsChar(this.isNumberTypeUsed()));
            bl = true;
        }
        if (this.isThousandSeparatorUsed() && viewFormat.getThousandSeparator() != this.getThousandSeparator()) {
            objectNode.addProperty(s_thousandSeparator, this.getThousandSeparator());
            bl = true;
        } else if (viewFormat.isThousandSeparatorUsed() != this.isThousandSeparatorUsed()) {
            objectNode.addProperty(s_thousandSeparatorUsed, Utility.getBooleanAsChar(this.isThousandSeparatorUsed()));
            bl = true;
        }
        if (this.isDecimalSeparatorUsed() && viewFormat.getDecimalSeparator() != this.getDecimalSeparator()) {
            objectNode.addProperty(s_decimalSeparator, this.getDecimalSeparator());
            bl = true;
        } else if (viewFormat.isDecimalSeparatorUsed() != this.isDecimalSeparatorUsed()) {
            objectNode.addProperty(s_decimalSeparatorUsed, Utility.getBooleanAsChar(this.isDecimalSeparatorUsed()));
            bl = true;
        }
        if (this.isCurrencySymbolUsed() && !viewFormat.getCurrencySymbol().equals(this.getCurrencySymbol())) {
            objectNode.addProperty(s_currencySymbol, this.createStringLiteral(this.getCurrencySymbol()));
            bl = true;
        } else if (viewFormat.isCurrencySymbolUsed() != this.isCurrencySymbolUsed()) {
            objectNode.addProperty(s_currencySymbolUsed, Utility.getBooleanAsChar(this.isCurrencySymbolUsed()));
            bl = true;
        }
        if (this.isLeadingZeroUsed() && viewFormat.isLeadingZero() != this.isLeadingZero()) {
            objectNode.addProperty(s_leadingZero, this.isLeadingZero());
            bl = true;
        } else if (viewFormat.isLeadingZeroUsed() != this.isLeadingZeroUsed()) {
            objectNode.addProperty(s_leadingZeroUsed, Utility.getBooleanAsChar(this.isLeadingZeroUsed()));
            bl = true;
        }
        if (this.isDecimalDigitUsed() && viewFormat.getDecimalDigit() != this.getDecimalDigit()) {
            objectNode.addProperty(s_decimalDigit, this.getDecimalDigit());
            bl = true;
        } else if (viewFormat.isDecimalDigitUsed() != this.isDecimalDigitUsed()) {
            objectNode.addProperty(s_decimalDigitUsed, Utility.getBooleanAsChar(this.isDecimalDigitUsed()));
            bl = true;
        }
        if (this.isPosNumFmtUsed() && viewFormat.getPosNumFmt() != this.getPosNumFmt()) {
            objectNode.addProperty(s_posNumFmt, this.getPosNumFmt());
            bl = true;
        } else if (viewFormat.isPosNumFmtUsed() != this.isPosNumFmtUsed()) {
            objectNode.addProperty(s_posNumFmtUsed, Utility.getBooleanAsChar(this.isPosNumFmtUsed()));
            bl = true;
        }
        if (this.isNegNumFmtUsed() && viewFormat.getNegNumFmt() != this.getNegNumFmt()) {
            objectNode.addProperty(s_negNumFmt, this.getNegNumFmt());
            bl = true;
        } else if (viewFormat.isNegNumFmtUsed() != this.isNegNumFmtUsed()) {
            objectNode.addProperty(s_negNumFmtUsed, Utility.getBooleanAsChar(this.isNegNumFmtUsed()));
            bl = true;
        }
        if (this.isPosCurFmtUsed() && viewFormat.getPosCurFmt() != this.getPosCurFmt()) {
            objectNode.addProperty(s_posCurFmt, this.getPosCurFmt());
            bl = true;
        } else if (viewFormat.isPosCurFmtUsed() != this.isPosCurFmtUsed()) {
            objectNode.addProperty(s_posCurFmtUsed, Utility.getBooleanAsChar(this.isPosCurFmtUsed()));
            bl = true;
        }
        if (this.isNegCurFmtUsed() && viewFormat.getNegCurFmt() != this.getNegCurFmt()) {
            objectNode.addProperty(s_negCurFmt, this.getNegCurFmt());
            bl = true;
        } else if (viewFormat.isNegCurFmtUsed() != this.isNegCurFmtUsed()) {
            objectNode.addProperty(s_negCurFmtUsed, Utility.getBooleanAsChar(this.isNegCurFmtUsed()));
            bl = true;
        }
        if (this.isScaleFactorUsed() && viewFormat.getScaleFactor() != this.getScaleFactor()) {
            objectNode.addProperty(s_scaleFactor, this.getScaleFactor());
            bl = true;
        } else if (viewFormat.isScaleFactorUsed() != this.isScaleFactorUsed()) {
            objectNode.addProperty(s_scaleFactorUsed, Utility.getBooleanAsChar(this.isScaleFactorUsed()));
            bl = true;
        }
        if (this.isScaleDownThousandsUsed() && !viewFormat.getScaleDownThousands().equals(this.getScaleDownThousands())) {
            objectNode.addProperty(s_scaleDownThousands, this.getScaleDownThousands());
            bl = true;
        } else if (viewFormat.isScaleDownThousandsUsed() != this.isScaleDownThousandsUsed()) {
            objectNode.addProperty(s_scaleDownThousandsUsed, Utility.getBooleanAsChar(this.isScaleDownThousandsUsed()));
            bl = true;
        }
        if (this.isScaleDownMillionsUsed() && !viewFormat.getScaleDownMillions().equals(this.getScaleDownMillions())) {
            objectNode.addProperty(s_scaleDownMillions, this.getScaleDownMillions());
            bl = true;
        } else if (viewFormat.isScaleDownMillionsUsed() != this.isScaleDownMillionsUsed()) {
            objectNode.addProperty(s_scaleDownMillionsUsed, Utility.getBooleanAsChar(this.isScaleDownMillionsUsed()));
            bl = true;
        }
        if (this.isScaleDownBillionsUsed() && !viewFormat.getScaleDownBillions().equals(this.getScaleDownBillions())) {
            objectNode.addProperty(s_scaleDownBillions, this.getScaleDownBillions());
            bl = true;
        } else if (viewFormat.isScaleDownBillionsUsed() != this.isScaleDownBillionsUsed()) {
            objectNode.addProperty(s_scaleDownBillionsUsed, Utility.getBooleanAsChar(this.isScaleDownBillionsUsed()));
            bl = true;
        }
        if (this.isScaleDownTrillionsUsed() && !viewFormat.getScaleDownTrillions().equals(this.getScaleDownTrillions())) {
            objectNode.addProperty(s_scaleDownTrillions, this.getScaleDownTrillions());
            bl = true;
        } else if (viewFormat.isScaleDownTrillionsUsed() != this.isScaleDownTrillionsUsed()) {
            objectNode.addProperty(s_scaleDownTrillionsUsed, Utility.getBooleanAsChar(this.isScaleDownTrillionsUsed()));
            bl = true;
        }
        if (this.isScaleDownQuadrillionsUsed() && !viewFormat.getScaleDownQuadrillions().equals(this.getScaleDownQuadrillions())) {
            objectNode.addProperty(s_scaleDownQuadrillions, this.getScaleDownQuadrillions());
            bl = true;
        } else if (viewFormat.isScaleDownQuadrillionsUsed() != this.isScaleDownQuadrillionsUsed()) {
            objectNode.addProperty(s_scaleDownQuadrillionsUsed, Utility.getBooleanAsChar(this.isScaleDownQuadrillionsUsed()));
            bl = true;
        }
        if (this.isJavaDateFormatUsed() && !viewFormat.getJavaDateFormat().equals(this.getJavaDateFormat())) {
            objectNode.addProperty(s_javaDateFormat, this.getJavaDateFormat());
            bl = true;
        } else if (viewFormat.isJavaDateFormatUsed() != this.isJavaDateFormatUsed()) {
            objectNode.addProperty(s_javaDateFormatUsed, Utility.getBooleanAsChar(this.isJavaDateFormatUsed()));
            bl = true;
        }
        if (this.isOracleDateFormatUsed() && !viewFormat.getOracleDateFormat().equals(this.getOracleDateFormat())) {
            objectNode.addProperty(s_oracleDateFormat, this.getOracleDateFormat());
            bl = true;
        } else if (viewFormat.isOracleDateFormatUsed() != this.isOracleDateFormatUsed()) {
            objectNode.addProperty(s_oracleDateFormatUsed, Utility.getBooleanAsChar(this.isOracleDateFormatUsed()));
            bl = true;
        }
        if (!Utility.compareObj(viewFormat.getNumberFormatString(), this.getNumberFormatString())) {
            objectNode.addProperty(s_CustomFormatString, this.getNumberFormatString());
            bl = true;
        }
        return bl ? objectNode : null;
    }

    private String createStringLiteral(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    if (c > '\u0fff') {
                        stringBuffer.append(String.valueOf(String.valueOf("\\u")) + Integer.toHexString(c));
                        break;
                    }
                    if (c > '\u00ff') {
                        stringBuffer.append(String.valueOf(String.valueOf("\\u0")) + Integer.toHexString(c));
                        break;
                    }
                    if (c > '\u007f') {
                        stringBuffer.append(String.valueOf(String.valueOf("\\x")) + Integer.toHexString(c));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

