/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class FontSizeTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_SIZE = "FontSize";
    protected Object m_selectedObject;
    protected boolean m_flag = true;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    JComboBox m_fontSize;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private Object[] _SIZES = new Object[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36), new Integer(48), new Integer(72)};
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled = true;
    private NumberEditor ne;
    protected boolean m_bRolloverIconEnabled;

    public FontSizeTool() {
        this.m_fontSize = new JComboBox();
        this.ne = null.new NumberEditor();
        this.ne.setMaximum(512);
        this.m_fontSize.setEditor(this.ne);
        int n = 0;
        while (n < 16) {
            this.m_fontSize.addItem(this._SIZES[n]);
            ++n;
        }
        this.m_fontSize.setEnabled(false);
        this.m_fontSize.setEditable(true);
        n = this.m_fontSize.getPreferredSize().height;
        this.m_fontSize.setMinimumSize(new Dimension(45, n));
        this.m_fontSize.setMaximumSize(new Dimension(45, n));
        this.m_fontSize.setPreferredSize(new Dimension(45, n));
        this.m_fontSize.addActionListener(this);
        this.setMinimumSize(new Dimension(50, n));
        this.setMaximumSize(new Dimension(50, n));
        this.setPreferredSize(new Dimension(50, n));
        this.add(this.m_fontSize);
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontSize.setToolTipText(this.rBundle.getString(PROPERTY_FONT_SIZE));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_fontSize.setToolTipText(this.rBundle.getString(PROPERTY_FONT_SIZE));
    }

    public void setDefaultSize(int n) {
        this.m_fontSize.setSelectedItem(new Integer(n));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.m_fontSize.setEnabled(false);
            return;
        }
        this.m_flag = false;
        Object object = controllerEvent.getComponentHandle().getComponent();
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.m_fontSize.setEnabled(true);
            int n = this.getFontSize();
            this.m_fontSize.setSelectedItem(new Integer(n));
        } else {
            this.m_fontSize.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_flag = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.m_flag) {
            return;
        }
        if (actionEvent == null) {
            return;
        }
        if (actionEvent.getSource() == this.m_fontSize && (object = this.m_fontSize.getSelectedItem()) instanceof Number) {
            this.setFontSize(((Number)object).intValue());
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void update() {
    }

    public void cleanUp() {
        this.m_fontSize.removeAllItems();
        this.m_fontSize = null;
        this.ne = null;
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof FontAttribute;
    }

    private int getFontSize() {
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            return ((DataviewTitles)this.m_selectedObject).getFont().getSize();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontSize();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontSize();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().getSize();
        }
        return 0;
    }

    private void setFontSize(int n) {
        int n2 = this.getFontSize();
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            Font font = ((DataviewTitles)this.m_selectedObject).getFont();
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(font.getName(), font.getStyle(), n));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontSize(n);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontSize(n);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font font = ((FontAttribute)this.m_selectedObject).getFont();
            ((FontAttribute)this.m_selectedObject).setFont(new Font(font.getName(), font.getStyle(), n));
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_SIZE, n2, n);
    }

    class NumberEditor
    extends NumberTextField
    implements ComboBoxEditor {
        private int _maximumValue;

        public NumberEditor() {
            this.setBorder(null);
            this.setSigned(false);
            this.setDecimal(false);
        }

        public void setBorder(Border border) {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            String string = object == null ? null : object.toString();
            this.setText(string);
        }

        public Object getItem() {
            return this.getNumber();
        }

        public void selectAll() {
            super.selectAll();
            this.requestFocus();
        }

        public void setMaximum(int n) {
            this._maximumValue = n;
        }

        public void addActionListener(ActionListener actionListener) {
            super.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            super.removeActionListener(actionListener);
        }

        protected boolean validateNumber(Number number) {
            return number.intValue() <= this._maximumValue;
        }
    }
}

