/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import oracle.dss.dataView.datacache.BaseCachedDataSource;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.RelationalEdge;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class RelationalCachedDataSource
extends BaseCachedDataSource
implements RelationalDataDirector {
    private static final boolean DEBUG_QDR = false;
    protected static final String[] DEFAULT_SUPPORTED_METADATAMAP = new String[]{"longName", "mediumName", "shortName", "value", "dataType", "isTotal"};
    public static final String CACHED_DATA = "RelationalCachedData";

    public static RelationalCachedDataSource createCachedDataSource(DataAccess dataAccess, DataDirector dataDirector) {
        RelationalCachedDataSource relationalCachedDataSource = new RelationalCachedDataSource();
        relationalCachedDataSource.initializeDataSource(dataAccess, dataDirector, -1, -1);
        return relationalCachedDataSource;
    }

    public static RelationalCachedDataSource createCachedDataSource(DataAccess dataAccess, DataDirector dataDirector, int n, int n2) {
        RelationalCachedDataSource relationalCachedDataSource = new RelationalCachedDataSource();
        relationalCachedDataSource.initializeDataSource(dataAccess, dataDirector, n, n2);
        return relationalCachedDataSource;
    }

    public QDR getValueQDR(int n, int n2, int n3) throws ColumnOutOfRangeException, RowOutOfRangeException {
        QDR qDR = null;
        try {
            qDR = this.getSliceQDR(1, n, n3);
            String string = (String)this.getLayerMetadata(0, n2, "dimName");
            qDR.setTarget(new QDRMember(string));
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return qDR;
    }

    public QDR getSliceQDR(int n, int n2, int n3) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        QDR qDR = null;
        switch (n) {
            case 2: {
                qDR = this.createQDR();
                try {
                    this.addPageEdgeToQDR(qDR);
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    qDR = null;
                }
                break;
            }
            case 1: {
                qDR = this.createQDR();
                try {
                    this.addEdgeToQDR(qDR, n, n2);
                    if (n3 != 1) break;
                    this.addPageEdgeToQDR(qDR);
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    qDR = null;
                }
                break;
            }
            case 0: {
                try {
                    qDR = this.getLayerQDR(n, n2, n3);
                    break;
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    throw new SliceOutOfRangeException(n2, this.getLayerCount(n));
                }
            }
            default: {
                return super.getSliceQDR(n, n2, 0);
            }
        }
        return qDR;
    }

    public QDR getMemberQDR(int n, int n2, int n3, int n4) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        QDR qDR = null;
        switch (n) {
            case 2: {
                qDR = this.createQDR();
                int n5 = 0;
                while (n5 <= n2) {
                    Object object = this.getMemberMetadata(n, n5, n3, "value");
                    String string = (String)this.getLayerMetadata(n, n5, "dimName");
                    qDR.addDimMemberPair(string, object == null ? null : object.toString());
                    ++n5;
                }
                break;
            }
            case 1: {
                qDR = this.getSliceQDR(n, n2, n4);
                break;
            }
            case 0: {
                qDR = this.getLayerQDR(n, n2, n4);
            }
        }
        return qDR;
    }

    public QDR getMemberQDR(int n, int[] nArray, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        QDR qDR = null;
        switch (n) {
            case 2: {
                qDR = this.createQDR();
                int n4 = 0;
                while (n4 <= n2) {
                    Object object = this.getMemberMetadata(n, nArray, n4, nArray[n4], "value");
                    String string = (String)this.getLayerMetadata(n, n4, "dimName");
                    qDR.addDimMemberPair(string, object == null ? null : object.toString());
                    ++n4;
                }
                break;
            }
            case 1: {
                qDR = this.getSliceQDR(n, n2, n3);
                break;
            }
            case 0: {
                qDR = this.getLayerQDR(n, n2, n3);
            }
        }
        return qDR;
    }

    public QDR getLayerQDR(int n, int n2, int n3) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        QDR qDR = null;
        switch (n) {
            case 0: 
            case 2: {
                String string = (String)this.getLayerMetadata(n, n2, "dimName");
                qDR = new QDR();
                try {
                    if (n != 2 && n3 == 1) {
                        this.addPageEdgeToQDR(qDR);
                    }
                }
                catch (SliceOutOfRangeException sliceOutOfRangeException) {
                    qDR = null;
                }
                qDR.addDimMemberPair(string, (String)null);
                break;
            }
        }
        return qDR;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    protected String getXMLObjectType() {
        return "RelationalDataCache";
    }

    protected String getXMLObjectName() {
        return CACHED_DATA;
    }

    protected Edge createRowColumnEdge(ObjectNode objectNode, boolean bl, Data data, Map map, Map map2) {
        return this.createRowColumnEdge(objectNode, data, map, map2);
    }

    protected Edge createRowColumnEdge(ObjectNode objectNode, Data data, Map map, Map map2) {
        return new RelationalEdge(objectNode, data, map);
    }

    protected Edge createRowColumnEdge(DataAccess dataAccess, boolean bl, int n, Map map, Map map2, int n2) {
        return this.createRowColumnEdge(dataAccess, n, map, map2, n2);
    }

    protected Edge createRowColumnEdge(DataAccess dataAccess, int n, Map map, Map map2, int n2) {
        return new RelationalEdge(dataAccess, n, map, n2);
    }

    protected int getEdgeExtent(ObjectNode objectNode) throws NoSuchPropertyException {
        return objectNode.getPropertyValueAsInteger("layerCount");
    }

    protected MetadataMap getDefaultSupportedMetadataMap() {
        return new MetadataMap(DEFAULT_SUPPORTED_METADATAMAP);
    }

    private void addPageEdgeToQDR(QDR qDR) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        Edge edge = this.m_edges[2];
        if (edge == null) {
            return;
        }
        int[] nArray = edge.getCurrentHPos();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                String string = (String)edge.getLayerMetadata(n, "dimName");
                Object object = edge.getMemberMetadata(nArray, n, nArray[n], "value");
                qDR.addDimMemberPair(string, object == null ? null : object.toString());
            }
            ++n;
        }
    }

    private void addEdgeToQDR(QDR qDR, int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        n = 0;
        try {
            int n3 = 0;
            while (n3 < this.getLayerCount(n)) {
                String string = (String)this.getLayerMetadata(n, n3, "dimName");
                qDR.addDimMemberPair(string, new QDRMember(0, this.getValue(n2, n3, "dataUnformatted").toString()));
                ++n3;
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (ColumnOutOfRangeException columnOutOfRangeException) {
        }
        catch (RowOutOfRangeException rowOutOfRangeException) {
            // empty catch block
        }
    }

    private void writeQDR(String string, QDR qDR) {
        System.out.println(String.valueOf(String.valueOf("***** ")) + string);
        System.out.print("QDR = ");
        if (qDR == null) {
            System.out.println("null");
        } else {
            System.out.println(qDR.toString());
            QDRMember qDRMember = qDR.getTarget();
            if (qDRMember != null) {
                System.out.println(String.valueOf(String.valueOf("\tTarget = ")) + qDRMember.toString());
            }
        }
    }
}

