/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.dss.dataView.AdornmentLayout;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.util.Utility;

public class DataviewUtils {
    public static boolean hasBorder(int n) {
        return n != 0 && n != 7;
    }

    public static int scaleByZoom(int n, int n2) {
        return (int)((float)n * ((float)n2 / (float)Dataview.DEFAULT_ZOOM_FACTOR));
    }

    public static int scaleDownByZoom(int n, int n2) {
        return Math.round((float)n / ((float)n2 / (float)Dataview.DEFAULT_ZOOM_FACTOR));
    }

    public static int adjustForEnhancedFont(int n, boolean bl, boolean bl2) {
        if (bl2) {
            return n + 2 + 2 + 2;
        }
        if (bl) {
            return n + 2 + 1;
        }
        return n;
    }

    public static void copyStyleProperties(Styleable styleable, Styleable styleable2) {
        ViewStyle viewStyle = styleable.getViewStyle();
        ViewStyle viewStyle2 = styleable2.getViewStyle();
        viewStyle.setBackground(viewStyle2.getBackground());
        viewStyle.setForeground(viewStyle2.getForeground());
        viewStyle.setSelectBackground(viewStyle2.getSelectBackground());
        viewStyle.setSelectForeground(viewStyle2.getSelectForeground());
        viewStyle.setFont(viewStyle2.getFont());
        viewStyle.setHorizontalAlignment(viewStyle2.getHorizontalAlignment());
        viewStyle.setVerticalAlignment(viewStyle2.getVerticalAlignment());
        viewStyle.setBorderStyle(15, viewStyle2.getBorderStyle(15));
        viewStyle.setBorderStyle(1, viewStyle2.getBorderStyle(1));
        viewStyle.setBorderStyle(4, viewStyle2.getBorderStyle(4));
        viewStyle.setBorderStyle(2, viewStyle2.getBorderStyle(2));
        viewStyle.setBorderStyle(8, viewStyle2.getBorderStyle(8));
        viewStyle.setBorderColor(15, viewStyle2.getBorderColor(15));
        viewStyle.setBorderColor(1, viewStyle2.getBorderColor(1));
        viewStyle.setBorderColor(2, viewStyle2.getBorderColor(2));
        viewStyle.setBorderColor(4, viewStyle2.getBorderColor(4));
        viewStyle.setBorderColor(8, viewStyle2.getBorderColor(8));
        viewStyle.setBorderWidth(15, viewStyle2.getBorderWidth(15));
        viewStyle.setBorderWidth(1, viewStyle2.getBorderWidth(1));
        viewStyle.setBorderWidth(2, viewStyle2.getBorderWidth(2));
        viewStyle.setBorderWidth(4, viewStyle2.getBorderWidth(4));
        viewStyle.setBorderWidth(8, viewStyle2.getBorderWidth(8));
        viewStyle.setUnderline(viewStyle2.isUnderline());
        viewStyle.setDoubleUnderline(viewStyle2.isDoubleUnderline());
        viewStyle.setStrikeThrough(viewStyle2.isStrikeThrough());
        viewStyle.setWordWrapEnabled(viewStyle2.isWordWrapEnabled());
        viewStyle.setGraphicImageIndex(viewStyle2.getGraphicImageIndex());
        viewStyle.setGraphicImageTooltip(viewStyle2.getGraphicImageTooltip());
        viewStyle.setCellEditStyle(viewStyle2.getCellEditStyle());
        viewStyle.setEditBackground(viewStyle2.getEditBackground());
        viewStyle.setEditForeground(viewStyle2.getEditForeground());
        viewStyle.setGraphicBarColor(viewStyle2.getGraphicBarColor());
        viewStyle.setGraphicBarVisible(viewStyle2.isGraphicBarVisible());
        viewStyle.setHPageBreak(viewStyle2.isHPageBreak());
        viewStyle.setVPageBreak(viewStyle2.isVPageBreak());
        viewStyle.setPropertyUsedFlags(viewStyle2.getPropertyUsedFlags());
    }

    static void setFlowAlignment(LayoutManager layoutManager, int n) {
        if (!(layoutManager instanceof AdornmentLayout)) {
            return;
        }
        AdornmentLayout adornmentLayout = (AdornmentLayout)layoutManager;
        switch (n) {
            case 0: {
                adornmentLayout.setAlignment(1);
                break;
            }
            case 2: {
                adornmentLayout.setAlignment(0);
                break;
            }
            case 4: {
                adornmentLayout.setAlignment(2);
            }
        }
    }

    public static final void selectPageItem(Dataview dataview, long l) {
        if (dataview.getPagingControl() != null && dataview.getPagingControl().getPagingComponent() != null && l >= (long)0) {
            dataview.getPagingControl().getPagingComponent().setSelectedItem(dataview.getPagingControl().getPagingComponent().getItem((int)l));
        }
    }

    public static int convertVertAlignToEWT(int n) {
        int n2 = -1;
        switch (n) {
            case 3: {
                n2 = 2;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static int convertHorizAlignToEWT(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static int convertVertAlignToJava(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
            }
        }
        return n2;
    }

    public static int convertHorizAlignToJava(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 0: {
                n2 = 10;
            }
        }
        return n2;
    }

    public static int compareXMLVersions(String string, String string2) {
        return Utility.compareXMLVersions(string, string2);
    }

    public static String toHexString(int n) {
        String string = Integer.toHexString(n & 0xFFFFFF);
        String string2 = "#";
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int hexStringToInt(String string) {
        String string2 = string.substring(1);
        return Integer.parseInt(string2, 16);
    }

    public static int fontStyle(boolean bl, boolean bl2) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        return n;
    }

    public static Double toDouble(String string, Locale locale, NumberFormat numberFormat) {
        String string2 = string.trim();
        DecimalFormatSymbols decimalFormatSymbols = null;
        decimalFormatSymbols = locale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(locale);
        char c = decimalFormatSymbols.getGroupingSeparator();
        string = c == '\u00a0' ? string2.replace(' ', c) : string2;
        if (numberFormat == null) {
            numberFormat = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string, parsePosition);
        Double d = null;
        if (parsePosition.getIndex() == string.length()) {
            if (number instanceof Double) {
                d = (Double)number;
            } else if (number != null) {
                d = new Double(number.doubleValue());
            }
        }
        return d;
    }

    public static void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                DataviewUtils.setCursor(container.getComponent(n), cursor);
                ++n;
            }
        }
    }
}

