/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.PacketProcessor;
import oracle.ias.cache.groupv2.RegistrationInfo;
import oracle.ias.cache.groupv2.SequenceToken;
import oracle.ias.cache.groupv2.View;

class DistributorPacketProcessor
extends PacketProcessor {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.DistributorPacketProcessor";
    private Distributor distributor_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.DistributorPacketProcessor");

    DistributorPacketProcessor(ConnectionOwner connectionOwner) {
        super((Distributor)connectionOwner);
        this.distributor_ = (Distributor)connectionOwner;
    }

    void process(Packet packet, EndPointConnection endPointConnection) throws GroupException {
        block29: {
            if (this.logger_.isLoggable(Level.FINER)) {
                this.logger_.log(Level.FINER, "Process " + packet.toString(true));
            }
            try {
                switch (packet.getType()) {
                    case 3: {
                        this.registerationRequest(packet, endPointConnection);
                        break;
                    }
                    case 4: {
                        this.coordinatorLookup(packet, endPointConnection);
                        break;
                    }
                    case 12: {
                        this.getDistributorList(packet, endPointConnection);
                        break;
                    }
                    case 13: {
                        this.electCoordinator(packet, endPointConnection, true);
                        break;
                    }
                    case 14: {
                        this.electCoordinator(packet, endPointConnection, false);
                        break;
                    }
                    case 2: {
                        this.disconnect(endPointConnection, packet);
                        break;
                    }
                    case 5: {
                        if (packet.isARequest()) {
                            this.broadcast(packet, endPointConnection);
                            break;
                        }
                        this.replyAck(packet, endPointConnection);
                        break;
                    }
                    case 6: {
                        if (packet.isARequest()) {
                            this.unicast(packet, endPointConnection);
                            break;
                        }
                        this.replyAck(packet, endPointConnection);
                        break;
                    }
                    case 1: {
                        this.newView(packet, endPointConnection);
                        break;
                    }
                    case 10: {
                        this.viewChangeComplete(packet, endPointConnection);
                        break;
                    }
                    case 8: {
                        this.linkDistributor(packet, endPointConnection);
                        break;
                    }
                    case 15: {
                        this.relinkDistributor(packet, endPointConnection);
                        break;
                    }
                    case 11: {
                        this.closeDuplicatedDistributor(packet, endPointConnection);
                        break;
                    }
                    case 16: {
                        this.switchCoordinator(packet, endPointConnection);
                        break;
                    }
                    case 17: {
                        this.terminate(packet, endPointConnection);
                        break;
                    }
                    case 19: {
                        if (packet.isARequest()) {
                            this.getToken(packet, endPointConnection);
                            break;
                        }
                        this.replyAck(packet, endPointConnection);
                        break;
                    }
                    case 20: {
                        this.releaseToken(packet, endPointConnection);
                        break;
                    }
                    case 21: {
                        this.updateTotalSequence(packet, endPointConnection);
                        break;
                    }
                    case 9: 
                    case 18: {
                        if (this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "Unsupported packet:" + packet.toString(true));
                        }
                        break;
                    }
                    default: {
                        if (this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "Unrecognized packet:" + packet.getType() + " " + packet.toString(true));
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (this.parent_.isTerminating() || !this.logger_.isLoggable(Level.SEVERE)) break block29;
                this.logger_.log(Level.SEVERE, "PacketProcessor failure ", exception);
            }
        }
    }

    private void coordinatorLookup(Packet packet, EndPointConnection endPointConnection) throws IOException, GroupException {
        MemberID memberID = MemberID.parse(packet.getOrigin());
        Address address = Address.parse(packet.getData());
        endPointConnection.setType(1);
        endPointConnection.setRemoteMemberID(memberID);
        endPointConnection.setRemoteAddress(address);
        if (this.distributor_.isACoordinator()) {
            packet.setData(this.distributor_.getMyAddressOn(address.getNetworkId()).toBytes());
        } else {
            Address address2 = this.distributor_.getCoordinatorAddress();
            if (address2 == null) {
                packet.getFlag().set(5);
            } else if (this.distributor_.isARouter() && address.getNetworkId() != address2.getNetworkId()) {
                packet.setData(this.distributor_.getMyAddressOn(address.getNetworkId()).toBytes());
            } else {
                packet.setData(address2.toBytes());
            }
        }
        this.distributor_.replyToSender(endPointConnection, packet);
    }

    private void getDistributorList(Packet packet, EndPointConnection endPointConnection) throws IOException, GroupException, CloneNotSupportedException {
        endPointConnection.setType(1);
        RegistrationInfo registrationInfo = RegistrationInfo.parse(packet.getData());
        if (this.distributor_.isACoordinator()) {
            if (this.distributor_.addDistributor(registrationInfo.getDistributorAddress(), registrationInfo.getDistributorID(), endPointConnection)) {
                this.distributor_.getViewManager().addDistributor(registrationInfo);
            } else {
                endPointConnection.close();
            }
        } else if (this.distributor_.isARouter()) {
            if (this.distributor_.addDistributor(registrationInfo.getDistributorAddress(), registrationInfo.getDistributorID(), endPointConnection)) {
                this.distributor_.forwardToCoordinator(packet);
            }
        } else {
            packet.getFlag().set(5);
            packet.setData(null);
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Ignore lookup request " + packet);
            }
            this.distributor_.replyToSender(endPointConnection, packet);
        }
    }

    private void linkDistributor(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        if (packet.isARequest()) {
            endPointConnection.setType(1);
            Address address = Address.parse(packet.getData());
            MemberID memberID = MemberID.parse(packet.getOrigin());
            endPointConnection.setRemoteAddress(address);
            packet.setData(null);
            boolean bl = this.distributor_.addDistributor(address, memberID, endPointConnection);
            if (bl) {
                endPointConnection.setTightlyBound(true);
                if (this.logger_.isLoggable(Level.INFO)) {
                    this.logger_.log(Level.INFO, "Connected from " + memberID);
                }
            } else {
                packet.getFlag().set(5);
                endPointConnection.setTightlyBound(false);
            }
            this.distributor_.replyToSender(endPointConnection, packet);
        }
    }

    private void relinkDistributor(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException, CloneNotSupportedException {
        if (this.distributor_.isACoordinator()) {
            if (packet.isARequest()) {
                Address address = Address.parse(packet.getData());
                MemberID memberID = MemberID.parse(packet.getOrigin());
                this.distributor_.getViewManager().replaceDistributor(address, memberID, true);
            } else if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unexpected reply " + packet);
            }
        } else if (this.distributor_.isARouter()) {
            this.distributor_.forwardToCoordinator(packet);
        } else if (this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "Unexpected request " + packet);
        }
    }

    private void electCoordinator(Packet packet, EndPointConnection endPointConnection, boolean bl) throws IOException, GroupException {
        MemberID memberID = MemberID.parse(packet.getOrigin());
        if (bl) {
            endPointConnection.setType(1);
            endPointConnection.close();
        }
        PacketHolder packetHolder = PacketHolder.wrap(packet, endPointConnection);
        this.distributor_.enqueue(3, packetHolder);
        if (this.distributor_.isARouter()) {
            Address address = Address.parse(packet.getData());
            int n = address.getNetworkId();
        }
    }

    void disconnect(EndPointConnection endPointConnection, Packet packet) throws IOException, GroupException, CloneNotSupportedException {
        if (this.distributor_.isACoordinator()) {
            if (!packet.getFlag().containsDistributor()) {
                endPointConnection.close();
            } else {
                MemberID memberID;
                MemberID memberID2 = MemberID.parse(packet.getData());
                if (!memberID2.equals(memberID = MemberID.parse(packet.getOrigin()))) {
                    Vector vector = this.distributor_.getMembersToBeRemoved();
                    Vector vector2 = this.distributor_.getDistributorsToBeRemoved();
                    Vector vector3 = this.distributor_.getQueue(1);
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "To be disconnected " + memberID2);
                    }
                    vector.addElement(memberID2);
                    this.distributor_.getViewManager().removeMembers(vector, vector2, vector3);
                } else {
                    endPointConnection.close();
                }
            }
        } else if (this.distributor_.isARouter()) {
            if (packet.isARequest() && !packet.getFlag().containsCoordinator()) {
                endPointConnection.close();
            } else {
                this.distributor_.forwardToCoordinator(packet);
            }
        } else if (packet.isARequest() && !packet.getFlag().containsCoordinator()) {
            endPointConnection.close();
        }
    }

    private void registerationRequest(Packet packet, EndPointConnection endPointConnection) throws IOException, GroupException, CloneNotSupportedException {
        try {
            this.distributor_.waitForInitCompleted(this.distributor_.getConfig().getInitTimeout());
        }
        catch (GroupException groupException) {
            endPointConnection.close();
            return;
        }
        if (!endPointConnection.isAlive()) {
            return;
        }
        RegistrationInfo registrationInfo = RegistrationInfo.parse(packet.getData());
        if (this.distributor_.isACoordinator()) {
            if (!packet.getFlag().containsDistributor()) {
                registrationInfo.setDistributorID(this.distributor_.getID());
                if (registrationInfo.getVMId().equals(ConnectionOwner.getVMId())) {
                    registrationInfo.setInSameJVMOfDistributor(true);
                } else {
                    registrationInfo.setInSameJVMOfDistributor(false);
                }
                this.distributor_.addClient(registrationInfo.getMemberID(), endPointConnection);
            }
            this.distributor_.addPendingNewMember(registrationInfo);
        } else {
            if (!this.distributor_.isARouter() || !packet.getFlag().containsDistributor()) {
                registrationInfo.setDistributorID(this.distributor_.getID());
                if (registrationInfo.getVMId().equals(ConnectionOwner.getVMId())) {
                    registrationInfo.setInSameJVMOfDistributor(true);
                } else {
                    registrationInfo.setInSameJVMOfDistributor(false);
                }
                packet.setData(registrationInfo.toBytes());
            }
            try {
                this.distributor_.forwardToCoordinator(packet);
                if (!this.distributor_.isARouter() || !packet.getFlag().containsDistributor()) {
                    this.distributor_.addClient(registrationInfo.getMemberID(), endPointConnection);
                }
            }
            catch (Exception exception) {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Unable to forward " + packet.toString(true), exception);
                }
                endPointConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException, CloneNotSupportedException {
        boolean bl = !packet.getFlag().containsDistributor() & !packet.getFlag().containsCoordinator();
        this.distributor_.getViewManager().lock(0, 0);
        View view = this.distributor_.getViewManager().getCurrentView();
        try {
            if (bl) {
                HashSet<MemberID> hashSet = new HashSet<MemberID>(1);
                hashSet.add(endPointConnection.getRemoteMemberID());
                this.distributor_.sendTo(view, packet, hashSet, null);
            } else {
                view = this.distributor_.getViewManager().getView(packet.getViewId());
                this.distributor_.sendToClients(packet, view, null);
            }
            Object var7_6 = null;
            this.removeTempFile(packet.getAttachedFilename());
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.removeTempFile(packet.getAttachedFilename());
            this.distributor_.getViewManager().unlock(0, 0);
            throw throwable;
        }
        this.distributor_.getViewManager().unlock(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unicast(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException, CloneNotSupportedException {
        boolean bl = !packet.getFlag().containsDistributor() & !packet.getFlag().containsCoordinator();
        this.distributor_.getViewManager().lock(0, 0);
        View view = this.distributor_.getViewManager().getCurrentView();
        try {
            MemberID memberID = MemberID.parse(packet.getDestination());
            MemberID memberID2 = view.getDistributorOfMember(memberID);
            if (memberID2 == null) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Can't find any distributor for " + memberID + ", view=" + view);
                }
            } else if (this.distributor_.getID().equals(memberID2)) {
                this.distributor_.sendToClient(memberID, packet);
            } else {
                this.distributor_.sendToDistributor(memberID2, packet);
            }
        }
        finally {
            this.distributor_.getViewManager().unlock(0, 0);
        }
    }

    private void replyAck(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        if (this.logger_.isLoggable(Level.FINER)) {
            this.logger_.log(Level.FINEST, "Reply to sender " + packet);
        }
        MemberID memberID = MemberID.parse(packet.getDestination());
        EndPointConnection endPointConnection2 = null;
        View view = this.distributor_.getViewManager().getCurrentView();
        if (!view.contains(memberID)) {
            return;
        }
        if (packet.getViewId() > view.getViewID()) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "View too old: " + view.getViewID());
            }
            this.replyAckLater(packet, endPointConnection);
            return;
        }
        MemberID memberID2 = view.getDistributorOfMember(memberID);
        endPointConnection2 = this.distributor_.getID().equals(memberID2) ? this.distributor_.getEndPointConnectionOf(memberID, true) : this.distributor_.getEndPointConnectionOf(memberID2, false);
        if (endPointConnection2 != null) {
            try {
                this.distributor_.sendPacketTo(endPointConnection2, packet);
            }
            catch (IOException iOException) {
                this.replyAckLater(packet, endPointConnection);
            }
            catch (GroupException groupException) {
                this.replyAckLater(packet, endPointConnection);
            }
        } else {
            if (this.logger_.isLoggable(Level.WARNING)) {
                this.logger_.log(Level.WARNING, "Unable to reply ACK " + packet.toString(true));
            }
            this.replyAckLater(packet, endPointConnection);
        }
    }

    private void replyAckLater(Packet packet, EndPointConnection endPointConnection) {
        PacketHolder packetHolder = PacketHolder.wrap(packet, endPointConnection);
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "Reply ack later. Packet=" + packet);
        }
        if (this.distributor_.isACoordinator()) {
            this.distributor_.enqueue(1, packetHolder);
        } else {
            this.distributor_.enqueue(5, packetHolder);
        }
    }

    private void reply(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        Packet packet2 = packet;
        boolean bl = !packet2.getFlag().containsDistributor() & !packet2.getFlag().containsCoordinator();
        if (this.distributor_.hasAll(packet.getSequence())) {
            this.distributor_.clearReciptHolder(packet.getSequence());
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Reply to sender " + packet);
            }
            MemberID memberID = MemberID.parse(packet2.getOrigin());
            EndPointConnection endPointConnection2 = this.distributor_.getEndPointConnectionOf(memberID, bl);
            byte[] byArray = packet2.getOrigin();
            packet2.setDestination(byArray);
            packet2.setOrigin(this.distributor_.getID());
            packet2.setAsReply();
            packet2.setAck(packet2.getSequence());
            this.distributor_.enqueue(0, PacketHolder.wrap(packet2, endPointConnection2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newView(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException, CloneNotSupportedException {
        if (!this.distributor_.isACoordinator()) {
            if (packet.isARequest()) {
                Object object;
                View view = View.parse(packet.getData());
                this.distributor_.getViewManager().addView(view);
                try {
                    object = view.getCoordinatorID();
                    EndPointConnection endPointConnection2 = this.distributor_.getEndPointConnectionOf((MemberID)object, false);
                    if (endPointConnection2 != null) {
                        this.distributor_.setCoordinatorEp(endPointConnection2);
                    }
                }
                finally {
                    this.distributor_.getViewManager().updateToLatest(true);
                }
                this.distributor_.sendToClients(packet, view, null);
                object = null;
                while ((object = this.distributor_.dequeue(5, 1L)) != null) {
                    this.distributor_.enqueue(1, (PacketHolder)object);
                }
            } else {
                this.distributor_.forwardToCoordinator(packet);
            }
        } else if (packet.isARequest()) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Coordinator does not expect any new  view request " + packet.toString(true));
            }
        } else if (this.distributor_.hasAll(packet.getSequence())) {
            this.distributor_.clearReciptHolder(packet.getSequence());
        }
    }

    private void viewChangeComplete(Packet packet, EndPointConnection endPointConnection) throws IOException, GroupException, CloneNotSupportedException {
        if (this.distributor_.isACoordinator()) {
            if (packet.isARequest()) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Coordinator does not expect any  view change request " + packet.toString(true));
                }
            } else if (this.distributor_.hasAll(packet.getSequence())) {
                this.distributor_.clearReciptHolder(packet.getSequence());
                this.distributor_.getViewManager().setInProgress(false);
                this.distributor_.getViewManager().unlock(1, 1);
            }
        } else if (packet.isARequest()) {
            this.distributor_.getViewManager().updateToLatest(true);
            this.distributor_.sendToClients(packet, this.distributor_.getViewManager().getCurrentView(), null);
        } else {
            this.distributor_.forwardToCoordinator(packet);
        }
    }

    private void closeDuplicatedDistributor(Packet packet, EndPointConnection endPointConnection) {
        endPointConnection.setTightlyBound(false);
        endPointConnection.close();
    }

    private void switchCoordinator(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        if (this.distributor_.isACoordinator()) {
            this.distributor_.setRole(0, false);
        } else if (this.distributor_.isARouter()) {
            this.distributor_.forwardToCoordinator(packet);
        }
    }

    private void terminate(Packet packet, EndPointConnection endPointConnection) throws GroupException {
        if (this.distributor_.isARouter()) {
            // empty if block
        }
        this.distributor_.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getToken(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        this.distributor_.getViewManager().lock(0, 0);
        View view = this.distributor_.getViewManager().getCurrentView();
        this.distributor_.getViewManager().unlock(0, 0);
        if (this.distributor_.isACoordinator()) {
            SequenceToken sequenceToken;
            SequenceToken sequenceToken2 = sequenceToken = this.distributor_.getSequenceToken();
            synchronized (sequenceToken2) {
                if (!sequenceToken.acquiredBy(MemberID.parse(packet.getOrigin()))) {
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "SequenceToken not available. " + sequenceToken);
                    }
                    PacketHolder packetHolder = PacketHolder.wrap(packet, endPointConnection);
                    this.distributor_.enqueue(4, packetHolder);
                    return;
                }
            }
            long l = sequenceToken.getSequence();
            Packet packet2 = new Packet(21, MemberID.parse(packet.getOrigin()));
            packet2.setTotalSequence(l);
            packet2.setViewId(view.getViewID());
            packet2.setBlockReceiver();
            this.distributor_.sendToDistributors(packet2);
            this.distributor_.sendToClients(packet2, view, null);
            Packet packet3 = new Packet(19, this.distributor_.getID());
            packet3.setAsReply();
            packet3.setAck(packet.getSequence());
            packet3.setTotalSequence(l);
            packet3.setForRegistered();
            packet3.setBlockReceiver();
            packet3.setDestination(packet.getOrigin());
            packet3.setViewId(view.getViewID());
            try {
                this.distributor_.sendPacketTo(endPointConnection, packet3);
            }
            catch (IOException iOException) {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Unable to contact token holder. ", iOException);
                }
                sequenceToken.release();
            }
        } else {
            this.distributor_.forwardToCoordinator(packet);
        }
    }

    private void releaseToken(Packet packet, EndPointConnection endPointConnection) throws GroupException, IOException {
        if (this.distributor_.isACoordinator()) {
            this.distributor_.releaseToken();
            View view = this.distributor_.getViewManager().getCurrentView();
            Packet packet2 = new Packet(21);
            packet2.setViewId(view.getViewID());
            packet2.setBlockReceiver();
            this.distributor_.sendToDistributors(packet2);
            this.distributor_.sendToClients(packet2, view, null);
        } else {
            this.distributor_.forwardToCoordinator(packet);
        }
    }

    private void updateTotalSequence(Packet packet, EndPointConnection endPointConnection) throws GroupException {
        if (!this.distributor_.isACoordinator()) {
            View view = this.distributor_.getViewManager().getCurrentView();
            this.distributor_.sendToClients(packet, view, null);
        }
    }

    private void removeTempFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        file.delete();
    }
}

