/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.Sender;

class CoordinatorBroadcaster
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.CoordinatorBroadcaster";
    static final long DEFAULT_LIFETIME = 3600000L;
    private Distributor parent_;
    private boolean terminate_;
    private InetAddress multicastAddr_;
    private long interval_;
    private Object waiter_;
    private int port_;
    private MulticastSocket ms_;
    private boolean confirmed_;
    private long endtime_;
    private boolean useMulticast_;
    private Address[] dlist_;
    private boolean onLink_;
    private int packetType_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.CoordinatorBroadcaster");

    CoordinatorBroadcaster(Distributor distributor, Address[] addressArray, boolean bl, boolean bl2, int n) throws GroupException {
        this(distributor, addressArray, bl, bl2);
        this.packetType_ = n;
    }

    CoordinatorBroadcaster(Distributor distributor, boolean bl, boolean bl2) throws GroupException {
        this.parent_ = distributor;
        this.confirmed_ = bl;
        this.onLink_ = bl2;
        this.packetType_ = bl2 ? 14 : 13;
        this.useMulticast_ = distributor.getConfig().isUseMulticastResolution();
        this.waiter_ = new Object();
        this.interval_ = distributor.getConfig().getResolutionInterval();
        this.endtime_ = 3600000L + System.currentTimeMillis();
        this.setDaemon(true);
        if (this.useMulticast_) {
            try {
                this.multicastAddr_ = InetAddress.getByName(distributor.getConfig().getMulticastAddress());
                this.ms_ = new MulticastSocket(distributor.getConfig().getMulticastPort());
                this.ms_.setTimeToLive(distributor.getConfig().getMulticastTtl());
                this.ms_.joinGroup(this.multicastAddr_);
            }
            catch (Exception exception) {
                throw new GcommException("Unable to broadcast coordinator availability", (Throwable)exception);
            }
            this.setName("Coordinator Election Broadcaster at [" + this.multicastAddr_.getHostAddress() + ":" + this.port_ + "]");
        }
    }

    CoordinatorBroadcaster(Distributor distributor, Address[] addressArray, boolean bl, boolean bl2) throws GroupException {
        this(distributor, bl, bl2);
        this.dlist_ = addressArray;
        this.setName("Coordinator Election Broadcaster");
    }

    MulticastSocket getMulticastSocket() {
        return this.ms_;
    }

    void setToConnectedMembersOnly(boolean bl) {
        this.onLink_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate_ = true;
        Object object = this.waiter_;
        synchronized (object) {
            this.waiter_.notifyAll();
        }
        if (this.useMulticast_ && this.ms_ != null) {
            try {
                this.ms_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.join(this.interval_ * 2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void shutdown(long l) {
        this.endtime_ = System.currentTimeMillis() + l;
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Schedule broadcaster shutdown in " + l + " msec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void confirmNominee() {
        this.confirmed_ = true;
        Object object = this.waiter_;
        synchronized (object) {
            this.waiter_.notifyAll();
        }
    }

    Packet createTicket(int n) throws GroupException {
        Packet packet = new Packet(this.packetType_, this.parent_.getID(), this.parent_.getViewManager().getCurrentView().getViewID());
        Address address = this.parent_.getMyAddressOn(n);
        if (address != null) {
            packet.setData(address.toBytes());
        }
        packet.setBlockReceiver();
        if (this.confirmed_) {
            packet.getFlag().set(3);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block32: {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, this.getName() + " is started.");
            }
            Hashtable<Address, Sender> hashtable2 = new Hashtable<Address, Sender>(this.dlist_.length);
            Vector vector = new Vector(this.dlist_.length);
            try {
                try {}
                catch (Exception exception) {
                    this.logger_.log(Level.FINE, "Failed to broadcast election vote", exception);
                    Object var13_14 = null;
                    Hashtable<Address, Sender> hashtable = hashtable2;
                    synchronized (hashtable) {
                        if (hashtable2.size() > 0) {
                            Enumeration enumeration = hashtable2.keys();
                            while (enumeration.hasMoreElements()) {
                                Object k = enumeration.nextElement();
                                Sender sender = (Sender)hashtable2.get(k);
                                if (sender == null) continue;
                                sender.shutdown();
                            }
                        }
                        break block32;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Hashtable<Address, Sender> hashtable = hashtable2;
                synchronized (hashtable) {
                    if (hashtable2.size() > 0) {
                        Enumeration enumeration = hashtable2.keys();
                        while (enumeration.hasMoreElements()) {
                            Object k = enumeration.nextElement();
                            Sender sender = (Sender)hashtable2.get(k);
                            if (sender == null) continue;
                            sender.shutdown();
                        }
                    }
                    throw throwable;
                }
            }
            while (!this.terminate_) {
                Packet packet = this.createTicket(-1);
                Object object = this;
                synchronized (object) {
                    if (this.useMulticast_) {
                        DatagramPacket datagramPacket = new DatagramPacket(packet.toBytes(), packet.toBytes().length, this.multicastAddr_, this.port_);
                        this.ms_.send(datagramPacket);
                        if (this.logger_.isLoggable(Level.FINE)) {
                            this.logger_.log(Level.FINE, "Broadcast election vote  to multicast address:" + this.ms_);
                        }
                    } else if (this.onLink_) {
                        this.parent_.sendToDistributors(packet);
                    } else {
                        for (int i = 0; i < this.dlist_.length && !this.terminate_; ++i) {
                            Address address = this.dlist_[i];
                            if (hashtable2.containsKey(this.dlist_[i])) continue;
                            boolean bl = this.parent_.isAlreadyConnectedTo(this.dlist_[i]);
                            if (!bl) {
                                packet = this.createTicket(-1);
                                Address address2 = this.parent_.getMyAddressOn(address.getNetworkId());
                                packet.setData(address2.toBytes());
                                Sender sender = new Sender(this.parent_, this.dlist_[i], packet, this.parent_.getConfig().getConnectTimeout(), vector, hashtable2, i, false, 0);
                                hashtable2.put(this.dlist_[i], sender);
                                sender.start();
                                continue;
                            }
                            if (!this.logger_.isLoggable(Level.FINEST)) continue;
                            this.logger_.log(Level.FINEST, "Skip broadcasting to " + this.dlist_[i]);
                        }
                    }
                    if (this.endtime_ <= System.currentTimeMillis()) {
                        break;
                    }
                    if (this.terminate_) break;
                }
                object = this.waiter_;
                synchronized (object) {
                    try {
                        this.waiter_.wait(this.interval_);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Object var13_13 = null;
            Hashtable<Address, Sender> hashtable = hashtable2;
            synchronized (hashtable) {
                if (hashtable2.size() > 0) {
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        Sender sender = (Sender)hashtable2.get(k);
                        if (sender == null) continue;
                        sender.shutdown();
                    }
                }
            }
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is terminated.");
        }
    }
}

