/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.GrpReplyInfo;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

class Monitor
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.Monitor";
    static final int SECONDS = 20;
    static final int FACTOR = 10;
    static final long MIN_READ = 10L;
    private boolean work = true;
    private byte[] long_lock = new byte[0];
    private long lastPinged;
    private byte[] lock = new byte[0];
    private HashSet pendingReply = null;
    private long counter = 0L;
    private boolean isPause_ = false;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.Monitor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Monitor(GrpCommunication grpCommunication, Transport transport) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        byte[] byArray = this.long_lock;
        synchronized (this.long_lock) {
            this.lastPinged = System.currentTimeMillis();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.setName("Group Monitor");
            this.setDaemon(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (this.work) {
            try {
                byte[] byArray = this.lock;
                // MONITORENTER : this.lock
                if (this.isPause_) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : byArray
                Thread.sleep(20000L);
                if (this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) {
                    this.ping();
                } else {
                    this.check();
                }
                ++this.counter;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                if (!this.trans_.isReady() || !this.logger_.isLoggable(Level.WARNING)) continue;
                this.logger_.log(Level.WARNING, "Monitor Exception:", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ping() throws GroupException, IOException, InterruptedException {
        Object object;
        Object object2;
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager2 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        View view = groupManager2.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager groupManager3 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        GroupManager groupManager4 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager4.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager5 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        ViewInfo viewInfo = groupManager5.getCurrentViewInfo(GroupManager.SYSTEM_GROUP);
        MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
        GroupManager groupManager6 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager6.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (this.counter % 10L == 0L) {
            object2 = this.lock;
            // MONITORENTER : this.lock
            HashSet hashSet = this.pendingReply != null && this.pendingReply.size() > 0 ? new HashSet(this.pendingReply) : null;
            // MONITOREXIT : object2
            if (hashSet != null && hashSet.size() != 0) {
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (Address)object2.next();
                    if (view.getMembers().contains(object) && this.trans_.getRecentReadOf((Address)object) < 10L) {
                        if (this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "No PING_ACK from " + object + " and " + this.trans_.getRecentReadOf((Address)object) + " recent packets: declare it dead.");
                        }
                        this.terminateRemoteMember((Address)object);
                        continue;
                    }
                    object2.remove();
                }
            }
        }
        if (view.getMembers().size() <= 1) return;
        Address address = this.trans_.getLocalAddress();
        this.trans_.getGroupManager();
        Packet packet = new Packet(10, 0, address, (Serializable)((Object)GroupManager.SYSTEM_GROUP), new Long(this.counter), 0L);
        packet.setReceiveArray(messageBuffer.getStableVector());
        packet.setReceivedTONumber(this.trans_.getReceivedTONumber());
        messageBuffer.setUpdated(false);
        object2 = this.trans_.multicast(packet);
        if (object2 == null) return;
        if (((GrpReplyInfo)object2).getView() == null) return;
        if (((GrpReplyInfo)object2).getView().getMembers() == null) {
            return;
        }
        if (this.counter % 10L != 0L) return;
        object = this.lock;
        // MONITORENTER : this.lock
        this.pendingReply = new HashSet(((GrpReplyInfo)object2).getView().getMembers());
        // MONITOREXIT : object
        this.pendingReply.remove(this.trans_.getLocalAddress());
        this.trans_.resetRecentCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotReply(Address address) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (address == null || this.pendingReply == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.pendingReply.size() > 0) {
                this.pendingReply.remove(address);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotPinged() {
        byte[] byArray = this.long_lock;
        synchronized (this.long_lock) {
            this.lastPinged = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void check() throws InterruptedException {
        Address address = this.trans_.getFailureDetector().getCoordinator();
        if (System.currentTimeMillis() - this.lastPinged > 400000L && this.trans_.getRecentReadOf(address) < 10L) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Haven't got PING message and only " + this.trans_.getRecentReadOf(address) + " recent packets. Declare Coordinator Dead at " + address);
            }
            this.terminateRemoteMember(address);
            this.gotPinged();
        }
        if (this.counter % 20L == 0L) {
            this.trans_.resetRecentCounter(this.trans_.getFailureDetector().getCoordinator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toPause() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.isPause_ = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.counter = 0L;
            this.pendingReply = null;
            this.isPause_ = false;
            this.lastPinged = System.currentTimeMillis();
            this.lock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.trans_.resetRecentCounter();
            return;
        }
    }

    public void stopit() {
        this.work = false;
        this.interrupt();
        Thread.yield();
    }

    private void terminateRemoteMember(Address address) {
        block8: {
            block7: {
                EndPoint endPoint = (EndPoint)this.trans_.getEndPointList().get(address);
                if (endPoint != null) {
                    endPoint.close(true);
                } else {
                    try {
                        this.trans_.getFailureDetector().processFailure(address);
                        if (this.logger_.isLoggable(Level.WARNING)) {
                            this.logger_.log(Level.WARNING, "Removed " + address + " by force");
                        }
                    }
                    catch (Exception exception) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block7;
                        this.logger_.log(Level.WARNING, "Unable to remove " + address + " from the view without any EndPoint", exception);
                    }
                }
            }
            try {
                Address address2 = this.trans_.getLocalAddress();
                this.trans_.getGroupManager();
                Packet packet = new Packet(22, 0, address2, (Serializable)((Object)GroupManager.SYSTEM_GROUP), address, 0L);
                this.trans_.multicast(packet);
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.WARNING)) break block8;
                this.logger_.log(Level.WARNING, "Warning, can't remotely terminate member at" + address, exception);
            }
        }
    }
}

