/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GrpChannel;
import oracle.ias.cache.group.GrpConfig;
import oracle.ias.cache.group.Transport;

public class GrpCommunication
implements GroupCommunication {
    static String EXP_GRP_INTERNAL;
    static String EXP_GRP_INVALIDADDR;
    static String EXP_GRP_BASE;
    static String EXP_GRP_INVALIDCHANNEL;
    static String EXP_GRP_VIEWINFOEMPTY;
    static String EXP_GRP_VIEWNULL;
    static String EXP_GRP_NOLOCALHOST;
    static String EXP_GRP_PORTINUSE;
    static String EXP_GRP_SOCKETINITFAIL;
    static String EXP_GRP_INVALIDPAR;
    static String EXP_GRP_NULLPOINTER;
    static String EXP_GRP_REPLYISNULL;
    static String EXP_GRP_NOCONNECTION;
    static String EXP_GRP_NOGROUPINFO;
    static String EXP_GRP_NOTINITIALIZED;
    static String EXP_GRP_WRONG_MODE;
    static String EXP_GRP_INVALID_STREAM;
    static String EXP_GRP_INVALID_HTTP;
    static String EXP_GRP_CON_TERMINATED;
    static String EXP_GRP_SSL_PROVIDER_INSTANTIATION;
    static String EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND;
    static String EXP_GRP_SSL_PROVIDER_CLASSCAST;
    static String EXP_GRP_SSL_CONFIG;
    static String EXP_GRP_SSL_SSOCKET;
    static String EXP_GRP_SSL_SOCKET;
    public static final String LOGGING = "oracle.ias.cache.group.logging";
    public static final String LOG_LEVEL = "oracle.ias.cache.group.loglevel";
    static final String LOGGER_NAME = "oracle.ias.cache.group.GrpCommunication";
    private GroupConfig config_;
    private boolean ready = false;
    private String logId = null;
    private GrpChannel channel_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.GrpCommunication");

    public Channel init(boolean bl, GroupConfig groupConfig, MessageQueue messageQueue, Object object) throws GroupException {
        if (this.ready) {
            return this.channel_;
        }
        this.config_ = groupConfig;
        try {
            ResourceBundle resourceBundle = CacheInternal.initExceptionLocale();
            if (resourceBundle == null) {
                this.logger_.log(Level.SEVERE, "Can't read exception locale.");
            } else {
                EXP_GRP_INTERNAL = resourceBundle.getString("EXP_GRP_INTERNAL");
                EXP_GRP_INVALIDADDR = resourceBundle.getString("EXP_GRP_INVALIDADDR");
                EXP_GRP_BASE = resourceBundle.getString("EXP_GRP_BASE");
                EXP_GRP_INVALIDCHANNEL = resourceBundle.getString("EXP_GRP_INVALIDCHANNEL");
                EXP_GRP_VIEWINFOEMPTY = resourceBundle.getString("EXP_GRP_VIEWINFOEMPTY");
                EXP_GRP_VIEWNULL = resourceBundle.getString("EXP_GRP_VIEWNULL");
                EXP_GRP_NOLOCALHOST = resourceBundle.getString("EXP_GRP_NOLOCALHOST");
                EXP_GRP_PORTINUSE = resourceBundle.getString("EXP_GRP_PORTINUSE");
                EXP_GRP_SOCKETINITFAIL = resourceBundle.getString("EXP_GRP_SOCKETINITFAIL");
                EXP_GRP_INVALIDPAR = resourceBundle.getString("EXP_GRP_INVALIDPAR");
                EXP_GRP_NULLPOINTER = resourceBundle.getString("EXP_GRP_NULLPOINTER");
                EXP_GRP_REPLYISNULL = resourceBundle.getString("EXP_GRP_REPLYISNULL");
                EXP_GRP_NOCONNECTION = resourceBundle.getString("EXP_GRP_NOCONNECTION");
                EXP_GRP_NOGROUPINFO = resourceBundle.getString("EXP_GRP_NOGROUPINFO");
                EXP_GRP_NOTINITIALIZED = resourceBundle.getString("EXP_GRP_NOTINITIALIZED");
                EXP_GRP_WRONG_MODE = resourceBundle.getString("EXP_GRP_WRONG_MODE");
                EXP_GRP_INVALID_STREAM = resourceBundle.getString("EXP_GRP_INVALID_STREAM");
                EXP_GRP_INVALID_HTTP = resourceBundle.getString("EXP_GRP_INVALID_HTTP");
                EXP_GRP_CON_TERMINATED = resourceBundle.getString("EXP_GRP_CON_TERMINATED");
                EXP_GRP_SSL_PROVIDER_INSTANTIATION = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_INSTANTIATION");
                EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND");
                EXP_GRP_SSL_PROVIDER_CLASSCAST = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_CLASSCAST");
                EXP_GRP_SSL_CONFIG = resourceBundle.getString("EXP_GRP_SSL_CONFIG");
                EXP_GRP_SSL_SSOCKET = resourceBundle.getString("EXP_GRP_SSL_SSOCKET");
                EXP_GRP_SSL_SOCKET = resourceBundle.getString("EXP_GRP_SSL_SOCKET");
            }
            this.trans_ = new Transport(this);
            this.trans_.init(bl);
            this.ready = true;
            this.logId = "[" + this.trans_.getLocalAddress().getPosition() + "] ";
        }
        catch (GroupException groupException) {
            throw groupException;
        }
        catch (Exception exception) {
            throw new GroupException(EXP_GRP_BASE + exception.toString(), exception);
        }
        this.channel_ = new GrpChannel(this, this.trans_);
        this.channel_.connect("Cache");
        this.channel_.registerReceivingQueue(messageQueue, object);
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "GrpCommunication is initialized.");
        }
        return this.channel_;
    }

    boolean isTerminated() {
        if (this.trans_ == null) {
            return true;
        }
        return this.trans_.getTerminated();
    }

    public void term() {
        if (!this.ready) {
            return;
        }
        this.ready = false;
        this.trans_.term();
        this.logId = null;
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "GrpCommunication is terminated.");
        }
    }

    String getLogID() {
        return this.logId;
    }

    public boolean isReady() {
        return this.ready;
    }

    public synchronized void dump() {
        this.logger_.log(Level.INFO, "<<< Begin Group Communication Internal Data Structure Dump >>>");
        try {
            this.trans_.dump();
        }
        catch (Exception exception) {
            this.logger_.log(Level.INFO, "dump exception", exception);
        }
        catch (Error error) {
            this.logger_.log(Level.INFO, "dump error", error);
        }
        this.logger_.log(Level.INFO, "<<< End Group Communication Internal Data Structure Dump >>>");
    }

    public String getTempFilePath() {
        String string = this.getWorkingDir() + File.separator + this.getUniqFileName();
        return string;
    }

    public String getUniqFileName() {
        UID uID = new UID();
        return uID.toString().replace(':', '_');
    }

    public int getMode() {
        return this.config_.getMode();
    }

    public String getWorkingDir() {
        return this.config_.getWorkingDir();
    }

    public GroupConfig getGroupConfig() {
        return this.config_;
    }

    public NetworkAddress createAddress(String string, int n, int n2, boolean bl, Serializable serializable) throws GroupException {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new GroupException(EXP_GRP_INVALIDPAR, unknownHostException);
        }
        return new Address(inetAddress, n, bl, n2, serializable);
    }

    public GroupConfig getDefaultConfiguration() {
        return new GrpConfig();
    }

    public int getLeaderID() throws GroupException {
        int n = -1;
        if (this.trans_ != null && this.trans_.getFailureDetector() != null) {
            n = this.trans_.getFailureDetector().getCoordinator().getPosition();
        }
        return n;
    }

    public Transport getTransport() {
        return this.trans_;
    }
}

